/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.library;

import app.freerouting.library.LogicalPart;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

public class LogicalParts
implements Serializable {
    private final Vector<LogicalPart> part_arr = new Vector();

    public LogicalPart add(String p_name, LogicalPart.PartPin[] p_part_pin_arr) {
        Arrays.sort(p_part_pin_arr);
        LogicalPart new_part = new LogicalPart(p_name, this.part_arr.size() + 1, p_part_pin_arr);
        this.part_arr.add(new_part);
        return new_part;
    }

    public LogicalPart get(String p_name) {
        for (LogicalPart curr_part : this.part_arr) {
            if (curr_part == null || !curr_part.name.equalsIgnoreCase(p_name)) continue;
            return curr_part;
        }
        return null;
    }

    public LogicalPart get(int p_part_no) {
        LogicalPart result = this.part_arr.elementAt(p_part_no - 1);
        if (result != null && result.no != p_part_no) {
            FRLogger.warn("LogicalParts.get: inconsistent part number");
        }
        return result;
    }

    public int count() {
        return this.part_arr.size();
    }
}

