/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.library;

import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public class LogicalPart
implements ObjectInfoPanel.Printable,
Serializable {
    public final String name;
    public final int no;
    private final PartPin[] part_pin_arr;

    public LogicalPart(String p_name, int p_no, PartPin[] p_part_pin_arr) {
        this.name = p_name;
        this.no = p_no;
        this.part_pin_arr = p_part_pin_arr;
    }

    public int pin_count() {
        return this.part_pin_arr.length;
    }

    public PartPin get_pin(int p_no) {
        if (p_no < 0 || p_no >= this.part_pin_arr.length) {
            FRLogger.warn("LogicalPart.get_pin: p_no out of range");
            return null;
        }
        return this.part_pin_arr[p_no];
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.ObjectInfoPanel", p_locale);
        p_window.append_bold(resources.getString("logical_part_2") + " ");
        p_window.append_bold(this.name);
        for (int i = 0; i < this.part_pin_arr.length; ++i) {
            PartPin curr_pin = this.part_pin_arr[i];
            p_window.newline();
            p_window.indent();
            p_window.append(resources.getString("pin") + " ");
            p_window.append(curr_pin.pin_name);
            p_window.append(", " + resources.getString("gate") + " ");
            p_window.append(curr_pin.gate_name);
            p_window.append(", " + resources.getString("swap_code") + " ");
            int gate_swap_code = curr_pin.gate_swap_code;
            p_window.append(String.valueOf(gate_swap_code));
            p_window.append(", " + resources.getString("gate_pin") + " ");
            p_window.append(curr_pin.gate_pin_name);
            p_window.append(", " + resources.getString("swap_code") + " ");
            int pin_swap_code = curr_pin.gate_pin_swap_code;
            p_window.append(String.valueOf(pin_swap_code));
        }
        p_window.newline();
        p_window.newline();
    }

    public static class PartPin
    implements Comparable<PartPin>,
    Serializable {
        public final int pin_no;
        public final String pin_name;
        public final String gate_name;
        public final int gate_swap_code;
        public final String gate_pin_name;
        public final int gate_pin_swap_code;

        public PartPin(int p_pin_no, String p_pin_name, String p_gate_name, int p_gate_swap_code, String p_gate_pin_name, int p_gate_pin_swap_code) {
            this.pin_no = p_pin_no;
            this.pin_name = p_pin_name;
            this.gate_name = p_gate_name;
            this.gate_swap_code = p_gate_swap_code;
            this.gate_pin_name = p_gate_pin_name;
            this.gate_pin_swap_code = p_gate_pin_swap_code;
        }

        @Override
        public int compareTo(PartPin p_other) {
            return this.pin_no - p_other.pin_no;
        }
    }
}

