/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.Unit;
import app.freerouting.geometry.planar.FloatPoint;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JLabel;

public class ScreenMessages {
    private static final String empty_string = "            ";
    private final ResourceBundle resources;
    private final Locale locale;
    private final String active_layer_string;
    private final String target_layer_string;
    private final NumberFormat number_format;
    private final JLabel add_field;
    private final JLabel status_field;
    private final JLabel layer_field;
    private final JLabel mouse_position;
    private String prev_target_layer_name = "            ";
    private boolean write_protected = false;

    public ScreenMessages(JLabel p_status_field, JLabel p_add_field, JLabel p_layer_field, JLabel p_mouse_position, Locale p_locale) {
        this.resources = ResourceBundle.getBundle("app.freerouting.interactive.ScreenMessages", p_locale);
        this.locale = p_locale;
        this.active_layer_string = this.resources.getString("current_layer") + " ";
        this.target_layer_string = this.resources.getString("target_layer") + " ";
        this.status_field = p_status_field;
        this.add_field = p_add_field;
        this.layer_field = p_layer_field;
        this.mouse_position = p_mouse_position;
        this.add_field.setText(empty_string);
        this.number_format = NumberFormat.getInstance(p_locale);
        this.number_format.setMinimumFractionDigits(2);
        this.number_format.setMaximumFractionDigits(2);
    }

    public void set_status_message(String p_message) {
        if (!this.write_protected) {
            this.status_field.setText(p_message);
        }
    }

    public void set_layer(String p_layer_name) {
        if (!this.write_protected) {
            this.layer_field.setText(this.active_layer_string + p_layer_name);
        }
    }

    public void set_interactive_autoroute_info(int p_found, int p_not_found, int p_items_to_go) {
        int found = p_found;
        int failed = p_not_found;
        int items_to_go = p_items_to_go;
        this.add_field.setText(this.resources.getString("to_route") + " " + items_to_go);
        this.layer_field.setText(this.resources.getString("found") + " " + found + ", " + this.resources.getString("failed") + " " + failed);
    }

    public void set_batch_autoroute_info(int p_items_to_go, int p_routed, int p_ripped, int p_failed) {
        int ripped = p_ripped;
        int routed = p_routed;
        int items_to_go = p_items_to_go;
        int failed = p_failed;
        this.add_field.setText(this.resources.getString("to_route") + " " + items_to_go + ", " + this.resources.getString("routed") + " " + routed + ", ");
        this.layer_field.setText(this.resources.getString("ripped") + " " + ripped + ", " + this.resources.getString("failed") + " " + failed);
    }

    public void set_batch_fanout_info(int p_pass_no, int p_components_to_go) {
        int components_to_go = p_components_to_go;
        int pass_no = p_pass_no;
        this.add_field.setText(this.resources.getString("fanout_pass") + " " + pass_no + ": ");
        this.layer_field.setText(this.resources.getString("still") + " " + components_to_go + " " + this.resources.getString("components"));
    }

    public void set_post_route_info(int p_via_count, double p_trace_length, Unit unit) {
        int via_count = p_via_count;
        this.add_field.setText(this.resources.getString("via_count") + " " + via_count);
        this.layer_field.setText(this.resources.getString("trace_length") + " " + this.number_format.format(p_trace_length) + " " + unit);
    }

    public void set_target_layer(String p_layer_name) {
        if (!p_layer_name.equals(this.prev_target_layer_name) && !this.write_protected) {
            this.add_field.setText(this.target_layer_string + p_layer_name);
            this.prev_target_layer_name = p_layer_name;
        }
    }

    public void set_mouse_position(FloatPoint p_pos) {
        if (p_pos == null || this.mouse_position == null || this.write_protected) {
            return;
        }
        this.mouse_position.setText(p_pos.to_string(this.locale, 1, 10));
    }

    public void clear_add_field() {
        if (!this.write_protected) {
            this.add_field.setText(empty_string);
            this.prev_target_layer_name = empty_string;
        }
    }

    public void clear() {
        if (!this.write_protected) {
            this.status_field.setText(empty_string);
            this.clear_add_field();
            this.layer_field.setText(empty_string);
        }
    }

    public void set_write_protected(boolean p_value) {
        this.write_protected = p_value;
    }
}

