/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.Connectable;
import app.freerouting.board.Item;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.board.Pin;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.NetIncompletes;
import app.freerouting.rules.Net;
import java.awt.Graphics;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class RatsNest {
    private final NetIncompletes[] net_incompletes;
    private final boolean[] is_filtered;
    private final Locale locale;
    public boolean hidden = false;

    public RatsNest(BasicBoard p_board, Locale p_locale) {
        Item curr_item;
        this.locale = p_locale;
        int max_net_no = p_board.rules.nets.max_net_no();
        Vector net_item_lists = new Vector(max_net_no);
        for (int i = 0; i < max_net_no; ++i) {
            net_item_lists.add(new LinkedList());
        }
        Iterator<UndoableObjects.UndoableObjectNode> it = p_board.item_list.start_read_object();
        while ((curr_item = (Item)p_board.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof Connectable)) continue;
            for (int i = 0; i < curr_item.net_count(); ++i) {
                ((Collection)net_item_lists.get(curr_item.get_net_no(i) - 1)).add(curr_item);
            }
        }
        this.net_incompletes = new NetIncompletes[max_net_no];
        this.is_filtered = new boolean[max_net_no];
        for (int i = 0; i < this.net_incompletes.length; ++i) {
            this.net_incompletes[i] = new NetIncompletes(i + 1, (Collection)net_item_lists.get(i), p_board, p_locale);
            this.is_filtered[i] = false;
        }
    }

    public void recalculate(int p_net_no, BasicBoard p_board) {
        if (p_net_no >= 1 && p_net_no <= this.net_incompletes.length) {
            Collection<Item> item_list = p_board.get_connectable_items(p_net_no);
            this.net_incompletes[p_net_no - 1] = new NetIncompletes(p_net_no, item_list, p_board, this.locale);
        }
    }

    public void recalculate(int p_net_no, Collection<Item> p_item_list, BasicBoard p_board) {
        if (p_net_no >= 1 && p_net_no <= this.net_incompletes.length) {
            LinkedList<Item> item_list = new LinkedList<Item>(p_item_list);
            this.net_incompletes[p_net_no - 1] = new NetIncompletes(p_net_no, item_list, p_board, this.locale);
        }
    }

    public int incomplete_count() {
        int result = 0;
        for (int i = 0; i < this.net_incompletes.length; ++i) {
            result += this.net_incompletes[i].count();
        }
        return result;
    }

    public int incomplete_count(int p_net_no) {
        if (p_net_no <= 0 || p_net_no > this.net_incompletes.length) {
            return 0;
        }
        return this.net_incompletes[p_net_no - 1].count();
    }

    public int length_violation_count() {
        int result = 0;
        for (int i = 0; i < this.net_incompletes.length; ++i) {
            if (this.net_incompletes[i].get_length_violation() == 0.0) continue;
            ++result;
        }
        return result;
    }

    public double get_length_violation(int p_net_no) {
        if (p_net_no <= 0 || p_net_no > this.net_incompletes.length) {
            return 0.0;
        }
        return this.net_incompletes[p_net_no - 1].get_length_violation();
    }

    public AirLine[] get_airlines() {
        AirLine[] result = new AirLine[this.incomplete_count()];
        int curr_index = 0;
        for (int i = 0; i < this.net_incompletes.length; ++i) {
            Collection<AirLine> curr_list = this.net_incompletes[i].incompletes;
            Iterator<AirLine> iterator = curr_list.iterator();
            while (iterator.hasNext()) {
                AirLine curr_line;
                result[curr_index] = curr_line = iterator.next();
                ++curr_index;
            }
        }
        return result;
    }

    public void hide() {
        this.hidden = true;
    }

    public void show() {
        this.hidden = false;
    }

    public boolean recalculate_length_violations() {
        boolean result = false;
        for (int i = 0; i < this.net_incompletes.length; ++i) {
            if (!this.net_incompletes[i].calc_length_violation()) continue;
            result = true;
        }
        return result;
    }

    public boolean is_hidden() {
        return this.hidden;
    }

    public void set_filter(int p_net_no, boolean p_value) {
        if (p_net_no < 1 || p_net_no > this.is_filtered.length) {
            return;
        }
        this.is_filtered[p_net_no - 1] = p_value;
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context) {
        boolean draw_length_violations_only = this.hidden;
        for (int i = 0; i < this.net_incompletes.length; ++i) {
            if (this.is_filtered[i]) continue;
            this.net_incompletes[i].draw(p_graphics, p_graphics_context, draw_length_violations_only);
        }
    }

    public static class AirLine
    implements Comparable<AirLine>,
    ObjectInfoPanel.Printable {
        public final Net net;
        public final Item from_item;
        public final FloatPoint from_corner;
        public final Item to_item;
        public final FloatPoint to_corner;
        private final Locale locale;

        AirLine(Net p_net, Item p_from_item, FloatPoint p_from_corner, Item p_to_item, FloatPoint p_to_corner, Locale p_locale) {
            this.net = p_net;
            this.from_item = p_from_item;
            this.from_corner = p_from_corner;
            this.to_item = p_to_item;
            this.to_corner = p_to_corner;
            this.locale = p_locale;
        }

        @Override
        public int compareTo(AirLine p_other) {
            return this.net.name.compareTo(p_other.net.name);
        }

        public String toString() {
            return this.net.name + ": " + this.item_info(this.from_item) + " - " + this.item_info(this.to_item);
        }

        private String item_info(Item p_item) {
            Object result;
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.interactive.RatsNest", this.locale);
            if (p_item instanceof Pin) {
                Pin curr_pin = (Pin)p_item;
                result = curr_pin.component_name() + ", " + curr_pin.name();
            } else {
                result = p_item instanceof Via ? resources.getString("via") : (p_item instanceof Trace ? resources.getString("trace") : (p_item instanceof ConductionArea ? resources.getString("conduction_area") : resources.getString("unknown")));
            }
            return result;
        }

        @Override
        public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.interactive.RatsNest", p_locale);
            p_window.append_bold(resources.getString("incomplete"));
            p_window.append(" " + resources.getString("net") + " ");
            p_window.append(this.net.name);
            p_window.append(" " + resources.getString("from") + " ", "Incomplete Start Item", this.from_item);
            p_window.append(this.from_corner);
            p_window.append(" " + resources.getString("to") + " ", "Incomplete End Item", this.to_item);
            p_window.append(this.to_corner);
            p_window.newline();
        }
    }
}

