/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.Item;
import app.freerouting.board.Pin;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.datastructures.PlanarDelaunayTriangulation;
import app.freerouting.datastructures.Signum;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.interactive.RatsNest;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.Net;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class NetIncompletes {
    final Collection<RatsNest.AirLine> incompletes;
    private final Net net;
    private final double draw_marker_radius;
    private double length_violation = 0.0;

    public NetIncompletes(int p_net_no, Collection<Item> p_net_items, BasicBoard p_board, Locale p_locale) {
        this.draw_marker_radius = p_board.rules.get_min_trace_half_width() * 2;
        this.incompletes = new LinkedList<RatsNest.AirLine>();
        this.net = p_board.rules.nets.get(p_net_no);
        NetItem[] net_items = this.calculate_net_items(p_net_items);
        if (net_items.length <= 1) {
            return;
        }
        LinkedList<PlanarDelaunayTriangulation.Storable> triangulation_objects = new LinkedList<PlanarDelaunayTriangulation.Storable>(Arrays.asList(net_items));
        PlanarDelaunayTriangulation triangulation = new PlanarDelaunayTriangulation(triangulation_objects);
        Collection<PlanarDelaunayTriangulation.ResultEdge> triangulation_lines = triangulation.get_edge_lines();
        TreeSet<Edge> sorted_edges = new TreeSet<Edge>();
        for (PlanarDelaunayTriangulation.ResultEdge curr_line : triangulation_lines) {
            Edge new_edge = new Edge((NetItem)curr_line.start_object, curr_line.start_point.to_float(), (NetItem)curr_line.end_object, curr_line.end_point.to_float());
            sorted_edges.add(new_edge);
        }
        Net curr_net = p_board.rules.nets.get(p_net_no);
        for (Edge curr_edge : sorted_edges) {
            if (curr_edge.from_item.connected_set == curr_edge.to_item.connected_set) continue;
            this.incompletes.add(new RatsNest.AirLine(curr_net, curr_edge.from_item.item, curr_edge.from_corner, curr_edge.to_item.item, curr_edge.to_corner, p_locale));
            this.join_connected_sets(net_items, curr_edge.from_item.connected_set, curr_edge.to_item.connected_set);
        }
        this.calc_length_violation();
    }

    static void draw_layer_change_marker(FloatPoint p_location, double p_radius, Graphics p_graphics, GraphicsContext p_graphics_context) {
        boolean draw_width = true;
        Color draw_color = p_graphics_context.get_incomplete_color();
        double draw_intensity = p_graphics_context.get_incomplete_color_intensity();
        FloatPoint[] draw_points = new FloatPoint[]{new FloatPoint(p_location.x - p_radius, p_location.y - p_radius), new FloatPoint(p_location.x + p_radius, p_location.y + p_radius)};
        p_graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, draw_intensity);
        draw_points[0] = new FloatPoint(p_location.x + p_radius, p_location.y - p_radius);
        draw_points[1] = new FloatPoint(p_location.x - p_radius, p_location.y + p_radius);
        p_graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, draw_intensity);
    }

    static void draw_length_violation_marker(FloatPoint p_location, double p_diameter, Graphics p_graphics, GraphicsContext p_graphics_context) {
        boolean draw_width = true;
        Color draw_color = p_graphics_context.get_incomplete_color();
        double draw_intensity = p_graphics_context.get_incomplete_color_intensity();
        double circle_radius = 0.5 * Math.abs(p_diameter);
        p_graphics_context.draw_circle(p_location, circle_radius, 1.0, draw_color, p_graphics, draw_intensity);
        FloatPoint[] draw_points = new FloatPoint[]{new FloatPoint(p_location.x - circle_radius, p_location.y), new FloatPoint(p_location.x + circle_radius, p_location.y)};
        p_graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, draw_intensity);
        if (p_diameter > 0.0) {
            draw_points[0] = new FloatPoint(p_location.x, p_location.y - circle_radius);
            draw_points[1] = new FloatPoint(p_location.x, p_location.y + circle_radius);
            p_graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, draw_intensity);
        }
    }

    public int count() {
        return this.incompletes.size();
    }

    boolean calc_length_violation() {
        double old_violation = this.length_violation;
        double max_length = this.net.get_class().get_maximum_trace_length();
        double min_length = this.net.get_class().get_minimum_trace_length();
        if (max_length <= 0.0 && min_length <= 0.0) {
            this.length_violation = 0.0;
            return false;
        }
        double new_violation = 0.0;
        double trace_length = this.net.get_trace_length();
        if (max_length > 0.0 && trace_length > max_length) {
            new_violation = trace_length - max_length;
        }
        if (min_length > 0.0 && trace_length < min_length && this.incompletes.isEmpty()) {
            new_violation = trace_length - min_length;
        }
        this.length_violation = new_violation;
        return Math.abs(new_violation - old_violation) > 0.1;
    }

    double get_length_violation() {
        return this.length_violation;
    }

    public void draw(Graphics p_graphics, GraphicsContext p_graphics_context, boolean p_length_violations_only) {
        if (!p_length_violations_only) {
            Color draw_color = p_graphics_context.get_incomplete_color();
            double draw_intensity = p_graphics_context.get_incomplete_color_intensity();
            if (draw_intensity <= 0.0) {
                return;
            }
            FloatPoint[] draw_points = new FloatPoint[2];
            boolean draw_width = true;
            for (RatsNest.AirLine curr_incomplete : this.incompletes) {
                draw_points[0] = curr_incomplete.from_corner;
                draw_points[1] = curr_incomplete.to_corner;
                p_graphics_context.draw(draw_points, (double)draw_width, draw_color, p_graphics, draw_intensity);
                if (curr_incomplete.from_item.shares_layer(curr_incomplete.to_item)) continue;
                NetIncompletes.draw_layer_change_marker(curr_incomplete.from_corner, this.draw_marker_radius, p_graphics, p_graphics_context);
                NetIncompletes.draw_layer_change_marker(curr_incomplete.to_corner, this.draw_marker_radius, p_graphics, p_graphics_context);
            }
        }
        if (this.length_violation == 0.0) {
            return;
        }
        Collection<Pin> net_pins = this.net.get_pins();
        for (Pin curr_pin : net_pins) {
            NetIncompletes.draw_length_violation_marker(curr_pin.get_center().to_float(), this.length_violation, p_graphics, p_graphics_context);
        }
    }

    private NetItem[] calculate_net_items(Collection<Item> p_item_list) {
        ArrayList<NetItem> result = new ArrayList<NetItem>();
        int input_size = p_item_list.size();
        LinkedList<Item> handled_items = new LinkedList<Item>();
        int curr_index = 0;
        while (!p_item_list.isEmpty()) {
            Item start_item = p_item_list.iterator().next();
            Set<Item> curr_connected_set = start_item.get_connected_set(this.net.net_number);
            handled_items.addAll(curr_connected_set);
            p_item_list.removeAll(curr_connected_set);
            for (Item curr_item : curr_connected_set) {
                result.add(new NetItem(curr_item, curr_connected_set));
                ++curr_index;
            }
        }
        if (curr_index > input_size) {
            FRLogger.warn("NetIncompletes.calculate_net_items: too many items");
        } else if (curr_index < input_size) {
            FRLogger.warn("NetIncompletes.calculate_net_items: too few items");
        }
        return result.toArray(new NetItem[0]);
    }

    private void join_connected_sets(NetItem[] p_net_items, Collection<Item> p_from_connected_set, Collection<Item> p_to_connected_set) {
        for (int i = 0; i < p_net_items.length; ++i) {
            NetItem curr_item = p_net_items[i];
            if (curr_item.connected_set != p_from_connected_set) continue;
            p_to_connected_set.add(curr_item.item);
            curr_item.connected_set = p_to_connected_set;
        }
    }

    private static class NetItem
    implements PlanarDelaunayTriangulation.Storable {
        final Item item;
        Collection<Item> connected_set;

        NetItem(Item p_item, Collection<Item> p_connected_set) {
            this.item = p_item;
            this.connected_set = p_connected_set;
        }

        @Override
        public Point[] get_triangulation_corners() {
            return this.item.get_ratsnest_corners();
        }
    }

    private static class Edge
    implements Comparable<Edge> {
        public final NetItem from_item;
        public final FloatPoint from_corner;
        public final NetItem to_item;
        public final FloatPoint to_corner;
        public final double length_square;

        private Edge(NetItem p_from_item, FloatPoint p_from_corner, NetItem p_to_item, FloatPoint p_to_corner) {
            this.from_item = p_from_item;
            this.from_corner = p_from_corner;
            this.to_item = p_to_item;
            this.to_corner = p_to_corner;
            this.length_square = p_to_corner.distance_square(p_from_corner);
        }

        @Override
        public int compareTo(Edge p_other) {
            double result = this.length_square - p_other.length_square;
            if (result == 0.0) {
                result = this.from_corner.x - p_other.from_corner.x;
                if (result == 0.0) {
                    result = this.from_corner.y - p_other.from_corner.y;
                }
                if (result == 0.0) {
                    result = this.to_corner.x - p_other.to_corner.x;
                }
                if (result == 0.0) {
                    result = this.to_corner.y - p_other.to_corner.y;
                }
            }
            return Signum.as_int(result);
        }
    }
}

