/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.board.LayerStructure;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.ActivityReplayFile;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.BoardHandling;
import app.freerouting.interactive.ZoomRegionState;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;

public class InteractiveState {
    protected final BoardHandling hdlg;
    protected final ActivityReplayFile activityReplayFile;
    protected final ResourceBundle resources;
    protected InteractiveState return_state;

    protected InteractiveState(InteractiveState p_return_state, BoardHandling p_board_handling, ActivityReplayFile p_activityReplayFile) {
        this.return_state = p_return_state;
        this.hdlg = p_board_handling;
        this.activityReplayFile = p_activityReplayFile;
        this.resources = ResourceBundle.getBundle("app.freerouting.interactive.InteractiveState", p_board_handling.get_locale());
    }

    public void draw(Graphics p_graphics) {
    }

    public InteractiveState left_button_clicked(FloatPoint p_location) {
        return this;
    }

    public InteractiveState button_released() {
        return this;
    }

    public InteractiveState mouse_moved() {
        FloatPoint mouse_position = this.hdlg.coordinate_transform.board_to_user(this.hdlg.get_current_mouse_position());
        this.hdlg.screen_messages.set_mouse_position(mouse_position);
        return this;
    }

    public InteractiveState mouse_dragged(FloatPoint p_point) {
        return this;
    }

    public InteractiveState mouse_pressed(FloatPoint p_point) {
        return this;
    }

    public InteractiveState mouse_wheel_moved(int p_rotation) {
        Point2D screen_mouse_pos = this.hdlg.graphics_context.coordinate_transform.board_to_screen(this.hdlg.get_current_mouse_position());
        this.hdlg.get_panel().zoom_with_mouse_wheel(screen_mouse_pos, p_rotation);
        return this;
    }

    public InteractiveState key_typed(char p_key_char) {
        InteractiveState result = this;
        Point2D screen_mouse_pos = this.hdlg.graphics_context.coordinate_transform.board_to_screen(this.hdlg.get_current_mouse_position());
        switch (p_key_char) {
            case 'a': {
                this.hdlg.get_panel().board_frame.zoom_all();
                break;
            }
            case 'c': {
                this.hdlg.get_panel().center_display(screen_mouse_pos);
                break;
            }
            case 'f': {
                result = ZoomRegionState.get_instance(this.hdlg.get_current_mouse_position(), this, this.hdlg, this.activityReplayFile);
                break;
            }
            case 'h': {
                this.hdlg.get_panel().board_frame.select_previous_snapshot();
                break;
            }
            case 'j': {
                this.hdlg.get_panel().board_frame.goto_selected_snapshot();
                break;
            }
            case 'k': {
                this.hdlg.get_panel().board_frame.select_next_snapshot();
                break;
            }
            case 'o': {
                this.hdlg.get_panel().zoom_out(screen_mouse_pos);
                break;
            }
            case 'z': {
                this.hdlg.get_panel().zoom_in(screen_mouse_pos);
                break;
            }
            case ',': {
                this.hdlg.get_panel().set_custom_crosshair_cursor(!this.hdlg.get_panel().is_custom_cross_hair_cursor());
                break;
            }
            case '\n': 
            case ' ': {
                result = this.complete();
                break;
            }
            case '\u001b': {
                result = this.cancel();
                break;
            }
            default: {
                if (!Character.isDigit(p_key_char)) break;
                LayerStructure layer_structure = this.hdlg.get_routing_board().layer_structure;
                int d = Character.digit(p_key_char, 10);
                d = Math.min(d, layer_structure.signal_layer_count());
                d = Math.max(d - 1, 0);
                d = layer_structure.get_no(layer_structure.get_signal_layer(d));
                this.hdlg.set_current_layer(d);
            }
        }
        return result;
    }

    public InteractiveState complete() {
        if (this.return_state != this && this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.COMPLETE_SCOPE);
        }
        return this.return_state;
    }

    public InteractiveState cancel() {
        if (this.return_state != this && this.activityReplayFile != null) {
            this.activityReplayFile.start_scope(ActivityReplayFileScope.CANCEL_SCOPE);
        }
        return this.return_state;
    }

    public boolean change_layer_action(int p_new_layer) {
        this.hdlg.set_layer(p_new_layer);
        return true;
    }

    public InteractiveState process_logfile_point(FloatPoint p_point) {
        return this;
    }

    public void display_default_message() {
    }

    public String get_help_id() {
        return "MenuState";
    }

    public JPopupMenu get_popup_menu() {
        return null;
    }

    public void set_toolbar() {
    }
}

