/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.datastructures.Stoppable;
import app.freerouting.interactive.ActivityReplayFileScope;
import app.freerouting.interactive.BatchAutorouterThread;
import app.freerouting.interactive.BoardHandling;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.SelectedItemState;
import app.freerouting.interactive.ThreadActionListener;
import app.freerouting.logger.FRLogger;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public abstract class InteractiveActionThread
extends Thread
implements Stoppable {
    public final BoardHandling hdlg;
    protected List<ThreadActionListener> listeners = new ArrayList<ThreadActionListener>();
    private boolean stop_requested = false;
    private boolean stop_auto_router = false;

    protected InteractiveActionThread(BoardHandling p_board_handling) {
        this.hdlg = p_board_handling;
    }

    public static InteractiveActionThread get_autoroute_instance(BoardHandling p_board_handling) {
        return new AutorouteThread(p_board_handling);
    }

    public static InteractiveActionThread get_batch_autorouter_instance(BoardHandling p_board_handling) {
        return new BatchAutorouterThread(p_board_handling);
    }

    public static InteractiveActionThread get_fanout_instance(BoardHandling p_board_handling) {
        return new FanoutThread(p_board_handling);
    }

    public static InteractiveActionThread get_pull_tight_instance(BoardHandling p_board_handling) {
        return new PullTightThread(p_board_handling);
    }

    public static InteractiveActionThread get_read_logfile_instance(BoardHandling p_board_handling, InputStream p_input_stream) {
        return new ReadLogfileThread(p_board_handling, p_input_stream);
    }

    public void addListener(ThreadActionListener toAdd) {
        this.listeners.add(toAdd);
    }

    protected abstract void thread_action();

    @Override
    public void run() {
        this.thread_action();
        this.hdlg.repaint();
    }

    @Override
    public synchronized void request_stop() {
        this.stop_requested = true;
    }

    @Override
    public synchronized boolean is_stop_requested() {
        return this.stop_requested;
    }

    public synchronized void request_stop_auto_router() {
        this.stop_auto_router = true;
    }

    public synchronized boolean is_stop_auto_router_requested() {
        return this.stop_auto_router;
    }

    public synchronized void draw(Graphics p_graphics) {
    }

    private static class AutorouteThread
    extends InteractiveActionThread {
        private AutorouteThread(BoardHandling p_board_handling) {
            super(p_board_handling);
        }

        @Override
        protected void thread_action() {
            if (!(this.hdlg.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.hdlg.interactive_state).autoroute(this);
            this.hdlg.set_interactive_state(return_state);
        }
    }

    private static class FanoutThread
    extends InteractiveActionThread {
        private FanoutThread(BoardHandling p_board_handling) {
            super(p_board_handling);
        }

        @Override
        protected void thread_action() {
            if (!(this.hdlg.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.hdlg.interactive_state).fanout(this);
            this.hdlg.set_interactive_state(return_state);
        }
    }

    private static class PullTightThread
    extends InteractiveActionThread {
        private PullTightThread(BoardHandling p_board_handling) {
            super(p_board_handling);
        }

        @Override
        protected void thread_action() {
            if (!(this.hdlg.interactive_state instanceof SelectedItemState)) {
                return;
            }
            InteractiveState return_state = ((SelectedItemState)this.hdlg.interactive_state).pull_tight(this);
            this.hdlg.set_interactive_state(return_state);
        }
    }

    private static class ReadLogfileThread
    extends InteractiveActionThread {
        private final InputStream input_stream;

        private ReadLogfileThread(BoardHandling p_board_handling, InputStream p_input_stream) {
            super(p_board_handling);
            this.input_stream = p_input_stream;
        }

        @Override
        protected void thread_action() {
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.interactive.InteractiveState", this.hdlg.get_locale());
            boolean saved_board_read_only = this.hdlg.is_board_read_only();
            this.hdlg.set_board_read_only(true);
            String start_message = resources.getString("logfile") + " " + resources.getString("stop_message");
            this.hdlg.screen_messages.set_status_message(start_message);
            this.hdlg.screen_messages.set_write_protected(true);
            boolean done = false;
            InteractiveState previous_state = this.hdlg.interactive_state;
            if (!this.hdlg.activityReplayFile.start_read(this.input_stream)) {
                done = true;
            }
            boolean interrupted = false;
            int debug_counter = 0;
            this.hdlg.get_panel().board_frame.refresh_windows();
            this.hdlg.paint_immediately = true;
            while (!done) {
                if (this.is_stop_requested()) {
                    interrupted = true;
                    done = true;
                }
                ++debug_counter;
                ActivityReplayFileScope logfile_scope = this.hdlg.activityReplayFile.start_read_scope();
                if (logfile_scope == null) {
                    done = true;
                }
                if (done) continue;
                try {
                    InteractiveState new_state = logfile_scope.read_scope(this.hdlg.activityReplayFile, this.hdlg.interactive_state, this.hdlg);
                    if (new_state == null) {
                        FRLogger.warn("BoardHandling:read_logfile: inconsistent logfile scope");
                        new_state = previous_state;
                    }
                    this.hdlg.repaint();
                    this.hdlg.set_interactive_state(new_state);
                }
                catch (Exception e) {
                    done = true;
                }
            }
            this.hdlg.paint_immediately = false;
            try {
                this.input_stream.close();
            }
            catch (IOException e) {
                FRLogger.error("ReadLogfileThread: unable to close input stream", e);
            }
            this.hdlg.get_panel().board_frame.refresh_windows();
            this.hdlg.screen_messages.set_write_protected(false);
            String curr_message = interrupted ? resources.getString("interrupted") : resources.getString("completed");
            String end_message = resources.getString("logfile") + " " + curr_message;
            this.hdlg.screen_messages.set_status_message(end_message);
            this.hdlg.set_board_read_only(saved_board_read_only);
            this.hdlg.get_panel().board_frame.repaint_all();
        }
    }
}

