/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.interactive;

import app.freerouting.autoroute.BatchAutorouter;
import app.freerouting.autoroute.BatchFanout;
import app.freerouting.autoroute.BatchOptRoute;
import app.freerouting.autoroute.BatchOptRouteMT;
import app.freerouting.autoroute.BoardUpdateStrategy;
import app.freerouting.autoroute.ItemSelectionStrategy;
import app.freerouting.board.AngleRestriction;
import app.freerouting.board.TestLevel;
import app.freerouting.board.Unit;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.interactive.AutorouteSettings;
import app.freerouting.interactive.BoardHandling;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.interactive.ThreadActionListener;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.FRAnalytics;
import app.freerouting.tests.Validate;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ResourceBundle;

public class BatchAutorouterThread
extends InteractiveActionThread {
    private final BatchAutorouter batch_autorouter;
    private final BatchOptRoute batch_opt_route;
    boolean save_intermediate_stages;
    float optimization_improvement_threshold;

    protected BatchAutorouterThread(BoardHandling p_board_handling) {
        super(p_board_handling);
        AutorouteSettings autoroute_settings = p_board_handling.get_settings().autoroute_settings;
        this.batch_autorouter = new BatchAutorouter(this, !autoroute_settings.get_with_fanout(), true, autoroute_settings.get_start_ripup_costs());
        BoardUpdateStrategy update_strategy = p_board_handling.get_board_update_strategy();
        String hybrid_ratio = p_board_handling.get_hybrid_ratio();
        ItemSelectionStrategy item_selection_strategy = p_board_handling.get_item_selection_strategy();
        int num_threads = p_board_handling.get_num_threads();
        this.save_intermediate_stages = p_board_handling.save_intermediate_stages;
        this.optimization_improvement_threshold = p_board_handling.optimization_improvement_threshold;
        if (num_threads > 1) {
            FRLogger.warn("Multi-threaded route optimization is broken and it is known to generate clearance violations. It is highly recommended to use the single-threaded route optimization instead by setting the number of threads to 1 with the '-mt 1' command line argument.");
        }
        this.batch_opt_route = num_threads > 1 ? new BatchOptRouteMT(this, num_threads, update_strategy, item_selection_strategy, hybrid_ratio) : new BatchOptRoute(this);
    }

    @Override
    protected void thread_action() {
        for (ThreadActionListener hl : this.listeners) {
            hl.autorouterStarted();
        }
        FRLogger.traceEntry("BatchAutorouterThread.thread_action()");
        try {
            boolean fanout_first;
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.interactive.InteractiveState", this.hdlg.get_locale());
            boolean saved_board_read_only = this.hdlg.is_board_read_only();
            this.hdlg.set_board_read_only(true);
            boolean ratsnest_hidden_before = this.hdlg.get_ratsnest().is_hidden();
            if (!ratsnest_hidden_before) {
                this.hdlg.get_ratsnest().hide();
            }
            FRLogger.info("Starting auto-routing...");
            FRLogger.traceEntry("BatchAutorouterThread.thread_action()-autorouting");
            FRAnalytics.autorouterStarted();
            String start_message = resources.getString("batch_autorouter") + " " + resources.getString("stop_message");
            this.hdlg.screen_messages.set_status_message(start_message);
            boolean bl = fanout_first = this.hdlg.get_settings().autoroute_settings.get_with_fanout() && this.hdlg.get_settings().autoroute_settings.get_start_pass_no() <= 1;
            if (fanout_first) {
                BatchFanout.fanout_board(this);
            }
            if (this.hdlg.get_settings().autoroute_settings.get_with_autoroute() && !this.is_stop_auto_router_requested()) {
                this.batch_autorouter.autoroute_passes(this.hdlg.save_intermediate_stages);
            }
            this.hdlg.get_routing_board().finish_autoroute();
            double autoroutingSecondsToComplete = FRLogger.traceExit("BatchAutorouterThread.thread_action()-autorouting");
            FRLogger.info("Auto-routing was completed in " + FRLogger.formatDuration(autoroutingSecondsToComplete) + ".");
            FRAnalytics.autorouterFinished();
            Thread.sleep(100L);
            int num_threads = this.hdlg.get_num_threads();
            if (num_threads > 0) {
                FRLogger.info("Starting route optimization on " + (String)(num_threads == 1 ? "1 thread" : num_threads + " threads") + "...");
                FRLogger.traceEntry("BatchAutorouterThread.thread_action()-routeoptimization");
                FRAnalytics.routeOptimizerStarted();
                int via_count_before = this.hdlg.get_routing_board().get_vias().size();
                double trace_length_before = this.hdlg.coordinate_transform.board_to_user(this.hdlg.get_routing_board().cumulative_trace_length());
                if (this.hdlg.get_settings().autoroute_settings.get_with_postroute() && !this.is_stop_requested()) {
                    String opt_message = resources.getString("batch_optimizer") + " " + resources.getString("stop_message");
                    this.hdlg.screen_messages.set_status_message(opt_message);
                    this.batch_opt_route.optimize_board(this.save_intermediate_stages, this.optimization_improvement_threshold, this);
                    String curr_message = this.is_stop_requested() ? resources.getString("interrupted") : resources.getString("completed");
                    end_message = resources.getString("postroute") + " " + curr_message;
                    this.hdlg.screen_messages.set_status_message(end_message);
                } else {
                    this.hdlg.screen_messages.clear();
                    String curr_message = this.is_stop_requested() ? resources.getString("interrupted") : resources.getString("completed");
                    int incomplete_count = this.hdlg.get_ratsnest().incomplete_count();
                    end_message = resources.getString("autoroute") + " " + curr_message + ", " + incomplete_count + " " + resources.getString("connections_not_found");
                    this.hdlg.screen_messages.set_status_message(end_message);
                }
                int via_count_after = this.hdlg.get_routing_board().get_vias().size();
                double trace_length_after = this.hdlg.coordinate_transform.board_to_user(this.hdlg.get_routing_board().cumulative_trace_length());
                double percentage_improvement = via_count_before != 0 && trace_length_before != 0.0 ? 1.0 - ((double)(via_count_after / via_count_before) + trace_length_after / trace_length_before) / 2.0 : 0.0;
                double routeOptimizationSecondsToComplete = FRLogger.traceExit("BatchAutorouterThread.thread_action()-routeoptimization");
                FRLogger.info("Route optimization was completed in " + FRLogger.formatDuration(routeOptimizationSecondsToComplete) + (String)(percentage_improvement > 0.0 ? " and it improved the design by ~" + String.format("%(,.2f", percentage_improvement * 100.0) + "%" : "") + ".");
                FRAnalytics.routeOptimizerFinished();
                if (!this.is_stop_requested()) {
                    this.hdlg.get_panel().board_frame.delete_intermediate_stage_file();
                }
            }
            this.hdlg.set_board_read_only(saved_board_read_only);
            this.hdlg.update_ratsnest();
            if (!ratsnest_hidden_before) {
                this.hdlg.get_ratsnest().show();
            }
            this.hdlg.get_panel().board_frame.refresh_windows();
            if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE && this.hdlg.get_routing_board().get_test_level() != TestLevel.RELEASE_VERSION) {
                Validate.multiple_of_45_degree("after autoroute: ", this.hdlg.get_routing_board());
            }
        }
        catch (Exception e) {
            FRLogger.error(e.getLocalizedMessage(), e);
        }
        FRLogger.traceExit("BatchAutorouterThread.thread_action()");
        for (ThreadActionListener hl : this.listeners) {
            if (this.is_stop_requested()) {
                hl.autorouterAborted();
                continue;
            }
            hl.autorouterFinished();
        }
    }

    @Override
    public void draw(Graphics p_graphics) {
        FloatLine curr_air_line = this.batch_autorouter.get_air_line();
        if (curr_air_line != null) {
            FloatPoint[] draw_line = new FloatPoint[]{curr_air_line.a, curr_air_line.b};
            Color draw_color = this.hdlg.graphics_context.get_incomplete_color();
            double draw_width = Math.min(this.hdlg.get_routing_board().communication.get_resolution(Unit.MIL) * 3.0, 300.0);
            this.hdlg.graphics_context.draw(draw_line, draw_width, draw_color, p_graphics, 1.0);
        }
        FloatPoint current_opt_position = this.batch_opt_route.get_current_position();
        int radius = 10 * this.hdlg.get_routing_board().rules.get_default_trace_half_width(0);
        if (current_opt_position != null) {
            boolean draw_width = true;
            Color draw_color = this.hdlg.graphics_context.get_incomplete_color();
            FloatPoint[] draw_points = new FloatPoint[]{new FloatPoint(current_opt_position.x - (double)radius, current_opt_position.y - (double)radius), new FloatPoint(current_opt_position.x + (double)radius, current_opt_position.y + (double)radius)};
            this.hdlg.graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, 1.0);
            draw_points[0] = new FloatPoint(current_opt_position.x + (double)radius, current_opt_position.y - (double)radius);
            draw_points[1] = new FloatPoint(current_opt_position.x - (double)radius, current_opt_position.y + (double)radius);
            this.hdlg.graphics_context.draw(draw_points, 1.0, draw_color, p_graphics, 1.0);
            this.hdlg.graphics_context.draw_circle(current_opt_position, radius, 1.0, draw_color, p_graphics, 1.0);
        }
    }
}

