/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.CoordinateTransform;
import app.freerouting.board.Layer;
import app.freerouting.board.LayerStructure;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.board.RoutingBoard;
import app.freerouting.geometry.planar.Circle;
import app.freerouting.geometry.planar.ConvexShape;
import app.freerouting.geometry.planar.Point;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.gui.WindowMessage;
import app.freerouting.gui.WindowObjectInfo;
import app.freerouting.gui.WindowViaRule;
import app.freerouting.library.BoardLibrary;
import app.freerouting.library.Padstack;
import app.freerouting.management.FRAnalytics;
import app.freerouting.rules.BoardRules;
import app.freerouting.rules.ViaInfo;
import app.freerouting.rules.ViaInfos;
import app.freerouting.rules.ViaRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class WindowVia
extends BoardSavableSubWindow {
    private static final int WINDOW_OFFSET = 30;
    private final BoardFrame board_frame;
    private final ResourceBundle resources;
    private final JList<ViaRule> rule_list;
    private final DefaultListModel<ViaRule> rule_list_model;
    private final JPanel main_panel;
    private final Collection<JFrame> subwindows = new LinkedList<JFrame>();

    public WindowVia(BoardFrame p_board_frame) {
        this.resources = ResourceBundle.getBundle("app.freerouting.gui.WindowVia", p_board_frame.get_locale());
        this.setTitle(this.resources.getString("title"));
        this.board_frame = p_board_frame;
        this.main_panel = new JPanel();
        this.main_panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.main_panel.setLayout(new BorderLayout());
        JPanel north_panel = new JPanel();
        this.main_panel.add((Component)north_panel, "North");
        GridBagLayout gridbag = new GridBagLayout();
        north_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.gridwidth = 0;
        JLabel available_via_padstack_label = new JLabel(this.resources.getString("available_via_padstacks"));
        available_via_padstack_label.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        gridbag.setConstraints(available_via_padstack_label, gridbag_constraints);
        north_panel.add((Component)available_via_padstack_label, gridbag_constraints);
        JPanel padstack_button_panel = new JPanel();
        padstack_button_panel.setLayout(new FlowLayout());
        gridbag.setConstraints(padstack_button_panel, gridbag_constraints);
        north_panel.add((Component)padstack_button_panel, gridbag_constraints);
        JButton rules_vias_padstacks_info_button = new JButton(this.resources.getString("info"));
        rules_vias_padstacks_info_button.setToolTipText(this.resources.getString("info_tooltip"));
        rules_vias_padstacks_info_button.addActionListener(new ShowPadstacksListener());
        rules_vias_padstacks_info_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_padstacks_info_button", rules_vias_padstacks_info_button.getText()));
        padstack_button_panel.add(rules_vias_padstacks_info_button);
        JButton rules_vias_padstacks_create_button = new JButton(this.resources.getString("create"));
        rules_vias_padstacks_create_button.setToolTipText(this.resources.getString("create_tooltip"));
        rules_vias_padstacks_create_button.addActionListener(new AddPadstackListener());
        rules_vias_padstacks_create_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_padstacks_create_button", rules_vias_padstacks_create_button.getText()));
        padstack_button_panel.add(rules_vias_padstacks_create_button);
        JButton rules_vias_padstacks_remove_button = new JButton(this.resources.getString("remove"));
        rules_vias_padstacks_remove_button.setToolTipText(this.resources.getString("remove_tooltip"));
        rules_vias_padstacks_remove_button.addActionListener(new RemovePadstackListener());
        rules_vias_padstacks_remove_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_padstacks_remove_button", rules_vias_padstacks_remove_button.getText()));
        padstack_button_panel.add(rules_vias_padstacks_remove_button);
        JLabel separator_label = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013");
        separator_label.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        gridbag.setConstraints(separator_label, gridbag_constraints);
        north_panel.add((Component)separator_label, gridbag_constraints);
        JLabel available_vias_label = new JLabel(this.resources.getString("available_vias"));
        available_vias_label.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        gridbag.setConstraints(available_vias_label, gridbag_constraints);
        north_panel.add((Component)available_vias_label, gridbag_constraints);
        JPanel via_button_panel = new JPanel();
        via_button_panel.setLayout(new FlowLayout());
        gridbag.setConstraints(via_button_panel, gridbag_constraints);
        north_panel.add((Component)via_button_panel, gridbag_constraints);
        JButton rules_vias_vias_info_button = new JButton(this.resources.getString("info"));
        rules_vias_vias_info_button.setToolTipText(this.resources.getString("info_tooltip_2"));
        rules_vias_vias_info_button.addActionListener(new ShowViasListener());
        rules_vias_vias_info_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_vias_info_button", rules_vias_vias_info_button.getText()));
        via_button_panel.add(rules_vias_vias_info_button);
        JButton rules_vias_vias_edit_button = new JButton(this.resources.getString("edit"));
        rules_vias_vias_edit_button.setToolTipText(this.resources.getString("edit_tooltip"));
        rules_vias_vias_edit_button.addActionListener(new EditViasListener());
        rules_vias_vias_edit_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_vias_edit_button", rules_vias_vias_edit_button.getText()));
        via_button_panel.add(rules_vias_vias_edit_button);
        separator_label = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013");
        separator_label.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        gridbag.setConstraints(separator_label, gridbag_constraints);
        north_panel.add((Component)separator_label, gridbag_constraints);
        JLabel via_rule_list_name = new JLabel(this.resources.getString("via_rules"));
        via_rule_list_name.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        gridbag.setConstraints(via_rule_list_name, gridbag_constraints);
        north_panel.add((Component)via_rule_list_name, gridbag_constraints);
        north_panel.add((Component)via_rule_list_name, gridbag_constraints);
        this.rule_list_model = new DefaultListModel();
        this.rule_list = new JList<ViaRule>(this.rule_list_model);
        this.rule_list.setSelectionMode(0);
        this.rule_list.setSelectedIndex(0);
        this.rule_list.setVisibleRowCount(5);
        JScrollPane list_scroll_pane = new JScrollPane(this.rule_list);
        list_scroll_pane.setPreferredSize(new Dimension(200, 100));
        this.main_panel.add((Component)list_scroll_pane, "Center");
        BoardRules board_rules = this.board_frame.board_panel.board_handling.get_routing_board().rules;
        for (ViaRule curr_rule : board_rules.via_rules) {
            this.rule_list_model.addElement(curr_rule);
        }
        JPanel via_rule_button_panel = new JPanel();
        via_rule_button_panel.setLayout(new FlowLayout());
        this.add((Component)via_rule_button_panel, "South");
        JButton rules_vias_rules_info_button = new JButton(this.resources.getString("info"));
        rules_vias_rules_info_button.setToolTipText(this.resources.getString("info_tooltip_3"));
        rules_vias_rules_info_button.addActionListener(new ShowViaRuleListener());
        rules_vias_rules_info_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_rules_info_button", rules_vias_rules_info_button.getText()));
        via_rule_button_panel.add(rules_vias_rules_info_button);
        JButton rules_vias_rules_create_button = new JButton(this.resources.getString("create"));
        rules_vias_rules_create_button.setToolTipText(this.resources.getString("create_tooltip_2"));
        rules_vias_rules_create_button.addActionListener(new AddViaRuleListener());
        rules_vias_rules_create_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_rules_create_button", rules_vias_rules_create_button.getText()));
        via_rule_button_panel.add(rules_vias_rules_create_button);
        JButton rules_vias_rules_edit_button = new JButton(this.resources.getString("edit"));
        rules_vias_rules_edit_button.setToolTipText(this.resources.getString("edit_tooltip_2"));
        rules_vias_rules_edit_button.addActionListener(new EditViaRuleListener());
        rules_vias_rules_edit_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_rules_edit_button", rules_vias_rules_edit_button.getText()));
        via_rule_button_panel.add(rules_vias_rules_edit_button);
        JButton rules_vias_rules_remove_button = new JButton(this.resources.getString("remove"));
        rules_vias_rules_remove_button.setToolTipText(this.resources.getString("remove_tooltip_2"));
        rules_vias_rules_remove_button.addActionListener(new RemoveViaRuleListener());
        rules_vias_rules_remove_button.addActionListener(evt -> FRAnalytics.buttonClicked("rules_vias_rules_remove_button", rules_vias_rules_remove_button.getText()));
        via_rule_button_panel.add(rules_vias_rules_remove_button);
        p_board_frame.set_context_sensitive_help(this, "WindowVia");
        this.add(this.main_panel);
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void refresh() {
        this.rule_list_model.removeAllElements();
        BoardRules board_rules = this.board_frame.board_panel.board_handling.get_routing_board().rules;
        for (ViaRule curr_rule : board_rules.via_rules) {
            this.rule_list_model.addElement(curr_rule);
        }
        Iterator<JFrame> it = this.subwindows.iterator();
        while (it.hasNext()) {
            JFrame curr_subwindow = it.next();
            if (curr_subwindow != null) {
                curr_subwindow.dispose();
            }
            it.remove();
        }
    }

    @Override
    public void dispose() {
        for (JFrame curr_subwindow : this.subwindows) {
            if (curr_subwindow == null) continue;
            curr_subwindow.dispose();
        }
        if (this.board_frame.edit_vias_window != null) {
            this.board_frame.edit_vias_window.dispose();
        }
        super.dispose();
    }

    private class ShowPadstacksListener
    implements ActionListener {
        private ShowPadstacksListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            LinkedList<ObjectInfoPanel.Printable> object_list = new LinkedList<ObjectInfoPanel.Printable>();
            BoardLibrary board_library = WindowVia.this.board_frame.board_panel.board_handling.get_routing_board().library;
            for (int i = 0; i < board_library.via_padstack_count(); ++i) {
                object_list.add(board_library.get_via_padstack(i));
            }
            CoordinateTransform coordinate_transform = WindowVia.this.board_frame.board_panel.board_handling.coordinate_transform;
            WindowObjectInfo new_window = WindowObjectInfo.display(WindowVia.this.resources.getString("available_via_padstacks"), object_list, WindowVia.this.board_frame, coordinate_transform);
            java.awt.Point loc = WindowVia.this.getLocation();
            java.awt.Point new_window_location = new java.awt.Point((int)(loc.getX() + 30.0), (int)(loc.getY() + 30.0));
            new_window.setLocation(new_window_location);
            WindowVia.this.subwindows.add(new_window);
        }
    }

    private class AddPadstackListener
    implements ActionListener {
        private AddPadstackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            RoutingBoard pcb = WindowVia.this.board_frame.board_panel.board_handling.get_routing_board();
            if (pcb.layer_structure.arr.length <= 1) {
                return;
            }
            String padstack_name = JOptionPane.showInputDialog(WindowVia.this.resources.getString("message_1"));
            if (padstack_name == null) {
                return;
            }
            while (pcb.library.padstacks.get(padstack_name) != null) {
                padstack_name = JOptionPane.showInputDialog(WindowVia.this.resources.getString("message_2"), (Object)padstack_name);
                if (padstack_name != null) continue;
                return;
            }
            Layer start_layer = pcb.layer_structure.arr[0];
            Layer end_layer = pcb.layer_structure.arr[pcb.layer_structure.arr.length - 1];
            boolean layers_selected = false;
            if (pcb.layer_structure.arr.length == 2) {
                layers_selected = true;
            } else {
                Object[] possible_start_layers = Arrays.copyOf(pcb.layer_structure.arr, pcb.layer_structure.arr.length - 1);
                Object selected_value = JOptionPane.showInputDialog(null, WindowVia.this.resources.getString("select_start_layer"), WindowVia.this.resources.getString("start_layer_selection"), 1, null, possible_start_layers, possible_start_layers[0]);
                if (selected_value == null) {
                    return;
                }
                start_layer = (Layer)selected_value;
                if (start_layer == possible_start_layers[possible_start_layers.length - 1]) {
                    layers_selected = true;
                }
            }
            if (!layers_selected) {
                int first_possible_end_layer_no = pcb.layer_structure.get_no(start_layer) + 1;
                Object[] possible_end_layers = Arrays.copyOfRange(pcb.layer_structure.arr, first_possible_end_layer_no, pcb.layer_structure.arr.length);
                Object selected_value = JOptionPane.showInputDialog(null, WindowVia.this.resources.getString("select_end_layer"), WindowVia.this.resources.getString("end_layer_selection"), 1, null, possible_end_layers, possible_end_layers[possible_end_layers.length - 1]);
                if (selected_value == null) {
                    return;
                }
                end_layer = (Layer)selected_value;
            }
            double default_radius = 100.0;
            JPanel default_radius_input_panel = new JPanel();
            default_radius_input_panel.add(new JLabel(WindowVia.this.resources.getString("message_3")));
            NumberFormat number_format = NumberFormat.getInstance(WindowVia.this.board_frame.get_locale());
            number_format.setMaximumFractionDigits(7);
            JFormattedTextField default_radius_input_field = new JFormattedTextField(number_format);
            default_radius_input_field.setColumns(7);
            default_radius_input_panel.add(default_radius_input_field);
            JOptionPane.showMessageDialog(WindowVia.this.board_frame, default_radius_input_panel, null, -1);
            Object input_value = default_radius_input_field.getValue();
            if (input_value instanceof Number) {
                default_radius = ((Number)input_value).doubleValue();
            }
            PadstackInputPanel padstack_input_panel = new PadstackInputPanel(start_layer, end_layer, default_radius);
            JOptionPane.showMessageDialog(WindowVia.this.board_frame, padstack_input_panel, WindowVia.this.resources.getString("adjust_circles"), -1);
            int from_layer_no = pcb.layer_structure.get_no(start_layer);
            int to_layer_no = pcb.layer_structure.get_no(end_layer);
            ConvexShape[] padstack_shapes = new ConvexShape[pcb.layer_structure.arr.length];
            CoordinateTransform coordinate_transform = WindowVia.this.board_frame.board_panel.board_handling.coordinate_transform;
            boolean shape_exists = false;
            for (int i = from_layer_no; i <= to_layer_no; ++i) {
                int circle_radius;
                Object input = padstack_input_panel.circle_radius[i - from_layer_no].getValue();
                double radius = default_radius;
                if (input instanceof Number) {
                    radius = ((Number)input).doubleValue();
                }
                if ((circle_radius = (int)Math.round(coordinate_transform.user_to_board(radius))) <= 0) continue;
                padstack_shapes[i] = new Circle(Point.ZERO, circle_radius);
                shape_exists = true;
            }
            if (!shape_exists) {
                return;
            }
            Padstack new_padstack = pcb.library.padstacks.add(padstack_name, padstack_shapes, true, true);
            pcb.library.add_via_padstack(new_padstack);
        }
    }

    private class RemovePadstackListener
    implements ActionListener {
        private RemovePadstackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            RoutingBoard pcb = WindowVia.this.board_frame.board_panel.board_handling.get_routing_board();
            Object[] via_padstacks = pcb.library.get_via_padstacks();
            Object selected_value = JOptionPane.showInputDialog(null, WindowVia.this.resources.getString("choose_padstack_to_remove"), WindowVia.this.resources.getString("remove_via_padstack"), 1, null, via_padstacks, via_padstacks[0]);
            if (selected_value == null) {
                return;
            }
            Padstack selected_padstack = (Padstack)selected_value;
            ViaInfo via_with_selected_padstack = null;
            for (int i = 0; i < pcb.rules.via_infos.count(); ++i) {
                if (pcb.rules.via_infos.get(i).get_padstack() != selected_padstack) continue;
                via_with_selected_padstack = pcb.rules.via_infos.get(i);
                break;
            }
            if (via_with_selected_padstack != null) {
                String message = WindowVia.this.resources.getString("message_4") + " " + via_with_selected_padstack.get_name();
                WindowVia.this.board_frame.screen_messages.set_status_message(message);
                return;
            }
            pcb.library.remove_via_padstack(selected_padstack, pcb);
        }
    }

    private class ShowViasListener
    implements ActionListener {
        private ShowViasListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            LinkedList<ObjectInfoPanel.Printable> object_list = new LinkedList<ObjectInfoPanel.Printable>();
            ViaInfos via_infos = WindowVia.this.board_frame.board_panel.board_handling.get_routing_board().rules.via_infos;
            for (int i = 0; i < via_infos.count(); ++i) {
                object_list.add(via_infos.get(i));
            }
            CoordinateTransform coordinate_transform = WindowVia.this.board_frame.board_panel.board_handling.coordinate_transform;
            WindowObjectInfo new_window = WindowObjectInfo.display(WindowVia.this.resources.getString("available_vias"), object_list, WindowVia.this.board_frame, coordinate_transform);
            java.awt.Point loc = WindowVia.this.getLocation();
            java.awt.Point new_window_location = new java.awt.Point((int)(loc.getX() + 30.0), (int)(loc.getY() + 30.0));
            new_window.setLocation(new_window_location);
            WindowVia.this.subwindows.add(new_window);
        }
    }

    private class EditViasListener
    implements ActionListener {
        private EditViasListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowVia.this.board_frame.edit_vias_window.setVisible(true);
        }
    }

    private class ShowViaRuleListener
    implements ActionListener {
        private ShowViaRuleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            List<ViaRule> selected_objects = WindowVia.this.rule_list.getSelectedValuesList();
            if (selected_objects.isEmpty()) {
                return;
            }
            LinkedList<ObjectInfoPanel.Printable> object_list = new LinkedList<ObjectInfoPanel.Printable>(selected_objects);
            CoordinateTransform coordinate_transform = WindowVia.this.board_frame.board_panel.board_handling.coordinate_transform;
            WindowObjectInfo new_window = WindowObjectInfo.display(WindowVia.this.resources.getString("selected_rule"), object_list, WindowVia.this.board_frame, coordinate_transform);
            java.awt.Point loc = WindowVia.this.getLocation();
            java.awt.Point new_window_location = new java.awt.Point((int)(loc.getX() + 30.0), (int)(loc.getY() + 30.0));
            new_window.setLocation(new_window_location);
            WindowVia.this.subwindows.add(new_window);
        }
    }

    private class AddViaRuleListener
    implements ActionListener {
        private AddViaRuleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            String new_name = JOptionPane.showInputDialog(WindowVia.this.resources.getString("message_5"));
            if (new_name == null) {
                return;
            }
            if ((new_name = new_name.trim()).isEmpty()) {
                return;
            }
            ViaRule new_via_rule = new ViaRule(new_name);
            BoardRules board_rules = WindowVia.this.board_frame.board_panel.board_handling.get_routing_board().rules;
            board_rules.via_rules.add(new_via_rule);
            WindowVia.this.rule_list_model.addElement(new_via_rule);
            WindowVia.this.board_frame.refresh_windows();
        }
    }

    private class EditViaRuleListener
    implements ActionListener {
        private EditViaRuleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            ViaRule selected_object = WindowVia.this.rule_list.getSelectedValue();
            if (selected_object == null) {
                return;
            }
            BoardRules board_rules = WindowVia.this.board_frame.board_panel.board_handling.get_routing_board().rules;
            WindowViaRule new_window = new WindowViaRule(selected_object, board_rules.via_infos, WindowVia.this.board_frame);
            java.awt.Point loc = WindowVia.this.getLocation();
            java.awt.Point new_window_location = new java.awt.Point((int)(loc.getX() + 30.0), (int)(loc.getY() + 30.0));
            new_window.setLocation(new_window_location);
            WindowVia.this.subwindows.add(new_window);
        }
    }

    private class RemoveViaRuleListener
    implements ActionListener {
        private RemoveViaRuleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            ViaRule selected_object = WindowVia.this.rule_list.getSelectedValue();
            if (selected_object == null) {
                return;
            }
            ViaRule selected_rule = selected_object;
            String message = WindowVia.this.resources.getString("remove_via_rule") + " " + selected_rule.name + "?";
            if (WindowMessage.confirm(message)) {
                BoardRules board_rules = WindowVia.this.board_frame.board_panel.board_handling.get_routing_board().rules;
                board_rules.via_rules.remove(selected_rule);
                WindowVia.this.rule_list_model.removeElement(selected_rule);
            }
        }
    }

    private class PadstackInputPanel
    extends JPanel {
        private final JLabel[] layer_names;
        private final JFormattedTextField[] circle_radius;

        PadstackInputPanel(Layer p_from_layer, Layer p_to_layer, Double p_default_radius) {
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            GridBagConstraints gridbag_constraints = new GridBagConstraints();
            LayerStructure layer_structure = WindowVia.this.board_frame.board_panel.board_handling.get_routing_board().layer_structure;
            int from_layer_no = layer_structure.get_no(p_from_layer);
            int to_layer_no = layer_structure.get_no(p_to_layer);
            int layer_count = to_layer_no - from_layer_no + 1;
            this.layer_names = new JLabel[layer_count];
            this.circle_radius = new JFormattedTextField[layer_count];
            for (int i = 0; i < layer_count; ++i) {
                String label_string = WindowVia.this.resources.getString("radius_on_layer") + " " + layer_structure.arr[from_layer_no + i].name + ": ";
                this.layer_names[i] = new JLabel(label_string);
                NumberFormat number_format = NumberFormat.getInstance(WindowVia.this.board_frame.get_locale());
                number_format.setMaximumFractionDigits(7);
                this.circle_radius[i] = new JFormattedTextField(number_format);
                this.circle_radius[i].setColumns(7);
                this.circle_radius[i].setValue(p_default_radius);
                gridbag.setConstraints(this.layer_names[i], gridbag_constraints);
                gridbag_constraints.gridwidth = 2;
                this.add((Component)this.layer_names[i], gridbag_constraints);
                gridbag.setConstraints(this.circle_radius[i], gridbag_constraints);
                gridbag_constraints.gridwidth = 0;
                this.add((Component)this.circle_radius[i], gridbag_constraints);
            }
        }
    }
}

