/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.BoardOutline;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.interactive.BoardHandling;
import app.freerouting.management.FRAnalytics;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowRouteDetail
extends BoardSavableSubWindow {
    private static final int c_max_slider_value = 100;
    private static final int c_accuracy_scale_factor = 20;
    private final BoardHandling board_handling;
    private final JSlider accuracy_slider;
    private final JRadioButton route_detail_on_button;
    private final JRadioButton route_detail_off_button;
    private final JCheckBox route_detail_outline_keepout_check_box;

    public WindowRouteDetail(BoardFrame p_board_frame) {
        this.board_handling = p_board_frame.board_panel.board_handling;
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.WindowRouteDetail", p_board_frame.get_locale());
        this.setTitle(resources.getString("title"));
        JPanel main_panel = new JPanel();
        this.getContentPane().add(main_panel);
        GridBagLayout gridbag = new GridBagLayout();
        main_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.anchor = 17;
        gridbag_constraints.insets = new Insets(5, 10, 5, 10);
        JLabel clearance_compensation_label = new JLabel(resources.getString("clearance_compensation"));
        clearance_compensation_label.setToolTipText(resources.getString("clearance_compensation_tooltip"));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 2;
        gridbag.setConstraints(clearance_compensation_label, gridbag_constraints);
        main_panel.add(clearance_compensation_label);
        this.route_detail_on_button = new JRadioButton(resources.getString("on"));
        this.route_detail_off_button = new JRadioButton(resources.getString("off"));
        this.route_detail_on_button.addActionListener(new CompensationOnListener());
        this.route_detail_on_button.addActionListener(evt -> FRAnalytics.buttonClicked("route_detail_on_button", this.route_detail_on_button.getText()));
        this.route_detail_off_button.addActionListener(new CompensationOffListener());
        this.route_detail_off_button.addActionListener(evt -> FRAnalytics.buttonClicked("route_detail_off_button", this.route_detail_off_button.getText()));
        ButtonGroup clearance_compensation_button_group = new ButtonGroup();
        clearance_compensation_button_group.add(this.route_detail_on_button);
        clearance_compensation_button_group.add(this.route_detail_off_button);
        this.route_detail_off_button.setSelected(true);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        gridbag.setConstraints(this.route_detail_on_button, gridbag_constraints);
        main_panel.add((Component)this.route_detail_on_button, gridbag_constraints);
        gridbag.setConstraints(this.route_detail_off_button, gridbag_constraints);
        main_panel.add((Component)this.route_detail_off_button, gridbag_constraints);
        JLabel separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel pull_tight_accuracy_label = new JLabel(resources.getString("pull_tight_accuracy"));
        pull_tight_accuracy_label.setToolTipText(resources.getString("pull_tight_accuracy_tooltip"));
        gridbag_constraints.insets = new Insets(5, 10, 5, 10);
        gridbag.setConstraints(pull_tight_accuracy_label, gridbag_constraints);
        main_panel.add(pull_tight_accuracy_label);
        this.accuracy_slider = new JSlider();
        this.accuracy_slider.setMaximum(100);
        this.accuracy_slider.addChangeListener(new SliderChangeListener());
        gridbag.setConstraints(this.accuracy_slider, gridbag_constraints);
        main_panel.add(this.accuracy_slider);
        separator = new JLabel("  \u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        this.route_detail_outline_keepout_check_box = new JCheckBox(resources.getString("keepout_outside_outline"));
        this.route_detail_outline_keepout_check_box.setSelected(false);
        this.route_detail_outline_keepout_check_box.addActionListener(new OutLineKeepoutListener());
        this.route_detail_outline_keepout_check_box.addActionListener(evt -> FRAnalytics.buttonClicked("route_detail_outline_keepout_check_box", this.route_detail_outline_keepout_check_box.getText()));
        gridbag.setConstraints(this.route_detail_outline_keepout_check_box, gridbag_constraints);
        this.route_detail_outline_keepout_check_box.setToolTipText(resources.getString("keepout_outside_outline_tooltip"));
        main_panel.add((Component)this.route_detail_outline_keepout_check_box, gridbag_constraints);
        separator = new JLabel();
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        this.refresh();
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void refresh() {
        if (this.board_handling.get_routing_board().search_tree_manager.is_clearance_compensation_used()) {
            this.route_detail_on_button.setSelected(true);
        } else {
            this.route_detail_off_button.setSelected(true);
        }
        BoardOutline outline = this.board_handling.get_routing_board().get_outline();
        if (outline != null) {
            this.route_detail_outline_keepout_check_box.setSelected(outline.keepout_outside_outline_generated());
        }
        int accuracy_slider_value = 100 - this.board_handling.settings.get_trace_pull_tight_accuracy() / 20 + 1;
        this.accuracy_slider.setValue(accuracy_slider_value);
    }

    private class CompensationOnListener
    implements ActionListener {
        private CompensationOnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteDetail.this.board_handling.set_clearance_compensation(true);
        }
    }

    private class CompensationOffListener
    implements ActionListener {
        private CompensationOffListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowRouteDetail.this.board_handling.set_clearance_compensation(false);
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        private SliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            int new_accuracy = (100 - WindowRouteDetail.this.accuracy_slider.getValue() + 1) * 20;
            WindowRouteDetail.this.board_handling.settings.set_current_pull_tight_accuracy(new_accuracy);
        }
    }

    private class OutLineKeepoutListener
    implements ActionListener {
        private OutLineKeepoutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            if (WindowRouteDetail.this.board_handling.is_board_read_only()) {
                return;
            }
            BoardOutline outline = WindowRouteDetail.this.board_handling.get_routing_board().get_outline();
            if (outline != null) {
                outline.generate_keepout_outside(WindowRouteDetail.this.route_detail_outline_keepout_check_box.isSelected());
            }
        }
    }
}

