/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.WindowObjectListWithFilter;
import app.freerouting.library.Padstack;
import app.freerouting.library.Padstacks;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;

public class WindowPadstacks
extends WindowObjectListWithFilter {
    public WindowPadstacks(BoardFrame p_board_frame) {
        super(p_board_frame);
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.Default", p_board_frame.get_locale());
        this.setTitle(resources.getString("padstacks"));
        p_board_frame.set_context_sensitive_help(this, "WindowObjectList_LibraryPadstacks");
    }

    @Override
    protected void fill_list() {
        int i;
        Padstacks padstacks = this.board_frame.board_panel.board_handling.get_routing_board().library.padstacks;
        Object[] sorted_arr = new Padstack[padstacks.count()];
        for (i = 0; i < sorted_arr.length; ++i) {
            sorted_arr[i] = padstacks.get(i + 1);
        }
        Arrays.sort(sorted_arr);
        for (i = 0; i < sorted_arr.length; ++i) {
            this.add_to_list(sorted_arr[i]);
        }
        this.list.setVisibleRowCount(Math.min(padstacks.count(), 20));
    }

    @Override
    protected void select_instances() {
        UndoableObjects.Storable curr_object;
        List selected_padstacks = this.list.getSelectedValuesList();
        if (selected_padstacks.isEmpty()) {
            return;
        }
        LinkedList<Padstack> padstack_list = new LinkedList<Padstack>();
        for (int i = 0; i < selected_padstacks.size(); ++i) {
            padstack_list.add((Padstack)selected_padstacks.get(i));
        }
        RoutingBoard routing_board = this.board_frame.board_panel.board_handling.get_routing_board();
        TreeSet<Item> board_instances = new TreeSet<Item>();
        Iterator<UndoableObjects.UndoableObjectNode> it = routing_board.item_list.start_read_object();
        block1: while ((curr_object = routing_board.item_list.read_object(it)) != null) {
            if (!(curr_object instanceof DrillItem)) continue;
            Padstack curr_padstack = ((DrillItem)curr_object).get_padstack();
            for (Padstack curr_selected_padstack : padstack_list) {
                if (curr_padstack != curr_selected_padstack) continue;
                board_instances.add((Item)curr_object);
                continue block1;
            }
        }
        this.board_frame.board_panel.board_handling.select_items(board_instances);
        this.board_frame.board_panel.board_handling.zoom_selection();
    }
}

