/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.boardgraphics.ColorIntensityTable;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.WindowVisibility;
import java.util.ResourceBundle;

public class WindowObjectVisibility
extends WindowVisibility {
    private WindowObjectVisibility(BoardFrame p_board_frame, String p_title, String p_header_message, String[] p_message_arr) {
        super(p_board_frame, p_title, p_header_message, p_message_arr);
    }

    public static WindowObjectVisibility get_instance(BoardFrame p_board_frame) {
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.WindowObjectVisibility", p_board_frame.get_locale());
        String title = resources.getString("title");
        String header_message = resources.getString("header_message");
        String[] message_arr = new String[ColorIntensityTable.ObjectNames.values().length];
        for (int i = 0; i < message_arr.length; ++i) {
            message_arr[i] = resources.getString(ColorIntensityTable.ObjectNames.values()[i].toString());
        }
        WindowObjectVisibility result = new WindowObjectVisibility(p_board_frame, title, header_message, message_arr);
        p_board_frame.set_context_sensitive_help(result, "WindowDisplay_ObjectVisibility");
        result.refresh();
        return result;
    }

    @Override
    public void refresh() {
        ColorIntensityTable color_intensity_table = this.get_board_handling().graphics_context.color_intensity_table;
        for (int i = 0; i < ColorIntensityTable.ObjectNames.values().length; ++i) {
            this.set_slider_value(i, color_intensity_table.get_value(i));
        }
    }

    @Override
    protected void set_changed_value(int p_index, double p_value) {
        this.get_board_handling().graphics_context.color_intensity_table.set_value(p_index, p_value);
    }
}

