/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.WindowObjectList;
import app.freerouting.logger.FRLogger;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class WindowObjectListWithFilter
extends WindowObjectList {
    private final JTextField filter_string;

    public WindowObjectListWithFilter(BoardFrame p_board_frame) {
        super(p_board_frame);
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.WindowObjectList", p_board_frame.get_locale());
        JPanel input_panel = new JPanel();
        this.south_panel.add((Component)input_panel, "South");
        JLabel filter_label = new JLabel(resources.getString("filter"));
        input_panel.add((Component)filter_label, "West");
        this.filter_string = new JTextField(10);
        this.filter_string.setText("");
        input_panel.add((Component)this.filter_string, "East");
    }

    @Override
    protected void add_to_list(Object p_object) {
        String curr_filter_string = this.filter_string.getText().trim();
        boolean object_matches = curr_filter_string.isEmpty() ? true : p_object.toString().contains(curr_filter_string);
        if (object_matches) {
            super.add_to_list(p_object);
        }
    }

    public SnapshotInfo get_snapshot_info() {
        int[] selected_indices = this.list != null ? this.list.getSelectedIndices() : new int[]{};
        return new SnapshotInfo(this.filter_string.getText(), selected_indices);
    }

    public void set_snapshot_info(SnapshotInfo p_snapshot_info) {
        if (!p_snapshot_info.filter.equals(this.filter_string.getText())) {
            this.filter_string.setText(p_snapshot_info.filter);
            this.recalculate();
        }
        if (this.list != null && p_snapshot_info.selected_indices.length > 0) {
            this.list.setSelectedIndices(p_snapshot_info.selected_indices);
        }
    }

    @Override
    public void save(ObjectOutputStream p_object_stream) {
        try {
            p_object_stream.writeObject(this.filter_string.getText());
        }
        catch (IOException e) {
            FRLogger.warn("WindowObjectListWithFilter.save: save failed");
        }
        super.save(p_object_stream);
    }

    @Override
    public boolean read(ObjectInputStream p_object_stream) {
        try {
            String curr_string = (String)p_object_stream.readObject();
            this.filter_string.setText(curr_string);
        }
        catch (Exception e) {
            FRLogger.warn("WindowObjectListWithFilter.read: read failed");
        }
        return super.read(p_object_stream);
    }

    public static class SnapshotInfo
    implements Serializable {
        private final String filter;
        private final int[] selected_indices;

        private SnapshotInfo(String p_filter, int[] p_selected_indices) {
            this.filter = p_filter;
            this.selected_indices = p_selected_indices;
        }
    }
}

