/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.CoordinateTransform;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.gui.WindowObjectInfo;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.FRAnalytics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class WindowObjectList
extends BoardSavableSubWindow {
    protected static final int DEFAULT_TABLE_SIZE = 20;
    protected final BoardFrame board_frame;
    protected final JPanel south_panel;
    protected final Collection<WindowObjectInfo> subwindows = new LinkedList<WindowObjectInfo>();
    private final JPanel main_panel;
    private final ResourceBundle resources;
    protected JLabel list_empty_message;
    protected JList<Object> list;
    private JScrollPane list_scroll_pane;
    private DefaultListModel<Object> list_model;

    public WindowObjectList(BoardFrame p_board_frame) {
        this.board_frame = p_board_frame;
        this.resources = ResourceBundle.getBundle("app.freerouting.gui.WindowObjectList", p_board_frame.get_locale());
        this.main_panel = new JPanel();
        this.main_panel.setLayout(new BorderLayout());
        this.add(this.main_panel);
        this.south_panel = new JPanel();
        this.south_panel.setLayout(new BorderLayout());
        this.main_panel.add((Component)this.south_panel, "South");
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new BorderLayout());
        this.south_panel.add((Component)button_panel, "Center");
        JPanel north_button_panel = new JPanel();
        button_panel.add((Component)north_button_panel, "North");
        JButton info_components_show_button = new JButton(this.resources.getString("info"));
        info_components_show_button.setToolTipText(this.resources.getString("info_tooltip"));
        ShowListener show_listener = new ShowListener();
        info_components_show_button.addActionListener(show_listener);
        info_components_show_button.addActionListener(evt -> FRAnalytics.buttonClicked("info_components_show_button", info_components_show_button.getText()));
        north_button_panel.add(info_components_show_button);
        JButton info_components_instance_button = new JButton(this.resources.getString("select"));
        info_components_instance_button.setToolTipText(this.resources.getString("select_tooltip"));
        SelectListener instance_listener = new SelectListener();
        info_components_instance_button.addActionListener(instance_listener);
        info_components_instance_button.addActionListener(evt -> FRAnalytics.buttonClicked("info_components_instance_button", info_components_instance_button.getText()));
        north_button_panel.add(info_components_instance_button);
        JPanel south_button_panel = new JPanel();
        button_panel.add((Component)south_button_panel, "South");
        JButton info_components_invert_button = new JButton(this.resources.getString("invert"));
        info_components_invert_button.setToolTipText(this.resources.getString("invert_tooltip"));
        info_components_invert_button.addActionListener(new InvertListener());
        info_components_invert_button.addActionListener(evt -> FRAnalytics.buttonClicked("info_components_invert_button", info_components_invert_button.getText()));
        south_button_panel.add(info_components_invert_button);
        JButton info_components_recalculate_button = new JButton(this.resources.getString("recalculate"));
        info_components_recalculate_button.setToolTipText(this.resources.getString("recalculate_tooltip"));
        RecalculateListener recalculate_listener = new RecalculateListener();
        info_components_recalculate_button.addActionListener(recalculate_listener);
        info_components_recalculate_button.addActionListener(evt -> FRAnalytics.buttonClicked("info_components_recalculate_button", info_components_recalculate_button.getText()));
        south_button_panel.add(info_components_recalculate_button);
        this.list_empty_message = new JLabel(this.resources.getString("list_empty"));
        this.list_empty_message.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WindowObjectList.this.dispose();
            }
        });
    }

    @Override
    public void setVisible(boolean p_value) {
        if (p_value) {
            this.recalculate();
        }
        super.setVisible(p_value);
    }

    protected void recalculate() {
        if (this.list_scroll_pane != null) {
            this.main_panel.remove(this.list_scroll_pane);
        }
        this.main_panel.remove(this.list_empty_message);
        this.list_model = new DefaultListModel();
        this.list = new JList<Object>(this.list_model);
        this.list.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.fill_list();
        if (this.list.getVisibleRowCount() > 0) {
            this.list_scroll_pane = new JScrollPane(this.list);
            this.main_panel.add((Component)this.list_scroll_pane, "Center");
        } else {
            this.main_panel.add((Component)this.list_empty_message, "Center");
        }
        this.pack();
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() > 1) {
                    WindowObjectList.this.select_instances();
                }
            }
        });
    }

    @Override
    public void dispose() {
        for (WindowObjectInfo curr_subwindow : this.subwindows) {
            if (curr_subwindow == null) continue;
            curr_subwindow.dispose();
        }
        super.dispose();
    }

    protected void add_to_list(Object p_object) {
        this.list_model.addElement(p_object);
    }

    protected abstract void fill_list();

    protected abstract void select_instances();

    @Override
    public void save(ObjectOutputStream p_object_stream) {
        int[] selected_indices = this.list != null ? this.list.getSelectedIndices() : new int[]{};
        try {
            p_object_stream.writeObject(selected_indices);
        }
        catch (IOException e) {
            FRLogger.error("WindowObjectList.save: save failed", e);
        }
        super.save(p_object_stream);
    }

    @Override
    public boolean read(ObjectInputStream p_object_stream) {
        int[] saved_selected_indices;
        try {
            saved_selected_indices = (int[])p_object_stream.readObject();
        }
        catch (Exception e) {
            FRLogger.error("WindowObjectListWithFilter.read: read failed", e);
            return false;
        }
        boolean result = super.read(p_object_stream);
        if (this.list != null && saved_selected_indices.length > 0) {
            this.list.setSelectedIndices(saved_selected_indices);
        }
        return result;
    }

    private class ShowListener
    implements ActionListener {
        private static final int WINDOW_OFFSET = 30;

        private ShowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            List<Object> selected_objects = WindowObjectList.this.list.getSelectedValuesList();
            if (selected_objects.isEmpty()) {
                return;
            }
            LinkedList<ObjectInfoPanel.Printable> object_list = new LinkedList<ObjectInfoPanel.Printable>();
            for (int i = 0; i < selected_objects.size(); ++i) {
                object_list.add((ObjectInfoPanel.Printable)selected_objects.get(i));
            }
            CoordinateTransform coordinate_transform = WindowObjectList.this.board_frame.board_panel.board_handling.coordinate_transform;
            WindowObjectInfo new_window = WindowObjectInfo.display(WindowObjectList.this.resources.getString("window_title"), object_list, WindowObjectList.this.board_frame, coordinate_transform);
            Point loc = WindowObjectList.this.getLocation();
            Point new_window_location = new Point((int)(loc.getX() + 30.0), (int)(loc.getY() + 30.0));
            new_window.setLocation(new_window_location);
            WindowObjectList.this.subwindows.add(new_window);
        }
    }

    private class SelectListener
    implements ActionListener {
        private SelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowObjectList.this.select_instances();
        }
    }

    private class InvertListener
    implements ActionListener {
        private InvertListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            if (WindowObjectList.this.list_model == null) {
                return;
            }
            int[] new_selected_indices = new int[WindowObjectList.this.list_model.getSize() - WindowObjectList.this.list.getSelectedIndices().length];
            int curr_index = 0;
            for (int i = 0; i < WindowObjectList.this.list_model.getSize(); ++i) {
                if (WindowObjectList.this.list.isSelectedIndex(i)) continue;
                new_selected_indices[curr_index] = i;
                ++curr_index;
            }
            WindowObjectList.this.list.setSelectedIndices(new_selected_indices);
        }
    }

    private class RecalculateListener
    implements ActionListener {
        private RecalculateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowObjectList.this.recalculate();
        }
    }
}

