/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.TestLevel;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSubWindow;
import app.freerouting.gui.DesignFile;
import app.freerouting.gui.WindowMessage;
import app.freerouting.management.FRAnalytics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public abstract class WindowNetSamples
extends BoardSubWindow {
    protected final ResourceBundle resources;
    protected final Locale locale;
    protected final JList<SampleDesignListElement> list;
    protected DefaultListModel<SampleDesignListElement> list_model = new DefaultListModel();

    public WindowNetSamples(Locale p_locale, String p_title, String p_button_name, int p_row_count) {
        this.locale = p_locale;
        this.resources = ResourceBundle.getBundle("app.freerouting.gui.WindowNetSamples", p_locale);
        this.setTitle(this.resources.getString(p_title));
        this.setDefaultCloseOperation(2);
        JPanel main_panel = new JPanel();
        this.add(main_panel);
        main_panel.setLayout(new BorderLayout());
        Border panel_border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        main_panel.setBorder(panel_border);
        JButton net_samples_open_button = new JButton(this.resources.getString(p_button_name));
        net_samples_open_button.addActionListener(new OpenListener());
        net_samples_open_button.addActionListener(evt -> FRAnalytics.buttonClicked("net_samples_open_button", net_samples_open_button.getText()));
        main_panel.add((Component)net_samples_open_button, "South");
        this.list = new JList<SampleDesignListElement>(this.list_model);
        this.fill_list();
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.setVisibleRowCount(p_row_count);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() > 1) {
                    WindowNetSamples.this.button_pushed();
                }
            }
        });
        JScrollPane list_scroll_pane = new JScrollPane(this.list);
        list_scroll_pane.setPreferredSize(new Dimension(200, 20 * p_row_count));
        main_panel.add((Component)list_scroll_pane, "Center");
        this.pack();
    }

    protected static ZipInputStream open_zipped_file(String p_archive_name, String p_file_name) {
        ZipEntry curr_entry;
        String design_name;
        ZipInputStream zip_input_stream;
        InputStream input_stream;
        URLConnection net_connection;
        URL archive_url;
        String archive_path_name = "http://www.freerouting.app" + p_archive_name + ".zip";
        try {
            archive_url = new URL(archive_path_name);
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            net_connection = archive_url.openConnection();
        }
        catch (Exception e) {
            return null;
        }
        try {
            input_stream = net_connection.getInputStream();
        }
        catch (IOException | SecurityException e) {
            return null;
        }
        try {
            zip_input_stream = new ZipInputStream(input_stream);
        }
        catch (Exception e) {
            WindowMessage.show("unable to get zip input stream");
            return null;
        }
        String compare_name = p_archive_name + "/" + p_file_name;
        do {
            try {
                curr_entry = zip_input_stream.getNextEntry();
            }
            catch (Exception E) {
                return null;
            }
            if (curr_entry != null) continue;
            return null;
        } while (!(design_name = curr_entry.getName()).equals(compare_name));
        return zip_input_stream;
    }

    protected static BoardFrame open_design(String p_archive_name, String p_design_name, Locale p_locale, boolean p_save_intermediate_stages, float p_optimization_improvement_threshold) {
        ZipInputStream zip_input_stream = WindowNetSamples.open_zipped_file(p_archive_name, p_design_name);
        if (zip_input_stream == null) {
            return null;
        }
        DesignFile design_file = DesignFile.get_instance("sharc_routed.dsn");
        BoardFrame new_frame = new BoardFrame(design_file, BoardFrame.Option.WEBSTART, TestLevel.RELEASE_VERSION, p_locale, false, p_save_intermediate_stages, p_optimization_improvement_threshold);
        boolean read_ok = new_frame.read(zip_input_stream, true, null);
        if (!read_ok) {
            return null;
        }
        new_frame.setVisible(true);
        return new_frame;
    }

    private static void read_zipped_logfile(BoardFrame p_board_frame, String p_archive_name, String p_logfile_name) {
        if (p_board_frame == null) {
            return;
        }
        ZipInputStream zip_input_stream = WindowNetSamples.open_zipped_file(p_archive_name, p_logfile_name);
        if (zip_input_stream == null) {
            return;
        }
        p_board_frame.read_logfile(zip_input_stream);
    }

    protected abstract void fill_list();

    protected abstract void button_pushed();

    protected void add(String p_design_name, String p_message_name, AdditionalAction p_additional_action) {
        this.list_model.addElement(new SampleDesignListElement(p_design_name, this.resources.getString(p_message_name), p_additional_action));
    }

    protected void add(String p_design_name) {
        this.list_model.addElement(new SampleDesignListElement(p_design_name, "", AdditionalAction.NONE));
    }

    private class OpenListener
    implements ActionListener {
        private OpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowNetSamples.this.button_pushed();
        }
    }

    protected static class SampleDesignListElement {
        public final String design_name;
        public final AdditionalAction additional_action;
        private final String message_name;

        SampleDesignListElement(String p_design_name, String p_message_name, AdditionalAction p_additional_action) {
            this.design_name = p_design_name;
            this.message_name = p_message_name;
            this.additional_action = p_additional_action;
        }

        public String toString() {
            return this.message_name;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum AdditionalAction {
        READ_LOGFILE{

            @Override
            void perform(BoardFrame p_board_frame, String p_archive_name) {
                String logfile_archive_name = "route_" + p_archive_name;
                WindowNetSamples.read_zipped_logfile(p_board_frame, logfile_archive_name, logfile_archive_name + ".log");
            }
        }
        ,
        AUTOROUTE{

            @Override
            void perform(BoardFrame p_board_frame, String p_archive_name) {
                p_board_frame.board_panel.board_handling.start_batch_autorouter();
            }
        }
        ,
        NONE{

            @Override
            void perform(BoardFrame p_board_frame, String p_archive_name) {
            }
        };


        abstract void perform(BoardFrame var1, String var2);
    }
}

