/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.WindowNetSamples;
import java.util.Locale;

public class WindowNetDemonstrations
extends WindowNetSamples {
    public WindowNetDemonstrations(Locale p_locale) {
        super(p_locale, "router_demonstrations", "replay_example", 7);
    }

    @Override
    protected void fill_list() {
        this.add("sample_45.dsn", "45_degree_logfile", WindowNetSamples.AdditionalAction.READ_LOGFILE);
        this.add("int_ar.dsn", "drag_component_logfile", WindowNetSamples.AdditionalAction.READ_LOGFILE);
        this.add("single_layer.dsn", "any_angle_logfile", WindowNetSamples.AdditionalAction.READ_LOGFILE);
        this.add("hexapod_empty.dsn", "autorouter_example_1", WindowNetSamples.AdditionalAction.AUTOROUTE);
        this.add("at14_empty.dsn", "autorouter_example_2", WindowNetSamples.AdditionalAction.AUTOROUTE);
        this.add("sharp_empty.dsn", "autorouter_example_3", WindowNetSamples.AdditionalAction.AUTOROUTE);
    }

    @Override
    protected void button_pushed() {
        int index = this.list.getSelectedIndex();
        if (index < 0 || index >= this.list_model.getSize()) {
            return;
        }
        WindowNetSamples.SampleDesignListElement selected_element = (WindowNetSamples.SampleDesignListElement)this.list_model.elementAt(index);
        String[] name_parts = selected_element.design_name.split("\\.");
        String archive_name = name_parts[0];
        BoardFrame new_frame = WindowNetDemonstrations.open_design(archive_name, selected_element.design_name, this.locale, false, 0.0f);
        if (new_frame != null) {
            selected_element.additional_action.perform(new_frame, archive_name);
        }
    }
}

