/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.LayerStructure;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardPanel;
import app.freerouting.gui.WindowVisibility;
import java.util.ResourceBundle;

public class WindowLayerVisibility
extends WindowVisibility {
    private WindowLayerVisibility(BoardFrame p_board_frame, String p_title, String p_header_message, String[] p_message_arr) {
        super(p_board_frame, p_title, p_header_message, p_message_arr);
    }

    public static WindowLayerVisibility get_instance(BoardFrame p_board_frame) {
        BoardPanel board_panel = p_board_frame.board_panel;
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.Default", p_board_frame.get_locale());
        String title = resources.getString("layer_visibility");
        String header_message = resources.getString("layer_visibility_header");
        LayerStructure layer_structure = board_panel.board_handling.get_routing_board().layer_structure;
        String[] message_arr = new String[layer_structure.arr.length];
        for (int i = 0; i < message_arr.length; ++i) {
            message_arr[i] = layer_structure.arr[i].name;
        }
        WindowLayerVisibility result = new WindowLayerVisibility(p_board_frame, title, header_message, message_arr);
        for (int i = 0; i < message_arr.length; ++i) {
            result.set_slider_value(i, board_panel.board_handling.graphics_context.get_raw_layer_visibility(i));
        }
        p_board_frame.set_context_sensitive_help(result, "WindowDisplay_LayerVisibility");
        return result;
    }

    @Override
    protected void set_changed_value(int p_index, double p_value) {
        this.get_board_handling().set_layer_visibility(p_index, p_value);
    }

    @Override
    protected void set_all_minimum() {
        int layer_count = this.get_board_handling().graphics_context.layer_count();
        for (int i = 0; i < layer_count; ++i) {
            if (i == this.get_board_handling().settings.get_layer()) continue;
            this.set_slider_value(i, 0.0);
            this.set_changed_value(i, 0.0);
        }
    }

    @Override
    public void refresh() {
        GraphicsContext graphics_context = this.get_board_handling().graphics_context;
        for (int i = 0; i < graphics_context.layer_count(); ++i) {
            this.set_slider_value(i, graphics_context.get_raw_layer_visibility(i));
        }
    }
}

