/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Component;
import app.freerouting.board.Components;
import app.freerouting.board.Item;
import app.freerouting.board.RoutingBoard;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.WindowObjectListWithFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;

public class WindowComponents
extends WindowObjectListWithFilter {
    public WindowComponents(BoardFrame p_board_frame) {
        super(p_board_frame);
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.Default", p_board_frame.get_locale());
        this.setTitle(resources.getString("components"));
        p_board_frame.set_context_sensitive_help(this, "WindowObjectList_BoardComponents");
    }

    @Override
    protected void fill_list() {
        int i;
        Components components = this.board_frame.board_panel.board_handling.get_routing_board().components;
        Object[] sorted_arr = new Component[components.count()];
        for (i = 0; i < sorted_arr.length; ++i) {
            sorted_arr[i] = components.get(i + 1);
        }
        Arrays.sort(sorted_arr);
        for (i = 0; i < sorted_arr.length; ++i) {
            this.add_to_list(sorted_arr[i]);
        }
        this.list.setVisibleRowCount(Math.min(components.count(), 20));
    }

    @Override
    protected void select_instances() {
        List selected_components = this.list.getSelectedValuesList();
        if (selected_components.isEmpty()) {
            return;
        }
        RoutingBoard routing_board = this.board_frame.board_panel.board_handling.get_routing_board();
        TreeSet<Item> selected_items = new TreeSet<Item>();
        Collection<Item> board_items = routing_board.get_items();
        for (Item curr_item : board_items) {
            if (curr_item.get_component_no() <= 0) continue;
            Component curr_component = routing_board.components.get(curr_item.get_component_no());
            boolean component_matches = false;
            for (int i = 0; i < selected_components.size(); ++i) {
                if (curr_component != selected_components.get(i)) continue;
                component_matches = true;
                break;
            }
            if (!component_matches) continue;
            selected_items.add(curr_item);
        }
        this.board_frame.board_panel.board_handling.select_items(selected_items);
        this.board_frame.board_panel.board_handling.zoom_selection();
    }
}

