/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Layer;
import app.freerouting.board.LayerStructure;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.gui.WindowAutorouteDetailParameter;
import app.freerouting.interactive.AutorouteSettings;
import app.freerouting.interactive.BoardHandling;
import app.freerouting.management.FRAnalytics;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WindowAutorouteParameter
extends BoardSavableSubWindow {
    private final BoardHandling board_handling;
    private final JLabel[] layer_name_arr;
    private final JCheckBox[] settings_autorouter_layer_active_arr;
    private final List<JComboBox<String>> settings_autorouter_combo_box_arr;
    private final JCheckBox settings_autorouter_vias_allowed;
    private final JCheckBox settings_autorouter_fanout_pass_button;
    private final JCheckBox settings_autorouter_autoroute_pass_button;
    private final JCheckBox settings_autorouter_postroute_pass_button;
    private final WindowAutorouteDetailParameter detail_window;
    private final DetailListener detail_listener;
    private final String horizontal;
    private final String vertical;

    public WindowAutorouteParameter(BoardFrame p_board_frame) {
        this.board_handling = p_board_frame.board_panel.board_handling;
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.WindowAutorouteParameter", p_board_frame.get_locale());
        this.setTitle(resources.getString("title"));
        this.setDefaultCloseOperation(2);
        JPanel main_panel = new JPanel();
        this.getContentPane().add(main_panel);
        GridBagLayout gridbag = new GridBagLayout();
        main_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.anchor = 17;
        gridbag_constraints.insets = new Insets(1, 10, 1, 10);
        gridbag_constraints.gridwidth = 3;
        JLabel layer_label = new JLabel(resources.getString("layer"));
        gridbag.setConstraints(layer_label, gridbag_constraints);
        main_panel.add(layer_label);
        JLabel active_label = new JLabel(resources.getString("active"));
        gridbag.setConstraints(active_label, gridbag_constraints);
        main_panel.add(active_label);
        gridbag_constraints.gridwidth = 0;
        JLabel preferred_direction_label = new JLabel(resources.getString("preferred_direction"));
        gridbag.setConstraints(preferred_direction_label, gridbag_constraints);
        main_panel.add(preferred_direction_label);
        this.horizontal = resources.getString("horizontal");
        this.vertical = resources.getString("vertical");
        LayerStructure layer_structure = this.board_handling.get_routing_board().layer_structure;
        int layer_count = layer_structure.arr.length;
        this.layer_name_arr = new JLabel[layer_count];
        this.settings_autorouter_layer_active_arr = new JCheckBox[layer_count];
        this.settings_autorouter_combo_box_arr = new ArrayList<JComboBox<String>>(layer_count);
        for (int i = 0; i < layer_count; ++i) {
            gridbag_constraints.gridwidth = 3;
            Layer curr_layer = layer_structure.arr[i];
            this.layer_name_arr[i] = new JLabel();
            this.layer_name_arr[i].setText(curr_layer.name);
            gridbag.setConstraints(this.layer_name_arr[i], gridbag_constraints);
            main_panel.add(this.layer_name_arr[i]);
            this.settings_autorouter_layer_active_arr[i] = new JCheckBox();
            this.settings_autorouter_layer_active_arr[i].addActionListener(new LayerActiveListener(i));
            this.settings_autorouter_layer_active_arr[i].addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_layer_active_arr", null));
            this.board_handling.settings.autoroute_settings.set_layer_active(i, curr_layer.is_signal);
            this.settings_autorouter_layer_active_arr[i].setEnabled(curr_layer.is_signal);
            gridbag.setConstraints(this.settings_autorouter_layer_active_arr[i], gridbag_constraints);
            main_panel.add(this.settings_autorouter_layer_active_arr[i]);
            this.settings_autorouter_combo_box_arr.add(new JComboBox());
            this.settings_autorouter_combo_box_arr.get(i).addItem(this.horizontal);
            this.settings_autorouter_combo_box_arr.get(i).addItem(this.vertical);
            this.settings_autorouter_combo_box_arr.get(i).addActionListener(new PreferredDirectionListener(i));
            this.settings_autorouter_combo_box_arr.get(i).addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_combo_box_arr", null));
            gridbag_constraints.gridwidth = 0;
            gridbag.setConstraints(this.settings_autorouter_combo_box_arr.get(i), gridbag_constraints);
            main_panel.add(this.settings_autorouter_combo_box_arr.get(i));
        }
        JLabel separator = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        gridbag_constraints.gridwidth = -1;
        JLabel vias_allowed_label = new JLabel(resources.getString("vias_allowed"));
        gridbag.setConstraints(vias_allowed_label, gridbag_constraints);
        main_panel.add(vias_allowed_label);
        this.settings_autorouter_vias_allowed = new JCheckBox();
        this.settings_autorouter_vias_allowed.addActionListener(new ViasAllowedListener());
        this.settings_autorouter_vias_allowed.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_vias_allowed", this.settings_autorouter_vias_allowed.getText()));
        gridbag_constraints.gridwidth = 0;
        gridbag.setConstraints(this.settings_autorouter_vias_allowed, gridbag_constraints);
        main_panel.add(this.settings_autorouter_vias_allowed);
        separator = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        JLabel passes_label = new JLabel(resources.getString("passes"));
        gridbag_constraints.gridwidth = -1;
        gridbag_constraints.gridheight = 3;
        gridbag.setConstraints(passes_label, gridbag_constraints);
        main_panel.add(passes_label);
        this.settings_autorouter_fanout_pass_button = new JCheckBox(resources.getString("fanout"));
        this.settings_autorouter_autoroute_pass_button = new JCheckBox(resources.getString("autoroute"));
        this.settings_autorouter_postroute_pass_button = new JCheckBox(resources.getString("postroute"));
        this.settings_autorouter_fanout_pass_button.addActionListener(new FanoutListener());
        this.settings_autorouter_fanout_pass_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_fanout_pass_button", this.settings_autorouter_fanout_pass_button.getText()));
        this.settings_autorouter_autoroute_pass_button.addActionListener(new AutorouteListener());
        this.settings_autorouter_autoroute_pass_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_autoroute_pass_button", this.settings_autorouter_autoroute_pass_button.getText()));
        this.settings_autorouter_postroute_pass_button.addActionListener(new PostrouteListener());
        this.settings_autorouter_postroute_pass_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_postroute_pass_button", this.settings_autorouter_postroute_pass_button.getText()));
        this.settings_autorouter_fanout_pass_button.setSelected(false);
        this.settings_autorouter_autoroute_pass_button.setSelected(true);
        this.settings_autorouter_autoroute_pass_button.setSelected(true);
        gridbag_constraints.gridwidth = 0;
        gridbag_constraints.gridheight = 1;
        gridbag.setConstraints(this.settings_autorouter_fanout_pass_button, gridbag_constraints);
        main_panel.add((Component)this.settings_autorouter_fanout_pass_button, gridbag_constraints);
        gridbag.setConstraints(this.settings_autorouter_autoroute_pass_button, gridbag_constraints);
        main_panel.add((Component)this.settings_autorouter_autoroute_pass_button, gridbag_constraints);
        gridbag.setConstraints(this.settings_autorouter_postroute_pass_button, gridbag_constraints);
        main_panel.add((Component)this.settings_autorouter_postroute_pass_button, gridbag_constraints);
        separator = new JLabel("\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013\u2013  ");
        gridbag.setConstraints(separator, gridbag_constraints);
        main_panel.add((Component)separator, gridbag_constraints);
        this.detail_window = new WindowAutorouteDetailParameter(p_board_frame);
        JButton settings_autorouter_detail_button = new JButton(resources.getString("detail_parameter"));
        this.detail_listener = new DetailListener();
        settings_autorouter_detail_button.addActionListener(this.detail_listener);
        settings_autorouter_detail_button.addActionListener(evt -> FRAnalytics.buttonClicked("settings_autorouter_detail_button", settings_autorouter_detail_button.getText()));
        gridbag.setConstraints(settings_autorouter_detail_button, gridbag_constraints);
        main_panel.add(settings_autorouter_detail_button);
        p_board_frame.set_context_sensitive_help(this, "WindowAutorouteParameter");
        this.refresh();
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void refresh() {
        int i;
        AutorouteSettings settings = this.board_handling.settings.autoroute_settings;
        LayerStructure layer_structure = this.board_handling.get_routing_board().layer_structure;
        this.settings_autorouter_vias_allowed.setSelected(settings.get_vias_allowed());
        this.settings_autorouter_fanout_pass_button.setSelected(settings.get_with_fanout());
        this.settings_autorouter_autoroute_pass_button.setSelected(settings.get_with_autoroute());
        this.settings_autorouter_postroute_pass_button.setSelected(settings.get_with_postroute());
        for (i = 0; i < this.settings_autorouter_layer_active_arr.length; ++i) {
            this.settings_autorouter_layer_active_arr[i].setSelected(settings.get_layer_active(i));
        }
        for (i = 0; i < this.settings_autorouter_combo_box_arr.size(); ++i) {
            if (settings.get_preferred_direction_is_horizontal(layer_structure.get_layer_no(i))) {
                this.settings_autorouter_combo_box_arr.get(i).setSelectedItem(this.horizontal);
                continue;
            }
            this.settings_autorouter_combo_box_arr.get(i).setSelectedItem(this.vertical);
        }
        this.detail_window.refresh();
    }

    @Override
    public void dispose() {
        this.detail_window.dispose();
        super.dispose();
    }

    @Override
    public void parent_iconified() {
        this.detail_window.parent_iconified();
        super.parent_iconified();
    }

    @Override
    public void parent_deiconified() {
        this.detail_window.parent_deiconified();
        super.parent_deiconified();
    }

    private class LayerActiveListener
    implements ActionListener {
        private final int signal_layer_no;

        public LayerActiveListener(int p_layer_no) {
            this.signal_layer_no = p_layer_no;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            int curr_layer_no = this.signal_layer_no;
            WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_layer_active(curr_layer_no, WindowAutorouteParameter.this.settings_autorouter_layer_active_arr[this.signal_layer_no].isSelected());
        }
    }

    private class PreferredDirectionListener
    implements ActionListener {
        private final int signal_layer_no;

        public PreferredDirectionListener(int p_layer_no) {
            this.signal_layer_no = p_layer_no;
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            int curr_layer_no = WindowAutorouteParameter.this.board_handling.get_routing_board().layer_structure.get_layer_no(this.signal_layer_no);
            WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_preferred_direction_is_horizontal(curr_layer_no, WindowAutorouteParameter.this.settings_autorouter_combo_box_arr.get(this.signal_layer_no).getSelectedItem() == WindowAutorouteParameter.this.horizontal);
        }
    }

    private class ViasAllowedListener
    implements ActionListener {
        private ViasAllowedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            WindowAutorouteParameter.this.board_handling.settings.autoroute_settings.set_vias_allowed(WindowAutorouteParameter.this.settings_autorouter_vias_allowed.isSelected());
        }
    }

    private class FanoutListener
    implements ActionListener {
        private FanoutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            AutorouteSettings autoroute_settings = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings;
            autoroute_settings.set_with_fanout(WindowAutorouteParameter.this.settings_autorouter_fanout_pass_button.isSelected());
            autoroute_settings.set_start_pass_no(1);
        }
    }

    private class AutorouteListener
    implements ActionListener {
        private AutorouteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            AutorouteSettings autoroute_settings = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings;
            autoroute_settings.set_with_autoroute(WindowAutorouteParameter.this.settings_autorouter_autoroute_pass_button.isSelected());
            autoroute_settings.set_start_pass_no(1);
        }
    }

    private class PostrouteListener
    implements ActionListener {
        private PostrouteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            AutorouteSettings autoroute_settings = WindowAutorouteParameter.this.board_handling.settings.autoroute_settings;
            autoroute_settings.set_with_postroute(WindowAutorouteParameter.this.settings_autorouter_postroute_pass_button.isSelected());
            autoroute_settings.set_start_pass_no(1);
        }
    }

    private class DetailListener
    implements ActionListener {
        private boolean first_time = true;

        private DetailListener() {
        }

        @Override
        public void actionPerformed(ActionEvent p_evt) {
            if (this.first_time) {
                Point location = WindowAutorouteParameter.this.getLocation();
                WindowAutorouteParameter.this.detail_window.setLocation((int)location.getX() + 200, (int)location.getY() + 100);
                this.first_time = false;
            }
            WindowAutorouteParameter.this.detail_window.setVisible(true);
        }
    }
}

