/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.autoroute.BoardUpdateStrategy;
import app.freerouting.autoroute.ItemSelectionStrategy;
import app.freerouting.logger.FRLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public class StartupOptions {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path PATH = Paths.get(System.getProperty("java.io.tmpdir"), "freerouting.json");
    transient boolean single_design_option = false;
    transient boolean test_version_option = false;
    transient boolean show_help_option = false;
    transient boolean session_file_option = false;
    transient boolean webstart_option = false;
    transient String design_input_filename;
    transient String design_output_filename;
    transient String design_rules_filename;
    public String input_directory;
    public int max_passes = 99999;
    public int num_threads = 1;
    public BoardUpdateStrategy board_update_strategy = BoardUpdateStrategy.GREEDY;
    public String hybrid_ratio = "1:1";
    public ItemSelectionStrategy item_selection_strategy = ItemSelectionStrategy.PRIORITIZED;
    transient String[] supported_languages = new String[]{"en", "de", "zh", "hi", "es", "fr", "ar", "bn", "ru", "pt", "ja", "ko"};
    transient Locale current_locale = Locale.getDefault();
    public boolean save_intermediate_stages = false;
    public float optimization_improvement_threshold = 1.0E-5f;
    transient String[] ignore_net_classes_by_autorouter = new String[0];
    public boolean disable_logging = false;
    public boolean disable_analytics = false;
    public final String user_id;
    public int dialog_confirmation_timeout = 20;
    public String host = "N/A";

    public StartupOptions() {
        if (Arrays.stream(this.supported_languages).noneMatch(this.current_locale.getLanguage()::equals)) {
            this.current_locale = Locale.ENGLISH;
        }
        this.user_id = UUID.randomUUID().toString();
    }

    public Locale getCurrentLocale() {
        return this.current_locale;
    }

    public void parseCommandLineArguments(String[] p_args) {
        for (int i = 0; i < p_args.length; ++i) {
            try {
                String op;
                if (p_args[i].startsWith("-de")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.single_design_option = true;
                    this.design_input_filename = p_args[i + 1];
                    continue;
                }
                if (p_args[i].startsWith("-di")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.input_directory = p_args[i + 1];
                    continue;
                }
                if (p_args[i].startsWith("-do")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.design_output_filename = p_args[i + 1];
                    continue;
                }
                if (p_args[i].startsWith("-dr")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.design_rules_filename = p_args[i + 1];
                    continue;
                }
                if (p_args[i].startsWith("-mp")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.max_passes = Integer.decode(p_args[i + 1]);
                    if (this.max_passes < 1) {
                        this.max_passes = 1;
                    }
                    if (this.max_passes <= 99998) continue;
                    this.max_passes = 99998;
                    continue;
                }
                if (p_args[i].startsWith("-mt")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.num_threads = Integer.decode(p_args[i + 1]);
                    if (this.num_threads <= 0) {
                        this.num_threads = 0;
                    }
                    if (this.num_threads <= 1024) continue;
                    this.num_threads = 1024;
                    continue;
                }
                if (p_args[i].startsWith("-oit")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.optimization_improvement_threshold = Float.parseFloat(p_args[i + 1]) / 100.0f;
                    if (!(this.optimization_improvement_threshold <= 0.0f)) continue;
                    this.optimization_improvement_threshold = 0.0f;
                    continue;
                }
                if (p_args[i].startsWith("-us")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    op = p_args[i + 1].toLowerCase().trim();
                    this.board_update_strategy = op.equals("global") ? BoardUpdateStrategy.GLOBAL_OPTIMAL : (op.equals("hybrid") ? BoardUpdateStrategy.HYBRID : BoardUpdateStrategy.GREEDY);
                    continue;
                }
                if (p_args[i].startsWith("-is")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    op = p_args[i + 1].toLowerCase().trim();
                    this.item_selection_strategy = op.indexOf("seq") == 0 ? ItemSelectionStrategy.SEQUENTIAL : (op.indexOf("rand") == 0 ? ItemSelectionStrategy.RANDOM : ItemSelectionStrategy.PRIORITIZED);
                    continue;
                }
                if (p_args[i].startsWith("-hr")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.hybrid_ratio = p_args[i + 1].trim();
                    continue;
                }
                if (p_args[i].startsWith("-l")) {
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("en")) {
                        this.current_locale = Locale.ENGLISH;
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("de")) {
                        this.current_locale = Locale.GERMAN;
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("zh")) {
                        this.current_locale = Locale.SIMPLIFIED_CHINESE;
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("hi")) {
                        this.current_locale = new Locale("hi", "IN");
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("es")) {
                        this.current_locale = new Locale("es", "ES");
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("fr")) {
                        this.current_locale = Locale.FRENCH;
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("ar")) {
                        this.current_locale = new Locale("ar", "EG");
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("bn")) {
                        this.current_locale = new Locale("bn", "BD");
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("ru")) {
                        this.current_locale = new Locale("ru", "RU");
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("pt")) {
                        this.current_locale = new Locale("pt", "PT");
                        continue;
                    }
                    if (p_args.length > i + 1 && p_args[i + 1].startsWith("ja")) {
                        this.current_locale = Locale.JAPANESE;
                        continue;
                    }
                    if (p_args.length <= i + 1 || !p_args[i + 1].startsWith("ko")) continue;
                    this.current_locale = Locale.KOREAN;
                    continue;
                }
                if (p_args[i].startsWith("-s")) {
                    this.session_file_option = true;
                    continue;
                }
                if (p_args[i].startsWith("-im")) {
                    this.save_intermediate_stages = true;
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.save_intermediate_stages = !Objects.equals(p_args[i + 1], "0");
                    continue;
                }
                if (p_args[i].startsWith("-w")) {
                    this.webstart_option = true;
                    continue;
                }
                if (p_args[i].startsWith("-test")) {
                    this.test_version_option = true;
                    continue;
                }
                if (p_args[i].startsWith("-dl")) {
                    this.disable_logging = true;
                    continue;
                }
                if (p_args[i].startsWith("-da")) {
                    this.disable_analytics = true;
                    continue;
                }
                if (p_args[i].startsWith("-host")) {
                    if (p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                    this.host = p_args[i + 1].trim();
                    continue;
                }
                if (p_args[i].startsWith("-help")) {
                    this.show_help_option = true;
                    continue;
                }
                if (p_args[i].startsWith("-inc")) {
                    this.ignore_net_classes_by_autorouter = p_args[i + 1].split(",");
                    continue;
                }
                if (!p_args[i].startsWith("-dct") || p_args.length <= i + 1 || p_args[i + 1].startsWith("-")) continue;
                this.dialog_confirmation_timeout = Integer.parseInt(p_args[i + 1]);
                if (this.dialog_confirmation_timeout > 0) continue;
                this.dialog_confirmation_timeout = 0;
                continue;
            }
            catch (Exception e) {
                FRLogger.error("There was a problem parsing the '" + p_args[i] + "' parameter", e);
            }
        }
    }

    public boolean getWebstartOption() {
        return this.webstart_option;
    }

    public boolean isTestVersion() {
        return this.test_version_option;
    }

    public String getDesignDir() {
        return this.input_directory;
    }

    public int getMaxPasses() {
        return this.max_passes;
    }

    public int getNumThreads() {
        return this.num_threads;
    }

    public String getHybridRatio() {
        return this.hybrid_ratio;
    }

    public BoardUpdateStrategy getBoardUpdateStrategy() {
        return this.board_update_strategy;
    }

    public ItemSelectionStrategy getItemSelectionStrategy() {
        return this.item_selection_strategy;
    }

    public static void save(StartupOptions options) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)options, (Appendable)writer);
        }
    }

    public static StartupOptions load() throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(PATH, StandardCharsets.UTF_8);){
            StartupOptions startupOptions = GSON.fromJson((Reader)reader, StartupOptions.class);
            return startupOptions;
        }
    }
}

