/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.LayerStructure;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.BoardPanel;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class PopupMenuChangeLayer
extends JMenu {
    private final BoardFrame board_frame;
    private final LayermenuItem[] item_arr;

    PopupMenuChangeLayer(BoardFrame p_board_frame) {
        this.board_frame = p_board_frame;
        LayerStructure layer_structure = this.board_frame.board_panel.board_handling.get_routing_board().layer_structure;
        this.item_arr = new LayermenuItem[layer_structure.signal_layer_count()];
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.Default", p_board_frame.get_locale());
        this.setText(resources.getString("change_layer"));
        this.setToolTipText(resources.getString("change_layer_tooltip"));
        int curr_signal_layer_no = 0;
        for (int i = 0; i < layer_structure.arr.length; ++i) {
            if (!layer_structure.arr[i].is_signal) continue;
            this.item_arr[curr_signal_layer_no] = new LayermenuItem(i);
            this.item_arr[curr_signal_layer_no].setText(layer_structure.arr[i].name);
            this.add(this.item_arr[curr_signal_layer_no]);
            ++curr_signal_layer_no;
        }
    }

    void disable_item(int p_no) {
        for (int i = 0; i < this.item_arr.length; ++i) {
            this.item_arr[i].setEnabled(i != p_no);
        }
    }

    private class LayermenuItem
    extends JMenuItem {
        private final int layer_no;
        private final String message1;

        LayermenuItem(int p_layer_no) {
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.Default", PopupMenuChangeLayer.this.board_frame.get_locale());
            this.message1 = resources.getString("layer_changed_to") + " ";
            this.layer_no = p_layer_no;
            this.addActionListener(evt -> {
                BoardPanel board_panel = PopupMenuChangeLayer.this.board_frame.board_panel;
                if (board_panel.board_handling.change_layer_action(this.layer_no)) {
                    String layer_name = board_panel.board_handling.get_routing_board().layer_structure.arr[this.layer_no].name;
                    board_panel.screen_messages.set_status_message(this.message1 + layer_name);
                }
                board_panel.move_mouse(board_panel.right_button_click_location);
            });
        }
    }
}

