/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.autoroute.BoardUpdateStrategy;
import app.freerouting.autoroute.ItemSelectionStrategy;
import app.freerouting.board.TestLevel;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.DefaultExceptionHandler;
import app.freerouting.gui.DesignFile;
import app.freerouting.gui.StartupOptions;
import app.freerouting.gui.WindowBase;
import app.freerouting.gui.WindowMessage;
import app.freerouting.gui.WindowNetDemonstrations;
import app.freerouting.gui.WindowNetSampleDesigns;
import app.freerouting.gui.WindowNetSamples;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.interactive.ThreadActionListener;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.FRAnalytics;
import app.freerouting.management.VersionChecker;
import app.freerouting.rules.NetClasses;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

public class MainApplication
extends WindowBase {
    static final String WEB_FILE_BASE_NAME = "http://www.freerouting.app";
    static final String VERSION_NUMBER_STRING = "v1.9.0 (build-date: 2023-10-30)";
    private static final TestLevel DEBUG_LEVEL = TestLevel.CRITICAL_DEBUGGING_OUTPUT;
    private final ResourceBundle resources;
    private final JButton demonstration_button;
    private final JButton sample_board_button;
    private final JButton open_board_button;
    private final JButton restore_defaults_button;
    private final JTextField message_field;
    private final JPanel main_panel;
    private final WindowNetSamples window_net_demonstrations;
    private final WindowNetSamples window_net_sample_designs;
    private final Collection<BoardFrame> board_frames = new LinkedList<BoardFrame>();
    private final boolean is_test_version;
    private final Locale locale;
    private final boolean save_intermediate_stages;
    private final float optimization_improvement_threshold;
    private final String[] ignore_net_classes_by_autorouter;
    private String design_dir_name;
    private final int max_passes;
    private final BoardUpdateStrategy board_update_strategy;
    private final String hybrid_ratio;
    private final ItemSelectionStrategy item_selection_strategy;
    private final int num_threads;
    private static StartupOptions startupOptions;

    public MainApplication(StartupOptions startupOptions) {
        super(600, 300);
        this.design_dir_name = startupOptions.getDesignDir();
        this.max_passes = startupOptions.getMaxPasses();
        this.num_threads = startupOptions.getNumThreads();
        this.board_update_strategy = startupOptions.getBoardUpdateStrategy();
        this.hybrid_ratio = startupOptions.getHybridRatio();
        this.item_selection_strategy = startupOptions.getItemSelectionStrategy();
        this.is_test_version = startupOptions.isTestVersion();
        this.locale = startupOptions.getCurrentLocale();
        this.save_intermediate_stages = startupOptions.save_intermediate_stages;
        this.optimization_improvement_threshold = startupOptions.optimization_improvement_threshold;
        this.ignore_net_classes_by_autorouter = startupOptions.ignore_net_classes_by_autorouter;
        this.resources = ResourceBundle.getBundle("app.freerouting.gui.MainApplication", this.locale);
        this.main_panel = new JPanel();
        this.getContentPane().add(this.main_panel);
        GridBagLayout gridbag = new GridBagLayout();
        this.main_panel.setLayout(gridbag);
        GridBagConstraints gridbag_constraints = new GridBagConstraints();
        gridbag_constraints.insets = new Insets(10, 10, 10, 10);
        gridbag_constraints.gridwidth = 0;
        this.demonstration_button = new JButton();
        this.sample_board_button = new JButton();
        this.open_board_button = new JButton();
        this.restore_defaults_button = new JButton();
        this.message_field = new JTextField();
        this.message_field.setText(this.resources.getString("command_line_missing_input"));
        this.window_net_demonstrations = new WindowNetDemonstrations(this.locale);
        Point location = this.getLocation();
        this.window_net_demonstrations.setLocation((int)location.getX() + 50, (int)location.getY() + 50);
        this.window_net_sample_designs = new WindowNetSampleDesigns(this.locale);
        this.window_net_sample_designs.setLocation((int)location.getX() + 90, (int)location.getY() + 90);
        this.setTitle(this.resources.getString("title") + " v1.9.0 (build-date: 2023-10-30)");
        boolean add_buttons = true;
        if (startupOptions.getWebstartOption() && add_buttons) {
            this.demonstration_button.setText(this.resources.getString("router_demonstrations"));
            this.demonstration_button.setToolTipText(this.resources.getString("router_demonstrations_tooltip"));
            this.demonstration_button.addActionListener(evt -> this.window_net_demonstrations.setVisible(true));
            this.demonstration_button.addActionListener(evt -> FRAnalytics.buttonClicked("demonstration_button", this.demonstration_button.getText()));
            gridbag.setConstraints(this.demonstration_button, gridbag_constraints);
            this.main_panel.add((Component)this.demonstration_button, gridbag_constraints);
            this.sample_board_button.setText(this.resources.getString("sample_designs"));
            this.sample_board_button.setToolTipText(this.resources.getString("sample_designs_tooltip"));
            this.sample_board_button.addActionListener(evt -> this.window_net_sample_designs.setVisible(true));
            this.sample_board_button.addActionListener(evt -> FRAnalytics.buttonClicked("sample_board_button", this.sample_board_button.getText()));
            gridbag.setConstraints(this.sample_board_button, gridbag_constraints);
            this.main_panel.add((Component)this.sample_board_button, gridbag_constraints);
        }
        this.open_board_button.setText(this.resources.getString("open_own_design"));
        this.open_board_button.setToolTipText(this.resources.getString("open_own_design_tooltip"));
        this.open_board_button.addActionListener(this::open_board_design_action);
        this.open_board_button.addActionListener(evt -> FRAnalytics.buttonClicked("open_board_button", this.open_board_button.getText()));
        gridbag.setConstraints(this.open_board_button, gridbag_constraints);
        if (add_buttons) {
            this.main_panel.add((Component)this.open_board_button, gridbag_constraints);
        }
        if (startupOptions.getWebstartOption() && add_buttons) {
            this.restore_defaults_button.setText(this.resources.getString("restore_defaults"));
            this.restore_defaults_button.setToolTipText(this.resources.getString("restore_defaults_tooltip"));
            this.restore_defaults_button.addActionListener(evt -> {});
            this.restore_defaults_button.addActionListener(evt -> FRAnalytics.buttonClicked("restore_defaults_button", this.restore_defaults_button.getText()));
            gridbag.setConstraints(this.restore_defaults_button, gridbag_constraints);
            this.main_panel.add((Component)this.restore_defaults_button, gridbag_constraints);
        }
        int window_width = 620;
        int window_height = 300;
        this.message_field.setPreferredSize(new Dimension(window_width - 40, 100));
        this.message_field.setRequestFocusEnabled(false);
        gridbag.setConstraints(this.message_field, gridbag_constraints);
        this.main_panel.add((Component)this.message_field, gridbag_constraints);
        this.addWindowListener(new WindowStateListener());
        this.pack();
        this.setSize(window_width, window_height);
        this.setResizable(false);
    }

    public static void main(String[] args) {
        if (args.length > 0 && Arrays.asList(args).contains("-dl")) {
            FRLogger.disableLogging();
        }
        FRLogger.traceEntry("MainApplication.main()");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            FRLogger.error(ex.getLocalizedMessage(), ex);
        }
        FRLogger.info("Freerouting v1.9.0 (build-date: 2023-10-30)");
        FRLogger.debug(" Version: 1.9.0,2023-10-30");
        FRLogger.debug(" Command line arguments: '" + String.join((CharSequence)" ", args) + "'");
        FRLogger.debug(" Architecture: " + System.getProperty("os.name") + "," + System.getProperty("os.arch") + "," + System.getProperty("os.version"));
        FRLogger.debug(" Java: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor"));
        FRLogger.debug(" System Language: " + Locale.getDefault().getLanguage() + "," + Locale.getDefault());
        FRLogger.debug(" Hardware: " + Runtime.getRuntime().availableProcessors() + " CPU cores," + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB RAM");
        FRLogger.debug(" UTC Time: " + Instant.now());
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        try {
            startupOptions = StartupOptions.load();
            FRLogger.info("Settings were loaded from freerouting.json");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (startupOptions == null) {
            startupOptions = new StartupOptions();
            try {
                StartupOptions.save(startupOptions);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        startupOptions.parseCommandLineArguments(args);
        FRLogger.debug(" GUI Language: " + MainApplication.startupOptions.current_locale);
        FRLogger.debug(" Host: " + MainApplication.startupOptions.host);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int width = screenSize.width;
        int height = screenSize.height;
        int dpi = toolkit.getScreenResolution();
        FRLogger.debug(" Screen: " + width + "x" + height + ", " + dpi + " DPI");
        FRAnalytics.setWriteKey("1.9.0", "G24pcCv4BmnqwBa8LsdODYRE6k9IAlqR");
        FRAnalytics.setEnabled(!MainApplication.startupOptions.disable_analytics);
        FRAnalytics.setUserId(MainApplication.startupOptions.user_id);
        FRAnalytics.identify();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FRAnalytics.setAppLocation("app.freerouting.gui", "Freerouting");
        FRAnalytics.appStarted("1.9.0", "2023-10-30", String.join((CharSequence)" ", args), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"), System.getProperty("java.vendor"), Locale.getDefault(), MainApplication.startupOptions.current_locale, Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().maxMemory() / 1024L / 1024L, MainApplication.startupOptions.host, width, height, dpi);
        FontUIResource menuFont = (FontUIResource)UIManager.get("Menu.font");
        FontUIResource defaultFont = (FontUIResource)UIManager.get("Button.font");
        Font newFont = new Font(defaultFont.getName(), 0, menuFont.getSize());
        UIManager.put("Component.font", newFont);
        UIManager.put("Button.font", newFont);
        UIManager.put("Label.font", newFont);
        UIManager.put("ToggleButton.font", newFont);
        UIManager.put("FormattedTextField.font", newFont);
        UIManager.put("TextField.font", newFont);
        UIManager.put("ComboBox.font", newFont);
        UIManager.put("CheckBox.font", newFont);
        UIManager.put("RadioButton.font", newFont);
        UIManager.put("Table.font", newFont);
        UIManager.put("TableHeader.font", newFont);
        UIManager.put("List.font", newFont);
        UIManager.put("Menu.font", newFont);
        UIManager.put("MenuItem.font", newFont);
        VersionChecker checker = new VersionChecker("1.9.0");
        new Thread(checker).start();
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.MainApplication", MainApplication.startupOptions.current_locale);
        if (MainApplication.startupOptions.show_help_option) {
            System.out.print(resources.getString("command_line_help"));
            System.exit(0);
            return;
        }
        if (MainApplication.startupOptions.single_design_option) {
            BoardFrame.Option board_option = MainApplication.startupOptions.session_file_option ? BoardFrame.Option.SESSION_FILE : BoardFrame.Option.SINGLE_FRAME;
            FRLogger.info("Opening '" + MainApplication.startupOptions.design_input_filename + "'...");
            DesignFile design_file = DesignFile.get_instance(MainApplication.startupOptions.design_input_filename);
            if (design_file == null) {
                FRLogger.warn(resources.getString("message_6") + " " + MainApplication.startupOptions.design_input_filename + " " + resources.getString("message_7"));
                return;
            }
            String message = resources.getString("loading_design") + " " + MainApplication.startupOptions.design_input_filename;
            WindowMessage welcome_window = WindowMessage.show(message);
            final BoardFrame new_frame = MainApplication.create_board_frame(design_file, null, board_option, MainApplication.startupOptions.test_version_option, MainApplication.startupOptions.current_locale, MainApplication.startupOptions.design_rules_filename, MainApplication.startupOptions.save_intermediate_stages, MainApplication.startupOptions.optimization_improvement_threshold, MainApplication.startupOptions.ignore_net_classes_by_autorouter);
            welcome_window.dispose();
            if (new_frame == null) {
                FRLogger.warn("Couldn't create window frame");
                System.exit(1);
                return;
            }
            new_frame.board_panel.board_handling.settings.autoroute_settings.set_stop_pass_no(new_frame.board_panel.board_handling.settings.autoroute_settings.get_start_pass_no() + MainApplication.startupOptions.max_passes - 1);
            new_frame.board_panel.board_handling.set_num_threads(MainApplication.startupOptions.num_threads);
            new_frame.board_panel.board_handling.set_board_update_strategy(MainApplication.startupOptions.board_update_strategy);
            new_frame.board_panel.board_handling.set_hybrid_ratio(MainApplication.startupOptions.hybrid_ratio);
            new_frame.board_panel.board_handling.set_item_selection_strategy(MainApplication.startupOptions.item_selection_strategy);
            if (MainApplication.startupOptions.design_output_filename != null) {
                new_frame.board_panel.board_handling.autorouter_listener = new ThreadActionListener(){

                    @Override
                    public void autorouterStarted() {
                    }

                    @Override
                    public void autorouterAborted() {
                        this.ExportBoardToFile(MainApplication.startupOptions.design_output_filename);
                    }

                    @Override
                    public void autorouterFinished() {
                        this.ExportBoardToFile(MainApplication.startupOptions.design_output_filename);
                    }

                    private void ExportBoardToFile(String filename) {
                        if (filename == null) {
                            FRLogger.warn("Couldn't export board, filename not specified");
                            return;
                        }
                        if (!(filename.toLowerCase().endsWith(".dsn") || filename.toLowerCase().endsWith(".ses") || filename.toLowerCase().endsWith(".scr"))) {
                            FRLogger.warn("Couldn't export board to '" + filename + "', unsupported extension");
                            return;
                        }
                        FRLogger.info("Saving '" + filename + "'...");
                        try {
                            String filename_only = new File(filename).getName();
                            String design_name = filename_only.substring(0, filename_only.length() - 4);
                            String extension = filename_only.substring(filename_only.length() - 4);
                            FileOutputStream output_stream = new FileOutputStream(filename);
                            switch (extension) {
                                case ".dsn": {
                                    new_frame.board_panel.board_handling.export_to_dsn_file(output_stream, design_name, false);
                                    break;
                                }
                                case ".ses": {
                                    new_frame.board_panel.board_handling.export_specctra_session_file(design_name, output_stream);
                                    break;
                                }
                                case ".scr": {
                                    ByteArrayOutputStream session_output_stream = new ByteArrayOutputStream();
                                    new_frame.board_panel.board_handling.export_specctra_session_file(filename, session_output_stream);
                                    ByteArrayInputStream input_stream = new ByteArrayInputStream(session_output_stream.toByteArray());
                                    new_frame.board_panel.board_handling.export_eagle_session_file(input_stream, output_stream);
                                }
                            }
                            System.exit(0);
                        }
                        catch (Exception e) {
                            FRLogger.error("Couldn't export board to file", e);
                        }
                    }
                };
            }
            if (new_frame.is_intermediate_stage_file_available()) {
                LocalDateTime modification_time = new_frame.get_intermediate_stage_file_modification_time();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String load_snapshot_confirmation = String.format(resources.getString("load_snapshot_confirmation"), modification_time.format(formatter));
                if (WindowMessage.confirm(load_snapshot_confirmation)) {
                    new_frame.load_intermediate_stage_file();
                }
            }
            if (MainApplication.startupOptions.design_input_filename != null && MainApplication.startupOptions.design_output_filename != null) {
                final String START_NOW_TEXT = resources.getString("auto_start_routing_startnow_button");
                final JButton startNowButton = new JButton(START_NOW_TEXT + " (" + MainApplication.startupOptions.dialog_confirmation_timeout + ")");
                String CANCEL_TEXT = resources.getString("auto_start_routing_cancel_button");
                final Object[] options = new Object[]{startNowButton, CANCEL_TEXT};
                String AUTOSTART_MSG = resources.getString("auto_start_routing_message");
                final JOptionPane auto_start_routing_dialog = new JOptionPane(AUTOSTART_MSG, 2, 2, null, options, options[0]);
                startNowButton.addActionListener(event -> auto_start_routing_dialog.setValue(options[0]));
                startNowButton.addActionListener(evt -> FRAnalytics.buttonClicked("auto_start_routing_dialog_start", startNowButton.getText()));
                String AUTOSTART_TITLE = resources.getString("auto_start_routing_title");
                if (MainApplication.startupOptions.dialog_confirmation_timeout > 0) {
                    JDialog autostartDialog = auto_start_routing_dialog.createDialog(AUTOSTART_TITLE);
                    Timer autostartTimer = new Timer(1000, new ActionListener(){
                        private int secondsLeft;
                        {
                            this.secondsLeft = MainApplication.startupOptions.dialog_confirmation_timeout;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (--this.secondsLeft > 0) {
                                startNowButton.setText(START_NOW_TEXT + " (" + this.secondsLeft + ")");
                            } else {
                                auto_start_routing_dialog.setValue(options[0]);
                                FRAnalytics.buttonClicked("auto_start_routing_dialog_start_with_timeout", startNowButton.getText());
                            }
                        }
                    });
                    autostartTimer.start();
                    autostartDialog.setVisible(true);
                    autostartDialog.dispose();
                    autostartTimer.stop();
                }
                Object choice = auto_start_routing_dialog.getValue();
                if (MainApplication.startupOptions.dialog_confirmation_timeout == 0 || choice == options[0]) {
                    InteractiveActionThread thread = new_frame.board_panel.board_handling.start_batch_autorouter();
                    if (new_frame.board_panel.board_handling.autorouter_listener != null) {
                        thread.addListener(new_frame.board_panel.board_handling.autorouter_listener);
                    }
                }
                if (choice == options[1]) {
                    FRAnalytics.buttonClicked("auto_start_routing_dialog_cancel", "Cancel");
                }
            }
            new_frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent evt) {
                    System.exit(0);
                }
            });
        } else {
            new MainApplication(startupOptions).setVisible(true);
        }
        FRLogger.traceExit("MainApplication.main()");
    }

    private static BoardFrame create_board_frame(DesignFile p_design_file, JTextField p_message_field, BoardFrame.Option p_option, boolean p_is_test_version, Locale p_locale, String p_design_rules_file, boolean p_save_intermediate_stages, float p_optimization_improvement_threshold, String[] p_ignore_net_classes_by_autorouter) {
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.MainApplication", p_locale);
        InputStream input_stream = p_design_file.get_input_stream();
        if (input_stream == null) {
            if (p_message_field != null) {
                p_message_field.setText(resources.getString("message_8") + " " + p_design_file.get_name());
            }
            return null;
        }
        TestLevel test_level = p_is_test_version ? DEBUG_LEVEL : TestLevel.RELEASE_VERSION;
        BoardFrame new_frame = new BoardFrame(p_design_file, p_option, test_level, p_locale, !p_is_test_version, p_save_intermediate_stages, p_optimization_improvement_threshold);
        boolean read_ok = new_frame.read(input_stream, p_design_file.is_created_from_text_file(), p_message_field);
        if (!read_ok) {
            return null;
        }
        new_frame.menubar.add_design_dependent_items();
        if (p_design_file.is_created_from_text_file()) {
            String confirm_import_rules_message;
            String parent_folder_name;
            Object rules_file_name;
            String file_name = p_design_file.get_name();
            String[] name_parts = file_name.split("\\.");
            String design_name = name_parts[0];
            if (p_design_rules_file == null) {
                rules_file_name = design_name + ".rules";
                parent_folder_name = p_design_file.get_parent();
                confirm_import_rules_message = resources.getString("confirm_import_rules");
            } else {
                rules_file_name = p_design_rules_file;
                parent_folder_name = null;
                confirm_import_rules_message = null;
            }
            File rules_file = new File(parent_folder_name, (String)rules_file_name);
            if (rules_file.exists()) {
                DesignFile.read_rules_file(design_name, parent_folder_name, (String)rules_file_name, new_frame.board_panel.board_handling, confirm_import_rules_message);
            }
            for (String net_class_name : p_ignore_net_classes_by_autorouter) {
                NetClasses netClasses = new_frame.board_panel.board_handling.get_routing_board().rules.net_classes;
                for (int i = 0; i < netClasses.count(); ++i) {
                    if (!netClasses.get(i).get_name().equalsIgnoreCase(net_class_name)) continue;
                    netClasses.get((int)i).is_ignored_by_autorouter = true;
                }
            }
            new_frame.refresh_windows();
        }
        return new_frame;
    }

    private void open_board_design_action(ActionEvent evt) {
        DesignFile design_file = DesignFile.open_dialog(this.design_dir_name);
        if (design_file != null && !Objects.equals(this.design_dir_name, design_file.get_directory())) {
            MainApplication.startupOptions.input_directory = this.design_dir_name = design_file.get_directory();
            try {
                StartupOptions.save(startupOptions);
            }
            catch (Exception e) {
                FRLogger.error("Couldn't save configuration file", e);
            }
        }
        if (design_file == null) {
            this.message_field.setText(this.resources.getString("message_3"));
            return;
        }
        FRLogger.info("Opening '" + design_file.get_name() + "'...");
        BoardFrame.Option option = BoardFrame.Option.FROM_START_MENU;
        String message = this.resources.getString("loading_design") + " " + design_file.get_name();
        this.message_field.setText(message);
        WindowMessage welcome_window = WindowMessage.show(message);
        welcome_window.setTitle(message);
        BoardFrame new_frame = MainApplication.create_board_frame(design_file, this.message_field, option, this.is_test_version, this.locale, null, this.save_intermediate_stages, this.optimization_improvement_threshold, this.ignore_net_classes_by_autorouter);
        welcome_window.dispose();
        if (new_frame == null) {
            return;
        }
        new_frame.board_panel.board_handling.settings.autoroute_settings.set_stop_pass_no(new_frame.board_panel.board_handling.settings.autoroute_settings.get_start_pass_no() + this.max_passes - 1);
        new_frame.board_panel.board_handling.set_num_threads(this.num_threads);
        new_frame.board_panel.board_handling.set_board_update_strategy(this.board_update_strategy);
        new_frame.board_panel.board_handling.set_hybrid_ratio(this.hybrid_ratio);
        new_frame.board_panel.board_handling.set_item_selection_strategy(this.item_selection_strategy);
        if (new_frame.is_intermediate_stage_file_available()) {
            LocalDateTime modification_time = new_frame.get_intermediate_stage_file_modification_time();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String load_snapshot_confirmation = String.format(this.resources.getString("load_snapshot_confirmation"), modification_time.format(formatter));
            if (WindowMessage.confirm(load_snapshot_confirmation)) {
                new_frame.load_intermediate_stage_file();
            }
        }
        this.message_field.setText(this.resources.getString("message_4") + " " + design_file.get_name() + " " + this.resources.getString("message_5"));
        this.board_frames.add(new_frame);
        new_frame.addWindowListener(new BoardFrameWindowListener(new_frame));
    }

    private void exitForm(WindowEvent evt) {
        FRAnalytics.appClosed();
        System.exit(0);
    }

    private class WindowStateListener
    extends WindowAdapter {
        private WindowStateListener() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            int application_confirm_exit_dialog;
            MainApplication.this.setDefaultCloseOperation(2);
            boolean exit_program = true;
            if (!MainApplication.this.is_test_version && !MainApplication.this.board_frames.isEmpty() && (application_confirm_exit_dialog = JOptionPane.showConfirmDialog(null, MainApplication.this.resources.getString("confirm_cancel"), null, 0)) == 1) {
                MainApplication.this.setDefaultCloseOperation(0);
                FRAnalytics.buttonClicked("application_confirm_exit_dialog_no", MainApplication.this.resources.getString("confirm_cancel"));
                exit_program = false;
            }
            if (exit_program) {
                MainApplication.this.exitForm(evt);
            }
        }

        @Override
        public void windowIconified(WindowEvent evt) {
            MainApplication.this.window_net_sample_designs.parent_iconified();
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
            MainApplication.this.window_net_sample_designs.parent_deiconified();
        }
    }

    private class BoardFrameWindowListener
    extends WindowAdapter {
        private BoardFrame board_frame;

        public BoardFrameWindowListener(BoardFrame p_board_frame) {
            this.board_frame = p_board_frame;
        }

        @Override
        public void windowClosed(WindowEvent evt) {
            if (this.board_frame != null) {
                this.board_frame.dispose();
                MainApplication.this.board_frames.remove(this.board_frame);
                this.board_frame = null;
            }
        }
    }
}

