/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.datastructures.IndentFileWriter;
import app.freerouting.gui.BoardFrame;
import app.freerouting.gui.GUIDefaultsScanner;
import app.freerouting.gui.WindowBase;
import app.freerouting.interactive.BoardHandling;
import app.freerouting.interactive.SnapShot;
import app.freerouting.logger.FRLogger;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFrame;

public class GUIDefaultsFile {
    private final BoardFrame board_frame;
    private final BoardHandling board_handling;
    private final GUIDefaultsScanner scanner;
    private final IndentFileWriter out_file;

    private GUIDefaultsFile(BoardFrame p_board_frame, BoardHandling p_board_handling, GUIDefaultsScanner p_scanner, IndentFileWriter p_output_file) {
        this.board_frame = p_board_frame;
        this.board_handling = p_board_handling;
        this.scanner = p_scanner;
        this.out_file = p_output_file;
    }

    public static boolean write(BoardFrame p_board_frame, BoardHandling p_board_handling, OutputStream p_output_stream) {
        if (p_output_stream == null) {
            return false;
        }
        IndentFileWriter output_file = new IndentFileWriter(p_output_stream);
        GUIDefaultsFile result = new GUIDefaultsFile(p_board_frame, p_board_handling, null, output_file);
        try {
            result.write_defaults_scope();
        }
        catch (IOException e) {
            FRLogger.warn("unable to write defaults file");
            return false;
        }
        try {
            output_file.close();
        }
        catch (IOException e) {
            FRLogger.error("unable to close defaults file", e);
            return false;
        }
        return true;
    }

    public static boolean read(BoardFrame p_board_frame, BoardHandling p_board_handling, InputStream p_input_stream) {
        boolean result;
        if (p_input_stream == null) {
            return false;
        }
        GUIDefaultsScanner scanner = new GUIDefaultsScanner(p_input_stream);
        GUIDefaultsFile new_instance = new GUIDefaultsFile(p_board_frame, p_board_handling, scanner, null);
        try {
            result = new_instance.read_defaults_scope();
        }
        catch (IOException e) {
            FRLogger.error("unable to read defaults file", e);
            result = false;
        }
        return result;
    }

    private static boolean skip_scope(GUIDefaultsScanner p_scanner) {
        int open_bracked_count = 1;
        while (open_bracked_count > 0) {
            Object curr_token;
            try {
                curr_token = p_scanner.next_token();
            }
            catch (Exception e) {
                FRLogger.error("GUIDefaultsFile.skip_scope: Error while scanning file", e);
                return false;
            }
            if (curr_token == null) {
                return false;
            }
            if (curr_token == Keyword.OPEN_BRACKET) {
                ++open_bracked_count;
                continue;
            }
            if (curr_token != Keyword.CLOSED_BRACKET) continue;
            --open_bracked_count;
        }
        FRLogger.warn("GUIDefaultsFile.skip_scope: unknown scope skipped");
        return true;
    }

    private void write_defaults_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("gui_defaults");
        this.write_windows_scope();
        this.write_colors_scope();
        this.write_parameter_scope();
        this.out_file.end_scope();
    }

    private boolean read_defaults_scope() throws IOException {
        Object next_token = this.scanner.next_token();
        if (next_token != Keyword.OPEN_BRACKET) {
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.GUI_DEFAULTS) {
            return false;
        }
        while (true) {
            Object prev_token = next_token;
            next_token = this.scanner.next_token();
            if (next_token == null) {
                return true;
            }
            if (next_token == Keyword.CLOSED_BRACKET) break;
            if (prev_token != Keyword.OPEN_BRACKET) continue;
            if (next_token == Keyword.COLORS) {
                if (this.read_colors_scope()) continue;
                return false;
            }
            if (next_token == Keyword.WINDOWS) {
                if (this.read_windows_scope()) continue;
                return false;
            }
            if (next_token == Keyword.PARAMETER) {
                if (this.read_parameter_scope()) continue;
                return false;
            }
            GUIDefaultsFile.skip_scope(this.scanner);
        }
        this.board_frame.refresh_windows();
        return true;
    }

    private boolean read_windows_scope() throws IOException {
        block3: {
            Object next_token = null;
            while (true) {
                Object prev_token = next_token;
                next_token = this.scanner.next_token();
                if (next_token == null) {
                    return false;
                }
                if (next_token == Keyword.CLOSED_BRACKET) break block3;
                if (prev_token != Keyword.OPEN_BRACKET) continue;
                if (!(next_token instanceof Keyword)) {
                    FRLogger.warn("GUIDefaultsFile.windows: Keyword expected");
                    return false;
                }
                if (!this.read_frame_scope((Keyword)((Object)next_token))) break;
            }
            return false;
        }
        return true;
    }

    private void write_windows_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("windows");
        this.write_frame_scope(this.board_frame, "board_frame");
        this.write_frame_scope(this.board_frame.color_manager, "color_manager");
        this.write_frame_scope(this.board_frame.layer_visibility_window, "layer_visibility");
        this.write_frame_scope(this.board_frame.object_visibility_window, "object_visibility");
        this.write_frame_scope(this.board_frame.display_misc_window, "display_miscellaneous");
        this.write_frame_scope(this.board_frame.snapshot_window, "snapshots");
        this.write_frame_scope(this.board_frame.select_parameter_window, "select_parameter");
        this.write_frame_scope(this.board_frame.route_parameter_window, "route_parameter");
        this.write_frame_scope(this.board_frame.route_parameter_window.manual_rule_window, "manual_rules");
        this.write_frame_scope(this.board_frame.route_parameter_window.detail_window, "route_details");
        this.write_frame_scope(this.board_frame.move_parameter_window, "move_parameter");
        this.write_frame_scope(this.board_frame.clearance_matrix_window, "clearance_matrix");
        this.write_frame_scope(this.board_frame.via_window, "via_rules");
        this.write_frame_scope(this.board_frame.edit_vias_window, "edit_vias");
        this.write_frame_scope(this.board_frame.edit_net_rules_window, "edit_net_rules");
        this.write_frame_scope(this.board_frame.assign_net_classes_window, "assign_net_rules");
        this.write_frame_scope(this.board_frame.padstacks_window, "padstack_info");
        this.write_frame_scope(this.board_frame.packages_window, "package_info");
        this.write_frame_scope(this.board_frame.components_window, "component_info");
        this.write_frame_scope(this.board_frame.net_info_window, "net_info");
        this.write_frame_scope(this.board_frame.incompletes_window, "incompletes_info");
        this.write_frame_scope(this.board_frame.clearance_violations_window, "violations_info");
        this.out_file.end_scope();
    }

    private boolean read_frame_scope(Keyword p_frame) throws IOException {
        WindowBase curr_frame;
        boolean is_visible;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.VISIBLE) {
            is_visible = true;
        } else if (next_token == Keyword.NOT_VISIBLE) {
            is_visible = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_frame_scope: visible or not_visible expected");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.OPEN_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_frame_scope: open_bracket expected");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.BOUNDS) {
            FRLogger.warn("GUIDefaultsFile.read_frame_scope: bounds expected");
            return false;
        }
        Rectangle bounds = this.read_rectangle();
        if (bounds == null) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            next_token = this.scanner.next_token();
            if (next_token == Keyword.CLOSED_BRACKET) continue;
            FRLogger.warn("GUIDefaultsFile.read_frame_scope: closing bracket expected");
            return false;
        }
        switch (p_frame) {
            case BOARD_FRAME: {
                curr_frame = this.board_frame;
                break;
            }
            case COLOR_MANAGER: {
                curr_frame = this.board_frame.color_manager;
                break;
            }
            case OBJECT_VISIBILITY: {
                curr_frame = this.board_frame.object_visibility_window;
                break;
            }
            case LAYER_VISIBILITY: {
                curr_frame = this.board_frame.layer_visibility_window;
                break;
            }
            case DISPLAY_MISCELLANEOUS: {
                curr_frame = this.board_frame.display_misc_window;
                break;
            }
            case SNAPSHOTS: {
                curr_frame = this.board_frame.snapshot_window;
                break;
            }
            case SELECT_PARAMETER: {
                curr_frame = this.board_frame.select_parameter_window;
                break;
            }
            case ROUTE_PARAMETER: {
                curr_frame = this.board_frame.route_parameter_window;
                break;
            }
            case MANUAL_RULES: {
                curr_frame = this.board_frame.route_parameter_window.manual_rule_window;
                break;
            }
            case ROUTE_DETAILS: {
                curr_frame = this.board_frame.route_parameter_window.detail_window;
                break;
            }
            case MOVE_PARAMETER: {
                curr_frame = this.board_frame.move_parameter_window;
                break;
            }
            case CLEARANCE_MATRIX: {
                curr_frame = this.board_frame.clearance_matrix_window;
                break;
            }
            case VIA_RULES: {
                curr_frame = this.board_frame.via_window;
                break;
            }
            case EDIT_VIAS: {
                curr_frame = this.board_frame.edit_vias_window;
                break;
            }
            case EDIT_NET_RULES: {
                curr_frame = this.board_frame.edit_net_rules_window;
                break;
            }
            case ASSIGN_NET_RULES: {
                curr_frame = this.board_frame.assign_net_classes_window;
                break;
            }
            case PADSTACK_INFO: {
                curr_frame = this.board_frame.padstacks_window;
                break;
            }
            case PACKAGE_INFO: {
                curr_frame = this.board_frame.packages_window;
                break;
            }
            case COMPONENT_INFO: {
                curr_frame = this.board_frame.components_window;
                break;
            }
            case NET_INFO: {
                curr_frame = this.board_frame.net_info_window;
                break;
            }
            case INCOMPLETES_INFO: {
                curr_frame = this.board_frame.incompletes_window;
                break;
            }
            case VIOLATIONS_INFO: {
                curr_frame = this.board_frame.clearance_violations_window;
                break;
            }
            default: {
                FRLogger.warn("GUIDefaultsFile.read_frame_scope: unknown frame");
                return false;
            }
        }
        curr_frame.setVisible(is_visible);
        if (p_frame == Keyword.BOARD_FRAME) {
            curr_frame.setBounds(bounds);
        } else {
            curr_frame.setLocation(bounds.getLocation());
        }
        return true;
    }

    private Rectangle read_rectangle() throws IOException {
        int[] coor = new int[4];
        for (int i = 0; i < 4; ++i) {
            Object next_token = this.scanner.next_token();
            if (!(next_token instanceof Integer)) {
                FRLogger.warn("GUIDefaultsFile.read_rectangle: Integer expected");
                return null;
            }
            coor[i] = (Integer)next_token;
        }
        return new Rectangle(coor[0], coor[1], coor[2], coor[3]);
    }

    private void write_frame_scope(JFrame p_frame, String p_frame_name) throws IOException {
        this.out_file.start_scope();
        this.out_file.write(p_frame_name);
        this.out_file.new_line();
        if (p_frame.isVisible()) {
            this.out_file.write("visible");
        } else {
            this.out_file.write("not_visible");
        }
        this.write_bounds(p_frame.getBounds());
        this.out_file.end_scope();
    }

    private void write_bounds(Rectangle p_bounds) throws IOException {
        this.out_file.start_scope();
        this.out_file.write("bounds");
        this.out_file.new_line();
        int x = (int)p_bounds.getX();
        this.out_file.write(String.valueOf(x));
        int y = (int)p_bounds.getY();
        this.out_file.write(" ");
        this.out_file.write(String.valueOf(y));
        int width = (int)p_bounds.getWidth();
        this.out_file.write(" ");
        this.out_file.write(String.valueOf(width));
        int height = (int)p_bounds.getHeight();
        this.out_file.write(" ");
        this.out_file.write(String.valueOf(height));
        this.out_file.end_scope();
    }

    private boolean read_colors_scope() throws IOException {
        Object next_token = null;
        while (true) {
            Object prev_token = next_token;
            next_token = this.scanner.next_token();
            if (next_token == null) {
                return false;
            }
            if (next_token == Keyword.CLOSED_BRACKET) break;
            if (prev_token != Keyword.OPEN_BRACKET) continue;
            if (next_token == Keyword.BACKGROUND) {
                if (this.read_background_color()) continue;
                return false;
            }
            if (next_token == Keyword.CONDUCTION) {
                if (this.read_conduction_colors()) continue;
                return false;
            }
            if (next_token == Keyword.HILIGHT) {
                if (this.read_hilight_color()) continue;
                return false;
            }
            if (next_token == Keyword.INCOMPLETES) {
                if (this.read_incompletes_color()) continue;
                return false;
            }
            if (next_token == Keyword.KEEPOUT) {
                if (this.read_keepout_colors()) continue;
                return false;
            }
            if (next_token == Keyword.OUTLINE) {
                if (this.read_outline_color()) continue;
                return false;
            }
            if (next_token == Keyword.COMPONENT_FRONT) {
                if (this.read_component_color(true)) continue;
                return false;
            }
            if (next_token == Keyword.COMPONENT_BACK) {
                if (this.read_component_color(false)) continue;
                return false;
            }
            if (next_token == Keyword.LENGTH_MATCHING) {
                if (this.read_length_matching_color()) continue;
                return false;
            }
            if (next_token == Keyword.PINS) {
                if (this.read_pin_colors()) continue;
                return false;
            }
            if (next_token == Keyword.TRACES) {
                if (this.read_trace_colors(false)) continue;
                return false;
            }
            if (next_token == Keyword.FIXED_TRACES) {
                if (this.read_trace_colors(true)) continue;
                return false;
            }
            if (next_token == Keyword.VIA_KEEPOUT) {
                if (this.read_via_keepout_colors()) continue;
                return false;
            }
            if (next_token == Keyword.VIAS) {
                if (this.read_via_colors(false)) continue;
                return false;
            }
            if (next_token == Keyword.FIXED_VIAS) {
                if (this.read_via_colors(true)) continue;
                return false;
            }
            if (next_token == Keyword.VIOLATIONS) {
                if (this.read_violations_color()) continue;
                return false;
            }
            GUIDefaultsFile.skip_scope(this.scanner);
        }
        return true;
    }

    private boolean read_trace_colors(boolean p_fixed) throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_trace_color_intensity(intensity);
        Color[] curr_colors = this.read_color_array();
        if (curr_colors.length < 1) {
            return false;
        }
        this.board_handling.graphics_context.item_color_table.set_trace_colors(curr_colors, p_fixed);
        return true;
    }

    private boolean read_via_colors(boolean p_fixed) throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_via_color_intensity(intensity);
        Color[] curr_colors = this.read_color_array();
        if (curr_colors.length < 1) {
            return false;
        }
        this.board_handling.graphics_context.item_color_table.set_via_colors(curr_colors, p_fixed);
        return true;
    }

    private boolean read_pin_colors() throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_pin_color_intensity(intensity);
        Color[] curr_colors = this.read_color_array();
        if (curr_colors.length < 1) {
            return false;
        }
        this.board_handling.graphics_context.item_color_table.set_pin_colors(curr_colors);
        return true;
    }

    private boolean read_conduction_colors() throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_conduction_color_intensity(intensity);
        Color[] curr_colors = this.read_color_array();
        if (curr_colors.length < 1) {
            return false;
        }
        this.board_handling.graphics_context.item_color_table.set_conduction_colors(curr_colors);
        return true;
    }

    private boolean read_keepout_colors() throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_obstacle_color_intensity(intensity);
        Color[] curr_colors = this.read_color_array();
        if (curr_colors.length < 1) {
            return false;
        }
        this.board_handling.graphics_context.item_color_table.set_keepout_colors(curr_colors);
        return true;
    }

    private boolean read_via_keepout_colors() throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_via_obstacle_color_intensity(intensity);
        Color[] curr_colors = this.read_color_array();
        if (curr_colors.length < 1) {
            return false;
        }
        this.board_handling.graphics_context.item_color_table.set_via_keepout_colors(curr_colors);
        return true;
    }

    private boolean read_background_color() throws IOException {
        Color curr_color = this.read_color();
        if (curr_color == null) {
            return false;
        }
        this.board_handling.graphics_context.other_color_table.set_background_color(curr_color);
        this.board_frame.set_board_background(curr_color);
        Object next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_background_color: closing bracket expected");
            return false;
        }
        return true;
    }

    private boolean read_hilight_color() throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_hilight_color_intensity(intensity);
        Color curr_color = this.read_color();
        if (curr_color == null) {
            return false;
        }
        this.board_handling.graphics_context.other_color_table.set_hilight_color(curr_color);
        Object next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_higlight_color: closing bracket expected");
            return false;
        }
        return true;
    }

    private boolean read_incompletes_color() throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_incomplete_color_intensity(intensity);
        Color curr_color = this.read_color();
        if (curr_color == null) {
            return false;
        }
        this.board_handling.graphics_context.other_color_table.set_incomplete_color(curr_color);
        Object next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_incompletes_color: closing bracket expected");
            return false;
        }
        return true;
    }

    private boolean read_length_matching_color() throws IOException {
        double intensity = this.read_color_intensity();
        if (intensity < 0.0) {
            return false;
        }
        this.board_handling.graphics_context.set_length_matching_area_color_intensity(intensity);
        Color curr_color = this.read_color();
        if (curr_color == null) {
            return false;
        }
        this.board_handling.graphics_context.other_color_table.set_length_matching_area_color(curr_color);
        Object next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_length_matching_color: closing bracket expected");
            return false;
        }
        return true;
    }

    private boolean read_violations_color() throws IOException {
        Color curr_color = this.read_color();
        if (curr_color == null) {
            return false;
        }
        this.board_handling.graphics_context.other_color_table.set_violations_color(curr_color);
        Object next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_violations_color: closing bracket expected");
            return false;
        }
        return true;
    }

    private boolean read_outline_color() throws IOException {
        Color curr_color = this.read_color();
        if (curr_color == null) {
            return false;
        }
        this.board_handling.graphics_context.other_color_table.set_outline_color(curr_color);
        Object next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_outline_color: closing bracket expected");
            return false;
        }
        return true;
    }

    private boolean read_component_color(boolean p_front) throws IOException {
        Color curr_color = this.read_color();
        if (curr_color == null) {
            return false;
        }
        this.board_handling.graphics_context.other_color_table.set_component_color(curr_color, p_front);
        Object next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_component_color: closing bracket expected");
            return false;
        }
        return true;
    }

    private double read_color_intensity() throws IOException {
        double result;
        Object next_token = this.scanner.next_token();
        if (next_token instanceof Double) {
            result = (Double)next_token;
        } else if (next_token instanceof Integer) {
            result = ((Integer)next_token).intValue();
        } else {
            FRLogger.warn("GUIDefaultsFile.read_color_intensity: Number expected");
            result = -1.0;
        }
        return result;
    }

    private Color read_color() throws IOException {
        int[] rgb_color_arr = new int[3];
        for (int i = 0; i < 3; ++i) {
            Object next_token = this.scanner.next_token();
            if (!(next_token instanceof Integer)) {
                if (next_token != Keyword.CLOSED_BRACKET) {
                    FRLogger.warn("GUIDefaultsFile.read_color: closing bracket expected");
                }
                return null;
            }
            rgb_color_arr[i] = (Integer)next_token;
        }
        return new Color(rgb_color_arr[0], rgb_color_arr[1], rgb_color_arr[2]);
    }

    private Color[] read_color_array() throws IOException {
        Color curr_color;
        LinkedList<Color> color_list = new LinkedList<Color>();
        while ((curr_color = this.read_color()) != null) {
            color_list.add(curr_color);
        }
        Color[] result = new Color[color_list.size()];
        Iterator it = color_list.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Color)it.next();
        }
        return result;
    }

    private void write_colors_scope() throws IOException {
        GraphicsContext graphics_context = this.board_handling.graphics_context;
        this.out_file.start_scope();
        this.out_file.write("colors");
        this.out_file.start_scope();
        this.out_file.write("background");
        this.write_color_scope(graphics_context.get_background_color());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("hilight");
        this.write_color_intensity(graphics_context.get_hilight_color_intensity());
        this.write_color_scope(graphics_context.get_hilight_color());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("incompletes");
        this.write_color_intensity(graphics_context.get_incomplete_color_intensity());
        this.write_color_scope(graphics_context.get_incomplete_color());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("outline");
        this.write_color_scope(graphics_context.get_outline_color());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("component_front");
        this.write_color_scope(graphics_context.get_component_color(true));
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("component_back");
        this.write_color_scope(graphics_context.get_component_color(false));
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("violations");
        this.write_color_scope(graphics_context.get_violations_color());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("length_matching");
        this.write_color_intensity(graphics_context.get_length_matching_area_color_intensity());
        this.write_color_scope(graphics_context.get_length_matching_area_color());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("traces");
        this.write_color_intensity(graphics_context.get_trace_color_intensity());
        this.write_color(graphics_context.get_trace_colors(false));
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("fixed_traces");
        this.write_color_intensity(graphics_context.get_trace_color_intensity());
        this.write_color(graphics_context.get_trace_colors(true));
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("vias");
        this.write_color_intensity(graphics_context.get_via_color_intensity());
        this.write_color(graphics_context.get_via_colors(false));
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("fixed_vias");
        this.write_color_intensity(graphics_context.get_via_color_intensity());
        this.write_color(graphics_context.get_via_colors(true));
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("pins");
        this.write_color_intensity(graphics_context.get_pin_color_intensity());
        this.write_color(graphics_context.get_pin_colors());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("conduction");
        this.write_color_intensity(graphics_context.get_conduction_color_intensity());
        this.write_color(graphics_context.get_conduction_colors());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("keepout");
        this.write_color_intensity(graphics_context.get_obstacle_color_intensity());
        this.write_color(graphics_context.get_obstacle_colors());
        this.out_file.end_scope();
        this.out_file.start_scope();
        this.out_file.write("via_keepout");
        this.write_color_intensity(graphics_context.get_via_obstacle_color_intensity());
        this.write_color(graphics_context.get_via_obstacle_colors());
        this.out_file.end_scope();
        this.out_file.end_scope();
    }

    private void write_color_intensity(double p_value) throws IOException {
        this.out_file.write(" ");
        float value = (float)p_value;
        this.out_file.write(String.valueOf(value));
    }

    private void write_color_scope(Color p_color) throws IOException {
        this.out_file.new_line();
        int red = p_color.getRed();
        this.out_file.write(String.valueOf(red));
        this.out_file.write(" ");
        int green = p_color.getGreen();
        this.out_file.write(String.valueOf(green));
        this.out_file.write(" ");
        int blue = p_color.getBlue();
        this.out_file.write(String.valueOf(blue));
    }

    private void write_color(Color[] p_colors) throws IOException {
        for (int i = 0; i < p_colors.length; ++i) {
            this.write_color_scope(p_colors[i]);
        }
    }

    private boolean read_parameter_scope() throws IOException {
        Object next_token = null;
        while (true) {
            Object prev_token = next_token;
            next_token = this.scanner.next_token();
            if (next_token == null) {
                return false;
            }
            if (next_token == Keyword.CLOSED_BRACKET) break;
            if (prev_token != Keyword.OPEN_BRACKET) continue;
            if (next_token == Keyword.SELECTION_LAYERS) {
                if (this.read_selection_layer_scope()) continue;
                return false;
            }
            if (next_token == Keyword.VIA_SNAP_TO_SMD_CENTER) {
                if (this.read_via_snap_to_smd_center_scope()) continue;
                return false;
            }
            if (next_token == Keyword.SHOVE_ENABLED) {
                if (this.read_shove_enabled_scope()) continue;
                return false;
            }
            if (next_token == Keyword.DRAG_COMPONENTS_ENABLED) {
                if (this.read_drag_components_enabled_scope()) continue;
                return false;
            }
            if (next_token == Keyword.ROUTE_MODE) {
                if (this.read_route_mode_scope()) continue;
                return false;
            }
            if (next_token == Keyword.PULL_TIGHT_REGION) {
                if (this.read_pull_tight_region_scope()) continue;
                return false;
            }
            if (next_token == Keyword.PULL_TIGHT_ACCURACY) {
                if (this.read_pull_tight_accuracy_scope()) continue;
                return false;
            }
            if (next_token == Keyword.IGNORE_CONDUCTION_AREAS) {
                if (this.read_ignore_conduction_scope()) continue;
                return false;
            }
            if (next_token == Keyword.AUTOMATIC_LAYER_DIMMING) {
                if (this.read_automatic_layer_dimming_scope()) continue;
                return false;
            }
            if (next_token == Keyword.CLEARANCE_COMPENSATION) {
                if (this.read_clearance_compensation_scope()) continue;
                return false;
            }
            if (next_token == Keyword.HILIGHT_ROUTING_OBSTACLE) {
                if (this.read_hilight_routing_obstacle_scope()) continue;
                return false;
            }
            if (next_token == Keyword.SELECTABLE_ITEMS) {
                if (this.read_selectable_item_scope()) continue;
                return false;
            }
            if (next_token == Keyword.DESELECTED_SNAPSHOT_ATTRIBUTES) {
                if (this.read_deselected_snapshot_attributes()) continue;
                return false;
            }
            GUIDefaultsFile.skip_scope(this.scanner);
        }
        return true;
    }

    private void write_parameter_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("parameter");
        this.write_selection_layer_scope();
        this.write_selectable_item_scope();
        this.write_via_snap_to_smd_center_scope();
        this.write_route_mode_scope();
        this.write_shove_enabled_scope();
        this.write_drag_components_enabled_scope();
        this.write_hilight_routing_obstacle_scope();
        this.write_pull_tight_region_scope();
        this.write_pull_tight_accuracy_scope();
        this.write_clearance_compensation_scope();
        this.write_ignore_conduction_scope();
        this.write_automatic_layer_dimming_scope();
        this.write_deselected_snapshot_attributes();
        this.out_file.end_scope();
    }

    private boolean read_selection_layer_scope() throws IOException {
        boolean select_on_all_layers;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.ALL_VISIBLE) {
            select_on_all_layers = true;
        } else if (next_token == Keyword.CURRENT_ONLY) {
            select_on_all_layers = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_selection_layer_scope: unexpected token");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_selection_layer_scop: closing bracket expected");
            return false;
        }
        this.board_handling.settings.set_select_on_all_visible_layers(select_on_all_layers);
        return true;
    }

    private boolean read_shove_enabled_scope() throws IOException {
        boolean shove_enabled;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.ON) {
            shove_enabled = true;
        } else if (next_token == Keyword.OFF) {
            shove_enabled = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_shove_enabled_scope: unexpected token");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_shove_enabled_scope: closing bracket expected");
            return false;
        }
        this.board_handling.settings.set_push_enabled(shove_enabled);
        return true;
    }

    private boolean read_drag_components_enabled_scope() throws IOException {
        boolean drag_components_enabled;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.ON) {
            drag_components_enabled = true;
        } else if (next_token == Keyword.OFF) {
            drag_components_enabled = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_drag_components_enabled_scope: unexpected token");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_drag_components_enabled_scope: closing bracket expected");
            return false;
        }
        this.board_handling.settings.set_drag_components_enabled(drag_components_enabled);
        return true;
    }

    private boolean read_ignore_conduction_scope() throws IOException {
        boolean ignore_conduction;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.ON) {
            ignore_conduction = true;
        } else if (next_token == Keyword.OFF) {
            ignore_conduction = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_ignore_conduction_scope: unexpected token");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_ignore_conduction_scope: closing bracket expected");
            return false;
        }
        this.board_handling.set_ignore_conduction(ignore_conduction);
        return true;
    }

    private void write_shove_enabled_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("shove_enabled ");
        this.out_file.new_line();
        if (this.board_handling.settings.get_push_enabled()) {
            this.out_file.write("on");
        } else {
            this.out_file.write("off");
        }
        this.out_file.end_scope();
    }

    private void write_drag_components_enabled_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("drag_components_enabled ");
        this.out_file.new_line();
        if (this.board_handling.settings.get_drag_components_enabled()) {
            this.out_file.write("on");
        } else {
            this.out_file.write("off");
        }
        this.out_file.end_scope();
    }

    private void write_ignore_conduction_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("ignore_conduction_areas ");
        this.out_file.new_line();
        if (this.board_handling.get_routing_board().rules.get_ignore_conduction()) {
            this.out_file.write("on");
        } else {
            this.out_file.write("off");
        }
        this.out_file.end_scope();
    }

    private void write_selection_layer_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("selection_layers ");
        this.out_file.new_line();
        if (this.board_handling.settings.get_select_on_all_visible_layers()) {
            this.out_file.write("all_visible");
        } else {
            this.out_file.write("current_only");
        }
        this.out_file.end_scope();
    }

    private boolean read_route_mode_scope() throws IOException {
        boolean is_stitch_mode;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.STITCHING) {
            is_stitch_mode = true;
        } else if (next_token == Keyword.DYNAMIC) {
            is_stitch_mode = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_route_mode_scope: unexpected token");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_selection_layer_scope: closing bracket expected");
            return false;
        }
        this.board_handling.settings.set_stitch_route(is_stitch_mode);
        return true;
    }

    private void write_route_mode_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("route_mode ");
        this.out_file.new_line();
        if (this.board_handling.settings.get_is_stitch_route()) {
            this.out_file.write("stitching");
        } else {
            this.out_file.write("dynamic");
        }
        this.out_file.end_scope();
    }

    private boolean read_pull_tight_region_scope() throws IOException {
        Object next_token = this.scanner.next_token();
        if (!(next_token instanceof Integer)) {
            FRLogger.warn("GUIDefaultsFile.read_pull_tight_region_scope: Integer expected");
            return false;
        }
        int pull_tight_region = (Integer)next_token;
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_pull_tight_region_scope: closing bracket expected");
            return false;
        }
        this.board_handling.settings.set_current_pull_tight_region_width(pull_tight_region);
        return true;
    }

    private void write_pull_tight_region_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("pull_tight_region ");
        this.out_file.new_line();
        int pull_tight_region = this.board_handling.settings.get_trace_pull_tight_region_width();
        this.out_file.write(String.valueOf(pull_tight_region));
        this.out_file.end_scope();
    }

    private boolean read_pull_tight_accuracy_scope() throws IOException {
        Object next_token = this.scanner.next_token();
        if (!(next_token instanceof Integer)) {
            FRLogger.warn("GUIDefaultsFile.read_pull_tight_accuracy_scope: Integer expected");
            return false;
        }
        int pull_tight_accuracy = (Integer)next_token;
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_pull_tight_accuracy_scope: closing bracket expected");
            return false;
        }
        this.board_handling.settings.set_current_pull_tight_accuracy(pull_tight_accuracy);
        return true;
    }

    private void write_pull_tight_accuracy_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("pull_tight_accuracy ");
        this.out_file.new_line();
        int pull_tight_accuracy = this.board_handling.settings.get_trace_pull_tight_accuracy();
        this.out_file.write(String.valueOf(pull_tight_accuracy));
        this.out_file.end_scope();
    }

    private boolean read_automatic_layer_dimming_scope() throws IOException {
        double intensity;
        Object next_token = this.scanner.next_token();
        if (next_token instanceof Double) {
            intensity = (Double)next_token;
        } else if (next_token instanceof Integer) {
            intensity = ((Integer)next_token).intValue();
        } else {
            FRLogger.warn("GUIDefaultsFile.read_automatic_layer_dimming_scope: Integer expected");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_automatic_layer_dimming_scope: closing bracket expected");
            return false;
        }
        this.board_handling.graphics_context.set_auto_layer_dim_factor(intensity);
        return true;
    }

    private void write_automatic_layer_dimming_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("automatic_layer_dimming ");
        this.out_file.new_line();
        float layer_dimming = (float)this.board_handling.graphics_context.get_auto_layer_dim_factor();
        this.out_file.write(String.valueOf(layer_dimming));
        this.out_file.end_scope();
    }

    private boolean read_hilight_routing_obstacle_scope() throws IOException {
        boolean hilight_obstacle;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.ON) {
            hilight_obstacle = true;
        } else if (next_token == Keyword.OFF) {
            hilight_obstacle = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_hilight_routing_obstacle_scope: unexpected token");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_hilight_routing_obstacle_scope: closing bracket expected");
            return false;
        }
        this.board_handling.settings.set_hilight_routing_obstacle(hilight_obstacle);
        return true;
    }

    private void write_hilight_routing_obstacle_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("hilight_routing_obstacle ");
        this.out_file.new_line();
        if (this.board_handling.settings.get_hilight_routing_obstacle()) {
            this.out_file.write("on");
        } else {
            this.out_file.write("off");
        }
        this.out_file.end_scope();
    }

    private boolean read_clearance_compensation_scope() throws IOException {
        boolean clearance_compensation;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.ON) {
            clearance_compensation = true;
        } else if (next_token == Keyword.OFF) {
            clearance_compensation = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_clearance_compensation_scope: unexpected token");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_clearance_compensation_scope: closing bracket expected");
            return false;
        }
        this.board_handling.set_clearance_compensation(clearance_compensation);
        return true;
    }

    private void write_clearance_compensation_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("clearance_compensation ");
        this.out_file.new_line();
        if (this.board_handling.get_routing_board().search_tree_manager.is_clearance_compensation_used()) {
            this.out_file.write("on");
        } else {
            this.out_file.write("off");
        }
        this.out_file.end_scope();
    }

    private boolean read_via_snap_to_smd_center_scope() throws IOException {
        boolean snap;
        Object next_token = this.scanner.next_token();
        if (next_token == Keyword.ON) {
            snap = true;
        } else if (next_token == Keyword.OFF) {
            snap = false;
        } else {
            FRLogger.warn("GUIDefaultsFile.read_via_snap_to_smd_center_scope: unexpected token");
            return false;
        }
        next_token = this.scanner.next_token();
        if (next_token != Keyword.CLOSED_BRACKET) {
            FRLogger.warn("GUIDefaultsFile.read_via_snap_to_smd_center_scope: closing bracket expected");
            return false;
        }
        this.board_handling.settings.set_via_snap_to_smd_center(snap);
        return true;
    }

    private void write_via_snap_to_smd_center_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("via_snap_to_smd_center ");
        this.out_file.new_line();
        if (this.board_handling.settings.get_via_snap_to_smd_center()) {
            this.out_file.write("on");
        } else {
            this.out_file.write("off");
        }
        this.out_file.end_scope();
    }

    private boolean read_selectable_item_scope() throws IOException {
        Object next_token;
        ItemSelectionFilter item_selection_filter = this.board_handling.settings.get_item_selection_filter();
        item_selection_filter.deselect_all();
        while ((next_token = this.scanner.next_token()) != Keyword.CLOSED_BRACKET) {
            if (next_token == Keyword.TRACES) {
                item_selection_filter.set_selected(ItemSelectionFilter.SelectableChoices.TRACES, true);
                continue;
            }
            if (next_token == Keyword.VIAS) {
                item_selection_filter.set_selected(ItemSelectionFilter.SelectableChoices.VIAS, true);
                continue;
            }
            if (next_token == Keyword.PINS) {
                item_selection_filter.set_selected(ItemSelectionFilter.SelectableChoices.PINS, true);
                continue;
            }
            if (next_token == Keyword.CONDUCTION) {
                item_selection_filter.set_selected(ItemSelectionFilter.SelectableChoices.CONDUCTION, true);
                continue;
            }
            if (next_token == Keyword.KEEPOUT) {
                item_selection_filter.set_selected(ItemSelectionFilter.SelectableChoices.KEEPOUT, true);
                continue;
            }
            if (next_token == Keyword.VIA_KEEPOUT) {
                item_selection_filter.set_selected(ItemSelectionFilter.SelectableChoices.VIA_KEEPOUT, true);
                continue;
            }
            if (next_token == Keyword.FIXED) {
                item_selection_filter.set_selected(ItemSelectionFilter.SelectableChoices.FIXED, true);
                continue;
            }
            if (next_token == Keyword.UNFIXED) {
                item_selection_filter.set_selected(ItemSelectionFilter.SelectableChoices.UNFIXED, true);
                continue;
            }
            FRLogger.warn("GUIDefaultsFile.read_selectable_item_scope: unexpected token");
            return false;
        }
        return true;
    }

    private void write_selectable_item_scope() throws IOException {
        this.out_file.start_scope();
        this.out_file.write("selectable_items ");
        this.out_file.new_line();
        ItemSelectionFilter item_selection_filter = this.board_handling.settings.get_item_selection_filter();
        ItemSelectionFilter.SelectableChoices[] selectable_choices = ItemSelectionFilter.SelectableChoices.values();
        for (int i = 0; i < selectable_choices.length; ++i) {
            if (!item_selection_filter.is_selected(selectable_choices[i])) continue;
            this.out_file.write(selectable_choices[i].toString());
            this.out_file.write(" ");
        }
        this.out_file.end_scope();
    }

    private void write_deselected_snapshot_attributes() throws IOException {
        SnapShot.Attributes attributes = this.board_handling.settings.get_snapshot_attributes();
        this.out_file.start_scope();
        this.out_file.write("deselected_snapshot_attributes ");
        if (!attributes.object_colors) {
            this.out_file.new_line();
            this.out_file.write("object_colors ");
        }
        if (!attributes.object_visibility) {
            this.out_file.new_line();
            this.out_file.write("object_visibility ");
        }
        if (!attributes.layer_visibility) {
            this.out_file.new_line();
            this.out_file.write("layer_visibility ");
        }
        if (!attributes.display_region) {
            this.out_file.new_line();
            this.out_file.write("display_region ");
        }
        if (!attributes.interactive_state) {
            this.out_file.new_line();
            this.out_file.write("interactive_state ");
        }
        if (!attributes.selection_layers) {
            this.out_file.new_line();
            this.out_file.write("selection_layers ");
        }
        if (!attributes.selectable_items) {
            this.out_file.new_line();
            this.out_file.write("selectable_items ");
        }
        if (!attributes.current_layer) {
            this.out_file.new_line();
            this.out_file.write("current_layer ");
        }
        if (!attributes.rule_selection) {
            this.out_file.new_line();
            this.out_file.write("rule_selection ");
        }
        if (!attributes.manual_rule_settings) {
            this.out_file.new_line();
            this.out_file.write("manual_rule_settings ");
        }
        if (!attributes.push_and_shove_enabled) {
            this.out_file.new_line();
            this.out_file.write("push_and_shove_enabled ");
        }
        if (!attributes.drag_components_enabled) {
            this.out_file.new_line();
            this.out_file.write("drag_components_enabled ");
        }
        if (!attributes.pull_tight_region) {
            this.out_file.new_line();
            this.out_file.write("pull_tight_region ");
        }
        if (!attributes.component_grid) {
            this.out_file.new_line();
            this.out_file.write("component_grid ");
        }
        this.out_file.end_scope();
    }

    private boolean read_deselected_snapshot_attributes() throws IOException {
        Object next_token;
        SnapShot.Attributes attributes = this.board_handling.settings.get_snapshot_attributes();
        while ((next_token = this.scanner.next_token()) != Keyword.CLOSED_BRACKET) {
            if (next_token == Keyword.OBJECT_COLORS) {
                attributes.object_colors = false;
                continue;
            }
            if (next_token == Keyword.OBJECT_VISIBILITY) {
                attributes.object_visibility = false;
                continue;
            }
            if (next_token == Keyword.LAYER_VISIBILITY) {
                attributes.layer_visibility = false;
                continue;
            }
            if (next_token == Keyword.DISPLAY_REGION) {
                attributes.display_region = false;
                continue;
            }
            if (next_token == Keyword.INTERACTIVE_STATE) {
                attributes.interactive_state = false;
                continue;
            }
            if (next_token == Keyword.SELECTION_LAYERS) {
                attributes.selection_layers = false;
                continue;
            }
            if (next_token == Keyword.SELECTABLE_ITEMS) {
                attributes.selectable_items = false;
                continue;
            }
            if (next_token == Keyword.CURRENT_LAYER) {
                attributes.current_layer = false;
                continue;
            }
            if (next_token == Keyword.RULE_SELECTION) {
                attributes.rule_selection = false;
                continue;
            }
            if (next_token == Keyword.MANUAL_RULE_SETTINGS) {
                attributes.manual_rule_settings = false;
                continue;
            }
            if (next_token == Keyword.PUSH_AND_SHOVE_ENABLED) {
                attributes.push_and_shove_enabled = false;
                continue;
            }
            if (next_token == Keyword.DRAG_COMPONENTS_ENABLED) {
                attributes.drag_components_enabled = false;
                continue;
            }
            if (next_token == Keyword.PULL_TIGHT_REGION) {
                attributes.pull_tight_region = false;
                continue;
            }
            if (next_token == Keyword.COMPONENT_GRID) {
                attributes.component_grid = false;
                continue;
            }
            FRLogger.warn("GUIDefaultsFile.read_deselected_snapshot_attributes: unexpected token");
            return false;
        }
        return true;
    }

    static enum Keyword {
        ALL_VISIBLE,
        ASSIGN_NET_RULES,
        AUTOMATIC_LAYER_DIMMING,
        BACKGROUND,
        BOARD_FRAME,
        BOUNDS,
        CLEARANCE_COMPENSATION,
        CLEARANCE_MATRIX,
        CLOSED_BRACKET,
        COLOR_MANAGER,
        COLORS,
        COMPONENT_BACK,
        COMPONENT_FRONT,
        COMPONENT_GRID,
        COMPONENT_INFO,
        CONDUCTION,
        CURRENT_LAYER,
        CURRENT_ONLY,
        DESELECTED_SNAPSHOT_ATTRIBUTES,
        DISPLAY_MISCELLANEOUS,
        DISPLAY_REGION,
        DRAG_COMPONENTS_ENABLED,
        DYNAMIC,
        EDIT_VIAS,
        EDIT_NET_RULES,
        FIXED,
        FIXED_TRACES,
        FIXED_VIAS,
        FORTYFIVE_DEGREE,
        GUI_DEFAULTS,
        HILIGHT,
        HILIGHT_ROUTING_OBSTACLE,
        IGNORE_CONDUCTION_AREAS,
        INCOMPLETES,
        INCOMPLETES_INFO,
        INTERACTIVE_STATE,
        KEEPOUT,
        LAYER_VISIBILITY,
        LENGTH_MATCHING,
        MANUAL_RULES,
        MANUAL_RULE_SETTINGS,
        MOVE_PARAMETER,
        NET_INFO,
        NINETY_DEGREE,
        NONE,
        NOT_VISIBLE,
        OBJECT_COLORS,
        OBJECT_VISIBILITY,
        OPEN_BRACKET,
        OFF,
        ON,
        OUTLINE,
        PARAMETER,
        PACKAGE_INFO,
        PADSTACK_INFO,
        PINS,
        PULL_TIGHT_ACCURACY,
        PULL_TIGHT_REGION,
        PUSH_AND_SHOVE_ENABLED,
        ROUTE_DETAILS,
        ROUTE_MODE,
        ROUTE_PARAMETER,
        RULE_SELECTION,
        SELECT_PARAMETER,
        SELECTABLE_ITEMS,
        SELECTION_LAYERS,
        SNAPSHOTS,
        SHOVE_ENABLED,
        STITCHING,
        TRACES,
        UNFIXED,
        VIA_KEEPOUT,
        VISIBLE,
        VIA_RULES,
        VIA_SNAP_TO_SMD_CENTER,
        VIAS,
        VIOLATIONS,
        VIOLATIONS_INFO,
        WINDOWS;

    }
}

