/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.Unit;
import app.freerouting.gui.BoardFrame;
import app.freerouting.interactive.DragMenuState;
import app.freerouting.interactive.InteractiveActionThread;
import app.freerouting.interactive.InteractiveState;
import app.freerouting.interactive.RouteMenuState;
import app.freerouting.interactive.SelectMenuState;
import app.freerouting.management.FRAnalytics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

class BoardToolbar
extends JPanel {
    final JFormattedTextField unit_factor_field;
    final JComboBox<Unit> toolbar_unit_combo_box;
    private final BoardFrame board_frame;
    private final JToggleButton toolbar_select_button;
    private final JToggleButton toolbar_route_button;
    private final JToggleButton toolbar_drag_button;

    BoardToolbar(BoardFrame p_board_frame) {
        this.board_frame = p_board_frame;
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.gui.BoardToolbar", p_board_frame.get_locale());
        this.setLayout(new BorderLayout());
        JToolBar left_toolbar = new JToolBar();
        ButtonGroup toolbar_button_group = new ButtonGroup();
        this.toolbar_select_button = new JToggleButton();
        this.toolbar_route_button = new JToggleButton();
        this.toolbar_drag_button = new JToggleButton();
        JLabel jLabel1 = new JLabel();
        left_toolbar.setMaximumSize(new Dimension(1200, 30));
        toolbar_button_group.add(this.toolbar_select_button);
        this.toolbar_select_button.setSelected(true);
        this.toolbar_select_button.setText(resources.getString("select_button"));
        this.toolbar_select_button.setToolTipText(resources.getString("select_button_tooltip"));
        this.toolbar_select_button.addActionListener(evt -> this.board_frame.board_panel.board_handling.set_select_menu_state());
        this.toolbar_select_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_select_button", this.toolbar_select_button.getText()));
        left_toolbar.add(this.toolbar_select_button);
        toolbar_button_group.add(this.toolbar_route_button);
        this.toolbar_route_button.setText(resources.getString("route_button"));
        this.toolbar_route_button.setToolTipText(resources.getString("route_button_tooltip"));
        this.toolbar_route_button.addActionListener(evt -> this.board_frame.board_panel.board_handling.set_route_menu_state());
        this.toolbar_route_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_route_button", this.toolbar_route_button.getText()));
        left_toolbar.add(this.toolbar_route_button);
        toolbar_button_group.add(this.toolbar_drag_button);
        this.toolbar_drag_button.setText(resources.getString("drag_button"));
        this.toolbar_drag_button.setToolTipText(resources.getString("drag_button_tooltip"));
        this.toolbar_drag_button.addActionListener(evt -> this.board_frame.board_panel.board_handling.set_drag_menu_state());
        this.toolbar_drag_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_drag_button", this.toolbar_drag_button.getText()));
        left_toolbar.add(this.toolbar_drag_button);
        jLabel1.setMaximumSize(new Dimension(30, 10));
        jLabel1.setMinimumSize(new Dimension(3, 10));
        jLabel1.setPreferredSize(new Dimension(30, 10));
        left_toolbar.add(jLabel1);
        this.add((Component)left_toolbar, "West");
        JToolBar middle_toolbar = new JToolBar();
        JButton toolbar_autoroute_button = new JButton();
        toolbar_autoroute_button.setText(resources.getString("autoroute_button"));
        toolbar_autoroute_button.setToolTipText(resources.getString("autoroute_button_tooltip"));
        toolbar_autoroute_button.setDefaultCapable(true);
        Font currentFont = toolbar_autoroute_button.getFont();
        Font boldFont = new Font(currentFont.getFontName(), 1, currentFont.getSize());
        toolbar_autoroute_button.setFont(boldFont);
        toolbar_autoroute_button.setBorder(BorderFactory.createBevelBorder(0));
        toolbar_autoroute_button.setBorder(BorderFactory.createCompoundBorder(toolbar_autoroute_button.getBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        toolbar_autoroute_button.setCursor(new Cursor(12));
        toolbar_autoroute_button.addActionListener(evt -> {
            InteractiveActionThread thread = this.board_frame.board_panel.board_handling.start_batch_autorouter();
            if (this.board_frame.board_panel.board_handling.autorouter_listener != null) {
                thread.addListener(this.board_frame.board_panel.board_handling.autorouter_listener);
            }
        });
        toolbar_autoroute_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_autoroute_button", toolbar_autoroute_button.getText()));
        middle_toolbar.add(toolbar_autoroute_button);
        JLabel separator_2 = new JLabel();
        separator_2.setMaximumSize(new Dimension(10, 10));
        separator_2.setPreferredSize(new Dimension(10, 10));
        separator_2.setRequestFocusEnabled(false);
        middle_toolbar.add(separator_2);
        JButton toolbar_undo_button = new JButton();
        toolbar_undo_button.setText(resources.getString("undo_button"));
        toolbar_undo_button.setToolTipText(resources.getString("undo_button_tooltip"));
        toolbar_undo_button.addActionListener(evt -> {
            this.board_frame.board_panel.board_handling.cancel_state();
            this.board_frame.board_panel.board_handling.undo();
            this.board_frame.refresh_windows();
        });
        toolbar_undo_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_undo_button", toolbar_undo_button.getText()));
        middle_toolbar.add(toolbar_undo_button);
        JButton toolbar_redo_button = new JButton();
        toolbar_redo_button.setText(resources.getString("redo_button"));
        toolbar_redo_button.setToolTipText(resources.getString("redo_button_tooltip"));
        toolbar_redo_button.addActionListener(evt -> this.board_frame.board_panel.board_handling.redo());
        toolbar_redo_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_redo_button", toolbar_redo_button.getText()));
        middle_toolbar.add(toolbar_redo_button);
        JLabel separator_1 = new JLabel();
        separator_1.setMaximumSize(new Dimension(10, 10));
        separator_1.setPreferredSize(new Dimension(10, 10));
        middle_toolbar.add(separator_1);
        JButton toolbar_incompletes_button = new JButton();
        toolbar_incompletes_button.setText(resources.getString("incompletes_button"));
        toolbar_incompletes_button.setToolTipText(resources.getString("incompletes_button_tooltip"));
        toolbar_incompletes_button.addActionListener(evt -> this.board_frame.board_panel.board_handling.toggle_ratsnest());
        toolbar_incompletes_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_incompletes_button", toolbar_incompletes_button.getText()));
        middle_toolbar.add(toolbar_incompletes_button);
        JButton toolbar_violation_button = new JButton();
        toolbar_violation_button.setText(resources.getString("violations_button"));
        toolbar_violation_button.setToolTipText(resources.getString("violations_button_tooltip"));
        toolbar_violation_button.addActionListener(evt -> this.board_frame.board_panel.board_handling.toggle_clearance_violations());
        toolbar_violation_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_violation_button", toolbar_violation_button.getText()));
        middle_toolbar.add(toolbar_violation_button);
        JLabel separator_3 = new JLabel();
        separator_3.setMaximumSize(new Dimension(10, 10));
        separator_3.setPreferredSize(new Dimension(10, 10));
        separator_3.setRequestFocusEnabled(false);
        middle_toolbar.add(separator_3);
        JButton toolbar_display_all_button = new JButton();
        toolbar_display_all_button.setText(resources.getString("display_all_button"));
        toolbar_display_all_button.setToolTipText(resources.getString("display_all_button_tooltip"));
        toolbar_display_all_button.addActionListener(evt -> this.board_frame.zoom_all());
        toolbar_display_all_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_display_all_button", toolbar_display_all_button.getText()));
        middle_toolbar.add(toolbar_display_all_button);
        JButton toolbar_display_region_button = new JButton();
        toolbar_display_region_button.setText(resources.getString("display_region_button"));
        toolbar_display_region_button.setToolTipText(resources.getString("display_region_button_tooltip"));
        toolbar_display_region_button.addActionListener(evt -> this.board_frame.board_panel.board_handling.zoom_region());
        toolbar_display_region_button.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_display_region_button", toolbar_display_region_button.getText()));
        middle_toolbar.add(toolbar_display_region_button);
        this.add((Component)middle_toolbar, "Center");
        JToolBar right_toolbar = new JToolBar();
        JLabel unit_label = new JLabel();
        NumberFormat number_format = NumberFormat.getInstance(p_board_frame.get_locale());
        number_format.setMaximumFractionDigits(7);
        this.unit_factor_field = new JFormattedTextField(number_format);
        JLabel jLabel4 = new JLabel();
        right_toolbar.setAutoscrolls(true);
        unit_label.setText(resources.getString("unit_button"));
        right_toolbar.add(unit_label);
        this.unit_factor_field.setHorizontalAlignment(0);
        this.unit_factor_field.setValue(1);
        this.unit_factor_field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\n') {
                    double input_value;
                    Object input = BoardToolbar.this.unit_factor_field.getValue();
                    if (input instanceof Number && (input_value = ((Number)input).doubleValue()) > 0.0) {
                        BoardToolbar.this.board_frame.board_panel.board_handling.change_user_unit_factor(input_value);
                    }
                    double unit_factor = BoardToolbar.this.board_frame.board_panel.board_handling.coordinate_transform.user_unit_factor;
                    BoardToolbar.this.unit_factor_field.setValue(unit_factor);
                    BoardToolbar.this.board_frame.refresh_windows();
                }
            }
        });
        right_toolbar.add(this.unit_factor_field);
        this.toolbar_unit_combo_box = new JComboBox();
        this.toolbar_unit_combo_box.setModel(new DefaultComboBoxModel<Unit>(Unit.values()));
        this.toolbar_unit_combo_box.setFocusTraversalPolicyProvider(true);
        this.toolbar_unit_combo_box.setInheritsPopupMenu(true);
        this.toolbar_unit_combo_box.setOpaque(false);
        this.toolbar_unit_combo_box.addActionListener(evt -> {
            Unit new_unit = (Unit)this.toolbar_unit_combo_box.getSelectedItem();
            this.board_frame.board_panel.board_handling.change_user_unit(new_unit);
            this.board_frame.refresh_windows();
        });
        this.toolbar_unit_combo_box.addActionListener(evt -> FRAnalytics.buttonClicked("toolbar_unit_combo_box", ((Unit)this.toolbar_unit_combo_box.getSelectedItem()).name()));
        right_toolbar.add(this.toolbar_unit_combo_box);
        jLabel4.setMaximumSize(new Dimension(30, 14));
        jLabel4.setPreferredSize(new Dimension(30, 14));
        right_toolbar.add(jLabel4);
        this.add((Component)right_toolbar, "East");
    }

    void hilight_selected_button() {
        InteractiveState interactive_state = this.board_frame.board_panel.board_handling.get_interactive_state();
        if (interactive_state instanceof RouteMenuState) {
            this.toolbar_route_button.setSelected(true);
        } else if (interactive_state instanceof DragMenuState) {
            this.toolbar_drag_button.setSelected(true);
        } else if (interactive_state instanceof SelectMenuState) {
            this.toolbar_select_button.setSelected(true);
        }
    }
}

