/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.gui;

import app.freerouting.board.BoardObserverAdaptor;
import app.freerouting.board.BoardObservers;
import app.freerouting.board.ItemIdNoGenerator;
import app.freerouting.board.TestLevel;
import app.freerouting.datastructures.FileFilter;
import app.freerouting.datastructures.IdNoGenerator;
import app.freerouting.designforms.specctra.DsnFile;
import app.freerouting.gui.BoardMenuBar;
import app.freerouting.gui.BoardPanel;
import app.freerouting.gui.BoardPanelStatus;
import app.freerouting.gui.BoardSavableSubWindow;
import app.freerouting.gui.BoardSubWindow;
import app.freerouting.gui.BoardTemporarySubWindow;
import app.freerouting.gui.BoardToolbar;
import app.freerouting.gui.BoardToolbarSelectedItem;
import app.freerouting.gui.ColorManager;
import app.freerouting.gui.DesignFile;
import app.freerouting.gui.GUIDefaultsFile;
import app.freerouting.gui.WindowAbout;
import app.freerouting.gui.WindowAssignNetClass;
import app.freerouting.gui.WindowAutorouteParameter;
import app.freerouting.gui.WindowBase;
import app.freerouting.gui.WindowClearanceMatrix;
import app.freerouting.gui.WindowClearanceViolations;
import app.freerouting.gui.WindowComponents;
import app.freerouting.gui.WindowDisplayMisc;
import app.freerouting.gui.WindowEditVias;
import app.freerouting.gui.WindowIncompletes;
import app.freerouting.gui.WindowLayerVisibility;
import app.freerouting.gui.WindowLengthViolations;
import app.freerouting.gui.WindowMessage;
import app.freerouting.gui.WindowMoveParameter;
import app.freerouting.gui.WindowNetClasses;
import app.freerouting.gui.WindowNets;
import app.freerouting.gui.WindowObjectListWithFilter;
import app.freerouting.gui.WindowObjectVisibility;
import app.freerouting.gui.WindowPackages;
import app.freerouting.gui.WindowPadstacks;
import app.freerouting.gui.WindowRouteParameter;
import app.freerouting.gui.WindowRouteStubs;
import app.freerouting.gui.WindowSelectParameter;
import app.freerouting.gui.WindowSnapshot;
import app.freerouting.gui.WindowUnconnectedRoute;
import app.freerouting.gui.WindowVia;
import app.freerouting.interactive.ScreenMessages;
import app.freerouting.logger.FRLogger;
import app.freerouting.management.FRAnalytics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class BoardFrame
extends WindowBase {
    static final int SUBWINDOW_COUNT = 24;
    static final String[] log_file_extensions = new String[]{"log"};
    static final String GUI_DEFAULTS_FILE_NAME = "gui_defaults.par";
    static final String GUI_DEFAULTS_FILE_BACKUP_NAME = "gui_defaults.par.bak";
    static final FileFilter logfile_filter = new FileFilter(log_file_extensions);
    final JScrollPane scroll_pane;
    final BoardMenuBar menubar;
    final BoardPanel board_panel;
    final ScreenMessages screen_messages;
    private final BoardToolbar toolbar_panel;
    private final JToolBar select_toolbar;
    private final BoardPanelStatus message_panel;
    private final TestLevel test_level;
    private final boolean help_system_used;
    private final boolean confirm_cancel;
    private final ResourceBundle resources;
    private final BoardObservers board_observers;
    private final IdNoGenerator item_id_no_generator;
    WindowAbout about_window;
    WindowRouteParameter route_parameter_window;
    WindowAutorouteParameter autoroute_parameter_window;
    WindowSelectParameter select_parameter_window;
    WindowMoveParameter move_parameter_window;
    WindowClearanceMatrix clearance_matrix_window;
    WindowVia via_window;
    WindowEditVias edit_vias_window;
    WindowNetClasses edit_net_rules_window;
    WindowAssignNetClass assign_net_classes_window;
    WindowPadstacks padstacks_window;
    WindowPackages packages_window;
    WindowIncompletes incompletes_window;
    WindowNets net_info_window;
    WindowClearanceViolations clearance_violations_window;
    WindowLengthViolations length_violations_window;
    WindowUnconnectedRoute unconnected_route_window;
    WindowRouteStubs route_stubs_window;
    WindowComponents components_window;
    WindowLayerVisibility layer_visibility_window;
    WindowObjectVisibility object_visibility_window;
    WindowDisplayMisc display_misc_window;
    WindowSnapshot snapshot_window;
    ColorManager color_manager;
    BoardSavableSubWindow[] permanent_subwindows = new BoardSavableSubWindow[24];
    Collection<BoardTemporarySubWindow> temporary_subwindows = new LinkedList<BoardTemporarySubWindow>();
    private LocalDateTime intermediate_stage_file_last_saved_at;
    DesignFile design_file;
    private final Locale locale;

    public BoardFrame(DesignFile p_design, Option p_option, TestLevel p_test_level, Locale p_locale, boolean p_confirm_cancel, boolean p_save_intermediate_stages, float p_optimization_improvement_threshold) {
        this(p_design, p_option, p_test_level, new BoardObserverAdaptor(), new ItemIdNoGenerator(), p_locale, p_confirm_cancel, p_save_intermediate_stages, p_optimization_improvement_threshold);
    }

    BoardFrame(DesignFile p_design, Option p_option, TestLevel p_test_level, BoardObservers p_observers, IdNoGenerator p_item_id_no_generator, Locale p_locale, boolean p_confirm_cancel, boolean p_save_intermediate_stages, float p_optimization_improvement_threshold) {
        super(800, 150);
        BoardMenuBar curr_menubar;
        this.design_file = p_design;
        this.test_level = p_test_level;
        this.confirm_cancel = p_confirm_cancel;
        this.board_observers = p_observers;
        this.item_id_no_generator = p_item_id_no_generator;
        this.locale = p_locale;
        this.resources = ResourceBundle.getBundle("app.freerouting.gui.BoardFrame", p_locale);
        boolean session_file_option = p_option == Option.SESSION_FILE;
        boolean curr_help_system_used = true;
        try {
            curr_menubar = BoardMenuBar.get_instance(this, curr_help_system_used, session_file_option);
        }
        catch (NoClassDefFoundError e) {
            curr_help_system_used = false;
            curr_menubar = BoardMenuBar.get_instance(this, false, session_file_option);
            FRLogger.warn("Online-Help deactivated because system file jh.jar is missing");
        }
        this.menubar = curr_menubar;
        this.help_system_used = curr_help_system_used;
        this.setJMenuBar(this.menubar);
        this.toolbar_panel = new BoardToolbar(this);
        this.add((Component)this.toolbar_panel, "North");
        this.message_panel = new BoardPanelStatus(this.locale);
        this.add((Component)this.message_panel, "South");
        this.select_toolbar = new BoardToolbarSelectedItem(this, p_option == Option.EXTENDED_TOOL_BAR);
        this.screen_messages = new ScreenMessages(this.message_panel.status_message, this.message_panel.add_message, this.message_panel.current_layer, this.message_panel.mouse_position, this.locale);
        this.scroll_pane = new JScrollPane();
        this.scroll_pane.setPreferredSize(new Dimension(1150, 800));
        this.scroll_pane.setVerifyInputWhenFocusTarget(false);
        this.add((Component)this.scroll_pane, "Center");
        this.board_panel = new BoardPanel(this.screen_messages, this, p_locale, p_save_intermediate_stages, p_optimization_improvement_threshold);
        this.scroll_pane.setViewportView(this.board_panel);
        this.setTitle(this.resources.getString("title"));
        this.addWindowListener(new WindowStateListener());
        this.pack();
    }

    public static BoardFrame get_embedded_instance(String p_design_file_path_name, BoardObservers p_observers, IdNoGenerator p_id_no_generator, Locale p_locale, boolean p_save_intermediate_stages, float p_optimization_improvement_threshold) {
        DesignFile design_file = DesignFile.get_instance(p_design_file_path_name);
        if (design_file == null) {
            WindowMessage.show("designfile not found");
            return null;
        }
        BoardFrame board_frame = new BoardFrame(design_file, Option.SINGLE_FRAME, TestLevel.RELEASE_VERSION, p_observers, p_id_no_generator, p_locale, false, p_save_intermediate_stages, p_optimization_improvement_threshold);
        InputStream input_stream = design_file.get_input_stream();
        boolean read_ok = board_frame.read(input_stream, true, null);
        if (!read_ok) {
            String error_message = "Unable to read design file with pathname " + p_design_file_path_name;
            board_frame.setVisible(true);
            board_frame.screen_messages.set_status_message(error_message);
        }
        return board_frame;
    }

    void read_logfile(InputStream p_input_stream) {
        this.board_panel.board_handling.read_logfile(p_input_stream);
    }

    boolean read(InputStream p_input_stream, boolean p_is_import, JTextField p_message_field) {
        Point viewport_position = null;
        DsnFile.ReadResult read_result = null;
        if (p_is_import) {
            read_result = this.board_panel.board_handling.import_design(p_input_stream, this.board_observers, this.item_id_no_generator, this.test_level);
            if (read_result == DsnFile.ReadResult.OK) {
                viewport_position = new Point(0, 0);
                this.initialize_windows();
            }
        } else {
            Rectangle frame_bounds;
            Point frame_location;
            ObjectInputStream object_stream;
            try {
                object_stream = new ObjectInputStream(p_input_stream);
            }
            catch (IOException e) {
                return false;
            }
            boolean read_ok = this.board_panel.board_handling.read_design(object_stream, this.test_level);
            if (!read_ok) {
                return false;
            }
            try {
                viewport_position = (Point)object_stream.readObject();
                frame_location = (Point)object_stream.readObject();
                frame_bounds = (Rectangle)object_stream.readObject();
            }
            catch (Exception e) {
                return false;
            }
            this.setLocation(frame_location);
            this.setBounds(frame_bounds);
            this.allocate_permanent_subwindows();
            for (int i = 0; i < this.permanent_subwindows.length; ++i) {
                this.permanent_subwindows[i].read(object_stream);
            }
        }
        try {
            p_input_stream.close();
        }
        catch (IOException e) {
            return false;
        }
        return this.update_gui(p_is_import, read_result, viewport_position, p_message_field);
    }

    private boolean update_gui(boolean p_is_import, DsnFile.ReadResult read_result, Point viewport_position, JTextField p_message_field) {
        if (p_is_import && read_result != DsnFile.ReadResult.OK) {
            if (p_message_field != null) {
                if (read_result == DsnFile.ReadResult.OUTLINE_MISSING) {
                    p_message_field.setText(this.resources.getString("error_7"));
                } else {
                    p_message_field.setText(this.resources.getString("error_6"));
                }
            }
            return false;
        }
        Dimension panel_size = this.board_panel.board_handling.graphics_context.get_panel_size();
        this.board_panel.setSize(panel_size);
        this.board_panel.setPreferredSize(panel_size);
        if (viewport_position != null) {
            this.board_panel.set_viewport_position(viewport_position);
        }
        this.board_panel.create_popup_menus();
        this.board_panel.init_colors();
        this.board_panel.board_handling.create_ratsnest();
        this.hilight_selected_button();
        this.toolbar_panel.unit_factor_field.setValue(this.board_panel.board_handling.coordinate_transform.user_unit_factor);
        this.toolbar_panel.toolbar_unit_combo_box.setSelectedItem(this.board_panel.board_handling.coordinate_transform.user_unit);
        this.setVisible(true);
        if (p_is_import) {
            FileInputStream input_stream = null;
            File defaults_file = new File(this.design_file.get_parent(), GUI_DEFAULTS_FILE_NAME);
            boolean defaults_file_found = true;
            try {
                input_stream = new FileInputStream(defaults_file);
            }
            catch (FileNotFoundException e) {
                defaults_file_found = false;
            }
            if (defaults_file_found) {
                boolean read_ok = GUIDefaultsFile.read(this, this.board_panel.board_handling, input_stream);
                if (!read_ok) {
                    this.screen_messages.set_status_message(this.resources.getString("error_1"));
                }
                try {
                    ((InputStream)input_stream).close();
                }
                catch (IOException e) {
                    return false;
                }
            }
            this.zoom_all();
        }
        return true;
    }

    boolean save() {
        return this.save(this.design_file.get_output_file());
    }

    public boolean load_intermediate_stage_file() {
        try {
            FileInputStream input_stream = new FileInputStream(this.design_file.get_snapshot_file());
            return this.read(input_stream, false, null);
        }
        catch (IOException e) {
            this.screen_messages.set_status_message(this.resources.getString("error_2"));
            return false;
        }
        catch (Exception e) {
            this.screen_messages.set_status_message(this.resources.getString("error_3"));
            return false;
        }
    }

    public boolean save_intermediate_stage_file() {
        if (this.intermediate_stage_file_last_saved_at != null && this.intermediate_stage_file_last_saved_at.plusSeconds(30L).isAfter(LocalDateTime.now())) {
            return false;
        }
        this.intermediate_stage_file_last_saved_at = LocalDateTime.now();
        return this.save(this.design_file.get_snapshot_file());
    }

    public boolean delete_intermediate_stage_file() {
        return this.design_file.get_snapshot_file().delete();
    }

    public boolean is_intermediate_stage_file_available() {
        return this.design_file.get_snapshot_file().exists() && this.design_file.get_snapshot_file().canRead();
    }

    public LocalDateTime get_intermediate_stage_file_modification_time() {
        long lastModified = this.design_file.get_snapshot_file().lastModified();
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(lastModified), ZoneId.systemDefault());
    }

    private boolean save(File output_file) {
        ObjectOutputStream object_stream;
        FileOutputStream output_stream;
        if (this.design_file == null) {
            return false;
        }
        try {
            FRLogger.info("Saving '" + output_file.getPath() + "'...");
            output_stream = new FileOutputStream(output_file);
            object_stream = new ObjectOutputStream(output_stream);
        }
        catch (IOException e) {
            this.screen_messages.set_status_message(this.resources.getString("error_2"));
            return false;
        }
        catch (Exception e) {
            this.screen_messages.set_status_message(this.resources.getString("error_3"));
            return false;
        }
        boolean save_ok = this.board_panel.board_handling.save_design_file(object_stream);
        if (!save_ok) {
            return false;
        }
        try {
            object_stream.writeObject(this.board_panel.get_viewport_position());
            object_stream.writeObject(this.getLocation());
            object_stream.writeObject(this.getBounds());
        }
        catch (IOException e) {
            this.screen_messages.set_status_message(this.resources.getString("error_4"));
            return false;
        }
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            this.permanent_subwindows[i].save(object_stream);
        }
        try {
            object_stream.flush();
            ((OutputStream)output_stream).close();
        }
        catch (IOException e) {
            this.screen_messages.set_status_message(this.resources.getString("error_5"));
            return false;
        }
        return true;
    }

    public void set_context_sensitive_help(Component p_component, String p_help_id) {
        if (p_component == null) {
            throw new NullPointerException("p_component");
        }
        if (this.help_system_used) {
            if (p_component instanceof JFrame) {
                JRootPane curr_component = ((JFrame)p_component).getRootPane();
            } else {
                Component curr_component = p_component;
            }
            String string = "html_files." + p_help_id;
        }
    }

    public void set_select_toolbar() {
        this.getContentPane().remove(this.toolbar_panel);
        this.getContentPane().add((Component)this.select_toolbar, "North");
        this.repaint();
    }

    public void set_menu_toolbar() {
        this.getContentPane().remove(this.select_toolbar);
        this.getContentPane().add((Component)this.toolbar_panel, "North");
        this.repaint();
    }

    Point absolute_panel_location() {
        int x = this.scroll_pane.getX();
        int y = this.scroll_pane.getY();
        for (Container curr_parent = this.scroll_pane.getParent(); curr_parent != null; curr_parent = curr_parent.getParent()) {
            x += curr_parent.getX();
            y += curr_parent.getY();
        }
        return new Point(x, y);
    }

    public void zoom_all() {
        this.board_panel.board_handling.adjust_design_bounds();
        Rectangle display_rect = this.board_panel.get_viewport_bounds();
        Rectangle design_bounds = this.board_panel.board_handling.graphics_context.get_design_bounds();
        double width_factor = display_rect.getWidth() / design_bounds.getWidth();
        double height_factor = display_rect.getHeight() / design_bounds.getHeight();
        double zoom_factor = Math.min(width_factor, height_factor);
        Point2D zoom_center = this.board_panel.board_handling.graphics_context.get_design_center();
        this.board_panel.zoom(zoom_factor, zoom_center);
        Point2D new_vieport_center = this.board_panel.board_handling.graphics_context.get_design_center();
        this.board_panel.set_viewport_center(new_vieport_center);
    }

    @Override
    public void dispose() {
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            if (this.permanent_subwindows[i] == null) continue;
            this.permanent_subwindows[i].dispose();
            this.permanent_subwindows[i] = null;
        }
        for (BoardTemporarySubWindow curr_subwindow : this.temporary_subwindows) {
            if (curr_subwindow == null) continue;
            curr_subwindow.board_frame_disposed();
        }
        if (this.board_panel.board_handling != null) {
            this.board_panel.board_handling.dispose();
            this.board_panel.board_handling = null;
        }
        super.dispose();
    }

    private void allocate_permanent_subwindows() {
        this.color_manager = new ColorManager(this);
        this.permanent_subwindows[0] = this.color_manager;
        this.object_visibility_window = WindowObjectVisibility.get_instance(this);
        this.permanent_subwindows[1] = this.object_visibility_window;
        this.layer_visibility_window = WindowLayerVisibility.get_instance(this);
        this.permanent_subwindows[2] = this.layer_visibility_window;
        this.display_misc_window = new WindowDisplayMisc(this);
        this.permanent_subwindows[3] = this.display_misc_window;
        this.snapshot_window = new WindowSnapshot(this);
        this.permanent_subwindows[4] = this.snapshot_window;
        this.route_parameter_window = new WindowRouteParameter(this);
        this.permanent_subwindows[5] = this.route_parameter_window;
        this.select_parameter_window = new WindowSelectParameter(this);
        this.permanent_subwindows[6] = this.select_parameter_window;
        this.clearance_matrix_window = new WindowClearanceMatrix(this);
        this.permanent_subwindows[7] = this.clearance_matrix_window;
        this.padstacks_window = new WindowPadstacks(this);
        this.permanent_subwindows[8] = this.padstacks_window;
        this.packages_window = new WindowPackages(this);
        this.permanent_subwindows[9] = this.packages_window;
        this.components_window = new WindowComponents(this);
        this.permanent_subwindows[10] = this.components_window;
        this.incompletes_window = new WindowIncompletes(this);
        this.permanent_subwindows[11] = this.incompletes_window;
        this.clearance_violations_window = new WindowClearanceViolations(this);
        this.permanent_subwindows[12] = this.clearance_violations_window;
        this.net_info_window = new WindowNets(this);
        this.permanent_subwindows[13] = this.net_info_window;
        this.via_window = new WindowVia(this);
        this.permanent_subwindows[14] = this.via_window;
        this.edit_vias_window = new WindowEditVias(this);
        this.permanent_subwindows[15] = this.edit_vias_window;
        this.edit_net_rules_window = new WindowNetClasses(this);
        this.permanent_subwindows[16] = this.edit_net_rules_window;
        this.assign_net_classes_window = new WindowAssignNetClass(this);
        this.permanent_subwindows[17] = this.assign_net_classes_window;
        this.length_violations_window = new WindowLengthViolations(this);
        this.permanent_subwindows[18] = this.length_violations_window;
        this.about_window = new WindowAbout(this.locale);
        this.permanent_subwindows[19] = this.about_window;
        this.move_parameter_window = new WindowMoveParameter(this);
        this.permanent_subwindows[20] = this.move_parameter_window;
        this.unconnected_route_window = new WindowUnconnectedRoute(this);
        this.permanent_subwindows[21] = this.unconnected_route_window;
        this.route_stubs_window = new WindowRouteStubs(this);
        this.permanent_subwindows[22] = this.route_stubs_window;
        this.autoroute_parameter_window = new WindowAutorouteParameter(this);
        this.permanent_subwindows[23] = this.autoroute_parameter_window;
    }

    private void initialize_windows() {
        this.allocate_permanent_subwindows();
        this.setLocation(120, 0);
        this.select_parameter_window.setLocation(0, 0);
        this.select_parameter_window.setVisible(true);
        this.route_parameter_window.setLocation(0, 100);
        this.autoroute_parameter_window.setLocation(0, 200);
        this.move_parameter_window.setLocation(0, 50);
        this.clearance_matrix_window.setLocation(0, 150);
        this.via_window.setLocation(50, 150);
        this.edit_vias_window.setLocation(100, 150);
        this.edit_net_rules_window.setLocation(100, 200);
        this.assign_net_classes_window.setLocation(100, 250);
        this.padstacks_window.setLocation(100, 30);
        this.packages_window.setLocation(200, 30);
        this.components_window.setLocation(300, 30);
        this.incompletes_window.setLocation(400, 30);
        this.clearance_violations_window.setLocation(500, 30);
        this.length_violations_window.setLocation(550, 30);
        this.net_info_window.setLocation(350, 30);
        this.unconnected_route_window.setLocation(650, 30);
        this.route_stubs_window.setLocation(600, 30);
        this.snapshot_window.setLocation(0, 250);
        this.layer_visibility_window.setLocation(0, 450);
        this.object_visibility_window.setLocation(0, 550);
        this.display_misc_window.setLocation(0, 350);
        this.color_manager.setLocation(0, 600);
        this.about_window.setLocation(200, 200);
    }

    public Locale get_locale() {
        return this.locale;
    }

    public void set_board_background(Color p_color) {
        this.board_panel.setBackground(p_color);
    }

    public void refresh_windows() {
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            if (this.permanent_subwindows[i] == null) continue;
            this.permanent_subwindows[i].refresh();
        }
    }

    public void hilight_selected_button() {
        this.toolbar_panel.hilight_selected_button();
    }

    public void goto_selected_snapshot() {
        if (this.snapshot_window != null) {
            this.snapshot_window.goto_selected();
        }
    }

    public void select_previous_snapshot() {
        if (this.snapshot_window != null) {
            this.snapshot_window.select_previous_item();
        }
    }

    public void select_next_snapshot() {
        if (this.snapshot_window != null) {
            this.snapshot_window.select_next_item();
        }
    }

    public SubwindowSelections get_snapshot_subwindow_selections() {
        SubwindowSelections result = new SubwindowSelections();
        result.incompletes_selection = this.incompletes_window.get_snapshot_info();
        result.packages_selection = this.packages_window.get_snapshot_info();
        result.nets_selection = this.net_info_window.get_snapshot_info();
        result.components_selection = this.components_window.get_snapshot_info();
        result.padstacks_selection = this.padstacks_window.get_snapshot_info();
        return result;
    }

    public void set_snapshot_subwindow_selections(SubwindowSelections p_filters) {
        this.incompletes_window.set_snapshot_info(p_filters.incompletes_selection);
        this.packages_window.set_snapshot_info(p_filters.packages_selection);
        this.net_info_window.set_snapshot_info(p_filters.nets_selection);
        this.components_window.set_snapshot_info(p_filters.components_selection);
        this.padstacks_window.set_snapshot_info(p_filters.padstacks_selection);
    }

    public void repaint_all() {
        this.repaint();
        for (int i = 0; i < this.permanent_subwindows.length; ++i) {
            this.permanent_subwindows[i].repaint();
        }
    }

    public static enum Option {
        FROM_START_MENU,
        SINGLE_FRAME,
        SESSION_FILE,
        WEBSTART,
        EXTENDED_TOOL_BAR;

    }

    private class WindowStateListener
    extends WindowAdapter {
        private WindowStateListener() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            BoardFrame.this.setDefaultCloseOperation(2);
            if (BoardFrame.this.confirm_cancel) {
                int board_confirm_exit_dialog = JOptionPane.showConfirmDialog(null, BoardFrame.this.resources.getString("confirm_cancel"), null, 0);
                if (board_confirm_exit_dialog == 1) {
                    BoardFrame.this.setDefaultCloseOperation(0);
                    FRAnalytics.buttonClicked("board_confirm_exit_dialog_no", BoardFrame.this.resources.getString("confirm_cancel"));
                } else {
                    FRAnalytics.appClosed();
                }
            }
        }

        @Override
        public void windowIconified(WindowEvent evt) {
            for (int i = 0; i < BoardFrame.this.permanent_subwindows.length; ++i) {
                BoardFrame.this.permanent_subwindows[i].parent_iconified();
            }
            for (BoardSubWindow boardSubWindow : BoardFrame.this.temporary_subwindows) {
                if (boardSubWindow == null) continue;
                boardSubWindow.parent_iconified();
            }
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
            for (int i = 0; i < BoardFrame.this.permanent_subwindows.length; ++i) {
                if (BoardFrame.this.permanent_subwindows[i] == null) continue;
                BoardFrame.this.permanent_subwindows[i].parent_deiconified();
            }
            for (BoardSubWindow boardSubWindow : BoardFrame.this.temporary_subwindows) {
                if (boardSubWindow == null) continue;
                boardSubWindow.parent_deiconified();
            }
        }
    }

    public static class SubwindowSelections
    implements Serializable {
        private WindowObjectListWithFilter.SnapshotInfo incompletes_selection;
        private WindowObjectListWithFilter.SnapshotInfo packages_selection;
        private WindowObjectListWithFilter.SnapshotInfo nets_selection;
        private WindowObjectListWithFilter.SnapshotInfo components_selection;
        private WindowObjectListWithFilter.SnapshotInfo padstacks_selection;
    }
}

