/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.datastructures.Signum;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.IntVector;
import app.freerouting.geometry.planar.Limits;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.RationalPoint;
import app.freerouting.geometry.planar.RationalVector;
import app.freerouting.geometry.planar.Side;
import java.io.Serializable;
import java.math.BigInteger;

public abstract class Vector
implements Serializable {
    public static final IntVector ZERO = new IntVector(0, 0);

    public static Vector get_instance(int p_x, int p_y) {
        IntVector result = new IntVector(p_x, p_y);
        if (Math.abs(p_x) > 0x2000000 || Math.abs(p_y) > 0x2000000) {
            return new RationalVector(result);
        }
        return result;
    }

    public static Vector get_instance(BigInteger p_x, BigInteger p_y, BigInteger p_z) {
        if (p_z.signum() < 0) {
            p_x = p_x.negate();
            p_y = p_y.negate();
            p_z = p_z.negate();
        }
        if (p_x.mod(p_z).signum() == 0 && p_x.mod(p_z).signum() == 0) {
            p_x = p_x.divide(p_z);
            p_y = p_y.divide(p_z);
            p_z = BigInteger.ONE;
        }
        if (p_z.equals(BigInteger.ONE) && p_x.abs().compareTo(Limits.CRIT_INT_BIG) <= 0 && p_y.abs().compareTo(Limits.CRIT_INT_BIG) <= 0) {
            return new IntVector(p_x.intValue(), p_y.intValue());
        }
        return new RationalVector(p_x, p_y, p_z);
    }

    public abstract boolean is_zero();

    public abstract Vector negate();

    public abstract Vector add(Vector var1);

    public abstract Side side_of(Vector var1);

    public abstract boolean is_orthogonal();

    public abstract boolean is_diagonal();

    public boolean is_multiple_of_45_degree() {
        return this.is_orthogonal() || this.is_diagonal();
    }

    public abstract Signum projection(Vector var1);

    public abstract double scalar_product(Vector var1);

    public abstract FloatPoint to_float();

    public abstract Vector turn_90_degree(int var1);

    public abstract Vector mirror_at_x_axis();

    public abstract Vector mirror_at_y_axis();

    public double length_approx() {
        return this.to_float().size();
    }

    public double cos_angle(Vector p_other) {
        double result = this.scalar_product(p_other);
        return result /= this.to_float().size() * p_other.to_float().size();
    }

    public double angle_approx(Vector p_other) {
        double result = Math.acos(this.cos_angle(p_other));
        if (this.side_of(p_other) == Side.ON_THE_LEFT) {
            result = -result;
        }
        return result;
    }

    public double angle_approx() {
        IntVector other = new IntVector(1, 0);
        return other.angle_approx(this);
    }

    public abstract Vector change_length_approx(double var1);

    abstract Direction to_normalized_direction();

    abstract Vector add(IntVector var1);

    abstract Vector add(RationalVector var1);

    abstract Point add_to(IntPoint var1);

    abstract Point add_to(RationalPoint var1);

    abstract Side side_of(IntVector var1);

    abstract Side side_of(RationalVector var1);

    abstract Signum projection(IntVector var1);

    abstract Signum projection(RationalVector var1);

    abstract double scalar_product(IntVector var1);

    abstract double scalar_product(RationalVector var1);
}

