/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.datastructures.Signum;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.IntVector;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.RationalPoint;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.math.BigInteger;

public class Line
implements Comparable<Line>,
Serializable {
    public final Point a;
    public final Point b;
    private transient Direction dir;

    public Line(Point p_a, Point p_b) {
        this.a = p_a;
        this.b = p_b;
        this.dir = null;
        if (!(this.a instanceof IntPoint) || !(this.b instanceof IntPoint)) {
            FRLogger.warn("Line(p_a, p_b) only implemented for IntPoints till now");
        }
    }

    public Line(int p_a_x, int p_a_y, int p_b_x, int p_b_y) {
        this.a = new IntPoint(p_a_x, p_a_y);
        this.b = new IntPoint(p_b_x, p_b_y);
        this.dir = null;
    }

    public Line(Point p_a, Direction p_dir) {
        this.a = p_a;
        this.b = p_a.translate_by(p_dir.get_vector());
        this.dir = p_dir;
        if (!(this.a instanceof IntPoint) || !(this.b instanceof IntPoint)) {
            FRLogger.warn("Line(p_a, p_dir) only implemented for IntPoints till now");
        }
    }

    public static Line get_instance(Point p_a, Direction p_dir) {
        Point b = p_a.translate_by(p_dir.get_vector());
        return new Line(p_a, b);
    }

    public final boolean equals(Object p_ob) {
        if (this == p_ob) {
            return true;
        }
        if (p_ob == null) {
            return false;
        }
        if (!(p_ob instanceof Line)) {
            return false;
        }
        Line other = (Line)p_ob;
        if (this.side_of(other.a) != Side.COLLINEAR) {
            return false;
        }
        return this.direction().equals(other.direction());
    }

    public final boolean fast_equals(Line p_other) {
        IntPoint this_a = (IntPoint)this.a;
        IntPoint this_b = (IntPoint)this.b;
        IntPoint other_a = (IntPoint)p_other.a;
        double dx1 = other_a.x - this_a.x;
        double dy2 = this_b.y - this_a.y;
        double dx2 = this_b.x - this_a.x;
        double dy1 = other_a.y - this_a.y;
        double det = dx1 * dy2 - dx2 * dy1;
        if (det != 0.0) {
            return false;
        }
        return this.direction().equals(p_other.direction());
    }

    public Direction direction() {
        if (this.dir == null) {
            Vector d = this.b.difference_by(this.a);
            this.dir = Direction.get_instance(d);
        }
        return this.dir;
    }

    public Side side_of(Point p_point) {
        Side result = p_point.side_of(this);
        return result.negate();
    }

    public Side side_of(FloatPoint p_point, double p_tolerance) {
        IntPoint this_a = (IntPoint)this.a;
        IntPoint this_b = (IntPoint)this.b;
        double det = (double)(this_b.y - this_a.y) * (p_point.x - (double)this_a.x) - (double)(this_b.x - this_a.x) * (p_point.y - (double)this_a.y);
        Side result = det - p_tolerance > 0.0 ? Side.ON_THE_LEFT : (det + p_tolerance < 0.0 ? Side.ON_THE_RIGHT : Side.COLLINEAR);
        return result;
    }

    public Side side_of(FloatPoint p_point) {
        return this.side_of(p_point, 0.0);
    }

    public Side side_of_intersection(Line p_1, Line p_2) {
        FloatPoint intersection_approx = p_1.intersection_approx(p_2);
        Side result = this.side_of(intersection_approx, 1.0);
        if (result == Side.COLLINEAR) {
            Point intersection = p_1.intersection(p_2);
            result = this.side_of(intersection);
        }
        return result;
    }

    public boolean is_on_the_left(TileShape p_tile) {
        for (int i = 0; i < p_tile.border_line_count(); ++i) {
            if (this.side_of(p_tile.corner(i)) != Side.ON_THE_RIGHT) continue;
            return false;
        }
        return true;
    }

    public boolean is_on_the_right(TileShape p_tile) {
        for (int i = 0; i < p_tile.border_line_count(); ++i) {
            if (this.side_of(p_tile.corner(i)) != Side.ON_THE_LEFT) continue;
            return false;
        }
        return true;
    }

    public double signed_distance(FloatPoint p_point) {
        IntPoint this_a = (IntPoint)this.a;
        IntPoint this_b = (IntPoint)this.b;
        double dx = this_b.x - this_a.x;
        double dy = this_b.y - this_a.y;
        double det = dy * (p_point.x - (double)this_a.x) - dx * (p_point.y - (double)this_a.y);
        double length = Math.sqrt(dx * dx + dy * dy);
        return det / length;
    }

    public boolean overlaps(Line p_other) {
        return this.side_of(p_other.a) == Side.COLLINEAR && this.side_of(p_other.b) == Side.COLLINEAR;
    }

    public Line opposite() {
        return new Line(this.b, this.a);
    }

    public Point intersection(Line p_other) {
        IntVector delta_1 = (IntVector)this.b.difference_by(this.a);
        IntVector delta_2 = (IntVector)p_other.b.difference_by(p_other.a);
        if (delta_1.x == 0) {
            if (delta_2.y == 0) {
                return new IntPoint(((IntPoint)this.a).x, ((IntPoint)p_other.a).y);
            }
            if (delta_2.x == delta_2.y) {
                int this_x = ((IntPoint)this.a).x;
                IntPoint other_a = (IntPoint)p_other.a;
                return new IntPoint(this_x, other_a.y + this_x - other_a.x);
            }
            if (delta_2.x == -delta_2.y) {
                int this_x = ((IntPoint)this.a).x;
                IntPoint other_a = (IntPoint)p_other.a;
                return new IntPoint(this_x, other_a.y + other_a.x - this_x);
            }
        } else if (delta_1.y == 0) {
            if (delta_2.x == 0) {
                return new IntPoint(((IntPoint)p_other.a).x, ((IntPoint)this.a).y);
            }
            if (delta_2.x == delta_2.y) {
                int this_y = ((IntPoint)this.a).y;
                IntPoint other_a = (IntPoint)p_other.a;
                return new IntPoint(other_a.x + this_y - other_a.y, this_y);
            }
            if (delta_2.x == -delta_2.y) {
                int this_y = ((IntPoint)this.a).y;
                IntPoint other_a = (IntPoint)p_other.a;
                return new IntPoint(other_a.x + other_a.y - this_y, this_y);
            }
        } else if (delta_1.x == delta_1.y) {
            if (delta_2.x == 0) {
                int other_x = ((IntPoint)p_other.a).x;
                IntPoint this_a = (IntPoint)this.a;
                return new IntPoint(other_x, this_a.y + other_x - this_a.x);
            }
            if (delta_2.y == 0) {
                int other_y = ((IntPoint)p_other.a).y;
                IntPoint this_a = (IntPoint)this.a;
                return new IntPoint(this_a.x + other_y - this_a.y, other_y);
            }
        } else if (delta_1.x == -delta_1.y) {
            if (delta_2.x == 0) {
                int other_x = ((IntPoint)p_other.a).x;
                IntPoint this_a = (IntPoint)this.a;
                return new IntPoint(other_x, this_a.y + this_a.x - other_x);
            }
            if (delta_2.y == 0) {
                int other_y = ((IntPoint)p_other.a).y;
                IntPoint this_a = (IntPoint)this.a;
                return new IntPoint(this_a.x + this_a.y - other_y, other_y);
            }
        }
        BigInteger det_1 = BigInteger.valueOf(((IntPoint)this.a).determinant((IntPoint)this.b));
        BigInteger det_2 = BigInteger.valueOf(((IntPoint)p_other.a).determinant((IntPoint)p_other.b));
        BigInteger det = BigInteger.valueOf(delta_2.determinant(delta_1));
        BigInteger tmp_1 = det_1.multiply(BigInteger.valueOf(delta_2.x));
        BigInteger tmp_2 = det_2.multiply(BigInteger.valueOf(delta_1.x));
        BigInteger is_x = tmp_1.subtract(tmp_2);
        tmp_1 = det_1.multiply(BigInteger.valueOf(delta_2.y));
        tmp_2 = det_2.multiply(BigInteger.valueOf(delta_1.y));
        BigInteger is_y = tmp_1.subtract(tmp_2);
        int signum = det.signum();
        if (signum != 0) {
            if (signum < 0) {
                det = det.negate();
                is_x = is_x.negate();
                is_y = is_y.negate();
            }
            if (is_x.mod(det).signum() == 0 && is_y.mod(det).signum() == 0) {
                is_x = is_x.divide(det);
                is_y = is_y.divide(det);
                if (Math.abs(is_x.doubleValue()) <= 3.3554432E7 && Math.abs(is_y.doubleValue()) <= 3.3554432E7) {
                    return new IntPoint(is_x.intValue(), is_y.intValue());
                }
                det = BigInteger.ONE;
            }
        }
        return new RationalPoint(is_x, is_y, det);
    }

    public FloatPoint intersection_approx(Line p_other) {
        double is_y;
        double is_x;
        IntPoint this_a = (IntPoint)this.a;
        IntPoint this_b = (IntPoint)this.b;
        IntPoint other_a = (IntPoint)p_other.a;
        IntPoint other_b = (IntPoint)p_other.b;
        double d1x = this_b.x - this_a.x;
        double d1y = this_b.y - this_a.y;
        double d2x = other_b.x - other_a.x;
        double d2y = other_b.y - other_a.y;
        double det_1 = (double)this_a.x * (double)this_b.y - (double)this_a.y * (double)this_b.x;
        double det_2 = (double)other_a.x * (double)other_b.y - (double)other_a.y * (double)other_b.x;
        double det = d2x * d1y - d2y * d1x;
        if (det == 0.0) {
            is_x = 2.147483647E9;
            is_y = 2.147483647E9;
        } else {
            is_x = (d2x * det_1 - d1x * det_2) / det;
            is_y = (d2y * det_1 - d1y * det_2) / det;
        }
        return new FloatPoint(is_x, is_y);
    }

    public Point perpendicular_projection(Point p_point) {
        return p_point.perpendicular_projection(this);
    }

    public Line translate(double p_dist) {
        IntPoint new_a;
        IntPoint ai = (IntPoint)this.a;
        IntVector v = (IntVector)this.direction().get_vector();
        double vxvx = (double)v.x * (double)v.x;
        double vyvy = (double)v.y * (double)v.y;
        double length = Math.sqrt(vxvx + vyvy);
        if (vxvx <= vyvy) {
            int rel_x = (int)Math.round(p_dist * length / (double)v.y);
            new_a = new IntPoint(ai.x - rel_x, ai.y);
        } else {
            int rel_y = (int)Math.round(p_dist * length / (double)v.x);
            new_a = new IntPoint(ai.x, ai.y + rel_y);
        }
        return Line.get_instance(new_a, this.direction());
    }

    public Line translate_by(Vector p_vector) {
        if (p_vector.equals(Vector.ZERO)) {
            return this;
        }
        Point new_a = this.a.translate_by(p_vector);
        Point new_b = this.b.translate_by(p_vector);
        return new Line(new_a, new_b);
    }

    public boolean is_orthogonal() {
        return this.direction().is_orthogonal();
    }

    public boolean is_diagonal() {
        return this.direction().is_diagonal();
    }

    public boolean is_multiple_of_45_degree() {
        return this.direction().is_multiple_of_45_degree();
    }

    public boolean is_parallel(Line p_other) {
        return this.direction().side_of(p_other.direction()) == Side.COLLINEAR;
    }

    public boolean is_perpendicular(Line p_other) {
        Vector v2;
        Vector v1 = this.direction().get_vector();
        return v1.projection(v2 = p_other.direction().get_vector()) == Signum.ZERO;
    }

    public boolean is_equal_or_opposite(Line p_other) {
        return this.side_of(p_other.a) == Side.COLLINEAR && this.side_of(p_other.b) == Side.COLLINEAR;
    }

    public double cos_angle(Line p_other) {
        Vector v1 = this.b.difference_by(this.a);
        Vector v2 = p_other.b.difference_by(p_other.a);
        return v1.cos_angle(v2);
    }

    @Override
    public int compareTo(Line p_other) {
        IntPoint this_a = (IntPoint)this.a;
        IntPoint this_b = (IntPoint)this.b;
        IntPoint other_a = (IntPoint)p_other.a;
        IntPoint other_b = (IntPoint)p_other.b;
        int dx1 = this_b.x - this_a.x;
        int dy1 = this_b.y - this_a.y;
        int dx2 = other_b.x - other_a.x;
        int dy2 = other_b.y - other_a.y;
        if (dy1 > 0) {
            if (dy2 < 0) {
                return -1;
            }
            if (dy2 == 0) {
                if (dx2 > 0) {
                    return 1;
                }
                return -1;
            }
        } else if (dy1 < 0) {
            if (dy2 >= 0) {
                return 1;
            }
        } else {
            if (dx1 > 0) {
                if (dy2 != 0 || dx2 < 0) {
                    return -1;
                }
                return 0;
            }
            if (dy2 > 0 || dy2 == 0 && dx2 > 0) {
                return 1;
            }
            if (dy2 < 0) {
                return -1;
            }
            return 0;
        }
        double determinant = (double)dx2 * (double)dy1 - (double)dy2 * (double)dx1;
        return Signum.as_int(determinant);
    }

    public double function_value_approx(double p_x) {
        FloatPoint p1 = this.a.to_float();
        FloatPoint p2 = this.b.to_float();
        double dx = p2.x - p1.x;
        if (dx == 0.0) {
            FRLogger.warn("function_value_approx: line is vertical");
            return 0.0;
        }
        double dy = p2.y - p1.y;
        double det = p1.x * p2.y - p2.x * p1.y;
        return (dy * p_x - det) / dx;
    }

    public double function_in_y_value_approx(double p_y) {
        FloatPoint p1 = this.a.to_float();
        FloatPoint p2 = this.b.to_float();
        double dy = p2.y - p1.y;
        if (dy == 0.0) {
            FRLogger.warn("function_in_y_value_approx: line is horizontal");
            return 0.0;
        }
        double dx = p2.x - p1.x;
        double det = p1.x * p2.y - p2.x * p1.y;
        return (dx * p_y + det) / dy;
    }

    public Direction perpendicular_direction(Point p_from_point) {
        Side line_side = this.side_of(p_from_point);
        if (line_side == Side.COLLINEAR) {
            return null;
        }
        Direction dir1 = this.direction().turn_45_degree(2);
        Direction dir2 = this.direction().turn_45_degree(6);
        Point check_point_1 = p_from_point.translate_by(dir1.get_vector());
        if (this.side_of(check_point_1) != line_side) {
            return dir1;
        }
        Point check_point_2 = p_from_point.translate_by(dir2.get_vector());
        if (this.side_of(check_point_2) != line_side) {
            return dir2;
        }
        FloatPoint nearest_line_point = p_from_point.to_float().projection_approx(this);
        Direction result = nearest_line_point.distance_square(check_point_1.to_float()) <= nearest_line_point.distance_square(check_point_2.to_float()) ? dir1 : dir2;
        return result;
    }

    public Line turn_90_degree(int p_factor, IntPoint p_pole) {
        Point new_a = this.a.turn_90_degree(p_factor, p_pole);
        Point new_b = this.b.turn_90_degree(p_factor, p_pole);
        return new Line(new_a, new_b);
    }

    public Line mirror_vertical(IntPoint p_pole) {
        Point new_a = this.b.mirror_vertical(p_pole);
        Point new_b = this.a.mirror_vertical(p_pole);
        return new Line(new_a, new_b);
    }

    public Line mirror_horizontal(IntPoint p_pole) {
        Point new_a = this.b.mirror_horizontal(p_pole);
        Point new_b = this.a.mirror_horizontal(p_pole);
        return new Line(new_a, new_b);
    }
}

