/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.datastructures.BigIntAux;
import app.freerouting.datastructures.Signum;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntDirection;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.RationalPoint;
import app.freerouting.geometry.planar.RationalVector;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.Vector;
import java.io.Serializable;

public class IntVector
extends Vector
implements Serializable {
    public final int x;
    public final int y;

    public IntVector(int p_x, int p_y) {
        this.x = p_x;
        this.y = p_y;
    }

    public final boolean equals(Object p_ob) {
        if (this == p_ob) {
            return true;
        }
        if (p_ob == null) {
            return false;
        }
        if (this.getClass() != p_ob.getClass()) {
            return false;
        }
        IntVector other = (IntVector)p_ob;
        return this.x == other.x && this.y == other.y;
    }

    @Override
    public final boolean is_zero() {
        return this.x == 0 && this.y == 0;
    }

    @Override
    public Vector negate() {
        return new IntVector(-this.x, -this.y);
    }

    @Override
    public boolean is_orthogonal() {
        return this.x == 0 || this.y == 0;
    }

    @Override
    public boolean is_diagonal() {
        return Math.abs(this.x) == Math.abs(this.y);
    }

    public final long determinant(IntVector p_other) {
        return (long)this.x * (long)p_other.y - (long)this.y * (long)p_other.x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Vector turn_90_degree(int p_factor) {
        int new_y;
        int new_x;
        int n;
        for (n = p_factor; n < 0; n += 4) {
        }
        while (n >= 4) {
            n -= 4;
        }
        switch (n) {
            case 0: {
                new_x = this.x;
                new_y = this.y;
                return new IntVector(new_x, new_y);
            }
            case 1: {
                new_x = -this.y;
                new_y = this.x;
                return new IntVector(new_x, new_y);
            }
            case 2: {
                new_x = -this.x;
                new_y = -this.y;
                return new IntVector(new_x, new_y);
            }
            case 3: {
                new_x = this.y;
                new_y = -this.x;
                return new IntVector(new_x, new_y);
            }
            default: {
                new_x = 0;
                new_y = 0;
            }
        }
        return new IntVector(new_x, new_y);
    }

    @Override
    public Vector mirror_at_y_axis() {
        return new IntVector(-this.x, this.y);
    }

    @Override
    public Vector mirror_at_x_axis() {
        return new IntVector(this.x, -this.y);
    }

    @Override
    public final Vector add(Vector p_other) {
        return p_other.add(this);
    }

    @Override
    final Vector add(IntVector p_other) {
        return new IntVector(this.x + p_other.x, this.y + p_other.y);
    }

    @Override
    final Vector add(RationalVector p_other) {
        return p_other.add(this);
    }

    @Override
    final Point add_to(IntPoint p_point) {
        return new IntPoint(p_point.x + this.x, p_point.y + this.y);
    }

    @Override
    final Point add_to(RationalPoint p_point) {
        return p_point.translate_by(this);
    }

    @Override
    public Side side_of(Vector p_other) {
        Side tmp = p_other.side_of(this);
        return tmp.negate();
    }

    @Override
    Side side_of(IntVector p_other) {
        double determinant = (double)p_other.x * (double)this.y - (double)p_other.y * (double)this.x;
        return Side.of(determinant);
    }

    @Override
    Side side_of(RationalVector p_other) {
        Side tmp = p_other.side_of(this);
        return tmp.negate();
    }

    @Override
    public Signum projection(Vector p_other) {
        return p_other.projection(this);
    }

    @Override
    public double scalar_product(Vector p_other) {
        return p_other.scalar_product(this);
    }

    @Override
    public FloatPoint to_float() {
        return new FloatPoint(this.x, this.y);
    }

    @Override
    public Vector change_length_approx(double p_length) {
        FloatPoint new_point = this.to_float().change_size(p_length);
        return new_point.round().difference_by(Point.ZERO);
    }

    @Override
    Direction to_normalized_direction() {
        int dx = this.x;
        int dy = this.y;
        int gcd = BigIntAux.binaryGcd(Math.abs(dx), Math.abs(dy));
        if (gcd > 1) {
            dx /= gcd;
            dy /= gcd;
        }
        return new IntDirection(dx, dy);
    }

    @Override
    Signum projection(IntVector p_other) {
        double tmp = (double)this.x * (double)p_other.x + (double)this.y * (double)p_other.y;
        return Signum.of(tmp);
    }

    @Override
    double scalar_product(IntVector p_other) {
        return (double)this.x * (double)p_other.x + (double)this.y * (double)p_other.y;
    }

    @Override
    double scalar_product(RationalVector p_other) {
        return p_other.scalar_product(this);
    }

    @Override
    Signum projection(RationalVector p_other) {
        return p_other.projection(this);
    }
}

