/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Side;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;

public class FloatPoint
implements Serializable {
    public static final FloatPoint ZERO = new FloatPoint(0.0, 0.0);
    public final double x;
    public final double y;

    public FloatPoint(double p_x, double p_y) {
        this.x = p_x;
        this.y = p_y;
    }

    public FloatPoint(IntPoint p_pt) {
        this.x = p_pt.x;
        this.y = p_pt.y;
    }

    public static IntOctagon bounding_octagon(FloatPoint[] p_point_arr) {
        double lx = 2.147483647E9;
        double ly = 2.147483647E9;
        double rx = -2.147483648E9;
        double uy = -2.147483648E9;
        double ulx = 2.147483647E9;
        double lrx = -2.147483648E9;
        double llx = 2.147483647E9;
        double urx = -2.147483648E9;
        for (int i = 0; i < p_point_arr.length; ++i) {
            FloatPoint curr = p_point_arr[i];
            lx = Math.min(lx, curr.x);
            ly = Math.min(ly, curr.y);
            rx = Math.max(rx, curr.x);
            uy = Math.max(uy, curr.y);
            double tmp = curr.x - curr.y;
            ulx = Math.min(ulx, tmp);
            lrx = Math.max(lrx, tmp);
            tmp = curr.x + curr.y;
            llx = Math.min(llx, tmp);
            urx = Math.max(urx, tmp);
        }
        IntOctagon surrounding_octagon = new IntOctagon((int)Math.floor(lx), (int)Math.floor(ly), (int)Math.ceil(rx), (int)Math.ceil(uy), (int)Math.floor(ulx), (int)Math.ceil(lrx), (int)Math.floor(llx), (int)Math.ceil(urx));
        return surrounding_octagon;
    }

    public final double size_square() {
        return this.x * this.x + this.y * this.y;
    }

    public final double size() {
        return Math.sqrt(this.size_square());
    }

    public final double distance_square(FloatPoint p_other) {
        double dx = p_other.x - this.x;
        double dy = p_other.y - this.y;
        return dx * dx + dy * dy;
    }

    public final double distance(FloatPoint p_other) {
        return Math.sqrt(this.distance_square(p_other));
    }

    public double weighted_distance(FloatPoint p_other, double p_horizontal_weight, double p_vertical_weight) {
        double delta_x = this.x - p_other.x;
        double delta_y = this.y - p_other.y;
        return Math.sqrt((delta_x *= p_horizontal_weight) * delta_x + (delta_y *= p_vertical_weight) * delta_y);
    }

    public IntPoint round() {
        return new IntPoint((int)Math.round(this.x), (int)Math.round(this.y));
    }

    public IntPoint round_to_the_right(Direction p_dir) {
        FloatPoint dir = p_dir.get_vector().to_float();
        int rounded_x = dir.y > 0.0 ? (int)Math.ceil(this.x) : (dir.y < 0.0 ? (int)Math.floor(this.x) : (int)Math.round(this.x));
        int rounded_y = dir.x > 0.0 ? (int)Math.floor(this.y) : (dir.x < 0.0 ? (int)Math.ceil(this.y) : (int)Math.round(this.y));
        return new IntPoint(rounded_x, rounded_y);
    }

    public IntPoint round_to_grid(int p_horizontal_grid, int p_vertical_grid) {
        double rounded_x = p_horizontal_grid > 0 ? Math.rint(this.x / (double)p_horizontal_grid) * (double)p_horizontal_grid : this.x;
        double rounded_y = p_vertical_grid > 0 ? Math.rint(this.y / (double)p_vertical_grid) * (double)p_vertical_grid : this.y;
        return new IntPoint((int)rounded_x, (int)rounded_y);
    }

    public IntPoint round_to_the_left(Direction p_dir) {
        FloatPoint dir = p_dir.get_vector().to_float();
        int rounded_x = dir.y > 0.0 ? (int)Math.floor(this.x) : (dir.y < 0.0 ? (int)Math.ceil(this.x) : (int)Math.round(this.x));
        int rounded_y = dir.x > 0.0 ? (int)Math.ceil(this.y) : (dir.x < 0.0 ? (int)Math.floor(this.y) : (int)Math.round(this.y));
        return new IntPoint(rounded_x, rounded_y);
    }

    public FloatPoint add(FloatPoint p_other) {
        return new FloatPoint(this.x + p_other.x, this.y + p_other.y);
    }

    public FloatPoint substract(FloatPoint p_other) {
        return new FloatPoint(this.x - p_other.x, this.y - p_other.y);
    }

    public FloatPoint projection_approx(Line p_line) {
        FloatLine line = new FloatLine(p_line.a.to_float(), p_line.b.to_float());
        return line.perpendicular_projection(this);
    }

    public double scalar_product(FloatPoint p_1, FloatPoint p_2) {
        if (p_1 == null || p_2 == null) {
            FRLogger.warn("FloatPoint.scalar_product: parameter point is null");
            return 0.0;
        }
        double dx_1 = p_1.x - this.x;
        double dx_2 = p_2.x - this.x;
        double dy_1 = p_1.y - this.y;
        double dy_2 = p_2.y - this.y;
        return dx_1 * dx_2 + dy_1 * dy_2;
    }

    public FloatPoint change_size(double p_new_size) {
        if (this.x == 0.0 && this.y == 0.0) {
            return this;
        }
        double length = Math.sqrt(this.x * this.x + this.y * this.y);
        double new_x = this.x * p_new_size / length;
        double new_y = this.y * p_new_size / length;
        return new FloatPoint(new_x, new_y);
    }

    public FloatPoint change_length(FloatPoint p_to_point, double p_new_length) {
        double dx = p_to_point.x - this.x;
        double dy = p_to_point.y - this.y;
        if (dx == 0.0 && dy == 0.0) {
            FRLogger.warn("IntPoint.change_length: Points are equal");
            return p_to_point;
        }
        double length = Math.sqrt(dx * dx + dy * dy);
        double new_x = this.x + dx * p_new_length / length;
        double new_y = this.y + dy * p_new_length / length;
        return new FloatPoint(new_x, new_y);
    }

    public FloatPoint middle_point(FloatPoint p_to_point) {
        if (p_to_point == this) {
            return this;
        }
        double middle_x = 0.5 * (this.x + p_to_point.x);
        double middle_y = 0.5 * (this.y + p_to_point.y);
        return new FloatPoint(middle_x, middle_y);
    }

    public Side side_of(FloatPoint p_1, FloatPoint p_2) {
        double d21_x = p_2.x - p_1.x;
        double d21_y = p_2.y - p_1.y;
        double d01_x = this.x - p_1.x;
        double d01_y = this.y - p_1.y;
        double determinant = d21_x * d01_y - d21_y * d01_x;
        return Side.of(determinant);
    }

    public FloatPoint rotate(double p_angle, FloatPoint p_pole) {
        if (p_angle == 0.0) {
            return this;
        }
        double dx = this.x - p_pole.x;
        double dy = this.y - p_pole.y;
        double sin_angle = Math.sin(p_angle);
        double cos_angle = Math.cos(p_angle);
        double new_dx = dx * cos_angle - dy * sin_angle;
        double new_dy = dx * sin_angle + dy * cos_angle;
        return new FloatPoint(p_pole.x + new_dx, p_pole.y + new_dy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FloatPoint turn_90_degree(int p_factor) {
        double new_y;
        double new_x;
        int n;
        for (n = p_factor; n < 0; n += 4) {
        }
        while (n >= 4) {
            n -= 4;
        }
        switch (n) {
            case 0: {
                new_x = this.x;
                new_y = this.y;
                return new FloatPoint(new_x, new_y);
            }
            case 1: {
                new_x = -this.y;
                new_y = this.x;
                return new FloatPoint(new_x, new_y);
            }
            case 2: {
                new_x = -this.x;
                new_y = -this.y;
                return new FloatPoint(new_x, new_y);
            }
            case 3: {
                new_x = this.y;
                new_y = -this.x;
                return new FloatPoint(new_x, new_y);
            }
            default: {
                new_x = 0.0;
                new_y = 0.0;
            }
        }
        return new FloatPoint(new_x, new_y);
    }

    public FloatPoint turn_90_degree(int p_factor, FloatPoint p_pole) {
        FloatPoint v = this.substract(p_pole);
        v = v.turn_90_degree(p_factor);
        return p_pole.add(v);
    }

    public boolean is_contained_in_box(FloatPoint p_1, FloatPoint p_2, double p_tolerance) {
        double max_y;
        double min_y;
        double max_x;
        double min_x;
        if (p_1.x < p_2.x) {
            min_x = p_1.x;
            max_x = p_2.x;
        } else {
            min_x = p_2.x;
            max_x = p_1.x;
        }
        if (this.x < min_x - p_tolerance || this.x > max_x + p_tolerance) {
            return false;
        }
        if (p_1.y < p_2.y) {
            min_y = p_1.y;
            max_y = p_2.y;
        } else {
            min_y = p_2.y;
            max_y = p_1.y;
        }
        return this.y >= min_y - p_tolerance && this.y <= max_y + p_tolerance;
    }

    public IntBox bounding_box() {
        IntPoint lower_left = new IntPoint((int)Math.floor(this.x), (int)Math.floor(this.y));
        IntPoint upper_right = new IntPoint((int)Math.ceil(this.x), (int)Math.ceil(this.y));
        return new IntBox(lower_left, upper_right);
    }

    public FloatPoint[] tangential_points(FloatPoint p_to_point, double p_distance) {
        FloatPoint circle_center;
        FloatPoint pole;
        boolean situation_turned;
        double dx = Math.abs(this.x - p_to_point.x);
        double dy = Math.abs(this.y - p_to_point.y);
        boolean bl = situation_turned = dy > dx;
        if (situation_turned) {
            pole = new FloatPoint(-this.y, this.x);
            circle_center = new FloatPoint(-p_to_point.y, p_to_point.x);
        } else {
            pole = this;
            circle_center = p_to_point;
        }
        dx = pole.x - circle_center.x;
        dy = pole.y - circle_center.y;
        double dx_square = dx * dx;
        double dy_square = dy * dy;
        double dist_square = dx_square + dy_square;
        double radius_square = p_distance * p_distance;
        double discriminant = radius_square * dy_square - (radius_square - dx_square) * dist_square;
        if (discriminant <= 0.0) {
            return new FloatPoint[0];
        }
        double square_root = Math.sqrt(discriminant);
        FloatPoint[] result = new FloatPoint[2];
        double a1 = radius_square * dy;
        double dy1 = (a1 + p_distance * square_root) / dist_square;
        double dy2 = (a1 - p_distance * square_root) / dist_square;
        double first_point_y = dy1 + circle_center.y;
        double first_point_x = (radius_square - dy * dy1) / dx + circle_center.x;
        double second_point_y = dy2 + circle_center.y;
        double second_point_x = (radius_square - dy * dy2) / dx + circle_center.x;
        if (situation_turned) {
            result[0] = new FloatPoint(first_point_y, -first_point_x);
            result[1] = new FloatPoint(second_point_y, -second_point_x);
        } else {
            result[0] = new FloatPoint(first_point_x, first_point_y);
            result[1] = new FloatPoint(second_point_x, second_point_y);
        }
        return result;
    }

    public FloatPoint left_tangential_point(FloatPoint p_to_point, double p_distance) {
        if (p_to_point == null) {
            return null;
        }
        FloatPoint[] tangent_points = this.tangential_points(p_to_point, p_distance);
        if (tangent_points.length < 2) {
            return null;
        }
        FloatPoint result = p_to_point.side_of(this, tangent_points[0]) == Side.ON_THE_RIGHT ? tangent_points[0] : tangent_points[1];
        return result;
    }

    public FloatPoint right_tangential_point(FloatPoint p_to_point, double p_distance) {
        if (p_to_point == null) {
            return null;
        }
        FloatPoint[] tangent_points = this.tangential_points(p_to_point, p_distance);
        if (tangent_points.length < 2) {
            return null;
        }
        FloatPoint result = p_to_point.side_of(this, tangent_points[0]) == Side.ON_THE_LEFT ? tangent_points[0] : tangent_points[1];
        return result;
    }

    public FloatPoint circle_center(FloatPoint p_1, FloatPoint p_2) {
        double slope_1 = (p_1.y - this.y) / (p_1.x - this.x);
        double slope_2 = (p_2.y - p_1.y) / (p_2.x - p_1.x);
        double x_center = (slope_1 * slope_2 * (this.y - p_2.y) + slope_2 * (this.x + p_1.x) - slope_1 * (p_1.x + p_2.x)) / (2.0 * (slope_2 - slope_1));
        double y_center = (0.5 * (this.x + p_1.x) - x_center) / slope_1 + 0.5 * (this.y + p_1.y);
        return new FloatPoint(x_center, y_center);
    }

    public boolean inside_circle(FloatPoint p_1, FloatPoint p_2, FloatPoint p_3) {
        FloatPoint center = p_1.circle_center(p_2, p_3);
        double radius_square = center.distance_square(p_1);
        return this.distance_square(center) < radius_square - 1.0;
    }

    public String to_string(Locale p_locale) {
        NumberFormat nf = NumberFormat.getInstance(p_locale);
        nf.setMaximumFractionDigits(4);
        return "(" + nf.format(this.x) + " , " + nf.format(this.y) + ")";
    }

    public String to_string(Locale p_locale, int fractionDigits, int padding) {
        NumberFormat nf = NumberFormat.getInstance(p_locale);
        nf.setMinimumFractionDigits(fractionDigits);
        nf.setMaximumFractionDigits(fractionDigits);
        return "(" + String.format("%" + padding + "s", nf.format(this.x)) + " , " + String.format("%" + padding + "s", nf.format(this.y)) + ")";
    }

    public String toString() {
        return this.to_string(Locale.ENGLISH);
    }
}

