/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.logger.FRLogger;

public class FloatLine {
    public final FloatPoint a;
    public final FloatPoint b;

    public FloatLine(FloatPoint p_a, FloatPoint p_b) {
        if (p_a == null || p_b == null) {
            FRLogger.warn("FloatLine: Parameter is null");
        }
        this.a = p_a;
        this.b = p_b;
    }

    public FloatLine opposite() {
        return new FloatLine(this.b, this.a);
    }

    public FloatLine adjust_direction(FloatLine p_other) {
        if (this.b.side_of(this.a, p_other.a) == p_other.b.side_of(this.a, p_other.a)) {
            return this;
        }
        return this.opposite();
    }

    public FloatPoint intersection(FloatLine p_other) {
        double d1x = this.b.x - this.a.x;
        double d1y = this.b.y - this.a.y;
        double d2x = p_other.b.x - p_other.a.x;
        double d2y = p_other.b.y - p_other.a.y;
        double det_1 = this.a.x * this.b.y - this.a.y * this.b.x;
        double det_2 = p_other.a.x * p_other.b.y - p_other.a.y * p_other.b.x;
        double det = d2x * d1y - d2y * d1x;
        if (det == 0.0) {
            return null;
        }
        double is_x = (d2x * det_1 - d1x * det_2) / det;
        double is_y = (d2y * det_1 - d1y * det_2) / det;
        return new FloatPoint(is_x, is_y);
    }

    public FloatLine translate(double p_dist) {
        FloatPoint new_a;
        double dx = this.b.x - this.a.x;
        double dy = this.b.y - this.a.y;
        double dxdx = dx * dx;
        double dydy = dy * dy;
        double length = Math.sqrt(dxdx + dydy);
        if (dxdx <= dydy) {
            double rel_x = p_dist * length / dy;
            new_a = new FloatPoint(this.a.x - rel_x, this.a.y);
        } else {
            double rel_y = p_dist * length / dx;
            new_a = new FloatPoint(this.a.x, this.a.y + rel_y);
        }
        FloatPoint new_b = new FloatPoint(new_a.x + dx, new_a.y + dy);
        return new FloatLine(new_a, new_b);
    }

    public double signed_distance(FloatPoint p_point) {
        double dx = this.b.x - this.a.x;
        double dy = this.b.y - this.a.y;
        double det = dy * (p_point.x - this.a.x) - dx * (p_point.y - this.a.y);
        double length = Math.sqrt(dx * dx + dy * dy);
        return det / length;
    }

    public FloatPoint perpendicular_projection(FloatPoint p_point) {
        double dx = this.b.x - this.a.x;
        double dy = this.b.y - this.a.y;
        if (dx == 0.0 && dy == 0.0) {
            return this.a;
        }
        double dxdx = dx * dx;
        double dydy = dy * dy;
        double dxdy = dx * dy;
        double denominator = dxdx + dydy;
        double det = this.a.x * this.b.y - this.b.x * this.a.y;
        double x = (p_point.x * dxdx + p_point.y * dxdy + det * dy) / denominator;
        double y = (p_point.x * dxdy + p_point.y * dydy - det * dx) / denominator;
        return new FloatPoint(x, y);
    }

    public double segment_distance(FloatPoint p_point) {
        FloatPoint projection = this.perpendicular_projection(p_point);
        double result = projection.is_contained_in_box(this.a, this.b, 0.01) ? p_point.distance(projection) : Math.min(p_point.distance(this.a), p_point.distance(this.b));
        return result;
    }

    public FloatLine segment_projection(FloatLine p_line_segment) {
        FloatPoint projected_a;
        if (this.b.scalar_product(this.a, p_line_segment.a) < 0.0) {
            return null;
        }
        if (this.a.scalar_product(this.b, p_line_segment.b) < 0.0) {
            return null;
        }
        if (this.a.scalar_product(this.b, p_line_segment.a) < 0.0) {
            projected_a = this.a;
        } else {
            projected_a = this.perpendicular_projection(p_line_segment.a);
            if (Math.abs(projected_a.x) >= 3.3554432E7 || Math.abs(projected_a.y) >= 3.3554432E7) {
                return null;
            }
        }
        FloatPoint projected_b = this.b.scalar_product(this.a, p_line_segment.b) < 0.0 ? this.b : this.perpendicular_projection(p_line_segment.b);
        if (Math.abs(projected_b.x) >= 3.3554432E7 || Math.abs(projected_b.y) >= 3.3554432E7) {
            return null;
        }
        return new FloatLine(projected_a, projected_b);
    }

    public FloatLine segment_projection_2(FloatLine p_line_segment) {
        FloatPoint projected_b;
        FloatPoint projected_a;
        if (p_line_segment.a.scalar_product(p_line_segment.b, this.b) <= 0.0) {
            return null;
        }
        if (p_line_segment.b.scalar_product(p_line_segment.a, this.a) <= 0.0) {
            return null;
        }
        if (p_line_segment.a.scalar_product(p_line_segment.b, this.a) < 0.0) {
            FloatLine curr_perpendicular_line = new FloatLine(p_line_segment.a, p_line_segment.b.turn_90_degree(1, p_line_segment.a));
            projected_a = curr_perpendicular_line.intersection(this);
            if (projected_a == null || Math.abs(projected_a.x) >= 3.3554432E7 || Math.abs(projected_a.y) >= 3.3554432E7) {
                return null;
            }
        } else {
            projected_a = this.a;
        }
        if (p_line_segment.b.scalar_product(p_line_segment.a, this.b) < 0.0) {
            FloatLine curr_perpendicular_line = new FloatLine(p_line_segment.b, p_line_segment.a.turn_90_degree(1, p_line_segment.b));
            projected_b = curr_perpendicular_line.intersection(this);
            if (projected_b == null || Math.abs(projected_b.x) >= 3.3554432E7 || Math.abs(projected_b.y) >= 3.3554432E7) {
                return null;
            }
        } else {
            projected_b = this.b;
        }
        return new FloatLine(projected_a, projected_b);
    }

    public FloatLine shrink_segment(double p_offset) {
        double dx = this.b.x - this.a.x;
        double dy = this.b.y - this.a.y;
        if (dx == 0.0 && dy == 0.0) {
            return this;
        }
        double length = Math.sqrt(dx * dx + dy * dy);
        double offset = Math.min(p_offset, length / 2.0);
        FloatPoint new_a = new FloatPoint(this.a.x + dx * offset / length, this.a.y + dy * offset / length);
        double new_length = length - offset;
        FloatPoint new_b = new FloatPoint(this.a.x + dx * new_length / length, this.a.y + dy * new_length / length);
        return new FloatLine(new_a, new_b);
    }

    public FloatPoint nearest_segment_point(FloatPoint p_from_point) {
        FloatPoint projection = this.perpendicular_projection(p_from_point);
        if (projection.is_contained_in_box(this.a, this.b, 0.01)) {
            return projection;
        }
        FloatPoint result = p_from_point.distance_square(this.a) <= p_from_point.distance_square(this.b) ? this.a : this.b;
        return result;
    }

    public FloatLine[] divide_segment_into_sections(int p_count) {
        if (p_count == 0) {
            return new FloatLine[0];
        }
        if (p_count == 1) {
            FloatLine[] result = new FloatLine[]{this};
            return result;
        }
        double line_length = this.b.distance(this.a);
        FloatLine[] result = new FloatLine[p_count];
        double section_length = line_length / (double)p_count;
        double dx = this.b.x - this.a.x;
        double dy = this.b.y - this.a.y;
        FloatPoint curr_a = this.a;
        for (int i = 0; i < p_count; ++i) {
            FloatPoint curr_b;
            if (i == p_count - 1) {
                curr_b = this.b;
            } else {
                double curr_b_dist = (double)(i + 1) * section_length;
                double curr_b_x = this.a.x + dx * curr_b_dist / line_length;
                double curr_b_y = this.a.y + dy * curr_b_dist / line_length;
                curr_b = new FloatPoint(curr_b_x, curr_b_y);
            }
            result[i] = new FloatLine(curr_a, curr_b);
            curr_a = curr_b;
        }
        return result;
    }
}

