/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.geometry.planar;

import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.IntDirection;
import app.freerouting.geometry.planar.RationalVector;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.math.BigInteger;

public class BigIntDirection
extends Direction
implements Serializable {
    final BigInteger x;
    final BigInteger y;

    BigIntDirection(BigInteger p_x, BigInteger p_y) {
        this.x = p_x;
        this.y = p_y;
    }

    BigIntDirection(IntDirection p_dir) {
        this.x = BigInteger.valueOf(p_dir.x);
        this.y = BigInteger.valueOf(p_dir.y);
    }

    @Override
    public boolean is_orthogonal() {
        return this.x.signum() == 0 || this.y.signum() == 0;
    }

    @Override
    public boolean is_diagonal() {
        return this.x.abs().equals(this.y.abs());
    }

    @Override
    public Vector get_vector() {
        return new RationalVector(this.x, this.y, BigInteger.ONE);
    }

    @Override
    public Direction turn_45_degree(int p_factor) {
        FRLogger.warn("BigIntDirection: turn_45_degree not yet implemented");
        return this;
    }

    @Override
    public Direction opposite() {
        return new BigIntDirection(this.x.negate(), this.y.negate());
    }

    @Override
    public int compareTo(Direction p_other_direction) {
        return -p_other_direction.compareTo(this);
    }

    @Override
    int compareTo(IntDirection p_other) {
        BigIntDirection other = new BigIntDirection(p_other);
        return this.compareTo(other);
    }

    @Override
    int compareTo(BigIntDirection p_other) {
        int x1 = this.x.signum();
        int y1 = this.y.signum();
        int x2 = p_other.x.signum();
        int y2 = p_other.y.signum();
        if (y1 > 0) {
            if (y2 < 0) {
                return -1;
            }
            if (y2 == 0) {
                if (x2 > 0) {
                    return 1;
                }
                return -1;
            }
        } else if (y1 < 0) {
            if (y2 >= 0) {
                return 1;
            }
        } else {
            if (x1 > 0) {
                if (y2 != 0 || x2 < 0) {
                    return -1;
                }
                return 0;
            }
            if (y2 > 0 || y2 == 0 && x2 > 0) {
                return 1;
            }
            if (y2 < 0) {
                return -1;
            }
            return 0;
        }
        BigInteger tmp_1 = this.y.multiply(p_other.x);
        BigInteger tmp_2 = this.x.multiply(p_other.y);
        BigInteger determinant = tmp_1.subtract(tmp_2);
        return determinant.signum();
    }
}

