/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.datastructures.IdentifierType;
import app.freerouting.datastructures.IndentFileWriter;
import app.freerouting.designforms.specctra.CoordinateTransform;
import app.freerouting.designforms.specctra.Layer;
import app.freerouting.designforms.specctra.Shape;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import java.io.IOException;

public class Rectangle
extends Shape {
    public final double[] coor;

    public Rectangle(Layer p_layer, double[] p_coor) {
        super(p_layer);
        this.coor = p_coor;
    }

    @Override
    public Rectangle bounding_box() {
        return this;
    }

    public Rectangle union(Rectangle p_other) {
        double[] result_coor = new double[]{Math.min(this.coor[0], p_other.coor[0]), Math.min(this.coor[1], p_other.coor[1]), Math.max(this.coor[2], p_other.coor[2]), Math.max(this.coor[3], p_other.coor[3])};
        return new Rectangle(this.layer, result_coor);
    }

    @Override
    public app.freerouting.geometry.planar.Shape transform_to_board_rel(CoordinateTransform p_coordinate_transform) {
        int[] box_coor = new int[4];
        for (int i = 0; i < 4; ++i) {
            box_coor[i] = (int)Math.round(p_coordinate_transform.dsn_to_board(this.coor[i]));
        }
        IntBox result = box_coor[1] <= box_coor[3] ? new IntBox(box_coor[0], box_coor[1], box_coor[2], box_coor[3]) : new IntBox(box_coor[0], box_coor[3], box_coor[2], box_coor[1]);
        return result;
    }

    @Override
    public app.freerouting.geometry.planar.Shape transform_to_board(CoordinateTransform p_coordinate_transform) {
        double[] curr_point = new double[]{Math.min(this.coor[0], this.coor[2]), Math.min(this.coor[1], this.coor[3])};
        FloatPoint lower_left = p_coordinate_transform.dsn_to_board(curr_point);
        curr_point[0] = Math.max(this.coor[0], this.coor[2]);
        curr_point[1] = Math.max(this.coor[1], this.coor[3]);
        FloatPoint upper_right = p_coordinate_transform.dsn_to_board(curr_point);
        return new IntBox(lower_left.round(), upper_right.round());
    }

    @Override
    public void write_scope(IndentFileWriter p_file, IdentifierType p_identifier) throws IOException {
        p_file.new_line();
        p_file.write("(rect ");
        p_identifier.write(this.layer.name, p_file);
        for (int i = 0; i < this.coor.length; ++i) {
            p_file.write(" ");
            p_file.write(String.valueOf(this.coor[i]));
        }
        p_file.write(")");
    }

    @Override
    public void write_scope_int(IndentFileWriter p_file, IdentifierType p_identifier) throws IOException {
        p_file.new_line();
        p_file.write("(rect ");
        p_identifier.write(this.layer.name, p_file);
        for (int i = 0; i < this.coor.length; ++i) {
            p_file.write(" ");
            int curr_coor = (int)Math.round(this.coor[i]);
            p_file.write(String.valueOf(curr_coor));
        }
        p_file.write(")");
    }
}

