/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.datastructures.IdentifierType;
import app.freerouting.datastructures.IndentFileWriter;
import app.freerouting.designforms.specctra.CoordinateTransform;
import app.freerouting.designforms.specctra.Layer;
import app.freerouting.designforms.specctra.Rectangle;
import app.freerouting.designforms.specctra.Shape;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.PolygonShape;
import app.freerouting.geometry.planar.Simplex;
import java.io.IOException;

public class Polygon
extends Shape {
    public final double[] coor;

    public Polygon(Layer p_layer, double[] p_coor) {
        super(p_layer);
        this.coor = p_coor;
    }

    @Override
    public app.freerouting.geometry.planar.Shape transform_to_board(CoordinateTransform p_coordinate_transform) {
        Point[] corner_arr = new IntPoint[this.coor.length / 2];
        double[] curr_point = new double[2];
        for (int i = 0; i < corner_arr.length; ++i) {
            curr_point[0] = this.coor[2 * i];
            curr_point[1] = this.coor[2 * i + 1];
            corner_arr[i] = p_coordinate_transform.dsn_to_board(curr_point).round();
        }
        return new PolygonShape(corner_arr);
    }

    @Override
    public app.freerouting.geometry.planar.Shape transform_to_board_rel(CoordinateTransform p_coordinate_transform) {
        if (this.coor.length < 2) {
            return Simplex.EMPTY;
        }
        Point[] corner_arr = new IntPoint[this.coor.length / 2];
        for (int i = 0; i < corner_arr.length; ++i) {
            int curr_x = (int)Math.round(p_coordinate_transform.dsn_to_board(this.coor[2 * i]));
            int curr_y = (int)Math.round(p_coordinate_transform.dsn_to_board(this.coor[2 * i + 1]));
            corner_arr[i] = new IntPoint(curr_x, curr_y);
        }
        return new PolygonShape(corner_arr);
    }

    @Override
    public Rectangle bounding_box() {
        double[] bounds = new double[]{2.147483647E9, 2.147483647E9, -2.147483648E9, -2.147483648E9};
        for (int i = 0; i < this.coor.length; ++i) {
            if (i % 2 == 0) {
                bounds[0] = Math.min(bounds[0], this.coor[i]);
                bounds[2] = Math.max(bounds[2], this.coor[i]);
                continue;
            }
            bounds[1] = Math.min(bounds[1], this.coor[i]);
            bounds[3] = Math.max(bounds[3], this.coor[i]);
        }
        return new Rectangle(this.layer, bounds);
    }

    @Override
    public void write_scope(IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.start_scope();
        p_file.write("polygon ");
        p_identifier_type.write(this.layer.name, p_file);
        p_file.write(" ");
        p_file.write(String.valueOf(0));
        int corner_count = this.coor.length / 2;
        for (int i = 0; i < corner_count; ++i) {
            p_file.new_line();
            p_file.write(String.valueOf(this.coor[2 * i]));
            p_file.write(" ");
            p_file.write(String.valueOf(this.coor[2 * i + 1]));
        }
        p_file.end_scope();
    }

    @Override
    public void write_scope_int(IndentFileWriter p_file, IdentifierType p_identifier_type) throws IOException {
        p_file.start_scope();
        p_file.write("polygon ");
        p_identifier_type.write(this.layer.name, p_file);
        p_file.write(" ");
        p_file.write(String.valueOf(0));
        int corner_count = this.coor.length / 2;
        for (int i = 0; i < corner_count; ++i) {
            p_file.new_line();
            int curr_coor = (int)Math.round(this.coor[2 * i]);
            p_file.write(String.valueOf(curr_coor));
            p_file.write(" ");
            curr_coor = (int)Math.round(this.coor[2 * i + 1]);
            p_file.write(String.valueOf(curr_coor));
        }
        p_file.end_scope();
    }
}

