/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.designforms.specctra;

import app.freerouting.designforms.specctra.Circuit;
import app.freerouting.designforms.specctra.DsnFile;
import app.freerouting.designforms.specctra.IJFlexScanner;
import app.freerouting.designforms.specctra.Keyword;
import app.freerouting.designforms.specctra.Rule;
import app.freerouting.designforms.specctra.ScopeKeyword;
import app.freerouting.logger.FRLogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;

public class NetClass {
    public final String name;
    public final String trace_clearance_class;
    public final Collection<String> net_list;
    public final Collection<Rule> rules;
    public final Collection<Rule.LayerRule> layer_rules;
    public final Collection<String> use_via;
    public final Collection<String> use_layer;
    public final String via_rule;
    public final boolean shove_fixed;
    public final boolean pull_tight;
    public final double min_trace_length;
    public final double max_trace_length;

    public NetClass(String p_name, String p_trace_clearance_class, Collection<String> p_net_list, Collection<Rule> p_rules, Collection<Rule.LayerRule> p_layer_rules, Collection<String> p_use_via, Collection<String> p_use_layer, String p_via_rule, boolean p_shove_fixed, boolean p_pull_tight, double p_min_trace_length, double p_max_trace_length) {
        this.name = p_name;
        this.trace_clearance_class = p_trace_clearance_class;
        this.net_list = p_net_list;
        this.rules = p_rules;
        this.layer_rules = p_layer_rules;
        this.use_via = p_use_via;
        this.use_layer = p_use_layer;
        this.via_rule = p_via_rule;
        this.shove_fixed = p_shove_fixed;
        this.pull_tight = p_pull_tight;
        this.min_trace_length = p_min_trace_length;
        this.max_trace_length = p_max_trace_length;
    }

    public static NetClass read_scope(IJFlexScanner p_scanner) {
        try {
            Object next_token;
            p_scanner.yybegin(3);
            String class_name = p_scanner.next_string();
            LinkedList<String> net_list = new LinkedList<String>();
            boolean rules_missing = false;
            while (true) {
                p_scanner.yybegin(3);
                next_token = p_scanner.next_token();
                if (next_token == Keyword.OPEN_BRACKET) break;
                if (next_token == Keyword.CLOSED_BRACKET) {
                    rules_missing = true;
                    break;
                }
                if (!(next_token instanceof String)) {
                    FRLogger.warn("NetClass.read_scope: String expected at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                net_list.add((String)next_token);
            }
            LinkedList<Rule> rules = new LinkedList<Rule>();
            LinkedList<Rule.LayerRule> layer_rules = new LinkedList<Rule.LayerRule>();
            LinkedList<String> use_via = new LinkedList<String>();
            LinkedList<String> use_layer = new LinkedList<String>();
            String via_rule = null;
            String trace_clearance_class = null;
            boolean pull_tight = true;
            boolean shove_fixed = false;
            double min_trace_length = 0.0;
            double max_trace_length = 0.0;
            if (!rules_missing) {
                Object prev_token = next_token;
                while (true) {
                    if ((next_token = p_scanner.next_token()) == null) {
                        FRLogger.warn("NetClass.read_scope: unexpected end of file at '" + p_scanner.get_scope_identifier() + "'");
                        return null;
                    }
                    if (next_token == Keyword.CLOSED_BRACKET) break;
                    if (prev_token == Keyword.OPEN_BRACKET) {
                        if (next_token == Keyword.RULE) {
                            rules.addAll(Rule.read_scope(p_scanner));
                        } else if (next_token == Keyword.LAYER_RULE) {
                            layer_rules.add(Rule.read_layer_rule_scope(p_scanner));
                        } else if (next_token == Keyword.VIA_RULE) {
                            via_rule = DsnFile.read_string_scope(p_scanner);
                        } else if (next_token == Keyword.CIRCUIT) {
                            Circuit.ReadScopeResult curr_rule = Circuit.read_scope(p_scanner);
                            if (curr_rule != null) {
                                max_trace_length = curr_rule.max_length;
                                min_trace_length = curr_rule.min_length;
                                use_via.addAll(curr_rule.use_via);
                                use_layer.addAll(curr_rule.use_layer);
                            }
                        } else if (next_token == Keyword.CLEARANCE_CLASS) {
                            trace_clearance_class = DsnFile.read_string_scope(p_scanner);
                            if (trace_clearance_class == null) {
                                return null;
                            }
                        } else if (next_token == Keyword.SHOVE_FIXED) {
                            shove_fixed = DsnFile.read_on_off_scope(p_scanner);
                        } else if (next_token == Keyword.PULL_TIGHT) {
                            pull_tight = DsnFile.read_on_off_scope(p_scanner);
                        } else {
                            ScopeKeyword.skip_scope(p_scanner);
                        }
                    }
                    prev_token = next_token;
                }
            }
            return new NetClass(class_name, trace_clearance_class, net_list, rules, layer_rules, use_via, use_layer, via_rule, shove_fixed, pull_tight, min_trace_length, max_trace_length);
        }
        catch (IOException e) {
            FRLogger.error("NetClass.read_scope: IO error while scanning file", e);
            return null;
        }
    }

    public static ClassClass read_class_class_scope(IJFlexScanner p_scanner) {
        try {
            LinkedList<String> classes = new LinkedList<String>();
            LinkedList<Rule> rules = new LinkedList<Rule>();
            LinkedList<Rule.LayerRule> layer_rules = new LinkedList<Rule.LayerRule>();
            Object prev_token = null;
            while (true) {
                Object next_token;
                if ((next_token = p_scanner.next_token()) == null) {
                    FRLogger.warn("ClassClass.read_scope: unexpected end of file at '" + p_scanner.get_scope_identifier() + "'");
                    return null;
                }
                if (next_token == Keyword.CLOSED_BRACKET) break;
                if (prev_token == Keyword.OPEN_BRACKET) {
                    if (next_token == Keyword.CLASSES) {
                        classes.addAll(Arrays.stream(DsnFile.read_string_list_scope(p_scanner)).toList());
                    } else if (next_token == Keyword.RULE) {
                        rules.addAll(Rule.read_scope(p_scanner));
                    } else if (next_token == Keyword.LAYER_RULE) {
                        layer_rules.add(Rule.read_layer_rule_scope(p_scanner));
                    }
                }
                prev_token = next_token;
            }
            return new ClassClass(classes, rules, layer_rules);
        }
        catch (IOException e) {
            FRLogger.error("NetClass.read_scope: IO error while scanning file", e);
            return null;
        }
    }

    public static class ClassClass {
        public final Collection<String> class_names;
        public final Collection<Rule> rules;
        public final Collection<Rule.LayerRule> layer_rules;

        public ClassClass(Collection<String> p_class_names, Collection<Rule> p_rules, Collection<Rule.LayerRule> p_layer_rules) {
            this.class_names = p_class_names;
            this.rules = p_rules;
            this.layer_rules = p_layer_rules;
        }
    }
}

