/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.datastructures;

import app.freerouting.geometry.planar.RegularTileShape;
import app.freerouting.geometry.planar.ShapeBoundingDirections;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;

public abstract class ShapeTree {
    protected final ShapeBoundingDirections bounding_directions;
    protected TreeNode root;
    protected int leaf_count;

    public ShapeTree(ShapeBoundingDirections p_directions) {
        this.bounding_directions = p_directions;
        this.root = null;
        this.leaf_count = 0;
    }

    public void insert(Storable p_obj) {
        int shape_count = p_obj.tree_shape_count(this);
        if (shape_count <= 0) {
            return;
        }
        Leaf[] leaf_arr = new Leaf[shape_count];
        for (int i = 0; i < shape_count; ++i) {
            leaf_arr[i] = this.insert(p_obj, i);
        }
        p_obj.set_search_tree_entries(leaf_arr, this);
    }

    protected Leaf insert(Storable p_object, int p_index) {
        TileShape object_shape = p_object.get_tree_shape(this, p_index);
        if (object_shape == null) {
            return null;
        }
        RegularTileShape bounding_shape = object_shape.bounding_shape(this.bounding_directions);
        if (bounding_shape == null) {
            FRLogger.warn("ShapeTree.insert: bounding shape of TreeObject is null");
            return null;
        }
        Leaf new_leaf = new Leaf(p_object, p_index, null, bounding_shape);
        this.insert(new_leaf);
        return new_leaf;
    }

    public Leaf[] to_array() {
        Leaf[] result = new Leaf[this.leaf_count];
        if (result.length == 0) {
            return result;
        }
        TreeNode curr_node = this.root;
        int curr_index = 0;
        while (true) {
            if (curr_node instanceof InnerNode) {
                curr_node = ((InnerNode)curr_node).first_child;
                continue;
            }
            result[curr_index] = (Leaf)curr_node;
            ++curr_index;
            InnerNode curr_parent = curr_node.parent;
            while (curr_parent != null && curr_parent.second_child == curr_node) {
                curr_node = curr_parent;
                curr_parent = curr_node.parent;
            }
            if (curr_parent == null) break;
            curr_node = curr_parent.second_child;
        }
        return result;
    }

    abstract void insert(Leaf var1);

    abstract void remove_leaf(Leaf var1);

    public void remove(Leaf[] p_entries) {
        if (p_entries == null) {
            return;
        }
        for (int i = 0; i < p_entries.length; ++i) {
            this.remove_leaf(p_entries[i]);
        }
    }

    public int size() {
        return this.leaf_count;
    }

    public void statistics(String p_message) {
        Leaf[] leaf_arr = this.to_array();
        double cumulative_depth = 0.0;
        int maximum_depth = 0;
        for (int i = 0; i < leaf_arr.length; ++i) {
            if (leaf_arr[i] == null) continue;
            int distance_to_root = leaf_arr[i].distance_to_root();
            cumulative_depth += (double)distance_to_root;
            maximum_depth = Math.max(maximum_depth, distance_to_root);
        }
        double average_depth = cumulative_depth / (double)leaf_arr.length;
        FRLogger.info("MinAreaTree: Entry count: " + leaf_arr.length + " log: " + Math.round(Math.log(leaf_arr.length)) + " Average depth: " + Math.round(average_depth) + "  Maximum depth: " + maximum_depth + " " + p_message);
    }

    protected static class TreeNode {
        public RegularTileShape bounding_shape;
        InnerNode parent;

        protected TreeNode() {
        }
    }

    public static interface Storable
    extends Comparable<Object> {
        public int tree_shape_count(ShapeTree var1);

        public TileShape get_tree_shape(ShapeTree var1, int var2);

        public void set_search_tree_entries(Leaf[] var1, ShapeTree var2);
    }

    public static class Leaf
    extends TreeNode
    implements Comparable<Leaf> {
        public Storable object;
        public int shape_index_in_object;

        public Leaf(Storable p_object, int p_index, InnerNode p_parent, RegularTileShape p_bounding_shape) {
            this.bounding_shape = p_bounding_shape;
            this.parent = p_parent;
            this.object = p_object;
            this.shape_index_in_object = p_index;
        }

        @Override
        public int compareTo(Leaf p_other) {
            int result = this.object.compareTo(p_other.object);
            if (result == 0) {
                result = this.shape_index_in_object - p_other.shape_index_in_object;
            }
            return result;
        }

        public int distance_to_root() {
            int result = 1;
            InnerNode curr_parent = this.parent;
            while (curr_parent.parent != null) {
                curr_parent = curr_parent.parent;
                ++result;
            }
            return result;
        }
    }

    public static class InnerNode
    extends TreeNode {
        public TreeNode first_child;
        public TreeNode second_child;

        public InnerNode(RegularTileShape p_bounding_shape, InnerNode p_parent) {
            this.bounding_shape = p_bounding_shape;
            this.parent = p_parent;
            this.first_child = null;
            this.second_child = null;
        }
    }

    public static class TreeEntry {
        public final Storable object;
        public final int shape_index_in_object;

        public TreeEntry(Storable p_object, int p_shape_index_in_object) {
            this.object = p_object;
            this.shape_index_in_object = p_shape_index_in_object;
        }
    }
}

