/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.boardgraphics;

import app.freerouting.board.LayerStructure;
import app.freerouting.boardgraphics.ColorIntensityTable;
import app.freerouting.boardgraphics.CoordinateTransform;
import app.freerouting.boardgraphics.ItemColorTableModel;
import app.freerouting.boardgraphics.OtherColorTableModel;
import app.freerouting.geometry.planar.Area;
import app.freerouting.geometry.planar.Circle;
import app.freerouting.geometry.planar.Ellipse;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.PolylineShape;
import app.freerouting.logger.FRLogger;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;

public class GraphicsContext
implements Serializable {
    private static final int update_offset = 10000;
    private static final boolean show_line_segments = false;
    private static final boolean show_area_division = false;
    public transient ItemColorTableModel item_color_table;
    public transient OtherColorTableModel other_color_table;
    public ColorIntensityTable color_intensity_table;
    public CoordinateTransform coordinate_transform;
    private double[] layer_visibility_arr;
    private double auto_layer_dim_factor = 0.7;
    private int fully_visible_layer = 0;

    public GraphicsContext(IntBox p_design_bounds, Dimension p_panel_bounds, LayerStructure p_layer_structure, Locale p_locale) {
        this.coordinate_transform = new CoordinateTransform(p_design_bounds, p_panel_bounds);
        this.item_color_table = new ItemColorTableModel(p_layer_structure, p_locale);
        this.other_color_table = new OtherColorTableModel(p_locale);
        this.color_intensity_table = new ColorIntensityTable();
        this.layer_visibility_arr = new double[p_layer_structure.arr.length];
        for (int i = 0; i < this.layer_visibility_arr.length; ++i) {
            this.layer_visibility_arr[i] = p_layer_structure.arr[i].is_signal ? 1.0 : 0.25;
        }
    }

    public GraphicsContext(GraphicsContext p_graphics_context) {
        this.coordinate_transform = new CoordinateTransform(p_graphics_context.coordinate_transform);
        this.item_color_table = new ItemColorTableModel(p_graphics_context.item_color_table);
        this.other_color_table = new OtherColorTableModel(p_graphics_context.other_color_table);
        this.color_intensity_table = new ColorIntensityTable(p_graphics_context.color_intensity_table);
        this.layer_visibility_arr = p_graphics_context.copy_layer_visibility_arr();
    }

    private static void init_draw_graphics(Graphics2D p_graphics, Color p_color, float p_width) {
        BasicStroke bs = new BasicStroke(Math.max(p_width, 0.0f), 1, 1);
        p_graphics.setStroke(bs);
        p_graphics.setColor(p_color);
        p_graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private static void set_translucency(Graphics2D p_g2, double p_factor) {
        AlphaComposite curr_alpha_composite = p_factor >= 0.0 ? AlphaComposite.getInstance(3, (float)p_factor) : AlphaComposite.getInstance(4, (float)(-p_factor));
        p_g2.setComposite(curr_alpha_composite);
    }

    public void change_design_bounds(IntBox p_new_design_bounds) {
        if (p_new_design_bounds.equals(this.coordinate_transform.design_box)) {
            return;
        }
        Dimension screen_bounds = this.coordinate_transform.screen_bounds;
        this.coordinate_transform = new CoordinateTransform(p_new_design_bounds, screen_bounds);
    }

    public void change_panel_size(Dimension p_new_bounds) {
        if (this.coordinate_transform == null) {
            return;
        }
        IntBox design_box = this.coordinate_transform.design_box;
        boolean left_right_swapped = this.coordinate_transform.is_mirror_left_right();
        boolean top_bottom_swapped = this.coordinate_transform.is_mirror_top_bottom();
        double rotation = this.coordinate_transform.get_rotation();
        this.coordinate_transform = new CoordinateTransform(design_box, p_new_bounds);
        this.coordinate_transform.set_mirror_left_right(left_right_swapped);
        this.coordinate_transform.set_mirror_top_bottom(top_bottom_swapped);
        this.coordinate_transform.set_rotation(rotation);
    }

    public void draw(FloatPoint[] p_points, double p_half_width, Color p_color, Graphics p_g, double p_translucency_factor) {
        if (p_color == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)p_g;
        Rectangle clip_shape = p_g.getClip().getBounds();
        IntBox clip_box = this.coordinate_transform.screen_to_board(clip_shape);
        double scaled_width = this.coordinate_transform.board_to_screen(p_half_width);
        GraphicsContext.init_draw_graphics(g2, p_color, (float)scaled_width * 2.0f);
        GraphicsContext.set_translucency(g2, p_translucency_factor);
        GeneralPath draw_path = null;
        draw_path = new GeneralPath();
        for (int i = 0; i < p_points.length - 1; ++i) {
            if (this.line_outside_update_box(p_points[i], p_points[i + 1], p_half_width + 10000.0, clip_box)) continue;
            Point2D p1 = this.coordinate_transform.board_to_screen(p_points[i]);
            Point2D p2 = this.coordinate_transform.board_to_screen(p_points[i + 1]);
            Line2D.Double line = new Line2D.Double(p1, p2);
            draw_path.append(line, false);
        }
        g2.draw(draw_path);
    }

    public void draw_circle(FloatPoint p_center, double p_radius, double p_draw_half_width, Color p_color, Graphics p_g, double p_translucency_factor) {
        if (p_color == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)p_g;
        Point2D center = this.coordinate_transform.board_to_screen(p_center);
        double radius = this.coordinate_transform.board_to_screen(p_radius);
        double diameter = 2.0 * radius;
        float draw_width = (float)(2.0 * this.coordinate_transform.board_to_screen(p_draw_half_width));
        Ellipse2D.Double circle = new Ellipse2D.Double(center.getX() - radius, center.getY() - radius, diameter, diameter);
        GraphicsContext.set_translucency(g2, p_translucency_factor);
        GraphicsContext.init_draw_graphics(g2, p_color, draw_width);
        g2.draw(circle);
    }

    public void draw_rectangle(FloatPoint p_corner1, FloatPoint p_corner2, double p_draw_half_width, Color p_color, Graphics p_g, double p_translucency_factor) {
        if (p_color == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)p_g;
        Point2D corner1 = this.coordinate_transform.board_to_screen(p_corner1);
        Point2D corner2 = this.coordinate_transform.board_to_screen(p_corner2);
        double xmin = Math.min(corner1.getX(), corner2.getX());
        double ymin = Math.min(corner1.getY(), corner2.getY());
        float draw_width = (float)(2.0 * this.coordinate_transform.board_to_screen(p_draw_half_width));
        double width = Math.abs(corner2.getX() - corner1.getX());
        double height = Math.abs(corner2.getY() - corner1.getY());
        Rectangle2D.Double rectangle = new Rectangle2D.Double(xmin, ymin, width, height);
        GraphicsContext.set_translucency(g2, p_translucency_factor);
        GraphicsContext.init_draw_graphics(g2, p_color, draw_width);
        g2.draw(rectangle);
    }

    public void draw_boundary(app.freerouting.geometry.planar.Shape p_shape, double p_draw_half_width, Color p_color, Graphics p_g, double p_translucency_factor) {
        if (p_shape instanceof PolylineShape) {
            FloatPoint[] draw_corners = p_shape.corner_approx_arr();
            if (draw_corners.length <= 1) {
                return;
            }
            FloatPoint[] closed_draw_corners = new FloatPoint[draw_corners.length + 1];
            System.arraycopy(draw_corners, 0, closed_draw_corners, 0, draw_corners.length);
            closed_draw_corners[closed_draw_corners.length - 1] = draw_corners[0];
            this.draw(closed_draw_corners, p_draw_half_width, p_color, p_g, p_translucency_factor);
        } else if (p_shape instanceof Circle) {
            Circle curr_circle = (Circle)p_shape;
            this.draw_circle(curr_circle.center.to_float(), curr_circle.radius, p_draw_half_width, p_color, p_g, p_translucency_factor);
        }
    }

    public void draw_boundary(Area p_area, double p_draw_half_width, Color p_color, Graphics p_g, double p_translucency_factor) {
        this.draw_boundary(p_area.get_border(), p_draw_half_width, p_color, p_g, p_translucency_factor);
        app.freerouting.geometry.planar.Shape[] holes = p_area.get_holes();
        for (int i = 0; i < holes.length; ++i) {
            this.draw_boundary(holes[i], p_draw_half_width, p_color, p_g, p_translucency_factor);
        }
    }

    public void fill_circle(Circle p_circle, Graphics p_g, Color p_color, double p_translucency_factor) {
        if (p_color == null) {
            return;
        }
        Point2D center = this.coordinate_transform.board_to_screen(p_circle.center.to_float());
        double radius = this.coordinate_transform.board_to_screen(p_circle.radius);
        if (!this.point_near_rectangle(center.getX(), center.getY(), p_g.getClip().getBounds(), radius)) {
            return;
        }
        double diameter = 2.0 * radius;
        Ellipse2D.Double circle = new Ellipse2D.Double(center.getX() - radius, center.getY() - radius, diameter, diameter);
        Graphics2D g2 = (Graphics2D)p_g;
        g2.setColor(p_color);
        GraphicsContext.set_translucency(g2, p_translucency_factor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(circle);
    }

    public void fill_ellipse(Ellipse p_ellipse, Graphics p_g, Color p_color, double p_translucency_factor) {
        Ellipse[] ellipse_arr = new Ellipse[]{p_ellipse};
        this.fill_ellipse_arr(ellipse_arr, p_g, p_color, p_translucency_factor);
    }

    public void fill_ellipse_arr(Ellipse[] p_ellipse_arr, Graphics p_g, Color p_color, double p_translucency_factor) {
        if (p_color == null || p_ellipse_arr.length == 0) {
            return;
        }
        GeneralPath draw_path = new GeneralPath(0);
        for (Ellipse curr_ellipse : p_ellipse_arr) {
            Point2D center = this.coordinate_transform.board_to_screen(curr_ellipse.center);
            double bigger_radius = this.coordinate_transform.board_to_screen(curr_ellipse.bigger_radius);
            if (!this.point_near_rectangle(center.getX(), center.getY(), p_g.getClip().getBounds(), bigger_radius)) continue;
            double smaller_radius = this.coordinate_transform.board_to_screen(curr_ellipse.smaller_radius);
            Ellipse2D.Double draw_ellipse = new Ellipse2D.Double(center.getX() - bigger_radius, center.getY() - smaller_radius, 2.0 * bigger_radius, 2.0 * smaller_radius);
            double rotation = this.coordinate_transform.board_to_screen_angle(curr_ellipse.rotation);
            AffineTransform affine_transform = new AffineTransform();
            affine_transform.rotate(rotation, center.getX(), center.getY());
            Shape rotated_ellipse = affine_transform.createTransformedShape(draw_ellipse);
            draw_path.append(rotated_ellipse, false);
        }
        Graphics2D g2 = (Graphics2D)p_g;
        g2.setColor(p_color);
        GraphicsContext.set_translucency(g2, p_translucency_factor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(draw_path);
    }

    private boolean point_near_rectangle(double p_x, double p_y, Rectangle p_rect, double p_dist) {
        if (p_x < (double)p_rect.x - p_dist) {
            return false;
        }
        if (p_y < (double)p_rect.y - p_dist) {
            return false;
        }
        if (p_x > (double)(p_rect.x + p_rect.width) + p_dist) {
            return false;
        }
        return !(p_y > (double)(p_rect.y + p_rect.height) + p_dist);
    }

    public void fill_shape(FloatPoint[] p_points, Graphics p_g, Color p_color, double p_translucency_factor) {
        if (p_color == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)p_g;
        Polygon draw_polygon = new Polygon();
        for (int i = 0; i < p_points.length; ++i) {
            Point2D curr_corner = this.coordinate_transform.board_to_screen(p_points[i]);
            draw_polygon.addPoint((int)Math.round(curr_corner.getX()), (int)Math.round(curr_corner.getY()));
        }
        g2.setColor(p_color);
        GraphicsContext.set_translucency(g2, p_translucency_factor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(draw_polygon);
    }

    public void fill_area(FloatPoint[][] p_point_lists, Graphics p_g, Color p_color, double p_translucency_factor) {
        if (p_color == null) {
            return;
        }
        GeneralPath draw_path = new GeneralPath(0);
        for (int j = 0; j < p_point_lists.length; ++j) {
            Polygon draw_polygon = new Polygon();
            FloatPoint[] curr_point_list = p_point_lists[j];
            for (int i = 0; i < curr_point_list.length; ++i) {
                Point2D curr_corner = this.coordinate_transform.board_to_screen(curr_point_list[i]);
                draw_polygon.addPoint((int)Math.round(curr_corner.getX()), (int)Math.round(curr_corner.getY()));
            }
            draw_path.append(draw_polygon, false);
        }
        Graphics2D g2 = (Graphics2D)p_g;
        g2.setColor(p_color);
        GraphicsContext.set_translucency(g2, p_translucency_factor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(draw_path);
    }

    public void fill_area(Area p_area, Graphics p_g, Color p_color, double p_translucency_factor) {
        if (p_color == null || p_area.is_empty()) {
            return;
        }
        if (p_area instanceof Circle) {
            this.fill_circle((Circle)p_area, p_g, p_color, p_translucency_factor);
        } else {
            PolylineShape border = (PolylineShape)p_area.get_border();
            if (!border.is_bounded()) {
                FRLogger.warn("GraphicsContext.fill_area: shape not bounded");
                return;
            }
            Rectangle clip_shape = p_g.getClip().getBounds();
            IntBox clip_box = this.coordinate_transform.screen_to_board(clip_shape);
            if (!border.bounding_box().intersects(clip_box)) {
                return;
            }
            app.freerouting.geometry.planar.Shape[] holes = p_area.get_holes();
            FloatPoint[][] draw_polygons = new FloatPoint[holes.length + 1][];
            for (int j = 0; j < draw_polygons.length; ++j) {
                PolylineShape curr_draw_shape = j == 0 ? border : (PolylineShape)holes[j - 1];
                draw_polygons[j] = new FloatPoint[curr_draw_shape.border_line_count() + 1];
                FloatPoint[] curr_draw_polygon = draw_polygons[j];
                for (int i = 0; i < curr_draw_polygon.length - 1; ++i) {
                    curr_draw_polygon[i] = curr_draw_shape.corner_approx(i);
                }
                curr_draw_polygon[curr_draw_polygon.length - 1] = curr_draw_polygon[0];
            }
            this.fill_area(draw_polygons, p_g, p_color, p_translucency_factor);
        }
    }

    public Color get_background_color() {
        return this.other_color_table.get_background_color();
    }

    public Color get_hilight_color() {
        return this.other_color_table.get_hilight_color();
    }

    public Color get_incomplete_color() {
        return this.other_color_table.get_incomplete_color();
    }

    public Color get_outline_color() {
        return this.other_color_table.get_outline_color();
    }

    public Color get_component_color(boolean p_front) {
        return this.other_color_table.get_component_color(p_front);
    }

    public Color get_violations_color() {
        return this.other_color_table.get_violations_color();
    }

    public Color get_length_matching_area_color() {
        return this.other_color_table.get_length_matching_area_color();
    }

    public Color[] get_trace_colors(boolean p_fixed) {
        return this.item_color_table.get_trace_colors(p_fixed);
    }

    public Color[] get_via_colors(boolean p_fixed) {
        return this.item_color_table.get_via_colors(p_fixed);
    }

    public Color[] get_pin_colors() {
        return this.item_color_table.get_pin_colors();
    }

    public Color[] get_conduction_colors() {
        return this.item_color_table.get_conduction_colors();
    }

    public Color[] get_obstacle_colors() {
        return this.item_color_table.get_obstacle_colors();
    }

    public Color[] get_via_obstacle_colors() {
        return this.item_color_table.get_via_obstacle_colors();
    }

    public Color[] get_place_obstacle_colors() {
        return this.item_color_table.get_place_obstacle_colors();
    }

    public double get_trace_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.TRACES.ordinal());
    }

    public void set_trace_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.TRACES.ordinal(), p_value);
    }

    public double get_via_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.VIAS.ordinal());
    }

    public void set_via_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.VIAS.ordinal(), p_value);
    }

    public double get_pin_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.PINS.ordinal());
    }

    public void set_pin_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.PINS.ordinal(), p_value);
    }

    public double get_conduction_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.CONDUCTION_AREAS.ordinal());
    }

    public void set_conduction_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.CONDUCTION_AREAS.ordinal(), p_value);
    }

    public double get_obstacle_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.KEEPOUTS.ordinal());
    }

    public void set_obstacle_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.KEEPOUTS.ordinal(), p_value);
    }

    public double get_via_obstacle_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.VIA_KEEPOUTS.ordinal());
    }

    public void set_via_obstacle_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.VIA_KEEPOUTS.ordinal(), p_value);
    }

    public double get_place_obstacle_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.PLACE_KEEPOUTS.ordinal());
    }

    public double get_component_outline_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.COMPONENT_OUTLINES.ordinal());
    }

    public double get_hilight_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.HILIGHT.ordinal());
    }

    public void set_hilight_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.HILIGHT.ordinal(), p_value);
    }

    public double get_incomplete_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.INCOMPLETES.ordinal());
    }

    public void set_incomplete_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.INCOMPLETES.ordinal(), p_value);
    }

    public double get_length_matching_area_color_intensity() {
        return this.color_intensity_table.get_value(ColorIntensityTable.ObjectNames.LENGTH_MATCHING_AREAS.ordinal());
    }

    public void set_length_matching_area_color_intensity(double p_value) {
        this.color_intensity_table.set_value(ColorIntensityTable.ObjectNames.LENGTH_MATCHING_AREAS.ordinal(), p_value);
    }

    public Dimension get_panel_size() {
        return this.coordinate_transform.screen_bounds;
    }

    public Point2D get_design_center() {
        FloatPoint center = this.coordinate_transform.design_box_with_offset.centre_of_gravity();
        return this.coordinate_transform.board_to_screen(center);
    }

    public Rectangle get_design_bounds() {
        return this.coordinate_transform.board_to_screen(this.coordinate_transform.design_box);
    }

    public double get_auto_layer_dim_factor() {
        return this.auto_layer_dim_factor;
    }

    public void set_auto_layer_dim_factor(double p_value) {
        this.auto_layer_dim_factor = p_value;
    }

    public void set_fully_visible_layer(int p_layer_no) {
        this.fully_visible_layer = p_layer_no;
    }

    public double get_layer_visibility(int p_layer_no) {
        double result = p_layer_no == this.fully_visible_layer ? this.layer_visibility_arr[p_layer_no] : this.auto_layer_dim_factor * this.layer_visibility_arr[p_layer_no];
        return result;
    }

    public double get_raw_layer_visibility(int p_layer_no) {
        return this.layer_visibility_arr[p_layer_no];
    }

    public void set_layer_visibility(int p_layer_no, double p_value) {
        this.layer_visibility_arr[p_layer_no] = Math.max(0.0, Math.min(p_value, 1.0));
    }

    public void set_layer_visibility_arr(double[] p_layer_visibility_arr) {
        this.layer_visibility_arr = p_layer_visibility_arr;
    }

    public double[] copy_layer_visibility_arr() {
        double[] result = new double[this.layer_visibility_arr.length];
        System.arraycopy(this.layer_visibility_arr, 0, result, 0, this.layer_visibility_arr.length);
        return result;
    }

    public int layer_count() {
        return this.layer_visibility_arr.length;
    }

    private boolean line_outside_update_box(FloatPoint p_1, FloatPoint p_2, double p_update_offset, IntBox p_update_box) {
        if (p_1 == null || p_2 == null) {
            return true;
        }
        if (Math.max(p_1.x, p_2.x) < (double)p_update_box.ll.x - p_update_offset) {
            return true;
        }
        if (Math.max(p_1.y, p_2.y) < (double)p_update_box.ll.y - p_update_offset) {
            return true;
        }
        if (Math.min(p_1.x, p_2.x) > (double)p_update_box.ur.x + p_update_offset) {
            return true;
        }
        return Math.min(p_1.y, p_2.y) > (double)p_update_box.ur.y + p_update_offset;
    }

    private void writeObject(ObjectOutputStream p_stream) throws IOException {
        p_stream.defaultWriteObject();
        this.item_color_table.write_object(p_stream);
        this.other_color_table.write_object(p_stream);
    }

    private void readObject(ObjectInputStream p_stream) throws IOException, ClassNotFoundException {
        p_stream.defaultReadObject();
        this.item_color_table = new ItemColorTableModel(p_stream);
        this.other_color_table = new OtherColorTableModel(p_stream);
    }
}

