/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.BasicBoard;
import app.freerouting.board.ComponentObstacleArea;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.Connectable;
import app.freerouting.board.DrillItem;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.PullTightAlgo;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.ViaObstacleArea;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.Net;
import app.freerouting.rules.Nets;
import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public abstract class Trace
extends Item
implements Connectable,
Serializable {
    private final int half_width;
    private int layer;

    Trace(int p_layer, int p_half_width, int[] p_net_no_arr, int p_clearance_type, int p_id_no, int p_group_no, FixedState p_fixed_state, BasicBoard p_board) {
        super(p_net_no_arr, p_clearance_type, p_id_no, p_group_no, p_fixed_state, p_board);
        this.half_width = p_half_width;
        p_layer = Math.max(p_layer, 0);
        if (p_board != null) {
            p_layer = Math.min(p_layer, p_board.get_layer_count() - 1);
        }
        this.layer = p_layer;
    }

    public abstract Point first_corner();

    public abstract Point last_corner();

    @Override
    public int first_layer() {
        return this.layer;
    }

    @Override
    public int last_layer() {
        return this.layer;
    }

    public int get_layer() {
        return this.layer;
    }

    public void set_layer(int p_layer) {
        this.layer = p_layer;
    }

    public int get_half_width() {
        return this.half_width;
    }

    public abstract double get_length();

    public int get_compensated_half_width(ShapeSearchTree p_search_tree) {
        return this.half_width + p_search_tree.clearance_compensation_value(this.clearance_class_no(), this.layer);
    }

    @Override
    public boolean is_obstacle(Item p_other) {
        if (p_other == this || p_other instanceof ViaObstacleArea || p_other instanceof ComponentObstacleArea) {
            return false;
        }
        if (p_other instanceof ConductionArea && !((ConductionArea)p_other).get_is_obstacle()) {
            return false;
        }
        return !p_other.shares_net(this);
    }

    public Set<Item> get_start_contacts() {
        return this.get_normal_contacts(this.first_corner(), false);
    }

    public Set<Item> get_end_contacts() {
        return this.get_normal_contacts(this.last_corner(), false);
    }

    @Override
    public Point normal_contact_point(Item p_other) {
        return p_other.normal_contact_point(this);
    }

    @Override
    public Set<Item> get_normal_contacts() {
        Point end_corner;
        TreeSet<Item> result = new TreeSet<Item>();
        Point start_corner = this.first_corner();
        if (start_corner != null) {
            result.addAll(this.get_normal_contacts(start_corner, false));
        }
        if ((end_corner = this.last_corner()) != null) {
            result.addAll(this.get_normal_contacts(end_corner, false));
        }
        return result;
    }

    @Override
    public boolean is_routable() {
        return !this.is_user_fixed() && this.net_count() > 0;
    }

    @Override
    public boolean is_tail() {
        Set<Item> contact_list = this.get_start_contacts();
        if (contact_list.isEmpty()) {
            return true;
        }
        contact_list = this.get_end_contacts();
        return contact_list.isEmpty();
    }

    @Override
    public Color[] get_draw_colors(GraphicsContext p_graphics_context) {
        return p_graphics_context.get_trace_colors(this.is_user_fixed());
    }

    @Override
    public int get_draw_priority() {
        return 3;
    }

    @Override
    public double get_draw_intensity(GraphicsContext p_graphics_context) {
        return p_graphics_context.get_trace_color_intensity();
    }

    public Set<Item> get_normal_contacts(Point p_point, boolean p_ignore_net) {
        if (p_point == null || !p_point.equals(this.first_corner()) && !p_point.equals(this.last_corner())) {
            return new TreeSet<Item>();
        }
        IntBox search_shape = TileShape.get_instance(p_point);
        Set<SearchTreeObject> overlaps = this.board.overlapping_objects(search_shape, this.layer);
        TreeSet<Item> result = new TreeSet<Item>();
        for (SearchTreeObject curr_ob : overlaps) {
            ConductionArea curr_area;
            Item curr_item;
            if (!(curr_ob instanceof Item) || (curr_item = (Item)curr_ob) == this || !curr_item.shares_layer(this) || !p_ignore_net && !curr_item.shares_net(this)) continue;
            if (curr_item instanceof Trace) {
                Trace curr_trace = (Trace)curr_item;
                if (!p_point.equals(curr_trace.first_corner()) && !p_point.equals(curr_trace.last_corner())) continue;
                result.add(curr_item);
                continue;
            }
            if (curr_item instanceof DrillItem) {
                DrillItem curr_drill_item = (DrillItem)curr_item;
                if (!p_point.equals(curr_drill_item.get_center())) continue;
                result.add(curr_item);
                continue;
            }
            if (!(curr_item instanceof ConductionArea) || !(curr_area = (ConductionArea)curr_item).get_area().contains(p_point)) continue;
            result.add(curr_item);
        }
        return result;
    }

    @Override
    Point normal_contact_point(DrillItem p_drill_item) {
        return p_drill_item.normal_contact_point(this);
    }

    @Override
    Point normal_contact_point(Trace p_other) {
        boolean contact_at_last_corner;
        if (this.layer != p_other.layer) {
            return null;
        }
        boolean contact_at_first_corner = this.first_corner().equals(p_other.first_corner()) || this.first_corner().equals(p_other.last_corner());
        boolean bl = contact_at_last_corner = this.last_corner().equals(p_other.first_corner()) || this.last_corner().equals(p_other.last_corner());
        Point result = !contact_at_first_corner && !contact_at_last_corner || contact_at_first_corner && contact_at_last_corner ? null : (contact_at_first_corner ? this.first_corner() : this.last_corner());
        return result;
    }

    @Override
    public boolean is_drillable(int p_net_no) {
        return this.contains_net(p_net_no);
    }

    @Override
    public boolean is_overlap() {
        Set<Item> end_contacts;
        Set<Item> start_contacts = this.get_start_contacts();
        return !Collections.disjoint(start_contacts, end_contacts = this.get_end_contacts());
    }

    @Override
    public boolean is_shove_fixed() {
        if (super.is_shove_fixed()) {
            return true;
        }
        Nets nets = this.board.rules.nets;
        for (int curr_net_no : this.net_no_arr) {
            if (!Nets.is_normal_net_no(curr_net_no) || !nets.get(curr_net_no).get_class().is_shove_fixed()) continue;
            return true;
        }
        return false;
    }

    public Point nearest_end_point(Point p_from_point) {
        double d2;
        Point p1 = this.first_corner();
        Point p2 = this.last_corner();
        FloatPoint from_point = p_from_point.to_float();
        double d1 = from_point.distance(p1.to_float());
        Point result = d1 < (d2 = from_point.distance(p2.to_float())) ? p1 : p2;
        return result;
    }

    public boolean is_cycle() {
        Net curr_net;
        if (this.is_overlap()) {
            return true;
        }
        Set<Item> start_contacts = this.get_start_contacts();
        TreeSet<Item> visited_items = new TreeSet<Item>(start_contacts);
        boolean ignore_areas = false;
        if (this.net_no_arr.length > 0 && (curr_net = this.board.rules.nets.get(this.net_no_arr[0])) != null && curr_net.get_class() != null) {
            ignore_areas = curr_net.get_class().get_ignore_cycles_with_areas();
        }
        for (Item curr_contact : start_contacts) {
            if (!curr_contact.is_cycle_recu(visited_items, this, this, ignore_areas)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int shape_layer(int p_index) {
        return this.layer;
    }

    @Override
    public Point[] get_ratsnest_corners() {
        int stub_count = 0;
        boolean stub_at_start = false;
        boolean stub_at_end = false;
        if (this.get_start_contacts().isEmpty()) {
            ++stub_count;
            stub_at_start = true;
        }
        if (this.get_end_contacts().isEmpty()) {
            ++stub_count;
            stub_at_end = true;
        }
        Point[] result = new Point[stub_count];
        int stub_no = 0;
        if (stub_at_start) {
            result[stub_no] = this.first_corner();
            ++stub_no;
        }
        if (stub_at_end) {
            result[stub_no] = this.last_corner();
        }
        for (int i = 0; i < result.length; ++i) {
            if (result[i] != null) continue;
            return new Point[0];
        }
        return result;
    }

    public abstract boolean check_connection_to_pin(boolean var1);

    @Override
    public boolean is_selected_by_filter(ItemSelectionFilter p_filter) {
        if (!this.is_selected_by_fixed_filter(p_filter)) {
            return false;
        }
        return p_filter.is_selected(ItemSelectionFilter.SelectableChoices.TRACES);
    }

    Set<Pin> touching_pins_at_end_corners() {
        TreeSet<Pin> result = new TreeSet<Pin>();
        if (this.board == null) {
            return result;
        }
        Point curr_end_point = this.first_corner();
        for (int i = 0; i < 2; ++i) {
            IntOctagon curr_oct = curr_end_point.surrounding_octagon();
            curr_oct = curr_oct.enlarge(this.half_width);
            Set<Item> curr_overlaps = this.board.overlapping_items_with_clearance(curr_oct, this.layer, new int[0], this.clearance_class_no());
            for (Item curr_item : curr_overlaps) {
                if (!(curr_item instanceof Pin) || !curr_item.shares_net(this)) continue;
                result.add((Pin)curr_item);
            }
            curr_end_point = this.last_corner();
        }
        return result;
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.ObjectInfoPanel", p_locale);
        p_window.append_bold(resources.getString("trace"));
        p_window.append(" " + resources.getString("from") + " ");
        p_window.append(this.first_corner().to_float());
        p_window.append(" " + resources.getString("to") + " ");
        p_window.append(this.last_corner().to_float());
        p_window.append(" " + resources.getString("on_layer") + " ");
        p_window.append(this.board.layer_structure.arr[this.layer].name);
        p_window.append(", " + resources.getString("width") + " ");
        p_window.append(2 * this.half_width);
        p_window.append(", " + resources.getString("length") + " ");
        p_window.append(this.get_length());
        this.print_connectable_item_info(p_window, p_locale);
        p_window.newline();
    }

    @Override
    public boolean validate() {
        boolean result = super.validate();
        if (this.first_corner().equals(this.last_corner())) {
            FRLogger.warn("Trace.validate: first and last corner are equal");
            result = false;
        }
        return result;
    }

    abstract boolean combine();

    public abstract Collection<PolylineTrace> split(IntOctagon var1);

    public abstract Trace[] split(Point var1);

    public abstract boolean pull_tight(PullTightAlgo var1);
}

