/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.AngleRestriction;
import app.freerouting.board.BasicBoard;
import app.freerouting.board.Item;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.ShapeSearchTree45Degree;
import app.freerouting.board.ShapeSearchTree90Degree;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.FortyfiveDegreeBoundingDirections;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class SearchTreeManager {
    private final Collection<ShapeSearchTree> compensated_search_trees;
    private final BasicBoard board;
    private ShapeSearchTree default_tree;
    private boolean clearance_compensation_used;

    public SearchTreeManager(BasicBoard p_board) {
        this.board = p_board;
        this.compensated_search_trees = new LinkedList<ShapeSearchTree>();
        this.default_tree = new ShapeSearchTree(FortyfiveDegreeBoundingDirections.INSTANCE, p_board, 0);
        this.compensated_search_trees.add(this.default_tree);
        this.clearance_compensation_used = false;
    }

    public void insert(Item p_item) {
        for (ShapeSearchTree curr_tree : this.compensated_search_trees) {
            curr_tree.insert(p_item);
        }
        p_item.set_on_the_board(true);
    }

    public void remove(Item p_item) {
        if (!p_item.is_on_the_board()) {
            return;
        }
        for (ShapeSearchTree curr_tree : this.compensated_search_trees) {
            ShapeTree.Leaf[] curr_tree_entries = p_item.get_search_tree_entries(curr_tree);
            if (curr_tree_entries == null) continue;
            curr_tree.remove(curr_tree_entries);
        }
        p_item.clear_search_tree_entries();
        p_item.set_on_the_board(false);
    }

    public ShapeSearchTree get_default_tree() {
        return this.default_tree;
    }

    boolean validate_entries(Item p_item) {
        boolean result = true;
        for (ShapeSearchTree curr_tree : this.compensated_search_trees) {
            if (curr_tree.validate_entries(p_item)) continue;
            result = false;
        }
        return result;
    }

    public boolean is_clearance_compensation_used() {
        return this.clearance_compensation_used;
    }

    public void set_clearance_compensation_used(boolean p_value) {
        if (this.clearance_compensation_used == p_value) {
            return;
        }
        this.clearance_compensation_used = p_value;
        this.remove_all_board_items();
        this.compensated_search_trees.clear();
        int compensated_clearance_class_no = p_value ? 1 : 0;
        this.default_tree = new ShapeSearchTree(FortyfiveDegreeBoundingDirections.INSTANCE, this.board, compensated_clearance_class_no);
        this.compensated_search_trees.add(this.default_tree);
        this.insert_all_board_items();
    }

    public void clearance_value_changed() {
        this.compensated_search_trees.removeIf(t -> t.compensated_clearance_class_no != this.default_tree.compensated_clearance_class_no);
        if (this.clearance_compensation_used) {
            this.remove_all_board_items();
            this.insert_all_board_items();
        }
    }

    public void clearance_class_removed(int p_no) {
        Iterator<ShapeSearchTree> it = this.compensated_search_trees.iterator();
        if (p_no == this.default_tree.compensated_clearance_class_no) {
            FRLogger.warn("SearchtreeManager.clearance_class_removed: unable to remove default tree");
            return;
        }
        while (it.hasNext()) {
            ShapeSearchTree curr_tree = it.next();
            if (curr_tree.compensated_clearance_class_no != p_no) continue;
            it.remove();
        }
    }

    public ShapeSearchTree get_autoroute_tree(int p_clearance_class_no) {
        Item curr_item;
        boolean fast_algorithm;
        for (ShapeSearchTree curr_tree : this.compensated_search_trees) {
            if (curr_tree.compensated_clearance_class_no != p_clearance_class_no) continue;
            return curr_tree;
        }
        boolean bl = fast_algorithm = !this.board.rules.get_slow_autoroute_algorithm();
        ShapeSearchTree curr_autoroute_tree = fast_algorithm && this.board.rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE ? new ShapeSearchTree90Degree(this.board, p_clearance_class_no) : (fast_algorithm && this.board.rules.get_trace_angle_restriction() == AngleRestriction.FORTYFIVE_DEGREE ? new ShapeSearchTree45Degree(this.board, p_clearance_class_no) : new ShapeSearchTree(FortyfiveDegreeBoundingDirections.INSTANCE, this.board, p_clearance_class_no));
        this.compensated_search_trees.add(curr_autoroute_tree);
        Iterator<UndoableObjects.UndoableObjectNode> it = this.board.item_list.start_read_object();
        while ((curr_item = (Item)this.board.item_list.read_object(it)) != null) {
            curr_autoroute_tree.insert(curr_item);
        }
        return curr_autoroute_tree;
    }

    public void reset_compensated_trees() {
        this.compensated_search_trees.removeIf(t -> t != this.default_tree);
    }

    void reinsert_tree_items() {
        this.remove_all_board_items();
        this.insert_all_board_items();
    }

    private void remove_all_board_items() {
        Item curr_item;
        if (this.board == null) {
            FRLogger.warn("SearchtreeManager.remove_all_board_items: app.freerouting.board is null");
            return;
        }
        Iterator<UndoableObjects.UndoableObjectNode> it = this.board.item_list.start_read_object();
        while ((curr_item = (Item)this.board.item_list.read_object(it)) != null) {
            this.remove(curr_item);
        }
    }

    private void insert_all_board_items() {
        Item curr_item;
        if (this.board == null) {
            FRLogger.warn("SearchtreeManager.insert_all_board_items: app.freerouting.board is null");
            return;
        }
        Iterator<UndoableObjects.UndoableObjectNode> it = this.board.item_list.start_read_object();
        while ((curr_item = (Item)this.board.item_list.read_object(it)) != null) {
            curr_item.clear_derived_data();
            this.insert(curr_item);
        }
    }

    void merge_entries_in_front(PolylineTrace p_from_trace, PolylineTrace p_to_trace, Polyline p_joined_polyline, int p_from_entry_no, int p_to_entry_no) {
        for (ShapeSearchTree curr_tree : this.compensated_search_trees) {
            curr_tree.merge_entries_in_front(p_from_trace, p_to_trace, p_joined_polyline, p_from_entry_no, p_to_entry_no);
        }
    }

    void merge_entries_at_end(PolylineTrace p_from_trace, PolylineTrace p_to_trace, Polyline p_joined_polyline, int p_from_entry_no, int p_to_entry_no) {
        for (ShapeSearchTree curr_tree : this.compensated_search_trees) {
            curr_tree.merge_entries_at_end(p_from_trace, p_to_trace, p_joined_polyline, p_from_entry_no, p_to_entry_no);
        }
    }

    void change_entries(PolylineTrace p_obj, Polyline p_new_polyline, int p_keep_at_start_count, int p_keep_at_end_count) {
        for (ShapeSearchTree curr_tree : this.compensated_search_trees) {
            curr_tree.change_entries(p_obj, p_new_polyline, p_keep_at_start_count, p_keep_at_end_count);
        }
    }

    void reuse_entries_after_cutout(PolylineTrace p_from_trace, PolylineTrace p_start_piece, PolylineTrace p_end_piece) {
        for (ShapeSearchTree curr_tree : this.compensated_search_trees) {
            curr_tree.reuse_entries_after_cutout(p_from_trace, p_start_piece, p_end_piece);
        }
    }
}

