/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.AngleRestriction;
import app.freerouting.board.BasicBoard;
import app.freerouting.board.ChangedArea;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.DrillItem;
import app.freerouting.board.FixedState;
import app.freerouting.board.Item;
import app.freerouting.board.Pin;
import app.freerouting.board.PullTightAlgo;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.Trace;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.datastructures.Signum;
import app.freerouting.datastructures.Stoppable;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.LineSegment;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.Shape;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.Net;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class PolylineTrace
extends Trace
implements Serializable {
    private static final int MAX_NORMALIZATION_DEPTH = 16;
    private Polyline lines;

    public PolylineTrace(Polyline p_polyline, int p_layer, int p_half_width, int[] p_net_no_arr, int p_clearance_type, int p_id_no, int p_group_no, FixedState p_fixed_state, BasicBoard p_board) {
        super(p_layer, p_half_width, p_net_no_arr, p_clearance_type, p_id_no, p_group_no, p_fixed_state, p_board);
        if (p_polyline.arr.length < 3) {
            FRLogger.warn("PolylineTrace: p_polyline.arr.length >= 3 expected");
        }
        this.lines = p_polyline;
    }

    @Override
    public Item copy(int p_id_no) {
        int[] curr_net_no_arr = new int[this.net_count()];
        for (int i = 0; i < curr_net_no_arr.length; ++i) {
            curr_net_no_arr[i] = this.get_net_no(i);
        }
        return new PolylineTrace(this.lines, this.get_layer(), this.get_half_width(), curr_net_no_arr, this.clearance_class_no(), p_id_no, this.get_component_no(), this.get_fixed_state(), this.board);
    }

    @Override
    public boolean is_on_layer(int p_layer) {
        return this.get_layer() == p_layer;
    }

    @Override
    public Point first_corner() {
        return this.lines.corner(0);
    }

    @Override
    public Point last_corner() {
        return this.lines.corner(this.lines.arr.length - 2);
    }

    public int corner_count() {
        return this.lines.arr.length - 1;
    }

    @Override
    public double get_length() {
        return this.lines.length_approx();
    }

    @Override
    public IntBox bounding_box() {
        IntBox result = this.lines.bounding_box();
        return result.offset(this.get_half_width());
    }

    @Override
    public void draw(Graphics p_g, GraphicsContext p_graphics_context, Color[] p_color_arr, double p_intensity) {
        if (p_graphics_context == null) {
            return;
        }
        int layer = this.get_layer();
        Color color = p_color_arr[layer];
        double display_width = this.get_half_width();
        double intensity = p_intensity * p_graphics_context.get_layer_visibility(layer);
        p_graphics_context.draw(this.lines.corner_approx_arr(), display_width, color, p_g, intensity);
    }

    public Polyline polyline() {
        return this.lines;
    }

    @Override
    protected TileShape[] calculate_tree_shapes(ShapeSearchTree p_search_tree) {
        return p_search_tree.calculate_tree_shapes(this);
    }

    @Override
    public int tile_shape_count() {
        return Math.max(this.lines.arr.length - 2, 0);
    }

    @Override
    public void translate_by(Vector p_vector) {
        this.lines = this.lines.translate_by(p_vector);
        this.clear_derived_data();
    }

    @Override
    public void turn_90_degree(int p_factor, IntPoint p_pole) {
        this.lines = this.lines.turn_90_degree(p_factor, p_pole);
        this.clear_derived_data();
    }

    @Override
    public void rotate_approx(double p_angle_in_degree, FloatPoint p_pole) {
        this.lines = this.lines.rotate_approx(Math.toRadians(p_angle_in_degree), p_pole);
    }

    @Override
    public void change_placement_side(IntPoint p_pole) {
        this.lines = this.lines.mirror_vertical(p_pole);
        if (this.board != null) {
            this.set_layer(this.board.get_layer_count() - this.get_layer() - 1);
        }
        this.clear_derived_data();
    }

    @Override
    public boolean combine() {
        boolean something_changed;
        if (!this.is_on_the_board()) {
            return false;
        }
        if (this.combine_at_start(true)) {
            something_changed = true;
            this.combine();
        } else if (this.combine_at_end(true)) {
            something_changed = true;
            this.combine();
        } else {
            something_changed = false;
        }
        if (something_changed) {
            this.board.communication.observers.notify_changed(this);
            this.board.additional_update_after_change(this);
        }
        return something_changed;
    }

    private boolean combine_at_start(boolean p_ignore_areas) {
        Line[] other_lines;
        Point start_corner = this.first_corner();
        Set<Item> contacts = this.get_normal_contacts(start_corner, false);
        if (p_ignore_areas) {
            contacts.removeIf(c -> c instanceof ConductionArea);
        }
        if (contacts.size() != 1) {
            return false;
        }
        PolylineTrace other_trace = null;
        boolean trace_found = false;
        boolean reverse_order = false;
        for (Item curr_ob : contacts) {
            if (!(curr_ob instanceof PolylineTrace) || (other_trace = (PolylineTrace)curr_ob).get_layer() != this.get_layer() || !other_trace.nets_equal(this) || other_trace.get_half_width() != this.get_half_width() || other_trace.get_fixed_state() != this.get_fixed_state()) continue;
            if (start_corner.equals(other_trace.last_corner())) {
                trace_found = true;
                break;
            }
            if (!start_corner.equals(other_trace.first_corner())) continue;
            reverse_order = true;
            trace_found = true;
            break;
        }
        if (!trace_found) {
            return false;
        }
        this.board.item_list.save_for_undo(this);
        Line[] this_lines = this.lines.arr;
        if (reverse_order) {
            other_lines = new Line[other_trace.lines.arr.length];
            for (int i = 0; i < other_lines.length; ++i) {
                other_lines[i] = other_trace.lines.arr[other_lines.length - 1 - i].opposite();
            }
        } else {
            other_lines = other_trace.lines.arr;
        }
        boolean skip_line = other_lines[other_lines.length - 2].is_equal_or_opposite(this_lines[1]);
        int new_line_count = this_lines.length + other_lines.length - 2;
        if (skip_line) {
            --new_line_count;
        }
        Line[] new_lines = new Line[new_line_count];
        System.arraycopy(other_lines, 0, new_lines, 0, other_lines.length - 1);
        int join_pos = other_lines.length - 1;
        if (skip_line) {
            --join_pos;
        }
        System.arraycopy(this_lines, 1, new_lines, join_pos, this_lines.length - 1);
        Polyline joined_polyline = new Polyline(new_lines);
        if (joined_polyline.arr.length != new_line_count) {
            this.board.search_tree_manager.remove(this);
            this.lines = joined_polyline;
            this.clear_derived_data();
            this.board.search_tree_manager.insert(this);
        } else {
            int to_no = other_lines.length;
            if (skip_line) {
                --to_no;
            }
            this.board.search_tree_manager.merge_entries_in_front(other_trace, this, joined_polyline, other_lines.length - 3, to_no);
            other_trace.clear_search_tree_entries();
            this.lines = joined_polyline;
        }
        if (this.lines.arr.length < 3) {
            this.board.remove_item(this);
        }
        this.board.remove_item(other_trace);
        if (this.board instanceof RoutingBoard) {
            ((RoutingBoard)this.board).join_changed_area(start_corner.to_float(), this.get_layer());
        }
        return true;
    }

    private boolean combine_at_end(boolean p_ignore_areas) {
        Line[] other_lines;
        Point end_corner = this.last_corner();
        Set<Item> contacts = this.get_normal_contacts(end_corner, false);
        if (p_ignore_areas) {
            contacts.removeIf(c -> c instanceof ConductionArea);
        }
        if (contacts.size() != 1) {
            return false;
        }
        PolylineTrace other_trace = null;
        boolean trace_found = false;
        boolean reverse_order = false;
        for (Item curr_ob : contacts) {
            if (!(curr_ob instanceof PolylineTrace) || (other_trace = (PolylineTrace)curr_ob).get_layer() != this.get_layer() || !other_trace.nets_equal(this) || other_trace.get_half_width() != this.get_half_width() || other_trace.get_fixed_state() != this.get_fixed_state()) continue;
            if (end_corner.equals(other_trace.first_corner())) {
                trace_found = true;
                break;
            }
            if (!end_corner.equals(other_trace.last_corner())) continue;
            reverse_order = true;
            trace_found = true;
            break;
        }
        if (!trace_found) {
            return false;
        }
        this.board.item_list.save_for_undo(this);
        Line[] this_lines = this.lines.arr;
        if (reverse_order) {
            other_lines = new Line[other_trace.lines.arr.length];
            for (int i = 0; i < other_lines.length; ++i) {
                other_lines[i] = other_trace.lines.arr[other_lines.length - 1 - i].opposite();
            }
        } else {
            other_lines = other_trace.lines.arr;
        }
        boolean skip_line = this_lines[this_lines.length - 2].is_equal_or_opposite(other_lines[1]);
        int new_line_count = this_lines.length + other_lines.length - 2;
        if (skip_line) {
            --new_line_count;
        }
        Line[] new_lines = new Line[new_line_count];
        System.arraycopy(this_lines, 0, new_lines, 0, this_lines.length - 1);
        int join_pos = this_lines.length - 1;
        if (skip_line) {
            --join_pos;
        }
        System.arraycopy(other_lines, 1, new_lines, join_pos, other_lines.length - 1);
        Polyline joined_polyline = new Polyline(new_lines);
        if (joined_polyline.arr.length != new_line_count) {
            this.board.search_tree_manager.remove(this);
            this.clear_search_tree_entries();
            this.lines = joined_polyline;
            this.clear_derived_data();
            this.board.search_tree_manager.insert(this);
        } else {
            int to_no = this_lines.length;
            if (skip_line) {
                --to_no;
            }
            this.board.search_tree_manager.merge_entries_at_end(other_trace, this, joined_polyline, this_lines.length - 3, to_no);
            other_trace.clear_search_tree_entries();
            this.lines = joined_polyline;
        }
        if (this.lines.arr.length < 3) {
            this.board.remove_item(this);
        }
        this.board.remove_item(other_trace);
        if (this.board instanceof RoutingBoard) {
            ((RoutingBoard)this.board).join_changed_area(end_corner.to_float(), this.get_layer());
        }
        return true;
    }

    @Override
    public Collection<PolylineTrace> split(IntOctagon p_clip_shape) {
        LinkedList<PolylineTrace> result = new LinkedList<PolylineTrace>();
        if (!this.nets_normal()) {
            result.add(this);
            return result;
        }
        boolean own_trace_split = false;
        ShapeSearchTree default_tree = this.board.search_tree_manager.get_default_tree();
        for (int i = 0; i < this.lines.arr.length - 2; ++i) {
            LineSegment lineSegment;
            if (p_clip_shape != null && !p_clip_shape.intersects((lineSegment = new LineSegment(this.lines, i + 1)).bounding_box())) continue;
            TileShape tileShape = this.get_tree_shape(default_tree, i);
            LineSegment curr_line_segment = new LineSegment(this.lines, i + 1);
            LinkedList<ShapeTree.TreeEntry> overlapping_tree_entries = new LinkedList<ShapeTree.TreeEntry>();
            default_tree.overlapping_tree_entries(tileShape, this.get_layer(), overlapping_tree_entries);
            Iterator it = overlapping_tree_entries.iterator();
            while (it.hasNext()) {
                Net curr_net;
                Item found_item;
                if (!this.is_on_the_board()) {
                    return result;
                }
                ShapeTree.TreeEntry found_entry = (ShapeTree.TreeEntry)it.next();
                if (!(found_entry.object instanceof Item) || (found_item = (Item)found_entry.object) == this && (found_entry.shape_index_in_object >= i - 1 && found_entry.shape_index_in_object <= i + 1 || (i >= found_entry.shape_index_in_object ? this.lines.corner(found_entry.shape_index_in_object + 1).equals(this.lines.corner(i)) : this.lines.corner(i + 1).equals(this.lines.corner(found_entry.shape_index_in_object)))) || !found_item.shares_net(this)) continue;
                if (found_item instanceof PolylineTrace) {
                    int j;
                    PolylineTrace found_trace = (PolylineTrace)found_item;
                    LineSegment found_line_segment = new LineSegment(found_trace.lines, found_entry.shape_index_in_object + 1);
                    Line[] intersecting_lines = found_line_segment.intersection(curr_line_segment);
                    LinkedList<PolylineTrace> split_pieces = new LinkedList<PolylineTrace>();
                    boolean found_trace_split = false;
                    if (found_trace != this) {
                        for (j = 0; j < intersecting_lines.length; ++j) {
                            int line_no = found_entry.shape_index_in_object + 1;
                            PolylineTrace[] curr_split_pieces = found_trace.split(line_no, intersecting_lines[j]);
                            if (curr_split_pieces == null) continue;
                            for (int k = 0; k < 2; ++k) {
                                if (curr_split_pieces[k] == null) continue;
                                found_trace_split = true;
                                split_pieces.add(curr_split_pieces[k]);
                            }
                            if (!found_trace_split) continue;
                            default_tree.overlapping_tree_entries(tileShape, this.get_layer(), overlapping_tree_entries);
                            it = overlapping_tree_entries.iterator();
                            break;
                        }
                        if (!found_trace_split) {
                            split_pieces.add(found_trace);
                        }
                    }
                    intersecting_lines = curr_line_segment.intersection(found_line_segment);
                    for (j = 0; j < intersecting_lines.length; ++j) {
                        PolylineTrace[] curr_split_pieces = this.split(i + 1, intersecting_lines[j]);
                        if (curr_split_pieces == null) continue;
                        own_trace_split = true;
                        if (curr_split_pieces[0] != null) {
                            result.addAll(curr_split_pieces[0].split(p_clip_shape));
                        }
                        if (curr_split_pieces[1] == null) break;
                        result.addAll(curr_split_pieces[1].split(p_clip_shape));
                        break;
                    }
                    if (found_trace_split || own_trace_split) {
                        Iterator it2 = split_pieces.iterator();
                        for (int j2 = 0; j2 < 2; ++j2) {
                            while (it2.hasNext()) {
                                PolylineTrace curr_piece = (PolylineTrace)it2.next();
                                this.board.remove_if_cycle(curr_piece);
                            }
                            it2 = result.iterator();
                        }
                    }
                    if (!own_trace_split) continue;
                    break;
                }
                if (found_item instanceof DrillItem) {
                    DrillItem curr_drill_item = (DrillItem)found_item;
                    Point split_point = curr_drill_item.get_center();
                    if (!curr_line_segment.contains(split_point)) continue;
                    Direction split_line_direction = curr_line_segment.get_line().direction().turn_45_degree(2);
                    Line split_line = new Line(split_point, split_line_direction);
                    this.split(i + 1, split_line);
                    continue;
                }
                if (this.is_user_fixed() || !(found_item instanceof ConductionArea)) continue;
                boolean ignore_areas = false;
                if (this.net_no_arr.length > 0 && (curr_net = this.board.rules.nets.get(this.net_no_arr[0])) != null && curr_net.get_class() != null) {
                    ignore_areas = curr_net.get_class().get_ignore_cycles_with_areas();
                }
                if (ignore_areas || !this.get_start_contacts().contains(found_item) || !this.get_end_contacts().contains(found_item)) continue;
                this.board.remove_item(this);
                return result;
            }
            if (own_trace_split) break;
        }
        if (!own_trace_split) {
            result.add(this);
        }
        if (result.size() > 1) {
            for (Item item : result) {
                this.board.additional_update_after_change(item);
            }
        }
        return result;
    }

    private boolean split_inside_drill_pad_prohibited(int p_line_no, Line p_line) {
        if (this.board == null) {
            return false;
        }
        Point intersection = this.lines.arr[p_line_no].intersection(p_line);
        Set<Item> overlap_items = this.board.pick_items(intersection, this.get_layer(), null);
        boolean pad_found = false;
        for (Item curr_item : overlap_items) {
            Trace curr_trace;
            if (!curr_item.shares_net(this)) continue;
            if (curr_item instanceof Pin) {
                DrillItem curr_drill_item = (DrillItem)curr_item;
                if (curr_drill_item.get_center().equals(intersection)) {
                    return false;
                }
                pad_found = true;
                continue;
            }
            if (!(curr_item instanceof Trace) || ((curr_trace = (Trace)curr_item) == this || !curr_trace.first_corner().equals(intersection)) && !curr_trace.last_corner().equals(intersection)) continue;
            return false;
        }
        return pad_found;
    }

    @Override
    public Trace[] split(Point p_point) {
        for (int i = 0; i < this.lines.arr.length - 2; ++i) {
            Direction split_line_direction;
            Line split_line;
            Trace[] result;
            LineSegment curr_line_segment = new LineSegment(this.lines, i + 1);
            if (!curr_line_segment.contains(p_point) || (result = this.split(i + 1, split_line = new Line(p_point, split_line_direction = curr_line_segment.get_line().direction().turn_45_degree(2)))) == null) continue;
            return result;
        }
        return null;
    }

    private PolylineTrace[] split(int p_line_no, Line p_new_end_line) {
        if (!this.is_on_the_board()) {
            return null;
        }
        Polyline[] split_polylines = this.lines.split(p_line_no, p_new_end_line);
        if (split_polylines == null) {
            return null;
        }
        if (split_polylines.length != 2) {
            FRLogger.warn("PolylineTrace.split: array of length 2 expected for split_polylines");
            return null;
        }
        if (this.split_inside_drill_pad_prohibited(p_line_no, p_new_end_line)) {
            return null;
        }
        this.board.remove_item(this);
        PolylineTrace[] result = new PolylineTrace[]{this.board.insert_trace_without_cleaning(split_polylines[0], this.get_layer(), this.get_half_width(), this.net_no_arr, this.clearance_class_no(), this.get_fixed_state()), this.board.insert_trace_without_cleaning(split_polylines[1], this.get_layer(), this.get_half_width(), this.net_no_arr, this.clearance_class_no(), this.get_fixed_state())};
        return result;
    }

    public boolean normalize(IntOctagon p_clip_shape) throws Exception {
        return this.normalize(p_clip_shape, 0);
    }

    private boolean normalize(IntOctagon p_clip_shape, int normalization_depth) throws Exception {
        Collection<PolylineTrace> split_pieces;
        if (normalization_depth > 16) {
            throw new Exception("We reached the maximum normalization depth (16).");
        }
        boolean observers_activated = false;
        BasicBoard routing_board = this.board;
        if (this.board != null) {
            boolean bl = observers_activated = !routing_board.observers_active();
            if (observers_activated) {
                routing_board.start_notify_observers();
            }
        }
        boolean result = (split_pieces = this.split(p_clip_shape)).size() != 1;
        for (PolylineTrace curr_split_trace : split_pieces) {
            if (!curr_split_trace.is_on_the_board()) continue;
            boolean trace_combined = curr_split_trace.combine();
            if (curr_split_trace.corner_count() == 2 && curr_split_trace.first_corner().equals(curr_split_trace.last_corner())) {
                this.board.remove_item(curr_split_trace);
                result = true;
                continue;
            }
            if (!trace_combined) continue;
            curr_split_trace.normalize(p_clip_shape, normalization_depth + 1);
            result = true;
        }
        if (observers_activated) {
            routing_board.end_notify_observers();
        }
        return result;
    }

    @Override
    public boolean pull_tight(PullTightAlgo p_pull_tight_algo) {
        if (!this.is_on_the_board()) {
            return false;
        }
        if (this.is_shove_fixed()) {
            return false;
        }
        if (!this.nets_normal()) {
            return false;
        }
        if (p_pull_tight_algo.only_net_no_arr.length > 0 && !this.nets_equal(p_pull_tight_algo.only_net_no_arr)) {
            return false;
        }
        if (this.net_no_arr.length > 0 && !this.board.rules.nets.get(this.net_no_arr[0]).get_class().get_pull_tight()) {
            return false;
        }
        Polyline new_lines = p_pull_tight_algo.pull_tight(this.lines, this.get_layer(), this.get_half_width(), this.net_no_arr, this.clearance_class_no(), this.touching_pins_at_end_corners());
        if (new_lines != this.lines) {
            this.change(new_lines);
            return true;
        }
        AngleRestriction angle_restriction = this.board.rules.get_trace_angle_restriction();
        if (angle_restriction != AngleRestriction.NINETY_DEGREE && this.board.rules.get_pin_edge_to_turn_dist() > 0.0) {
            if (this.swap_connection_to_pin(true)) {
                this.pull_tight(p_pull_tight_algo);
                return true;
            }
            if (this.swap_connection_to_pin(false)) {
                this.pull_tight(p_pull_tight_algo);
                return true;
            }
            if (this.correct_connection_to_pin(true, angle_restriction)) {
                this.pull_tight(p_pull_tight_algo);
                return true;
            }
            if (this.correct_connection_to_pin(false, angle_restriction)) {
                this.pull_tight(p_pull_tight_algo);
                return true;
            }
        }
        return false;
    }

    public boolean pull_tight(boolean p_own_net_only, int p_pull_tight_accuracy, Stoppable p_stoppable_thread) {
        if (!(this.board instanceof RoutingBoard)) {
            return false;
        }
        int[] opt_net_no_arr = p_own_net_only ? this.net_no_arr : new int[]{};
        PullTightAlgo pull_tight_algo = PullTightAlgo.get_instance((RoutingBoard)this.board, opt_net_no_arr, null, p_pull_tight_accuracy, p_stoppable_thread, -1, null, -1);
        return this.pull_tight(pull_tight_algo);
    }

    public boolean smoothen_end_corners_fork(boolean p_own_net_only, int p_pull_tight_accuracy, Stoppable p_stoppable_thread) {
        if (!(this.board instanceof RoutingBoard)) {
            return false;
        }
        int[] opt_net_no_arr = p_own_net_only ? this.net_no_arr : new int[]{};
        PullTightAlgo pull_tight_algo = PullTightAlgo.get_instance((RoutingBoard)this.board, opt_net_no_arr, null, p_pull_tight_accuracy, p_stoppable_thread, -1, null, -1);
        return pull_tight_algo.smoothen_end_corners_at_trace(this);
    }

    @Override
    public TileShape get_trace_connection_shape(ShapeSearchTree p_search_tree, int p_index) {
        if (p_index < 0 || p_index >= this.tile_shape_count()) {
            FRLogger.warn("PolylineTrace.get_trace_connection_shape p_index out of range");
            return null;
        }
        LineSegment curr_line_segment = new LineSegment(this.lines, p_index + 1);
        return curr_line_segment.to_simplex().simplify();
    }

    @Override
    public boolean write(ObjectOutputStream p_stream) {
        try {
            p_stream.writeObject(this);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    void change(Polyline p_new_polyline) {
        ChangedArea changed_area;
        int last_index;
        if (!this.is_on_the_board()) {
            this.lines = p_new_polyline;
            return;
        }
        this.board.additional_update_after_change(this);
        this.board.item_list.save_for_undo(this);
        int index_of_first_different_line = last_index = Math.min(p_new_polyline.arr.length, this.lines.arr.length);
        for (int i = 0; i < last_index; ++i) {
            if (p_new_polyline.arr[i] == this.lines.arr[i]) continue;
            index_of_first_different_line = i;
            break;
        }
        if (index_of_first_different_line == last_index) {
            return;
        }
        int index_of_last_different_line = -1;
        for (int i = 1; i <= last_index; ++i) {
            if (p_new_polyline.arr[p_new_polyline.arr.length - i] == this.lines.arr[this.lines.arr.length - i]) continue;
            index_of_last_different_line = p_new_polyline.arr.length - i;
            break;
        }
        if (index_of_last_different_line < 0) {
            return;
        }
        int keep_at_start_count = Math.max(index_of_first_different_line - 2, 0);
        int keep_at_end_count = Math.max(p_new_polyline.arr.length - index_of_last_different_line - 3, 0);
        this.board.search_tree_manager.change_entries(this, p_new_polyline, keep_at_start_count, keep_at_end_count);
        this.lines = p_new_polyline;
        this.board.communication.observers.notify_changed(this);
        IntOctagon clip_shape = null;
        if (this.board instanceof RoutingBoard && (changed_area = ((RoutingBoard)this.board).changed_area) != null) {
            clip_shape = changed_area.get_area(this.get_layer());
        }
        try {
            this.normalize(clip_shape);
        }
        catch (Exception e) {
            FRLogger.error("Couldn't change the trace, because its normalization failed.", e);
        }
    }

    @Override
    public boolean check_connection_to_pin(boolean p_at_start) {
        Point prev_end_corner;
        Point end_corner;
        if (this.board == null) {
            return true;
        }
        if (this.corner_count() < 2) {
            return true;
        }
        Set<Item> contact_list = p_at_start ? this.get_start_contacts() : this.get_end_contacts();
        Pin contact_pin = null;
        for (Item curr_contact : contact_list) {
            if (!(curr_contact instanceof Pin)) continue;
            contact_pin = (Pin)curr_contact;
            break;
        }
        if (contact_pin == null) {
            return true;
        }
        Collection<Pin.TraceExitRestriction> trace_exit_restrictions = contact_pin.get_trace_exit_restrictions(this.get_layer());
        if (trace_exit_restrictions.isEmpty()) {
            return true;
        }
        if (p_at_start) {
            end_corner = this.first_corner();
            prev_end_corner = this.lines.corner(1);
        } else {
            end_corner = this.last_corner();
            prev_end_corner = this.lines.corner(this.lines.corner_count() - 2);
        }
        Direction trace_end_direction = Direction.get_instance(end_corner, prev_end_corner);
        if (trace_end_direction == null) {
            return true;
        }
        Pin.TraceExitRestriction matching_exit_restriction = null;
        for (Pin.TraceExitRestriction curr_exit_restriction : trace_exit_restrictions) {
            if (!curr_exit_restriction.direction.equals(trace_end_direction)) continue;
            matching_exit_restriction = curr_exit_restriction;
            break;
        }
        if (matching_exit_restriction == null) {
            return false;
        }
        double edge_to_turn_dist = this.board.rules.get_pin_edge_to_turn_dist();
        if (edge_to_turn_dist < 0.0) {
            return false;
        }
        double end_line_length = end_corner.to_float().distance(prev_end_corner.to_float());
        double curr_clearance = this.board.clearance_value(this.clearance_class_no(), contact_pin.clearance_class_no(), this.get_layer());
        double add_width = Math.max(edge_to_turn_dist, curr_clearance + 1.0);
        double preserve_length = matching_exit_restriction.min_length + (double)this.get_half_width() + add_width;
        return !(preserve_length > end_line_length);
    }

    public boolean correct_connection_to_pin(boolean p_at_start, AngleRestriction p_angle_restriction) {
        Line[] curr_lines;
        Set<Item> contact_list;
        Polyline trace_polyline;
        if (this.check_connection_to_pin(p_at_start)) {
            return false;
        }
        if (p_at_start) {
            trace_polyline = this.polyline();
            contact_list = this.get_start_contacts();
        } else {
            trace_polyline = this.polyline().reverse();
            contact_list = this.get_end_contacts();
        }
        Pin contact_pin = null;
        for (Item curr_contact : contact_list) {
            if (!(curr_contact instanceof Pin)) continue;
            contact_pin = (Pin)curr_contact;
            break;
        }
        if (contact_pin == null) {
            return false;
        }
        Collection<Pin.TraceExitRestriction> trace_exit_restrictions = contact_pin.get_trace_exit_restrictions(this.get_layer());
        if (trace_exit_restrictions.isEmpty()) {
            return false;
        }
        Shape pin_shape = contact_pin.get_shape(this.get_layer() - contact_pin.first_layer());
        if (!(pin_shape instanceof TileShape)) {
            return false;
        }
        Point pin_center = contact_pin.get_center();
        double edge_to_turn_dist = this.board.rules.get_pin_edge_to_turn_dist();
        if (edge_to_turn_dist < 0.0) {
            return false;
        }
        double curr_clearance = this.board.clearance_value(this.clearance_class_no(), contact_pin.clearance_class_no(), this.get_layer());
        double add_width = Math.max(edge_to_turn_dist, curr_clearance + 1.0);
        TileShape offset_pin_shape = (TileShape)((TileShape)pin_shape).offset((double)this.get_half_width() + add_width);
        if (p_angle_restriction == AngleRestriction.NINETY_DEGREE || offset_pin_shape.is_IntBox()) {
            offset_pin_shape = offset_pin_shape.bounding_box();
        } else if (p_angle_restriction == AngleRestriction.FORTYFIVE_DEGREE) {
            offset_pin_shape = offset_pin_shape.bounding_octagon();
        }
        int[][] entries = offset_pin_shape.entrance_points(trace_polyline);
        if (entries.length == 0) {
            return false;
        }
        int[] latest_entry_tuple = entries[entries.length - 1];
        FloatPoint trace_entry_location_approx = trace_polyline.arr[latest_entry_tuple[0]].intersection_approx(offset_pin_shape.border_line(latest_entry_tuple[1]));
        double min_exit_corner_distance = Double.MAX_VALUE;
        Line nearest_pin_exit_ray = null;
        int nearest_border_line_no = -1;
        Direction pin_exit_direction = null;
        FloatPoint nearest_exit_corner = null;
        double TOLERANCE = 1.0;
        for (Pin.TraceExitRestriction curr_exit_restriction : trace_exit_restrictions) {
            int curr_intersecting_border_line_no = offset_pin_shape.intersecting_border_line_no(pin_center, curr_exit_restriction.direction);
            Line curr_pin_exit_ray = new Line(pin_center, curr_exit_restriction.direction);
            FloatPoint curr_exit_corner = curr_pin_exit_ray.intersection_approx(offset_pin_shape.border_line(curr_intersecting_border_line_no));
            double curr_exit_corner_distance = curr_exit_corner.distance_square(trace_entry_location_approx);
            boolean new_nearest_corner_found = false;
            if (curr_exit_corner_distance + 1.0 < min_exit_corner_distance) {
                new_nearest_corner_found = true;
            } else if (curr_exit_corner_distance < min_exit_corner_distance + 1.0) {
                for (int i = 1; i < trace_polyline.corner_count(); ++i) {
                    double old_trace_corner_distance;
                    FloatPoint curr_trace_corner = trace_polyline.corner_approx(i);
                    double curr_trace_corner_distance = curr_trace_corner.distance_square(curr_exit_corner);
                    if (curr_trace_corner_distance + 1.0 < (old_trace_corner_distance = curr_trace_corner.distance_square(nearest_exit_corner))) {
                        new_nearest_corner_found = true;
                        break;
                    }
                    if (curr_trace_corner_distance > old_trace_corner_distance + 1.0) break;
                }
            }
            if (!new_nearest_corner_found) continue;
            min_exit_corner_distance = curr_exit_corner_distance;
            nearest_pin_exit_ray = curr_pin_exit_ray;
            nearest_border_line_no = curr_intersecting_border_line_no;
            pin_exit_direction = curr_exit_restriction.direction;
            nearest_exit_corner = curr_exit_corner;
        }
        int corner_count = offset_pin_shape.border_line_count();
        int clock_wise_side_diff = (nearest_border_line_no - latest_entry_tuple[1] + corner_count) % corner_count;
        int counter_clock_wise_side_diff = (latest_entry_tuple[1] - nearest_border_line_no + corner_count) % corner_count;
        int curr_border_line_no = nearest_border_line_no;
        if (counter_clock_wise_side_diff <= clock_wise_side_diff) {
            curr_lines = new Line[counter_clock_wise_side_diff + 3];
            for (i = 0; i <= counter_clock_wise_side_diff; ++i) {
                curr_lines[i + 1] = offset_pin_shape.border_line(curr_border_line_no);
                curr_border_line_no = (curr_border_line_no + 1) % corner_count;
            }
        } else {
            curr_lines = new Line[clock_wise_side_diff + 3];
            for (i = 0; i <= clock_wise_side_diff; ++i) {
                curr_lines[i + 1] = offset_pin_shape.border_line(curr_border_line_no);
                curr_border_line_no = (curr_border_line_no - 1 + corner_count) % corner_count;
            }
        }
        curr_lines[0] = nearest_pin_exit_ray;
        curr_lines[curr_lines.length - 1] = trace_polyline.arr[latest_entry_tuple[0]];
        Polyline border_polyline = new Polyline(curr_lines);
        if (!this.board.check_polyline_trace(border_polyline, this.get_layer(), this.get_half_width(), this.net_no_arr, this.clearance_class_no())) {
            return false;
        }
        Line[] cut_lines = new Line[trace_polyline.arr.length - latest_entry_tuple[0] + 1];
        cut_lines[0] = curr_lines[curr_lines.length - 2];
        System.arraycopy(trace_polyline.arr, latest_entry_tuple[0], cut_lines, 1, cut_lines.length - 1);
        Polyline cut_polyline = new Polyline(cut_lines);
        Polyline changed_polyline = cut_polyline.first_corner().equals(cut_polyline.last_corner()) ? border_polyline : border_polyline.combine(cut_polyline);
        if (!p_at_start) {
            changed_polyline = changed_polyline.reverse();
        }
        this.change(changed_polyline);
        curr_lines = new Line[]{new Line(pin_center, pin_exit_direction.turn_45_degree(2)), nearest_pin_exit_ray, offset_pin_shape.border_line(nearest_border_line_no)};
        Polyline exit_line_segment = new Polyline(curr_lines);
        this.board.insert_trace(exit_line_segment, this.get_layer(), this.get_half_width(), this.net_no_arr, this.clearance_class_no(), FixedState.SHOVE_FIXED);
        return true;
    }

    public boolean swap_connection_to_pin(boolean p_at_start) {
        boolean check_swap;
        Set<Item> contact_list;
        Polyline trace_polyline;
        if (p_at_start) {
            trace_polyline = this.polyline();
            contact_list = this.get_start_contacts();
        } else {
            trace_polyline = this.polyline().reverse();
            contact_list = this.get_end_contacts();
        }
        if (contact_list.size() != 1) {
            return false;
        }
        Item curr_contact = (Item)contact_list.iterator().next();
        if (curr_contact.get_fixed_state() != FixedState.SHOVE_FIXED || !(curr_contact instanceof PolylineTrace)) {
            return false;
        }
        PolylineTrace contact_trace = (PolylineTrace)curr_contact;
        Polyline contact_polyline = contact_trace.polyline();
        Line contact_last_line = contact_polyline.arr[contact_polyline.arr.length - 2];
        Line first_line = trace_polyline.arr[1];
        boolean bl = check_swap = contact_last_line.direction().projection(first_line.direction()) == Signum.NEGATIVE;
        if (!check_swap) {
            double half_width = this.get_half_width();
            if (trace_polyline.arr.length > 3 && trace_polyline.corner_approx(0).distance_square(trace_polyline.corner_approx(1)) <= half_width * half_width) {
                boolean bl2 = check_swap = contact_last_line.direction().projection(trace_polyline.arr[2].direction()) == Signum.NEGATIVE;
            }
        }
        if (!check_swap) {
            return false;
        }
        Pin contact_pin = null;
        Set<Item> curr_contacts = contact_trace.get_start_contacts();
        for (Item tmp_contact : curr_contacts) {
            if (!(tmp_contact instanceof Pin)) continue;
            contact_pin = (Pin)tmp_contact;
            break;
        }
        if (contact_pin == null) {
            return false;
        }
        Polyline combined_polyline = contact_polyline.combine(trace_polyline);
        Direction nearest_pin_exit_direction = contact_pin.calc_nearest_exit_restriction_direction(combined_polyline, this.get_half_width(), this.get_layer());
        if (nearest_pin_exit_direction == null || nearest_pin_exit_direction.equals(contact_polyline.arr[1].direction())) {
            return false;
        }
        contact_trace.set_fixed_state(this.get_fixed_state());
        this.combine();
        return true;
    }
}

