/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.Component;
import app.freerouting.board.ComponentOutline;
import app.freerouting.board.DrillItem;
import app.freerouting.board.Item;
import app.freerouting.board.MoveDrillItemAlgo;
import app.freerouting.board.ObstacleArea;
import app.freerouting.board.RoutingBoard;
import app.freerouting.datastructures.Signum;
import app.freerouting.datastructures.TimeLimit;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Vector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class MoveComponent {
    private static final int PULL_TIGHT_TIME_LIMIT = 1000;
    private static final int CHECK_TIME_LIMIT = 3000;
    private final Vector translate_vector;
    private final int max_recursion_depth;
    private final int max_via_recursion_depth;
    private final RoutingBoard board;
    private boolean all_items_movable = true;
    private SortedItem[] item_group_arr;
    private Component component;

    public MoveComponent(Item p_item, Vector p_translate_vector, int p_max_recursion_depth, int p_max_via_recursion_depth) {
        Collection<Object> item_group_list;
        this.translate_vector = p_translate_vector;
        this.max_recursion_depth = p_max_recursion_depth;
        this.max_via_recursion_depth = p_max_via_recursion_depth;
        if (p_item.board instanceof RoutingBoard) {
            this.board = (RoutingBoard)p_item.board;
        } else {
            this.board = null;
            this.all_items_movable = false;
        }
        int component_no = p_item.get_component_no();
        if (component_no > 0) {
            item_group_list = this.board.get_component_items(component_no);
            this.component = this.board.components.get(component_no);
        } else {
            item_group_list = new LinkedList();
            item_group_list.add(p_item);
        }
        LinkedList<FloatPoint> item_centers = new LinkedList<FloatPoint>();
        for (Item item : item_group_list) {
            boolean curr_item_movable;
            boolean bl = curr_item_movable = !item.is_user_fixed() && (item instanceof DrillItem || item instanceof ObstacleArea || item instanceof ComponentOutline);
            if (!curr_item_movable) {
                this.all_items_movable = false;
                return;
            }
            if (!(item instanceof DrillItem)) continue;
            item_centers.add(((DrillItem)item).get_center().to_float());
        }
        double gravity_x = 0.0;
        double gravity_y = 0.0;
        for (FloatPoint curr_center : item_centers) {
            gravity_x += curr_center.x;
            gravity_y += curr_center.y;
        }
        IntPoint gravity_point = new IntPoint((int)Math.round(gravity_x /= (double)item_centers.size()), (int)Math.round(gravity_y /= (double)item_centers.size()));
        this.item_group_arr = new SortedItem[item_group_list.size()];
        Iterator<Object> it = item_group_list.iterator();
        for (int i = 0; i < this.item_group_arr.length; ++i) {
            Item curr_item = (Item)it.next();
            Point item_center = curr_item instanceof DrillItem ? ((DrillItem)curr_item).get_center() : curr_item.bounding_box().centre_of_gravity().round();
            Vector compare_vector = ((Point)gravity_point).difference_by(item_center);
            double curr_projection = compare_vector.scalar_product(this.translate_vector);
            this.item_group_arr[i] = new SortedItem(curr_item, curr_projection);
        }
        Arrays.sort(this.item_group_arr);
    }

    public boolean check() {
        if (!this.all_items_movable) {
            return false;
        }
        TimeLimit time_limit = new TimeLimit(3000);
        LinkedList<Item> ignore_items = new LinkedList<Item>();
        for (int i = 0; i < this.item_group_arr.length; ++i) {
            boolean move_ok;
            if (this.item_group_arr[i].item instanceof DrillItem) {
                DrillItem curr_drill_item = (DrillItem)this.item_group_arr[i].item;
                move_ok = this.translate_vector.length_approx() >= curr_drill_item.min_width() ? false : MoveDrillItemAlgo.check(curr_drill_item, this.translate_vector, this.max_recursion_depth, this.max_via_recursion_depth, ignore_items, this.board, time_limit);
            } else {
                move_ok = this.board.check_move_item(this.item_group_arr[i].item, this.translate_vector, ignore_items);
            }
            if (move_ok) continue;
            return false;
        }
        return true;
    }

    public boolean insert(int p_tidy_width, int p_pull_tight_accuracy) {
        if (!this.all_items_movable) {
            return false;
        }
        if (this.component != null) {
            this.board.components.move(this.component.no, this.translate_vector);
            this.board.communication.observers.notify_moved(this.component);
        }
        for (int i = 0; i < this.item_group_arr.length; ++i) {
            if (this.item_group_arr[i].item instanceof DrillItem) {
                DrillItem curr_drill_item = (DrillItem)this.item_group_arr[i].item;
                boolean move_ok = this.board.move_drill_item(curr_drill_item, this.translate_vector, this.max_recursion_depth, this.max_via_recursion_depth, p_tidy_width, p_pull_tight_accuracy, 1000);
                if (move_ok) continue;
                if (this.component != null) {
                    this.component.translate_by(this.translate_vector.negate());
                }
                return false;
            }
            this.item_group_arr[i].item.move_by(this.translate_vector);
        }
        return true;
    }

    private static class SortedItem
    implements Comparable<SortedItem> {
        final Item item;
        final double projection;

        SortedItem(Item p_item, double p_projection) {
            this.item = p_item;
            this.projection = p_projection;
        }

        @Override
        public int compareTo(SortedItem p_other) {
            return Signum.as_int(this.projection - p_other.projection);
        }
    }
}

