/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.autoroute.ItemAutorouteInfo;
import app.freerouting.board.BasicBoard;
import app.freerouting.board.ClearanceViolation;
import app.freerouting.board.ConductionArea;
import app.freerouting.board.Connectable;
import app.freerouting.board.DrillItem;
import app.freerouting.board.FixedState;
import app.freerouting.board.ItemSearchTreesInfo;
import app.freerouting.board.ItemSelectionFilter;
import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.SearchTreeObject;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.boardgraphics.Drawable;
import app.freerouting.boardgraphics.GraphicsContext;
import app.freerouting.datastructures.ShapeTree;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import app.freerouting.rules.Net;
import app.freerouting.rules.Nets;
import java.awt.Color;
import java.awt.Graphics;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public abstract class Item
implements Drawable,
SearchTreeObject,
ObjectInfoPanel.Printable,
UndoableObjects.Storable,
Serializable {
    private static final double PROTECT_FANOUT_LENGTH = 400.0;
    private final int id_no;
    public transient BasicBoard board;
    int[] net_no_arr;
    private int clearance_class;
    private transient ItemSearchTreesInfo search_trees_info;
    private FixedState fixed_state;
    private int component_no;
    private boolean on_the_board = false;
    private transient ItemAutorouteInfo autoroute_info;
    public double smallest_clearance;

    Item(int[] p_net_no_arr, int p_clearance_type, int p_id_no, int p_component_no, FixedState p_fixed_state, BasicBoard p_board) {
        if (p_net_no_arr == null) {
            this.net_no_arr = new int[0];
        } else {
            this.net_no_arr = new int[p_net_no_arr.length];
            System.arraycopy(p_net_no_arr, 0, this.net_no_arr, 0, p_net_no_arr.length);
        }
        this.clearance_class = p_clearance_type;
        this.component_no = p_component_no;
        this.fixed_state = p_fixed_state;
        this.board = p_board;
        this.id_no = p_id_no <= 0 ? this.board.communication.id_no_generator.new_no() : p_id_no;
    }

    @Override
    public int compareTo(Object p_other) {
        int result = p_other instanceof Item ? ((Item)p_other).id_no - this.id_no : 1;
        return result;
    }

    public int get_id_no() {
        return this.id_no;
    }

    public boolean contains_net(int p_net_no) {
        if (p_net_no <= 0) {
            return false;
        }
        for (int i = 0; i < this.net_no_arr.length; ++i) {
            if (this.net_no_arr[i] != p_net_no) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean is_obstacle(int p_net_no) {
        return !this.contains_net(p_net_no);
    }

    @Override
    public boolean is_trace_obstacle(int p_net_no) {
        return !this.contains_net(p_net_no);
    }

    public abstract boolean is_obstacle(Item var1);

    public boolean shares_net(Item p_other) {
        return this.shares_net_no(p_other.net_no_arr);
    }

    public boolean shares_net_no(int[] p_net_no_arr) {
        for (int i = 0; i < this.net_no_arr.length; ++i) {
            for (int j = 0; j < p_net_no_arr.length; ++j) {
                if (this.net_no_arr[i] != p_net_no_arr[j]) continue;
                return true;
            }
        }
        return false;
    }

    public abstract int tile_shape_count();

    public TileShape get_tile_shape(int p_index) {
        if (this.board == null) {
            FRLogger.warn("Item.get_tile_shape: app.freerouting.board is null");
            return null;
        }
        return this.get_tree_shape(this.board.search_tree_manager.get_default_tree(), p_index);
    }

    @Override
    public int tree_shape_count(ShapeTree p_tree) {
        if (this.board == null) {
            return 0;
        }
        TileShape[] precalculated_tree_shapes = this.get_precalculated_tree_shapes(p_tree);
        return precalculated_tree_shapes.length;
    }

    @Override
    public TileShape get_tree_shape(ShapeTree p_tree, int p_index) {
        if (this.board == null) {
            return null;
        }
        TileShape[] precalculated_tree_shapes = this.get_precalculated_tree_shapes(p_tree);
        return precalculated_tree_shapes[p_index];
    }

    private TileShape[] get_precalculated_tree_shapes(ShapeTree p_tree) {
        TileShape[] precalculated_tree_shapes;
        if (this.search_trees_info == null) {
            this.search_trees_info = new ItemSearchTreesInfo();
        }
        if ((precalculated_tree_shapes = this.search_trees_info.get_precalculated_tree_shapes(p_tree)) == null) {
            precalculated_tree_shapes = this.calculate_tree_shapes((ShapeSearchTree)p_tree);
            this.search_trees_info.set_precalculated_tree_shapes(precalculated_tree_shapes, p_tree);
        }
        return precalculated_tree_shapes;
    }

    protected abstract TileShape[] calculate_tree_shapes(ShapeSearchTree var1);

    public boolean is_on_the_board() {
        return this.on_the_board;
    }

    void set_on_the_board(boolean p_value) {
        this.on_the_board = p_value;
    }

    public abstract Item copy(int var1);

    @Override
    public Object clone() {
        Item dup = this.copy(this.get_id_no());
        dup.on_the_board = this.on_the_board;
        return dup;
    }

    public abstract boolean is_on_layer(int var1);

    public abstract int first_layer();

    public abstract int last_layer();

    public abstract boolean write(ObjectOutputStream var1);

    public abstract void translate_by(Vector var1);

    public abstract void turn_90_degree(int var1, IntPoint var2);

    public abstract void rotate_approx(double var1, FloatPoint var3);

    public abstract void change_placement_side(IntPoint var1);

    public abstract IntBox bounding_box();

    public void move_by(Vector p_vector) {
        this.board.item_list.save_for_undo(this);
        this.board.search_tree_manager.remove(this);
        this.translate_by(p_vector);
        this.board.search_tree_manager.insert(this);
        this.board.communication.observers.notify_changed(this);
    }

    public boolean shares_layer(Item p_other) {
        int min_last_layer;
        int max_first_layer = Math.max(this.first_layer(), p_other.first_layer());
        return max_first_layer <= (min_last_layer = Math.min(this.last_layer(), p_other.last_layer()));
    }

    public int first_common_layer(Item p_other) {
        int min_last_layer;
        int max_first_layer = Math.max(this.first_layer(), p_other.first_layer());
        if (max_first_layer > (min_last_layer = Math.min(this.last_layer(), p_other.last_layer()))) {
            return -1;
        }
        return max_first_layer;
    }

    public int last_common_layer(Item p_other) {
        int min_last_layer;
        int max_first_layer = Math.max(this.first_layer(), p_other.first_layer());
        if (max_first_layer > (min_last_layer = Math.min(this.last_layer(), p_other.last_layer()))) {
            return -1;
        }
        return min_last_layer;
    }

    public String component_name() {
        if (this.component_no <= 0) {
            return null;
        }
        return this.board.components.get((int)this.component_no).name;
    }

    public int clearance_violation_count() {
        Collection<ClearanceViolation> violations = this.clearance_violations();
        return violations.size();
    }

    public Collection<ClearanceViolation> clearance_violations() {
        LinkedList<ClearanceViolation> result = new LinkedList<ClearanceViolation>();
        if (this.board == null) {
            return result;
        }
        ShapeSearchTree default_tree = this.board.search_tree_manager.get_default_tree();
        for (int i = 0; i < this.tile_shape_count(); ++i) {
            TileShape curr_tile_shape = this.get_tile_shape(i);
            Collection<ShapeTree.TreeEntry> curr_overlapping_items = default_tree.overlapping_tree_entries_with_clearance(curr_tile_shape, this.shape_layer(i), new int[0], this.clearance_class);
            for (ShapeTree.TreeEntry curr_entry : curr_overlapping_items) {
                TileShape intersection;
                if (!(curr_entry.object instanceof Item) || curr_entry.object == this) continue;
                Item curr_item = (Item)curr_entry.object;
                boolean is_obstacle = curr_item.is_obstacle(this);
                if (is_obstacle && this instanceof Trace && curr_item instanceof Trace) {
                    Trace this_trace = (Trace)this;
                    Point contact_point = this_trace.first_corner();
                    boolean contact_found = false;
                    Set<Item> curr_contacts = this_trace.get_normal_contacts(contact_point, true);
                    if (curr_contacts.contains(curr_item)) {
                        contact_found = true;
                    }
                    if (!contact_found && (curr_contacts = this_trace.get_normal_contacts(contact_point = this_trace.last_corner(), true)).contains(curr_item)) {
                        contact_found = true;
                    }
                    if (contact_found) {
                        for (Item curr_contact : curr_contacts) {
                            if (!(curr_contact instanceof Pin) || !curr_contact.shares_net(this) || !curr_contact.shares_net(curr_item)) continue;
                            is_obstacle = false;
                            break;
                        }
                    }
                }
                if (!is_obstacle) continue;
                TileShape shape_1 = curr_tile_shape;
                TileShape shape_2 = curr_item.get_tree_shape(default_tree, curr_entry.shape_index_in_object);
                if (shape_1 == null || shape_2 == null) {
                    FRLogger.warn("Item.clearance_violations: unexpected null shape");
                    continue;
                }
                double minimum_clearance = this.board.rules.clearance_matrix.get_value(curr_item.clearance_class, this.clearance_class, this.shape_layer(i), false);
                double actual_clearance = 0.0;
                TileShape enlarged_shape_1 = (TileShape)shape_1.enlarge(0.0);
                TileShape enlarged_shape_2 = (TileShape)shape_2.enlarge(0.0);
                if (!this.board.search_tree_manager.is_clearance_compensation_used()) {
                    double cl_offset = 0.5 * minimum_clearance;
                    enlarged_shape_1 = (TileShape)shape_1.enlarge(cl_offset);
                    enlarged_shape_2 = (TileShape)shape_2.enlarge(cl_offset);
                    actual_clearance = this.calculate_clearance_between_two_shapes(shape_1, shape_2, minimum_clearance + 16.0);
                    if (this.smallest_clearance == 0.0 || actual_clearance < this.smallest_clearance) {
                        this.smallest_clearance = actual_clearance;
                    }
                }
                if ((intersection = enlarged_shape_1.intersection(enlarged_shape_2)).dimension() != 2) continue;
                ClearanceViolation curr_violation = new ClearanceViolation(this, curr_item, intersection, this.shape_layer(i), minimum_clearance, actual_clearance);
                result.add(curr_violation);
            }
        }
        return result;
    }

    private double calculate_clearance_between_two_shapes(TileShape shape_1, TileShape shape_2, double minimum_clearance) {
        for (double clearance = minimum_clearance; clearance > 0.0; clearance -= 1.0) {
            TileShape enlarged_shape_2;
            double cl_offset = 0.5 * clearance;
            TileShape enlarged_shape_1 = (TileShape)shape_1.enlarge(cl_offset);
            TileShape intersection = enlarged_shape_1.intersection(enlarged_shape_2 = (TileShape)shape_2.enlarge(cl_offset));
            if (intersection.dimension() == 2) continue;
            return clearance;
        }
        return 0.0;
    }

    public Set<Item> get_all_contacts() {
        TreeSet<Item> result = new TreeSet<Item>();
        if (!(this instanceof Connectable)) {
            return result;
        }
        for (int i = 0; i < this.tile_shape_count(); ++i) {
            Set<SearchTreeObject> overlapping_items = this.board.overlapping_objects(this.get_tile_shape(i), this.shape_layer(i));
            for (SearchTreeObject curr_ob : overlapping_items) {
                Item curr_item;
                if (!(curr_ob instanceof Item) || (curr_item = (Item)curr_ob) == this || !(curr_item instanceof Connectable) || !curr_item.shares_net(this)) continue;
                result.add(curr_item);
            }
        }
        return result;
    }

    public Set<Item> get_all_contacts(int p_layer) {
        TreeSet<Item> result = new TreeSet<Item>();
        if (!(this instanceof Connectable)) {
            return result;
        }
        for (int i = 0; i < this.tile_shape_count(); ++i) {
            if (this.shape_layer(i) != p_layer) continue;
            Set<SearchTreeObject> overlapping_items = this.board.overlapping_objects(this.get_tile_shape(i), p_layer);
            for (SearchTreeObject curr_ob : overlapping_items) {
                Item curr_item;
                if (!(curr_ob instanceof Item) || (curr_item = (Item)curr_ob) == this || !(curr_item instanceof Connectable) || !curr_item.shares_net(this)) continue;
                result.add(curr_item);
            }
        }
        return result;
    }

    public boolean is_connected() {
        Set<Item> contacts = this.get_all_contacts();
        return !contacts.isEmpty();
    }

    public boolean is_connected_on_layer(int p_layer) {
        Set<Item> contacts_on_layer = this.get_all_contacts(p_layer);
        return !contacts_on_layer.isEmpty();
    }

    public Set<Item> get_normal_contacts() {
        return new TreeSet<Item>();
    }

    public Point normal_contact_point(Item p_other) {
        return null;
    }

    Point normal_contact_point(Trace p_other) {
        return null;
    }

    Point normal_contact_point(DrillItem p_other) {
        return null;
    }

    public Set<Item> get_connected_set(int p_net_no) {
        return this.get_connected_set(p_net_no, false);
    }

    public Set<Item> get_connected_set(int p_net_no, boolean p_stop_at_plane) {
        TreeSet<Item> result = new TreeSet<Item>();
        if (p_net_no > 0 && !this.contains_net(p_net_no)) {
            return result;
        }
        result.add(this);
        this.get_connected_set_recu(result, p_net_no, p_stop_at_plane);
        return result;
    }

    private void get_connected_set_recu(Set<Item> p_result, int p_net_no, boolean p_stop_at_plane) {
        Set<Item> contact_list = this.get_normal_contacts();
        if (contact_list == null) {
            return;
        }
        for (Item curr_contact : contact_list) {
            if (p_stop_at_plane && curr_contact instanceof ConductionArea && curr_contact.get_component_no() <= 0 || p_net_no > 0 && !curr_contact.contains_net(p_net_no) || !p_result.add(curr_contact)) continue;
            curr_contact.get_connected_set_recu(p_result, p_net_no, p_stop_at_plane);
        }
    }

    public boolean is_overlap() {
        return false;
    }

    boolean is_cycle_recu(Set<Item> p_visited_items, Item p_search_item, Item p_come_from_item, boolean p_ignore_areas) {
        if (p_ignore_areas && this instanceof ConductionArea) {
            return false;
        }
        Set<Item> contact_list = this.get_normal_contacts();
        if (contact_list == null) {
            return false;
        }
        for (Item curr_contact : contact_list) {
            if (curr_contact == p_come_from_item) continue;
            if (curr_contact == p_search_item) {
                return true;
            }
            if (!p_visited_items.add(curr_contact) || !curr_contact.is_cycle_recu(p_visited_items, p_search_item, this, p_ignore_areas)) continue;
            return true;
        }
        return false;
    }

    public Set<Item> get_unconnected_set(int p_net_no) {
        TreeSet<Item> result = new TreeSet<Item>();
        if (p_net_no > 0 && !this.contains_net(p_net_no)) {
            return result;
        }
        if (p_net_no > 0) {
            result.addAll(this.board.get_connectable_items(p_net_no));
        } else {
            for (int curr_net_no : this.net_no_arr) {
                result.addAll(this.board.get_connectable_items(curr_net_no));
            }
        }
        result.removeAll(this.get_connected_set(p_net_no));
        return result;
    }

    public Set<Item> get_connection_items() {
        return this.get_connection_items(StopConnectionOption.NONE);
    }

    public Set<Item> get_connection_items(StopConnectionOption p_stop_option) {
        Set<Item> contacts = this.get_normal_contacts();
        TreeSet<Item> result = new TreeSet<Item>();
        if (this.is_routable()) {
            result.add(this);
        }
        block0: for (Item curr_item : contacts) {
            Trace start_trace;
            Set<Item> check_contacts;
            Point prev_contact_point = this.normal_contact_point(curr_item);
            if (prev_contact_point == null) continue;
            int prev_contact_layer = this.first_common_layer(curr_item);
            if (this instanceof Trace && (check_contacts = (start_trace = (Trace)this).get_normal_contacts(prev_contact_point, false)).size() != 1) continue;
            while (!(!curr_item.is_routable() || curr_item instanceof Via && (p_stop_option == StopConnectionOption.VIA || p_stop_option == StopConnectionOption.FANOUT_VIA && curr_item.is_fanout_via(result)))) {
                result.add(curr_item);
                Set<Item> curr_ob_contacts = curr_item.get_normal_contacts();
                Point next_contact_point = null;
                int next_contact_layer = -1;
                Item next_contact = null;
                boolean fork_found = false;
                for (Item tmp_contact : curr_ob_contacts) {
                    int tmp_contact_layer = curr_item.first_common_layer(tmp_contact);
                    if (tmp_contact_layer < 0) continue;
                    Point tmp_contact_point = curr_item.normal_contact_point(tmp_contact);
                    if (tmp_contact_point == null) {
                        fork_found = true;
                        break;
                    }
                    if (prev_contact_layer == tmp_contact_layer && prev_contact_point.equals(tmp_contact_point)) continue;
                    if (next_contact != null) {
                        fork_found = true;
                        break;
                    }
                    next_contact = tmp_contact;
                    next_contact_point = tmp_contact_point;
                    next_contact_layer = tmp_contact_layer;
                }
                if (next_contact == null || fork_found) continue block0;
                curr_item = next_contact;
                prev_contact_point = next_contact_point;
                prev_contact_layer = next_contact_layer;
            }
        }
        return result;
    }

    public boolean is_tail() {
        return false;
    }

    public Point[] get_ratsnest_corners() {
        return new Point[0];
    }

    @Override
    public void draw(Graphics p_g, GraphicsContext p_graphics_context, Color p_color, double p_intensity) {
        Object[] color_arr = new Color[this.board.get_layer_count()];
        Arrays.fill(color_arr, p_color);
        this.draw(p_g, p_graphics_context, (Color[])color_arr, p_intensity);
    }

    public void draw(Graphics p_g, GraphicsContext p_graphics_context) {
        Color[] layer_colors = this.get_draw_colors(p_graphics_context);
        this.draw(p_g, p_graphics_context, layer_colors, this.get_draw_intensity(p_graphics_context));
    }

    public boolean validate() {
        boolean result = this.board.search_tree_manager.validate_entries(this);
        for (int i = 0; i < this.tile_shape_count(); ++i) {
            TileShape curr_shape = this.get_tile_shape(i);
            if (!curr_shape.is_empty()) continue;
            FRLogger.warn("Item.validate: shape is empty");
            result = false;
        }
        return result;
    }

    @Override
    public abstract int shape_layer(int var1);

    public boolean is_user_fixed() {
        return this.fixed_state.ordinal() >= FixedState.USER_FIXED.ordinal();
    }

    boolean is_delete_fixed() {
        if (this.component_no > 0 || this.is_user_fixed()) {
            return true;
        }
        if (this instanceof ConductionArea) {
            return !this.board.layer_structure.arr[((ConductionArea)this).get_layer()].is_signal;
        }
        return false;
    }

    public boolean is_shove_fixed() {
        return this.fixed_state.ordinal() >= FixedState.SHOVE_FIXED.ordinal();
    }

    public FixedState get_fixed_state() {
        return this.fixed_state;
    }

    public void set_fixed_state(FixedState p_fixed_state) {
        this.fixed_state = p_fixed_state;
    }

    public boolean is_drillable(int p_net_no) {
        return false;
    }

    public void unfix() {
        if (this.fixed_state != FixedState.SYSTEM_FIXED) {
            this.fixed_state = FixedState.UNFIXED;
        }
    }

    public boolean is_routable() {
        return false;
    }

    public boolean is_connectable() {
        return this instanceof Connectable && this.net_count() > 0;
    }

    public int net_count() {
        return this.net_no_arr.length;
    }

    public int get_net_no(int p_no) {
        return this.net_no_arr[p_no];
    }

    public int get_component_no() {
        return this.component_no;
    }

    public boolean remove_from_net(int p_net_no) {
        int found_index = -1;
        for (int i = 0; i < this.net_no_arr.length; ++i) {
            if (this.net_no_arr[i] != p_net_no) continue;
            found_index = i;
        }
        if (found_index < 0) {
            return false;
        }
        int[] new_net_no_arr = new int[this.net_no_arr.length - 1];
        System.arraycopy(this.net_no_arr, 0, new_net_no_arr, 0, found_index);
        if (found_index < new_net_no_arr.length) {
            System.arraycopy(this.net_no_arr, found_index + 1, new_net_no_arr, found_index, new_net_no_arr.length - found_index);
        }
        this.net_no_arr = new_net_no_arr;
        return true;
    }

    public int clearance_class_no() {
        return this.clearance_class;
    }

    public void set_clearance_class_no(int p_index) {
        if (p_index < 0 || p_index >= this.board.rules.clearance_matrix.get_class_count()) {
            FRLogger.warn("Item.set_clearance_class_no: p_index out of range");
            return;
        }
        this.clearance_class = p_index;
    }

    public void change_clearance_class(int p_index) {
        if (p_index < 0 || p_index >= this.board.rules.clearance_matrix.get_class_count()) {
            FRLogger.warn("Item.set_clearance_class_no: p_index out of range");
            return;
        }
        this.clearance_class = p_index;
        this.clear_derived_data();
        if (this.board != null && this.board.search_tree_manager.is_clearance_compensation_used()) {
            this.board.search_tree_manager.remove(this);
            this.board.search_tree_manager.insert(this);
        }
    }

    public void assign_component_no(int p_no) {
        this.component_no = p_no;
    }

    public void assign_net_no(int p_net_no) {
        if (!Nets.is_normal_net_no(p_net_no)) {
            return;
        }
        if (p_net_no > this.board.rules.nets.max_net_no()) {
            FRLogger.warn("Item.assign_net_no: p_net_no to big");
            return;
        }
        this.board.item_list.save_for_undo(this);
        if (p_net_no <= 0) {
            this.net_no_arr = new int[0];
        } else {
            if (this.net_no_arr.length == 0) {
                this.net_no_arr = new int[1];
            } else if (this.net_no_arr.length > 1) {
                FRLogger.warn("Item.assign_net_no: unexpected net_count > 1");
            }
            this.net_no_arr[0] = p_net_no;
        }
    }

    public abstract boolean is_selected_by_filter(ItemSelectionFilter var1);

    protected boolean is_selected_by_fixed_filter(ItemSelectionFilter p_filter) {
        boolean result = this.is_user_fixed() ? p_filter.is_selected(ItemSelectionFilter.SelectableChoices.FIXED) : p_filter.is_selected(ItemSelectionFilter.SelectableChoices.UNFIXED);
        return result;
    }

    @Override
    public void set_search_tree_entries(ShapeTree.Leaf[] p_tree_entries, ShapeTree p_tree) {
        if (this.board == null) {
            return;
        }
        if (this.search_trees_info == null) {
            this.search_trees_info = new ItemSearchTreesInfo();
        }
        this.search_trees_info.set_tree_entries(p_tree_entries, p_tree);
    }

    public ShapeTree.Leaf[] get_search_tree_entries(ShapeSearchTree p_tree) {
        if (this.search_trees_info == null) {
            return null;
        }
        return this.search_trees_info.get_tree_entries(p_tree);
    }

    protected void set_precalculated_tree_shapes(TileShape[] p_shapes, ShapeSearchTree p_tree) {
        if (this.board == null) {
            return;
        }
        if (this.search_trees_info == null) {
            FRLogger.warn("Item.set_precalculated_tree_shapes search_trees_info not allocated");
            return;
        }
        this.search_trees_info.set_precalculated_tree_shapes(p_shapes, p_tree);
    }

    public void clear_search_tree_entries() {
        this.search_trees_info = null;
    }

    public ItemAutorouteInfo get_autoroute_info() {
        if (this.autoroute_info == null) {
            this.autoroute_info = new ItemAutorouteInfo(this);
        }
        return this.autoroute_info;
    }

    public ItemAutorouteInfo get_autoroute_info_pur() {
        return this.autoroute_info;
    }

    public void clear_autoroute_info() {
        this.autoroute_info = null;
    }

    public void clear_derived_data() {
        if (this.search_trees_info != null) {
            this.search_trees_info.clear_precalculated_tree_shapes();
        }
        this.autoroute_info = null;
    }

    protected void print_net_info(ObjectInfoPanel p_window, Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.ObjectInfoPanel", p_locale);
        for (int i = 0; i < this.net_count(); ++i) {
            p_window.append(", " + resources.getString("net") + " ");
            Net curr_net = this.board.rules.nets.get(this.get_net_no(i));
            p_window.append(curr_net.name, resources.getString("net_info"), curr_net);
        }
    }

    protected void print_clearance_info(ObjectInfoPanel p_window, Locale p_locale) {
        if (this.clearance_class > 0) {
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.ObjectInfoPanel", p_locale);
            p_window.append(", " + resources.getString("clearance_class") + " ");
            String name = this.board.rules.clearance_matrix.get_name(this.clearance_class);
            p_window.append(name, resources.getString("clearance_info"), this.board.rules.clearance_matrix.get_row(this.clearance_class));
        }
    }

    protected void print_fixed_info(ObjectInfoPanel p_window, Locale p_locale) {
        if (this.fixed_state != FixedState.UNFIXED) {
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.FixedState", p_locale);
            p_window.append(", ");
            p_window.append(resources.getString(this.fixed_state.toString()));
        }
    }

    protected void print_contact_info(ObjectInfoPanel p_window, Locale p_locale) {
        Set<Item> contacts = this.get_normal_contacts();
        if (!contacts.isEmpty()) {
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.ObjectInfoPanel", p_locale);
            p_window.append(", " + resources.getString("contacts") + " ");
            int contact_count = contacts.size();
            p_window.append_items(String.valueOf(contact_count), resources.getString("contact_info"), contacts);
        }
    }

    protected void print_clearance_violation_info(ObjectInfoPanel p_window, Locale p_locale) {
        Collection<ClearanceViolation> clearance_violations = this.clearance_violations();
        if (!clearance_violations.isEmpty()) {
            ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.ObjectInfoPanel", p_locale);
            p_window.append(", ");
            int violation_count = clearance_violations.size();
            LinkedList<ObjectInfoPanel.Printable> violations = new LinkedList<ObjectInfoPanel.Printable>(clearance_violations);
            p_window.append_objects(String.valueOf(violation_count), resources.getString("violation_info"), violations);
            if (violation_count == 1) {
                p_window.append(" " + resources.getString("clearance_violation"));
            } else {
                p_window.append(" " + resources.getString("clearance_violations"));
            }
        }
    }

    protected void print_connectable_item_info(ObjectInfoPanel p_window, Locale p_locale) {
        this.print_clearance_info(p_window, p_locale);
        this.print_fixed_info(p_window, p_locale);
        this.print_net_info(p_window, p_locale);
        this.print_contact_info(p_window, p_locale);
        this.print_clearance_violation_info(p_window, p_locale);
    }

    protected void print_item_info(ObjectInfoPanel p_window, Locale p_locale) {
        this.print_clearance_info(p_window, p_locale);
        this.print_fixed_info(p_window, p_locale);
        this.print_clearance_violation_info(p_window, p_locale);
    }

    public boolean nets_normal() {
        for (int i = 0; i < this.net_no_arr.length; ++i) {
            if (Nets.is_normal_net_no(this.net_no_arr[i])) continue;
            return false;
        }
        return true;
    }

    public boolean nets_equal(Item p_other) {
        return this.nets_equal(p_other.net_no_arr);
    }

    public boolean nets_equal(int[] p_net_no_arr) {
        if (this.net_no_arr.length != p_net_no_arr.length) {
            return false;
        }
        for (int curr_net_no : p_net_no_arr) {
            if (this.contains_net(curr_net_no)) continue;
            return false;
        }
        return true;
    }

    boolean is_fanout_via(Set<Item> p_ignore_items) {
        Set<Item> contact_list = this.get_normal_contacts();
        for (Item curr_contact : contact_list) {
            Trace curr_trace;
            if (curr_contact instanceof Pin && curr_contact.first_layer() == curr_contact.last_layer() && curr_contact.get_normal_contacts().size() <= 1) {
                return true;
            }
            if (!(curr_contact instanceof Trace) || p_ignore_items != null && p_ignore_items.contains(curr_contact) || (curr_trace = (Trace)curr_contact).get_length() >= 400.0 * (double)curr_trace.get_half_width()) continue;
            Set<Item> trace_contact_list = curr_trace.get_normal_contacts();
            for (Item tmp_contact : trace_contact_list) {
                PolylineTrace contact_trace;
                if (tmp_contact instanceof Pin && curr_contact.first_layer() == curr_contact.last_layer() && tmp_contact.get_normal_contacts().size() <= 1) {
                    return true;
                }
                if (!(tmp_contact instanceof PolylineTrace) || tmp_contact.get_fixed_state() != FixedState.SHOVE_FIXED || (contact_trace = (PolylineTrace)tmp_contact).corner_count() != 2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean has_ignored_nets() {
        for (int net_no : this.net_no_arr) {
            Net net = this.board.rules.nets.get(net_no);
            if (!net.get_class().is_ignored_by_autorouter) continue;
            return true;
        }
        return false;
    }

    public static enum StopConnectionOption {
        NONE,
        FANOUT_VIA,
        VIA;

    }
}

