/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.CalcFromSide;
import app.freerouting.board.CalcShapeAndFromSide;
import app.freerouting.board.Item;
import app.freerouting.board.MoveDrillItemAlgo;
import app.freerouting.board.Pin;
import app.freerouting.board.PolylineTrace;
import app.freerouting.board.RoutingBoard;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.ShapeTraceEntries;
import app.freerouting.board.ShoveTraceAlgo;
import app.freerouting.board.Trace;
import app.freerouting.board.Via;
import app.freerouting.datastructures.TimeLimit;
import app.freerouting.geometry.planar.Direction;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;
import app.freerouting.geometry.planar.IntOctagon;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

public class ForcedPadAlgo {
    private final RoutingBoard board;

    public ForcedPadAlgo(RoutingBoard p_board) {
        this.board = p_board;
    }

    private static TileShape calc_check_shape_for_from_side(TileShape p_shape, Point p_shape_center, Line p_border_line) {
        FloatPoint shape_center = p_shape_center.to_float();
        FloatPoint offset_projection = shape_center.projection_approx(p_border_line);
        Line[] line_arr = new Line[3];
        Direction curr_dir = p_border_line.direction();
        line_arr[0] = new Line(p_shape_center, curr_dir);
        line_arr[1] = new Line(p_shape_center, curr_dir.turn_45_degree(2));
        line_arr[2] = new Line((Point)offset_projection.round(), curr_dir);
        Polyline check_line = new Polyline(line_arr);
        return check_line.offset_shape(1, 0);
    }

    private static boolean in_front_of_pad(Line p_line, TileShape p_pad_shape, int p_from_side, int p_width, boolean p_with_sides) {
        boolean result;
        if (!p_pad_shape.is_IntOctagon()) {
            return true;
        }
        IntOctagon pad_octagon = p_pad_shape.bounding_octagon();
        if (!(p_line.a instanceof IntPoint) || !(p_line.b instanceof IntPoint)) {
            return true;
        }
        IntPoint line_a = (IntPoint)p_line.a;
        IntPoint line_b = (IntPoint)p_line.b;
        double diag_width = (double)p_width * Math.sqrt(2.0);
        switch (p_from_side) {
            case 0: {
                boolean bl = result = Math.min(line_a.y, line_b.y) >= pad_octagon.uy + p_width || (double)Math.max(line_a.x - line_a.y, line_b.x - line_b.y) <= (double)pad_octagon.ulx - diag_width || (double)Math.min(line_a.x + line_a.y, line_b.x + line_b.x) >= (double)pad_octagon.urx + diag_width;
                if (!p_with_sides || result) break;
                result = Math.max(line_a.x, line_b.x) <= pad_octagon.lx - p_width && (double)Math.min(line_a.x - line_a.y, line_b.x - line_b.y) <= (double)pad_octagon.ulx - diag_width || Math.min(line_a.x, line_b.x) >= pad_octagon.rx + p_width && (double)Math.min(line_a.x + line_a.y, line_b.x + line_b.y) >= (double)pad_octagon.urx + diag_width;
                break;
            }
            case 1: {
                boolean bl = result = Math.min(line_a.y, line_b.y) >= pad_octagon.uy + p_width || (double)Math.max(line_a.x - line_a.y, line_b.x - line_b.y) <= (double)pad_octagon.ulx - diag_width || Math.max(line_a.x, line_b.x) <= pad_octagon.lx - p_width;
                if (!p_with_sides || result) break;
                result = Math.min(line_a.x, line_b.x) <= pad_octagon.lx - p_width && (double)Math.max(line_a.x + line_a.y, line_b.x + line_b.y) <= (double)pad_octagon.llx - diag_width || Math.max(line_a.y, line_b.y) >= pad_octagon.uy + p_width && (double)Math.min(line_a.x + line_a.y, line_b.x + line_b.y) >= (double)pad_octagon.urx + diag_width;
                break;
            }
            case 2: {
                boolean bl = result = Math.max(line_a.x, line_b.x) <= pad_octagon.lx - p_width || (double)Math.max(line_a.x - line_a.y, line_b.x - line_b.y) <= (double)pad_octagon.ulx - diag_width || (double)Math.max(line_a.x + line_a.y, line_b.x + line_b.y) <= (double)pad_octagon.llx - diag_width;
                if (!p_with_sides || result) break;
                result = Math.max(line_a.y, line_b.y) <= pad_octagon.ly - p_width && (double)Math.min(line_a.x + line_a.y, line_b.x + line_b.y) <= (double)pad_octagon.llx - diag_width || Math.min(line_a.y, line_b.y) >= pad_octagon.uy + p_width && (double)Math.min(line_a.x - line_a.y, line_b.x - line_b.y) <= (double)pad_octagon.ulx - diag_width;
                break;
            }
            case 3: {
                boolean bl = result = Math.max(line_a.x, line_b.x) <= pad_octagon.lx - p_width || Math.max(line_a.y, line_b.y) <= pad_octagon.ly - p_width || (double)Math.max(line_a.x + line_a.y, line_b.x + line_b.y) <= (double)pad_octagon.llx - diag_width;
                if (!p_with_sides || result) break;
                result = Math.min(line_a.y, line_b.y) <= pad_octagon.ly - p_width && (double)Math.min(line_a.x - line_a.y, line_b.x - line_b.y) >= (double)pad_octagon.lrx + diag_width || Math.min(line_a.x, line_b.x) <= pad_octagon.lx - p_width && (double)Math.max(line_a.x - line_a.y, line_b.x - line_b.y) <= (double)pad_octagon.ulx - diag_width;
                break;
            }
            case 4: {
                boolean bl = result = Math.max(line_a.y, line_b.y) <= pad_octagon.ly - p_width || (double)Math.max(line_a.x + line_a.y, line_b.x + line_b.y) <= (double)pad_octagon.llx - diag_width || (double)Math.min(line_a.x - line_a.y, line_b.x - line_b.y) >= (double)pad_octagon.lrx + diag_width;
                if (!p_with_sides || result) break;
                result = Math.min(line_a.x, line_b.x) >= pad_octagon.rx + p_width && (double)Math.max(line_a.x - line_a.y, line_b.x - line_b.y) >= (double)pad_octagon.lrx + diag_width || Math.max(line_a.x, line_b.x) <= pad_octagon.lx - p_width && (double)Math.min(line_a.x + line_a.y, line_b.x + line_b.y) <= (double)pad_octagon.llx - diag_width;
                break;
            }
            case 5: {
                boolean bl = result = Math.max(line_a.y, line_b.y) <= pad_octagon.ly - p_width || Math.min(line_a.x, line_b.x) >= pad_octagon.rx + p_width || (double)Math.min(line_a.x - line_a.y, line_b.x - line_b.y) >= (double)pad_octagon.lrx + diag_width;
                if (!p_with_sides || result) break;
                result = Math.max(line_a.x, line_b.x) >= pad_octagon.rx + p_width && (double)Math.min(line_a.x + line_a.y, line_b.x + line_b.y) >= (double)pad_octagon.urx + diag_width || Math.min(line_a.y, line_b.y) <= pad_octagon.ly - p_width && (double)Math.max(line_a.x + line_a.y, line_b.x + line_b.y) <= (double)pad_octagon.llx - diag_width;
                break;
            }
            case 6: {
                boolean bl = result = Math.min(line_a.x, line_b.x) >= pad_octagon.rx + p_width || (double)Math.min(line_a.x + line_a.y, line_b.x + line_b.y) >= (double)pad_octagon.urx + diag_width || (double)Math.min(line_a.x - line_a.y, line_b.x - line_b.y) >= (double)pad_octagon.lrx + diag_width;
                if (!p_with_sides || result) break;
                result = Math.max(line_a.y, line_b.y) <= pad_octagon.ly - p_width && (double)Math.max(line_a.x - line_a.y, line_b.x - line_b.y) >= (double)pad_octagon.lrx + diag_width || Math.min(line_a.y, line_b.y) >= pad_octagon.uy + p_width && (double)Math.max(line_a.x + line_a.y, line_b.x + line_b.y) >= (double)pad_octagon.urx + diag_width;
                break;
            }
            case 7: {
                boolean bl = result = Math.min(line_a.y, line_b.y) >= pad_octagon.uy + p_width || (double)Math.min(line_a.x + line_a.y, line_b.x + line_b.y) >= (double)pad_octagon.urx + diag_width || Math.min(line_a.x, line_b.x) >= pad_octagon.rx + p_width;
                if (!p_with_sides || result) break;
                result = Math.max(line_a.y, line_b.y) >= pad_octagon.uy + p_width && (double)Math.max(line_a.x - line_a.y, line_b.x - line_b.y) <= (double)pad_octagon.ulx - diag_width || Math.max(line_a.x, line_b.x) >= pad_octagon.rx + p_width && (double)Math.min(line_a.x - line_a.y, line_b.x - line_b.y) >= (double)pad_octagon.lrx + diag_width;
                break;
            }
            default: {
                FRLogger.warn("ForcedPadAlgo.in_front_of_pad: p_from_side out of range");
                result = true;
            }
        }
        return result;
    }

    public CheckDrillResult check_forced_pad(TileShape p_pad_shape, CalcFromSide p_from_side, int p_layer, int[] p_net_no_arr, int p_cl_type, boolean p_copper_sharing_allowed, Collection<Item> p_ignore_items, int p_max_recursion_depth, int p_max_via_recursion_depth, boolean p_check_only_front, TimeLimit p_time_limit) {
        PolylineTrace curr_substitute_trace;
        int n;
        boolean obstacles_shovable;
        if (!p_pad_shape.is_contained_in(this.board.get_bounding_box())) {
            this.board.set_shove_failing_obstacle(this.board.get_outline());
            return CheckDrillResult.NOT_DRILLABLE;
        }
        ShapeSearchTree search_tree = this.board.search_tree_manager.get_default_tree();
        ShapeTraceEntries shape_entries = new ShapeTraceEntries(p_pad_shape, p_layer, p_net_no_arr, p_cl_type, p_from_side, this.board);
        Set<Item> obstacles = search_tree.overlapping_items_with_clearance(p_pad_shape, p_layer, new int[0], p_cl_type);
        if (p_ignore_items != null) {
            obstacles.removeAll(p_ignore_items);
        }
        if (!(obstacles_shovable = shape_entries.store_items(obstacles, true, p_copper_sharing_allowed))) {
            this.board.set_shove_failing_obstacle(shape_entries.get_found_obstacle());
            return CheckDrillResult.NOT_DRILLABLE;
        }
        for (Via via : shape_entries.shove_via_list) {
            LinkedList<Item> ignore_items;
            if (p_max_via_recursion_depth <= 0) {
                this.board.set_shove_failing_obstacle(via);
                return CheckDrillResult.NOT_DRILLABLE;
            }
            IntPoint[] new_via_center = MoveDrillItemAlgo.try_shove_via_points(p_pad_shape, p_layer, via, p_cl_type, false, this.board);
            if (new_via_center.length == 0) {
                this.board.set_shove_failing_obstacle(via);
                return CheckDrillResult.NOT_DRILLABLE;
            }
            Vector delta = new_via_center[0].difference_by(via.get_center());
            if (MoveDrillItemAlgo.check(via, delta, p_max_recursion_depth, p_max_via_recursion_depth - 1, ignore_items = new LinkedList<Item>(), this.board, p_time_limit)) continue;
            return CheckDrillResult.NOT_DRILLABLE;
        }
        CheckDrillResult result = CheckDrillResult.DRILLABLE;
        if (p_copper_sharing_allowed) {
            for (Item curr_obstacle : obstacles) {
                if (!(curr_obstacle instanceof Pin)) continue;
                result = CheckDrillResult.DRILLABLE_WITH_ATTACH_SMD;
                break;
            }
        }
        if ((n = shape_entries.substitute_trace_count()) == 0) {
            return result;
        }
        if (p_max_recursion_depth <= 0) {
            this.board.set_shove_failing_obstacle(shape_entries.get_found_obstacle());
            return CheckDrillResult.NOT_DRILLABLE;
        }
        if (shape_entries.stack_depth() > 1) {
            this.board.set_shove_failing_obstacle(shape_entries.get_found_obstacle());
            return CheckDrillResult.NOT_DRILLABLE;
        }
        ShoveTraceAlgo shove_trace_algo = new ShoveTraceAlgo(this.board);
        boolean is_orthogonal_mode = p_pad_shape instanceof IntBox;
        while ((curr_substitute_trace = shape_entries.next_substitute_trace_piece()) != null) {
            for (int i = 0; i < curr_substitute_trace.tile_shape_count(); ++i) {
                Line curr_line = curr_substitute_trace.polyline().arr[i + 1];
                Direction curr_dir = curr_line.direction();
                boolean is_in_front = p_check_only_front ? ForcedPadAlgo.in_front_of_pad(curr_line, p_pad_shape, p_from_side.no, curr_substitute_trace.get_half_width(), true) : true;
                if (!is_in_front) continue;
                CalcShapeAndFromSide curr = new CalcShapeAndFromSide(curr_substitute_trace, i, is_orthogonal_mode, true);
                if (shove_trace_algo.check(curr.shape, curr.from_side, curr_dir, p_layer, curr_substitute_trace.net_no_arr, curr_substitute_trace.clearance_class_no(), p_max_recursion_depth - 1, p_max_via_recursion_depth, 0, p_time_limit)) continue;
                return CheckDrillResult.NOT_DRILLABLE;
            }
        }
        return result;
    }

    boolean forced_pad(TileShape p_pad_shape, CalcFromSide p_from_side, int p_layer, int[] p_net_no_arr, int p_cl_type, boolean p_copper_sharing_allowed, Collection<Item> p_ignore_items, int p_max_recursion_depth, int p_max_via_recursion_depth) {
        PolylineTrace curr_substitute_trace;
        boolean obstacles_shovable;
        if (p_pad_shape.is_empty()) {
            FRLogger.warn("ShoveTraceAux.forced_pad: p_pad_shape is empty");
            return true;
        }
        if (!p_pad_shape.is_contained_in(this.board.get_bounding_box())) {
            this.board.set_shove_failing_obstacle(this.board.get_outline());
            return false;
        }
        if (!MoveDrillItemAlgo.shove_vias(p_pad_shape, p_from_side, p_layer, p_net_no_arr, p_cl_type, p_ignore_items, p_max_recursion_depth, p_max_via_recursion_depth, false, this.board)) {
            return false;
        }
        ShapeSearchTree search_tree = this.board.search_tree_manager.get_default_tree();
        ShapeTraceEntries shape_entries = new ShapeTraceEntries(p_pad_shape, p_layer, p_net_no_arr, p_cl_type, p_from_side, this.board);
        Set<Item> obstacles = search_tree.overlapping_items_with_clearance(p_pad_shape, p_layer, new int[0], p_cl_type);
        if (p_ignore_items != null) {
            obstacles.removeAll(p_ignore_items);
        }
        boolean bl = obstacles_shovable = shape_entries.store_items(obstacles, true, p_copper_sharing_allowed) && shape_entries.shove_via_list.isEmpty();
        if (!obstacles_shovable) {
            this.board.set_shove_failing_obstacle(shape_entries.get_found_obstacle());
            return false;
        }
        int trace_piece_count = shape_entries.substitute_trace_count();
        if (trace_piece_count == 0) {
            return true;
        }
        if (p_max_recursion_depth <= 0) {
            this.board.set_shove_failing_obstacle(shape_entries.get_found_obstacle());
            return false;
        }
        boolean tails_exist_before = this.board.contains_trace_tails(obstacles, p_net_no_arr);
        shape_entries.cutout_traces(obstacles);
        boolean is_orthogonal_mode = p_pad_shape instanceof IntBox;
        ShoveTraceAlgo shove_trace_algo = new ShoveTraceAlgo(this.board);
        while ((curr_substitute_trace = shape_entries.next_substitute_trace_piece()) != null) {
            int i;
            if (curr_substitute_trace.first_corner().equals(curr_substitute_trace.last_corner())) continue;
            int[] curr_net_no_arr = curr_substitute_trace.net_no_arr;
            for (i = 0; i < curr_substitute_trace.tile_shape_count(); ++i) {
                CalcShapeAndFromSide curr = new CalcShapeAndFromSide(curr_substitute_trace, i, is_orthogonal_mode, false);
                if (shove_trace_algo.insert(curr.shape, curr.from_side, p_layer, curr_net_no_arr, curr_substitute_trace.clearance_class_no(), p_ignore_items, p_max_recursion_depth - 1, p_max_via_recursion_depth, 0)) continue;
                return false;
            }
            for (i = 0; i < curr_substitute_trace.corner_count(); ++i) {
                this.board.join_changed_area(curr_substitute_trace.polyline().corner_approx(i), p_layer);
            }
            Point[] end_corners = null;
            if (!tails_exist_before) {
                end_corners = new Point[]{curr_substitute_trace.first_corner(), curr_substitute_trace.last_corner()};
            }
            this.board.insert_item(curr_substitute_trace);
            IntOctagon opt_area = this.board.changed_area != null ? this.board.changed_area.get_area(p_layer) : null;
            try {
                curr_substitute_trace.normalize(opt_area);
            }
            catch (Exception e) {
                FRLogger.error("Couldn't normalize trace.", e);
            }
            if (tails_exist_before) continue;
            for (int i2 = 0; i2 < 2; ++i2) {
                Trace tail = this.board.get_trace_tail(end_corners[i2], p_layer, curr_net_no_arr);
                if (tail == null) continue;
                this.board.remove_items(tail.get_connection_items(Item.StopConnectionOption.VIA), false);
                for (int curr_net_no : curr_net_no_arr) {
                    this.board.combine_traces(curr_net_no);
                }
            }
        }
        return true;
    }

    CalcFromSide calc_from_side(TileShape p_shape, Point p_shape_center, int p_layer, int p_offset, int p_cl_class) {
        TileShape check_shape;
        int i;
        int[] empty_arr = new int[]{};
        TileShape offset_shape = (TileShape)p_shape.offset(p_offset);
        for (i = 0; i < offset_shape.border_line_count(); ++i) {
            check_shape = ForcedPadAlgo.calc_check_shape_for_from_side(p_shape, p_shape_center, offset_shape.border_line(i));
            if (!this.board.check_trace_shape(check_shape, p_layer, empty_arr, p_cl_class, null)) continue;
            return new CalcFromSide(i, null);
        }
        for (i = 0; i < offset_shape.border_line_count(); ++i) {
            check_shape = ForcedPadAlgo.calc_check_shape_for_from_side(p_shape, p_shape_center, offset_shape.border_line(i));
            if (!this.board.check_trace_shape(check_shape, p_layer, empty_arr, 0, null)) continue;
            return new CalcFromSide(i, null);
        }
        return CalcFromSide.NOT_CALCULATED;
    }

    public static enum CheckDrillResult {
        DRILLABLE,
        DRILLABLE_WITH_ATTACH_SMD,
        NOT_DRILLABLE;

    }
}

