/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.BoardObservers;
import app.freerouting.board.Component;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.library.Package;
import app.freerouting.logger.FRLogger;
import java.io.Serializable;
import java.util.Iterator;

public class Components
implements Serializable {
    private final UndoableObjects undo_list = new UndoableObjects();
    private final java.util.Vector<Component> component_arr = new java.util.Vector();
    private boolean flip_style_rotate_first = false;

    public Component add(String p_name, Point p_location, double p_rotation_in_degree, boolean p_on_front, Package p_package_front, Package p_package_back, boolean p_position_fixed) {
        Component new_component = new Component(p_name, p_location, p_rotation_in_degree, p_on_front, p_package_front, p_package_back, this.component_arr.size() + 1, p_position_fixed);
        this.component_arr.add(new_component);
        this.undo_list.insert(new_component);
        return new_component;
    }

    public Component add(Point p_location, double p_rotation, boolean p_on_front, Package p_package) {
        String component_name = "Component#" + (this.component_arr.size() + 1);
        return this.add(component_name, p_location, p_rotation, p_on_front, p_package, p_package, false);
    }

    public Component get(String p_name) {
        for (Component curr : this.component_arr) {
            if (!curr.name.equals(p_name)) continue;
            return curr;
        }
        return null;
    }

    public Component get(int p_component_no) {
        Component result = this.component_arr.elementAt(p_component_no - 1);
        if (result != null && result.no != p_component_no) {
            FRLogger.warn("Components.get: inconsistent component number");
        }
        return result;
    }

    public int count() {
        return this.component_arr.size();
    }

    public void generate_snapshot() {
        this.undo_list.generate_snapshot();
    }

    public boolean undo(BoardObservers p_observers) {
        if (!this.undo_list.undo(null, null)) {
            return false;
        }
        this.restore_component_arr_from_undo_list(p_observers);
        return true;
    }

    public boolean redo(BoardObservers p_observers) {
        if (!this.undo_list.redo(null, null)) {
            return false;
        }
        this.restore_component_arr_from_undo_list(p_observers);
        return true;
    }

    private void restore_component_arr_from_undo_list(BoardObservers p_observers) {
        Component curr_component;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.undo_list.start_read_object();
        while ((curr_component = (Component)this.undo_list.read_object(it)) != null) {
            this.component_arr.setElementAt(curr_component, curr_component.no - 1);
            p_observers.notify_moved(curr_component);
        }
    }

    public void move(int p_component_no, Vector p_vector) {
        Component curr_component = this.get(p_component_no);
        this.undo_list.save_for_undo(curr_component);
        curr_component.translate_by(p_vector);
    }

    public void turn_90_degree(int p_component_no, int p_factor, IntPoint p_pole) {
        Component curr_component = this.get(p_component_no);
        this.undo_list.save_for_undo(curr_component);
        curr_component.turn_90_degree(p_factor, p_pole);
    }

    public void rotate(int p_component_no, double p_rotation_in_degree, IntPoint p_pole) {
        Component curr_component = this.get(p_component_no);
        this.undo_list.save_for_undo(curr_component);
        curr_component.rotate(p_rotation_in_degree, p_pole, this.flip_style_rotate_first);
    }

    public void change_side(int p_component_no, IntPoint p_pole) {
        Component curr_component = this.get(p_component_no);
        this.undo_list.save_for_undo(curr_component);
        curr_component.change_side(p_pole);
    }

    public boolean get_flip_style_rotate_first() {
        return this.flip_style_rotate_first;
    }

    public void set_flip_style_rotate_first(boolean p_value) {
        this.flip_style_rotate_first = p_value;
    }
}

