/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.ObjectInfoPanel;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.geometry.planar.IntPoint;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Vector;
import app.freerouting.library.LogicalPart;
import app.freerouting.library.Package;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public class Component
implements UndoableObjects.Storable,
ObjectInfoPanel.Printable,
Serializable {
    public final String name;
    public final int no;
    public final boolean position_fixed;
    private final Package lib_package_front;
    private final Package lib_package_back;
    private Point location;
    private double rotation_in_degree;
    private LogicalPart logical_part;
    private boolean on_front;

    Component(String p_name, Point p_location, double p_rotation_in_degree, boolean p_on_front, Package p_package_front, Package p_package_back, int p_no, boolean p_position_fixed) {
        this.name = p_name;
        this.location = p_location;
        this.rotation_in_degree = p_rotation_in_degree;
        while (this.rotation_in_degree >= 360.0) {
            this.rotation_in_degree -= 360.0;
        }
        while (this.rotation_in_degree < 0.0) {
            this.rotation_in_degree += 360.0;
        }
        this.on_front = p_on_front;
        this.lib_package_front = p_package_front;
        this.lib_package_back = p_package_back;
        this.no = p_no;
        this.position_fixed = p_position_fixed;
    }

    public Point get_location() {
        return this.location;
    }

    public double get_rotation_in_degree() {
        return this.rotation_in_degree;
    }

    public boolean is_placed() {
        return this.location != null;
    }

    public boolean placed_on_front() {
        return this.on_front;
    }

    public void translate_by(Vector p_vector) {
        if (this.location != null) {
            this.location = this.location.translate_by(p_vector);
        }
    }

    public void turn_90_degree(int p_factor, IntPoint p_pole) {
        if (p_factor == 0) {
            return;
        }
        this.rotation_in_degree += (double)(p_factor * 90);
        while (this.rotation_in_degree >= 360.0) {
            this.rotation_in_degree -= 360.0;
        }
        while (this.rotation_in_degree < 0.0) {
            this.rotation_in_degree += 360.0;
        }
        if (this.location != null) {
            this.location = this.location.turn_90_degree(p_factor, p_pole);
        }
    }

    public void rotate(double p_angle_in_degree, IntPoint p_pole, boolean p_flip_style_rotate_first) {
        if (p_angle_in_degree == 0.0) {
            return;
        }
        double turn_angle = p_angle_in_degree;
        if (p_flip_style_rotate_first && !this.placed_on_front()) {
            turn_angle = 360.0 - p_angle_in_degree;
        }
        this.rotation_in_degree += turn_angle;
        while (this.rotation_in_degree >= 360.0) {
            this.rotation_in_degree -= 360.0;
        }
        while (this.rotation_in_degree < 0.0) {
            this.rotation_in_degree += 360.0;
        }
        if (this.location != null) {
            this.location = this.location.to_float().rotate(Math.toRadians(p_angle_in_degree), p_pole.to_float()).round();
        }
    }

    public void change_side(IntPoint p_pole) {
        this.on_front = !this.on_front;
        this.location = this.location.mirror_vertical(p_pole);
    }

    @Override
    public int compareTo(Object p_other) {
        if (p_other instanceof Component) {
            return this.name.compareToIgnoreCase(((Component)p_other).name);
        }
        return 1;
    }

    @Override
    public Component clone() {
        Component result = new Component(this.name, this.location, this.rotation_in_degree, this.on_front, this.lib_package_front, this.lib_package_back, this.no, this.position_fixed);
        result.logical_part = this.logical_part;
        return result;
    }

    public String toString() {
        return this.name;
    }

    public LogicalPart get_logical_part() {
        return this.logical_part;
    }

    public void set_logical_part(LogicalPart p_logical_part) {
        this.logical_part = p_logical_part;
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("app.freerouting.board.ObjectInfoPanel", p_locale);
        p_window.append_bold(resources.getString("component") + " ");
        p_window.append_bold(this.name);
        if (this.location != null) {
            p_window.append(" " + resources.getString("at") + " ");
            p_window.append(this.location.to_float());
            p_window.append(", " + resources.getString("rotation") + " ");
            p_window.append_without_transforming(this.rotation_in_degree);
            if (this.on_front) {
                p_window.append(", " + resources.getString("front"));
            } else {
                p_window.append(", " + resources.getString("back"));
            }
        } else {
            p_window.append(" " + resources.getString("not_yet_placed"));
        }
        p_window.append(", " + resources.getString("package"));
        Package lib_package = this.get_package();
        p_window.append(lib_package.name, resources.getString("package_info"), lib_package);
        if (this.logical_part != null) {
            p_window.append(", " + resources.getString("logical_part") + " ");
            p_window.append(this.logical_part.name, resources.getString("logical_part_info"), this.logical_part);
        }
        p_window.newline();
    }

    public Package get_package() {
        Package result = this.on_front ? this.lib_package_front : this.lib_package_back;
        return result;
    }
}

