/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.board.BoardObserverAdaptor;
import app.freerouting.board.BoardObservers;
import app.freerouting.board.ItemIdNoGenerator;
import app.freerouting.board.Unit;
import app.freerouting.datastructures.IdNoGenerator;
import app.freerouting.designforms.specctra.CoordinateTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Communication
implements Serializable {
    public final CoordinateTransform coordinate_transform;
    public final Unit unit;
    public final int resolution;
    public final SpecctraParserInfo specctra_parser_info;
    public final IdNoGenerator id_no_generator;
    public transient BoardObservers observers;

    public Communication(Unit p_unit, int p_resolution, SpecctraParserInfo p_specctra_parser_info, CoordinateTransform p_coordinate_transform, IdNoGenerator p_id_no_generator, BoardObservers p_observers) {
        this.coordinate_transform = p_coordinate_transform;
        this.unit = p_unit;
        this.resolution = p_resolution;
        this.specctra_parser_info = p_specctra_parser_info;
        this.id_no_generator = p_id_no_generator;
        this.observers = p_observers;
    }

    public Communication() {
        this(Unit.MIL, 1, new SpecctraParserInfo("\"", null, null, null, null, false), new CoordinateTransform(1.0, 0.0, 0.0), new ItemIdNoGenerator(), new BoardObserverAdaptor());
    }

    public boolean host_cad_is_eagle() {
        return this.specctra_parser_info != null && this.specctra_parser_info.host_cad != null && this.specctra_parser_info.host_cad.equalsIgnoreCase("CadSoft");
    }

    public boolean host_is_old_kicad() {
        if (this.specctra_parser_info == null || this.specctra_parser_info.host_cad == null || this.specctra_parser_info.host_version == null) {
            return false;
        }
        if (this.specctra_parser_info.host_cad.toLowerCase().contains("kicad")) {
            String versionString = this.specctra_parser_info.host_version;
            Matcher matcher = Pattern.compile("\\d+").matcher(versionString);
            if (matcher.find()) {
                int versionNumber = Integer.parseInt(matcher.group());
                return versionNumber <= 5;
            }
        }
        return false;
    }

    public boolean host_cad_exists() {
        return this.specctra_parser_info != null && this.specctra_parser_info.host_cad != null;
    }

    public double get_resolution(Unit p_unit) {
        return Unit.scale(this.resolution, p_unit, this.unit);
    }

    private void readObject(ObjectInputStream p_stream) throws IOException, ClassNotFoundException {
        p_stream.defaultReadObject();
        this.observers = new BoardObserverAdaptor();
    }

    public static class SpecctraParserInfo
    implements Serializable {
        public final String string_quote;
        public final String host_cad;
        public final String host_version;
        public final Collection<String[]> constants;
        public final WriteResolution write_resolution;
        public final boolean dsn_file_generated_by_host;

        public SpecctraParserInfo(String p_string_quote, String p_host_cad, String p_host_version, Collection<String[]> p_constants, WriteResolution p_write_resolution, boolean p_dsn_file_generated_by_host) {
            this.string_quote = p_string_quote;
            this.host_cad = p_host_cad;
            this.host_version = p_host_version;
            this.constants = p_constants;
            this.write_resolution = p_write_resolution;
            this.dsn_file_generated_by_host = p_dsn_file_generated_by_host;
        }

        public static class WriteResolution
        implements Serializable {
            public final String char_name;
            public final int positive_int;

            public WriteResolution(String p_char_name, int p_positive_int) {
                this.char_name = p_char_name;
                this.positive_int = p_positive_int;
            }
        }
    }
}

