/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.board;

import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.Line;
import app.freerouting.geometry.planar.LineSegment;
import app.freerouting.geometry.planar.Point;
import app.freerouting.geometry.planar.Polyline;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;

public class CalcFromSide {
    public static final CalcFromSide NOT_CALCULATED = new CalcFromSide(-1, null);
    final int no;
    final FloatPoint border_intersection;

    CalcFromSide(Polyline p_polyline, int p_no, TileShape p_shape) {
        int fromside_no = -1;
        FloatPoint intersection = null;
        boolean border_intersection_found = false;
        for (int curr_no = p_no; curr_no > 0; --curr_no) {
            LineSegment curr_seg = new LineSegment(p_polyline, curr_no);
            int[] intersections = curr_seg.border_intersections(p_shape);
            if (intersections.length <= 0) continue;
            fromside_no = intersections[0];
            intersection = curr_seg.get_line().intersection_approx(p_shape.border_line(fromside_no));
            border_intersection_found = true;
            break;
        }
        if (!border_intersection_found) {
            FloatPoint from_point = p_polyline.corner_approx(0);
            Line check_line = p_polyline.arr[1];
            double min_dist = Double.MAX_VALUE;
            int edge_count = p_shape.border_line_count();
            for (int i = 0; i < edge_count; ++i) {
                Line curr_line = p_shape.border_line(i);
                FloatPoint curr_intersection = check_line.intersection_approx(curr_line);
                double curr_dist = Math.abs(curr_intersection.distance(from_point));
                if (!(curr_dist < min_dist)) continue;
                fromside_no = i;
                intersection = curr_intersection;
                min_dist = curr_dist;
            }
        }
        this.no = fromside_no;
        this.border_intersection = intersection;
    }

    CalcFromSide(Point p_from_point, TileShape p_shape) {
        Point border_projection = p_shape.nearest_border_point(p_from_point);
        this.no = p_shape.contains_on_border_line_no(border_projection);
        if (this.no < 0) {
            FRLogger.warn("CalcFromSide: this.no >= 0 expected");
        }
        this.border_intersection = border_projection.to_float();
    }

    CalcFromSide(LineSegment p_line_segment, TileShape p_shape, boolean p_shove_to_the_left) {
        FloatPoint next_corner;
        FloatPoint start_corner = p_line_segment.start_point_approx();
        FloatPoint end_corner = p_line_segment.end_point_approx();
        int border_line_count = p_shape.border_line_count();
        Line check_line = p_line_segment.get_line();
        FloatPoint first_corner = p_shape.corner_approx(0);
        Side prev_side = check_line.side_of(first_corner);
        int front_side_no = -1;
        for (int i = 1; i <= border_line_count; ++i) {
            FloatPoint curr_intersection;
            next_corner = i == border_line_count ? first_corner : p_shape.corner_approx(i);
            Side next_side = check_line.side_of(next_corner);
            if (prev_side != next_side && (curr_intersection = p_shape.border_line(i - 1).intersection_approx(check_line)).distance_square(start_corner) < curr_intersection.distance_square(end_corner)) {
                front_side_no = i - 1;
                break;
            }
            prev_side = next_side;
        }
        if (front_side_no < 0) {
            FRLogger.warn("CalcFromSide: start corner was not found");
            this.no = -1;
            this.border_intersection = null;
            return;
        }
        this.no = p_shove_to_the_left ? (front_side_no + 2) % border_line_count : (front_side_no + border_line_count - 2) % border_line_count;
        FloatPoint prev_corner = p_shape.corner_approx(this.no);
        next_corner = p_shape.corner_approx((this.no + 1) % border_line_count);
        this.border_intersection = prev_corner.middle_point(next_corner);
    }

    CalcFromSide(int p_no, FloatPoint p_border_intersection) {
        this.no = p_no;
        this.border_intersection = p_border_intersection;
    }
}

