/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.BatchOptRoute;
import app.freerouting.autoroute.BatchOptRouteMT;
import app.freerouting.autoroute.ItemRouteResult;
import app.freerouting.board.Item;
import app.freerouting.datastructures.UndoableObjects;
import app.freerouting.interactive.RatsNest;
import app.freerouting.logger.FRLogger;
import java.util.Iterator;

public class OptimizeRouteTask
extends BatchOptRoute
implements Runnable {
    private Item curr_item;
    private final int pass_no;
    private final boolean with_preferred_directions;
    private ItemRouteResult route_result;
    private final BatchOptRouteMT optimizer;

    public OptimizeRouteTask(BatchOptRouteMT p_optimizer, int item_id, int p_pass_no, boolean p_with_preferred_directions, double p_min_cumulative_trace_length) {
        super(p_optimizer.thread, true);
        this.optimizer = p_optimizer;
        this.curr_item = this.findItemOnBoard(item_id);
        this.pass_no = p_pass_no;
        this.with_preferred_directions = p_with_preferred_directions;
        this.min_cumulative_trace_length_before = p_min_cumulative_trace_length;
    }

    private Item findItemOnBoard(int item_id) {
        boolean found = false;
        Iterator<UndoableObjects.UndoableObjectNode> it = this.routing_board.item_list.start_read_object();
        while (it.hasNext()) {
            Item item;
            UndoableObjects.Storable curr_ob = this.routing_board.item_list.read_object(it);
            if (!(curr_ob instanceof Item) || (item = (Item)curr_ob).get_id_no() != item_id) continue;
            return item;
        }
        return null;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        if (this.curr_item == null) {
            return;
        }
        this.route_result = this.opt_route_item(this.curr_item, this.pass_no, this.with_preferred_directions);
        boolean winning_candidate = this.optimizer.is_winning_candidate(this);
        long duration = System.currentTimeMillis() - startTime;
        long minutes = duration / 60000L;
        float sec = (float)(duration % 60000L) / 1000.0f;
        FRLogger.debug("Finished   task #" + this.optimizer.get_num_tasks_finished() + " of " + this.optimizer.get_num_tasks() + " for item #" + this.curr_item.get_id_no() + " on pass " + this.pass_no + " in " + minutes + " m " + sec + "s. Best so far: " + winning_candidate + ", improved: " + this.route_result.improved() + ", via reduction: " + this.route_result.via_count_reduced() + (String)(winning_candidate ? ", length reduction: " + (int)this.route_result.length_reduced() : "") + ", incomplete trace reduction: " + (this.route_result.incomplete_count_before() - this.route_result.incomplete_count()));
        if (!winning_candidate) {
            this.clean();
        }
    }

    public ItemRouteResult getRouteResult() {
        return this.route_result;
    }

    public Item getItem() {
        return this.curr_item;
    }

    public void clean() {
        this.curr_item.board = null;
        this.curr_item = null;
        this.sorted_route_items = null;
        this.routing_board = null;
    }

    @Override
    protected void remove_ratsnest() {
    }

    @Override
    protected RatsNest get_ratsnest() {
        return new RatsNest(this.routing_board, this.thread.hdlg.get_locale());
    }
}

