/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.autoroute.CompleteExpansionRoom;
import app.freerouting.autoroute.LocateFoundConnectionAlgo;
import app.freerouting.autoroute.MazeSearchAlgo;
import app.freerouting.board.AngleRestriction;
import app.freerouting.board.Item;
import app.freerouting.board.ShapeSearchTree;
import app.freerouting.board.TestLevel;
import app.freerouting.geometry.planar.FloatLine;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.Side;
import app.freerouting.geometry.planar.TileShape;
import app.freerouting.logger.FRLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SortedSet;

class LocateFoundConnectionAlgoAnyAngle
extends LocateFoundConnectionAlgo {
    private static final double c_tolerance = 1.0;

    protected LocateFoundConnectionAlgoAnyAngle(MazeSearchAlgo.Result p_maze_search_result, AutorouteControl p_ctrl, ShapeSearchTree p_search_tree, AngleRestriction p_angle_restriction, SortedSet<Item> p_ripped_item_list, TestLevel p_test_level) {
        super(p_maze_search_result, p_ctrl, p_search_tree, p_angle_restriction, p_ripped_item_list, p_test_level);
    }

    private static FloatPoint calc_door_left_corner(LocateFoundConnectionAlgo.BacktrackElement p_to_info) {
        CompleteExpansionRoom from_room = p_to_info.door.other_room(p_to_info.next_room);
        FloatPoint pole = from_room.get_shape().centre_of_gravity();
        TileShape curr_to_door_shape = p_to_info.door.get_shape();
        int left_most_corner_no = curr_to_door_shape.index_of_left_most_corner(pole);
        return curr_to_door_shape.corner_approx(left_most_corner_no);
    }

    private static FloatPoint calc_door_right_corner(LocateFoundConnectionAlgo.BacktrackElement p_to_info) {
        CompleteExpansionRoom from_room = p_to_info.door.other_room(p_to_info.next_room);
        FloatPoint pole = from_room.get_shape().centre_of_gravity();
        TileShape curr_to_door_shape = p_to_info.door.get_shape();
        int right_most_corner_no = curr_to_door_shape.index_of_right_most_corner(pole);
        return curr_to_door_shape.corner_approx(right_most_corner_no);
    }

    @Override
    protected Collection<FloatPoint> calculate_next_trace_corners() {
        FloatPoint right_tangent_point;
        FloatPoint left_tangent_point;
        int new_door_ind;
        FloatPoint door_right_corner;
        LinkedList<FloatPoint> result = new LinkedList<FloatPoint>();
        if (this.current_to_door_index >= this.current_target_door_index) {
            if (this.current_to_door_index == this.current_target_door_index) {
                FloatPoint nearest_point = this.current_target_shape.nearest_point(this.current_from_point.round()).to_float();
                ++this.current_to_door_index;
                result.add(nearest_point);
            }
            return result;
        }
        double trace_halfwidth_exact = this.ctrl.compensated_trace_half_width[this.current_trace_layer];
        double trace_halfwidth_max = trace_halfwidth_exact + 2.0;
        double trace_halfwidth_middle = trace_halfwidth_exact + 1.0;
        LocateFoundConnectionAlgo.BacktrackElement curr_to_info = this.backtrack_array[this.current_to_door_index];
        FloatPoint door_left_corner = LocateFoundConnectionAlgoAnyAngle.calc_door_left_corner(curr_to_info);
        if (this.current_from_point.side_of(door_left_corner, door_right_corner = LocateFoundConnectionAlgoAnyAngle.calc_door_right_corner(curr_to_info)) != Side.ON_THE_RIGHT) {
            if (this.current_from_point.scalar_product(this.previous_from_point, door_left_corner) >= 0.0) {
                door_left_corner = null;
            }
            if (this.current_from_point.scalar_product(this.previous_from_point, door_right_corner) >= 0.0) {
                door_right_corner = null;
            }
            if (door_left_corner == null && door_right_corner == null) {
                ++this.current_to_door_index;
                result.add(this.current_from_point);
                return result;
            }
        }
        boolean end_of_trace = false;
        int left_ind = new_door_ind = this.current_to_door_index;
        int right_ind = new_door_ind;
        int curr_door_ind = this.current_to_door_index + 1;
        FloatPoint result_corner = null;
        while (true) {
            FloatLine check_line;
            FloatPoint curr_tangential_point;
            boolean visability_range_gets_smaller_on_the_left_side;
            FloatLine check_line2;
            FloatPoint curr_tangential_point2;
            boolean visability_range_gets_smaller_on_the_right_side;
            FloatPoint next_right_corner;
            left_tangent_point = this.current_from_point.right_tangential_point(door_left_corner, trace_halfwidth_max);
            if (door_left_corner != null && left_tangent_point == null) {
                if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                    FRLogger.warn("LocateFoundConnectionAlgo.calculate_next_trace_corner: left tangent point is null");
                }
                left_tangent_point = door_left_corner;
            }
            right_tangent_point = this.current_from_point.left_tangential_point(door_right_corner, trace_halfwidth_max);
            if (door_right_corner != null && right_tangent_point == null) {
                if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                    FRLogger.warn("LocateFoundConnectionAlgo.calculate_next_trace_corner: right tangent point is null");
                }
                right_tangent_point = door_right_corner;
            }
            if (left_tangent_point != null && right_tangent_point != null && right_tangent_point.side_of(this.current_from_point, left_tangent_point) != Side.ON_THE_RIGHT) {
                double right_corner_distance;
                double left_corner_distance = door_left_corner.distance(this.current_from_point);
                if (left_corner_distance <= (right_corner_distance = door_right_corner.distance(this.current_from_point))) {
                    new_door_ind = left_ind;
                    result_corner = this.left_turn_next_corner(this.current_from_point, trace_halfwidth_max, door_left_corner, door_right_corner);
                    break;
                }
                new_door_ind = right_ind;
                result_corner = this.right_turn_next_corner(this.current_from_point, trace_halfwidth_max, door_right_corner, door_left_corner);
                break;
            }
            if (curr_door_ind >= this.current_target_door_index) {
                end_of_trace = true;
                break;
            }
            LocateFoundConnectionAlgo.BacktrackElement next_to_info = this.backtrack_array[curr_door_ind];
            FloatPoint next_left_corner = LocateFoundConnectionAlgoAnyAngle.calc_door_left_corner(next_to_info);
            if (this.current_from_point.side_of(next_left_corner, next_right_corner = LocateFoundConnectionAlgoAnyAngle.calc_door_right_corner(next_to_info)) != Side.ON_THE_RIGHT) {
                if (door_left_corner == null && this.current_from_point.scalar_product(this.previous_from_point, next_left_corner) >= 0.0) {
                    next_left_corner = null;
                }
                if (door_right_corner == null && this.current_from_point.scalar_product(this.previous_from_point, next_right_corner) >= 0.0) {
                    next_right_corner = null;
                }
                if (next_left_corner == null && next_right_corner == null) {
                    if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                        FRLogger.warn("LocateFoundConnectionAlgo.calculate_next_trace_corner: next door passed unexpected");
                    }
                    ++this.current_to_door_index;
                    result.add(this.current_from_point);
                    return result;
                }
            }
            if (door_left_corner != null && door_right_corner != null) {
                if (next_left_corner.side_of(this.current_from_point, door_right_corner) == Side.ON_THE_RIGHT) {
                    new_door_ind = right_ind + 1;
                    result_corner = this.right_turn_next_corner(this.current_from_point, trace_halfwidth_max, door_right_corner, next_left_corner);
                    break;
                }
                if (next_right_corner.side_of(this.current_from_point, door_left_corner) == Side.ON_THE_LEFT) {
                    new_door_ind = left_ind + 1;
                    result_corner = this.left_turn_next_corner(this.current_from_point, trace_halfwidth_max, door_left_corner, next_right_corner);
                    break;
                }
            }
            boolean bl = visability_range_gets_smaller_on_the_right_side = door_right_corner == null;
            if (door_right_corner != null && next_right_corner.side_of(this.current_from_point, door_right_corner) != Side.ON_THE_RIGHT && (curr_tangential_point2 = this.current_from_point.left_tangential_point(next_right_corner, trace_halfwidth_max)) != null && (check_line2 = new FloatLine(this.current_from_point, curr_tangential_point2)).segment_distance(door_right_corner) >= trace_halfwidth_max) {
                visability_range_gets_smaller_on_the_right_side = true;
            }
            if (visability_range_gets_smaller_on_the_right_side) {
                door_right_corner = next_right_corner;
                right_ind = curr_door_ind;
            }
            boolean bl2 = visability_range_gets_smaller_on_the_left_side = door_left_corner == null;
            if (door_left_corner != null && next_left_corner.side_of(this.current_from_point, door_left_corner) != Side.ON_THE_LEFT && (curr_tangential_point = this.current_from_point.right_tangential_point(next_left_corner, trace_halfwidth_max)) != null && (check_line = new FloatLine(this.current_from_point, curr_tangential_point)).segment_distance(door_left_corner) >= trace_halfwidth_max) {
                visability_range_gets_smaller_on_the_left_side = true;
            }
            if (visability_range_gets_smaller_on_the_left_side) {
                door_left_corner = next_left_corner;
                left_ind = curr_door_ind;
            }
            ++curr_door_ind;
        }
        if (end_of_trace) {
            FloatPoint nearest_point;
            result_corner = nearest_point = this.current_target_shape.nearest_point(this.current_from_point.round()).to_float();
            if (left_tangent_point != null && nearest_point.side_of(this.current_from_point, left_tangent_point) == Side.ON_THE_LEFT) {
                new_door_ind = left_ind + 1;
                FloatPoint target_right_corner = this.current_target_shape.corner_approx(this.current_target_shape.index_of_right_most_corner(this.current_from_point));
                FloatPoint curr_corner = this.right_left_tangential_point(this.current_from_point, target_right_corner, door_left_corner, trace_halfwidth_max);
                if (curr_corner != null) {
                    result_corner = curr_corner;
                    end_of_trace = false;
                }
            } else if (right_tangent_point != null && nearest_point.side_of(this.current_from_point, right_tangent_point) == Side.ON_THE_RIGHT) {
                FloatPoint target_left_corner = this.current_target_shape.corner_approx(this.current_target_shape.index_of_left_most_corner(this.current_from_point));
                new_door_ind = right_ind + 1;
                FloatPoint curr_corner = this.left_right_tangential_point(this.current_from_point, target_left_corner, door_right_corner, trace_halfwidth_max);
                if (curr_corner != null) {
                    result_corner = curr_corner;
                    end_of_trace = false;
                }
            }
        }
        if (end_of_trace) {
            new_door_ind = this.current_target_door_index;
        }
        FloatLine check_line = new FloatLine(this.current_from_point, result_corner);
        int check_from_door_index = Math.max(this.current_to_door_index - 5, this.current_from_door_index + 1);
        FloatPoint corrected_result = null;
        int corrected_door_ind = 0;
        for (int i = check_from_door_index; i < new_door_ind; ++i) {
            FloatPoint curr_corrected_result;
            FloatPoint curr_right_corner;
            FloatPoint curr_corrected_result2;
            FloatPoint curr_left_corner = LocateFoundConnectionAlgoAnyAngle.calc_door_left_corner(this.backtrack_array[i]);
            double curr_dist = check_line.segment_distance(curr_left_corner);
            if (Math.abs(curr_dist) < trace_halfwidth_middle && (curr_corrected_result2 = this.right_left_tangential_point(check_line.a, check_line.b, curr_left_corner, trace_halfwidth_max)) != null && (corrected_result == null || curr_corrected_result2.side_of(this.current_from_point, corrected_result) == Side.ON_THE_RIGHT)) {
                corrected_door_ind = i;
                corrected_result = curr_corrected_result2;
            }
            if (!(Math.abs(curr_dist = check_line.segment_distance(curr_right_corner = LocateFoundConnectionAlgoAnyAngle.calc_door_right_corner(this.backtrack_array[i]))) < trace_halfwidth_middle) || (curr_corrected_result = this.left_right_tangential_point(check_line.a, check_line.b, curr_right_corner, trace_halfwidth_max)) == null || corrected_result != null && curr_corrected_result.side_of(this.current_from_point, corrected_result) != Side.ON_THE_LEFT) continue;
            corrected_door_ind = i;
            corrected_result = curr_corrected_result;
        }
        if (corrected_result != null) {
            result_corner = corrected_result;
            new_door_ind = Math.max(corrected_door_ind, this.current_to_door_index);
        }
        this.current_to_door_index = new_door_ind;
        if (result_corner != null && result_corner != this.current_from_point) {
            result.add(result_corner);
        }
        return result;
    }

    private FloatPoint right_turn_next_corner(FloatPoint p_from_corner, double p_dist, FloatPoint p_to_corner, FloatPoint p_next_corner) {
        FloatPoint curr_tangential_point = p_from_corner.left_tangential_point(p_to_corner, p_dist);
        if (curr_tangential_point == null) {
            if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("LocateFoundConnectionAlgo.right_turn_next_corner: left tangential point is null");
            }
            return p_from_corner;
        }
        FloatLine first_line = new FloatLine(p_from_corner, curr_tangential_point);
        curr_tangential_point = p_to_corner.right_tangential_point(p_next_corner, 2.0 * p_dist + 1.0);
        if (curr_tangential_point == null) {
            if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("LocateFoundConnectionAlgo.right_turn_next_corner: right tangential point is null");
            }
            return p_from_corner;
        }
        FloatLine second_line = new FloatLine(p_to_corner, curr_tangential_point);
        second_line = second_line.translate(p_dist);
        return first_line.intersection(second_line);
    }

    private FloatPoint left_turn_next_corner(FloatPoint p_from_corner, double p_dist, FloatPoint p_to_corner, FloatPoint p_next_corner) {
        FloatPoint curr_tangential_point = p_from_corner.right_tangential_point(p_to_corner, p_dist);
        if (curr_tangential_point == null) {
            if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("LocateFoundConnectionAlgo.left_turn_next_corner: right tangential point is null");
            }
            return p_from_corner;
        }
        FloatLine first_line = new FloatLine(p_from_corner, curr_tangential_point);
        curr_tangential_point = p_to_corner.left_tangential_point(p_next_corner, 2.0 * p_dist + 1.0);
        if (curr_tangential_point == null) {
            if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("LocateFoundConnectionAlgo.left_turn_next_corner: left tangential point is null");
            }
            return p_from_corner;
        }
        FloatLine second_line = new FloatLine(p_to_corner, curr_tangential_point);
        second_line = second_line.translate(-p_dist);
        return first_line.intersection(second_line);
    }

    private FloatPoint right_left_tangential_point(FloatPoint p_from_point, FloatPoint p_to_point, FloatPoint p_center, double p_dist) {
        FloatPoint curr_tangential_point = p_from_point.right_tangential_point(p_center, p_dist);
        if (curr_tangential_point == null) {
            if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("LocateFoundConnectionAlgo. right_left_tangential_point: right tangential point is null");
            }
            return null;
        }
        FloatLine first_line = new FloatLine(p_from_point, curr_tangential_point);
        curr_tangential_point = p_to_point.left_tangential_point(p_center, p_dist);
        if (curr_tangential_point == null) {
            if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("LocateFoundConnectionAlgo. right_left_tangential_point: left tangential point is null");
            }
            return null;
        }
        FloatLine second_line = new FloatLine(p_to_point, curr_tangential_point);
        return first_line.intersection(second_line);
    }

    private FloatPoint left_right_tangential_point(FloatPoint p_from_point, FloatPoint p_to_point, FloatPoint p_center, double p_dist) {
        FloatPoint curr_tangential_point = p_from_point.left_tangential_point(p_center, p_dist);
        if (curr_tangential_point == null) {
            if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("LocateFoundConnectionAlgo. left_right_tangential_point: left tangential point is null");
            }
            return null;
        }
        FloatLine first_line = new FloatLine(p_from_point, curr_tangential_point);
        curr_tangential_point = p_to_point.right_tangential_point(p_center, p_dist);
        if (curr_tangential_point == null) {
            if (this.test_level.ordinal() >= TestLevel.ALL_DEBUGGING_OUTPUT.ordinal()) {
                FRLogger.warn("LocateFoundConnectionAlgo. left_right_tangential_point: right tangential point is null");
            }
            return null;
        }
        FloatLine second_line = new FloatLine(p_to_point, curr_tangential_point);
        return first_line.intersection(second_line);
    }
}

