/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

public class ItemRouteResult
implements Comparable<ItemRouteResult> {
    private final int item_id;
    private boolean improved;
    private final float improvement_percentage;
    private final int via_count_before;
    private final int via_count_after;
    private final double trace_length_before;
    private final double trace_length_after;
    private final int incomplete_count_before;
    private final int incomplete_count_after;

    public ItemRouteResult(int p_item_id) {
        this(p_item_id, 0, 0, 0.0, 0.0, 0, 1);
        this.improved = false;
    }

    public ItemRouteResult(int p_item_id, int p_via_count_before, int p_via_count_after, double p_trace_length_before, double p_trace_length_after, int p_incomplete_count_before, int p_incomplete_count_after) {
        this.item_id = p_item_id;
        this.via_count_before = p_via_count_before;
        this.via_count_after = p_via_count_after;
        this.trace_length_before = p_trace_length_before;
        this.trace_length_after = p_trace_length_after;
        this.incomplete_count_before = p_incomplete_count_before;
        this.incomplete_count_after = p_incomplete_count_after;
        this.improved = this.incomplete_count_after < this.incomplete_count_before ? true : (this.incomplete_count_after > this.incomplete_count_before ? false : (this.via_count_after < this.via_count_before ? true : (this.via_count_after > this.via_count_before ? false : (this.trace_length_after < this.trace_length_before ? true : (this.trace_length_after > this.trace_length_before ? false : false)))));
        this.improvement_percentage = (float)(this.via_count_before != 0 && this.trace_length_before != 0.0 ? 1.0 - ((double)(this.via_count_after / this.via_count_before) + this.trace_length_after / this.trace_length_before) / 2.0 : 0.0);
    }

    @Override
    public int compareTo(ItemRouteResult r) {
        if (this.incomplete_count_after < r.incomplete_count_after) {
            return -1;
        }
        if (this.incomplete_count_after > r.incomplete_count_after) {
            return 1;
        }
        if (this.via_count_after < r.via_count_after) {
            return -1;
        }
        if (this.via_count_after > r.via_count_after) {
            return 1;
        }
        if (this.trace_length_after < r.trace_length_after) {
            return -1;
        }
        if (this.trace_length_after > r.trace_length_after) {
            return 1;
        }
        return 0;
    }

    public boolean improved_over(ItemRouteResult r) {
        return this.compareTo(r) < 0;
    }

    public int item_id() {
        return this.item_id;
    }

    public boolean improved() {
        return this.improved;
    }

    public float improvement_percentage() {
        return this.improvement_percentage;
    }

    public int via_count() {
        return this.via_count_after;
    }

    public double trace_length() {
        return this.trace_length_after;
    }

    public int incomplete_count() {
        return this.incomplete_count_after;
    }

    public int via_count_reduced() {
        return this.via_count_before - this.via_count_after;
    }

    public double length_reduced() {
        return this.trace_length_before - this.trace_length_after;
    }

    public void update_improved(boolean p_improved) {
        this.improved = p_improved;
    }

    public int incomplete_count_before() {
        return this.incomplete_count_before;
    }
}

