/*
 * Decompiled with CFR 0.152.
 */
package app.freerouting.autoroute;

import app.freerouting.autoroute.AutorouteControl;
import app.freerouting.geometry.planar.FloatPoint;
import app.freerouting.geometry.planar.IntBox;

public class DestinationDistance {
    private final AutorouteControl.ExpansionCostFactor[] trace_costs;
    private final boolean[] layer_active;
    private final int layer_count;
    private final int active_layer_count;
    double min_component_side_trace_cost;
    double max_component_side_trace_cost;
    double min_solder_side_trace_cost;
    double max_solder_side_trace_cost;
    double max_inner_side_trace_cost;
    double min_component_inner_trace_cost;
    double min_solder_inner_trace_cost;
    double min_component_solder_inner_trace_cost;
    private double min_normal_via_cost;
    private final double min_cheap_via_cost;
    private IntBox component_side_box = IntBox.EMPTY;
    private IntBox solder_side_box = IntBox.EMPTY;
    private IntBox inner_side_box = IntBox.EMPTY;
    private boolean box_is_empty = true;
    private boolean component_side_box_is_empty = true;
    private boolean solder_side_box_is_empty = true;
    private boolean inner_side_box_is_empty = true;

    public DestinationDistance(AutorouteControl.ExpansionCostFactor[] p_trace_costs, boolean[] p_layer_active, double p_min_normal_via_cost, double p_min_cheap_via_cost) {
        this.trace_costs = p_trace_costs;
        this.layer_active = p_layer_active;
        this.layer_count = p_layer_active.length;
        this.min_normal_via_cost = p_min_normal_via_cost;
        this.min_cheap_via_cost = p_min_cheap_via_cost;
        int curr_active_layer_count = 0;
        for (int ind = 0; ind < this.layer_count; ++ind) {
            if (!this.layer_active[ind]) continue;
            ++curr_active_layer_count;
        }
        this.active_layer_count = curr_active_layer_count;
        if (this.layer_active[0]) {
            if (this.trace_costs[0].horizontal < this.trace_costs[0].vertical) {
                this.min_component_side_trace_cost = this.trace_costs[0].horizontal;
                this.max_component_side_trace_cost = this.trace_costs[0].vertical;
            } else {
                this.min_component_side_trace_cost = this.trace_costs[0].vertical;
                this.max_component_side_trace_cost = this.trace_costs[0].horizontal;
            }
        }
        if (this.layer_active[this.layer_count - 1]) {
            AutorouteControl.ExpansionCostFactor curr_trace_cost = this.trace_costs[this.layer_count - 1];
            if (curr_trace_cost.horizontal < curr_trace_cost.vertical) {
                this.min_solder_side_trace_cost = curr_trace_cost.horizontal;
                this.max_solder_side_trace_cost = curr_trace_cost.vertical;
            } else {
                this.min_solder_side_trace_cost = curr_trace_cost.vertical;
                this.max_solder_side_trace_cost = curr_trace_cost.horizontal;
            }
        }
        this.max_inner_side_trace_cost = Math.min(this.max_component_side_trace_cost, this.max_solder_side_trace_cost);
        for (int ind2 = 1; ind2 < this.layer_count - 1; ++ind2) {
            if (!this.layer_active[ind2]) continue;
            double curr_max_cost = Math.max(this.trace_costs[ind2].horizontal, this.trace_costs[ind2].vertical);
            this.max_inner_side_trace_cost = Math.min(this.max_inner_side_trace_cost, curr_max_cost);
        }
        this.min_component_inner_trace_cost = Math.min(this.min_component_side_trace_cost, this.max_inner_side_trace_cost);
        this.min_solder_inner_trace_cost = Math.min(this.min_solder_side_trace_cost, this.max_inner_side_trace_cost);
        this.min_component_solder_inner_trace_cost = Math.min(this.min_component_inner_trace_cost, this.min_solder_inner_trace_cost);
    }

    public void join(IntBox p_box, int p_layer) {
        if (p_layer == 0) {
            this.component_side_box = this.component_side_box.union(p_box);
            this.component_side_box_is_empty = false;
        } else if (p_layer == this.layer_count - 1) {
            this.solder_side_box = this.solder_side_box.union(p_box);
            this.solder_side_box_is_empty = false;
        } else {
            this.inner_side_box = this.inner_side_box.union(p_box);
            this.inner_side_box_is_empty = false;
        }
        this.box_is_empty = false;
    }

    public double calculate(FloatPoint p_point, int p_layer) {
        return this.calculate(p_point.bounding_box(), p_layer);
    }

    public double calculate(IntBox p_box, int p_layer) {
        double inner_side_min_delta;
        double inner_side_max_delta;
        double solder_side_min_delta;
        double solder_side_max_delta;
        double component_side_min_delta;
        double component_side_max_delta;
        if (this.box_is_empty) {
            return 2.147483647E9;
        }
        double component_side_delta_x = p_box.ll.x > this.component_side_box.ur.x ? (double)(p_box.ll.x - this.component_side_box.ur.x) : (p_box.ur.x < this.component_side_box.ll.x ? (double)(this.component_side_box.ll.x - p_box.ur.x) : 0.0);
        double component_side_delta_y = p_box.ll.y > this.component_side_box.ur.y ? (double)(p_box.ll.y - this.component_side_box.ur.y) : (p_box.ur.y < this.component_side_box.ll.y ? (double)(this.component_side_box.ll.y - p_box.ur.y) : 0.0);
        double solder_side_delta_x = p_box.ll.x > this.solder_side_box.ur.x ? (double)(p_box.ll.x - this.solder_side_box.ur.x) : (p_box.ur.x < this.solder_side_box.ll.x ? (double)(this.solder_side_box.ll.x - p_box.ur.x) : 0.0);
        double solder_side_delta_y = p_box.ll.y > this.solder_side_box.ur.y ? (double)(p_box.ll.y - this.solder_side_box.ur.y) : (p_box.ur.y < this.solder_side_box.ll.y ? (double)(this.solder_side_box.ll.y - p_box.ur.y) : 0.0);
        double inner_side_delta_x = p_box.ll.x > this.inner_side_box.ur.x ? (double)(p_box.ll.x - this.inner_side_box.ur.x) : (p_box.ur.x < this.inner_side_box.ll.x ? (double)(this.inner_side_box.ll.x - p_box.ur.x) : 0.0);
        double inner_side_delta_y = p_box.ll.y > this.inner_side_box.ur.y ? (double)(p_box.ll.y - this.inner_side_box.ur.y) : (p_box.ur.y < this.inner_side_box.ll.y ? (double)(this.inner_side_box.ll.y - p_box.ur.y) : 0.0);
        if (component_side_delta_x > component_side_delta_y) {
            component_side_max_delta = component_side_delta_x;
            component_side_min_delta = component_side_delta_y;
        } else {
            component_side_max_delta = component_side_delta_y;
            component_side_min_delta = component_side_delta_x;
        }
        if (solder_side_delta_x > solder_side_delta_y) {
            solder_side_max_delta = solder_side_delta_x;
            solder_side_min_delta = solder_side_delta_y;
        } else {
            solder_side_max_delta = solder_side_delta_y;
            solder_side_min_delta = solder_side_delta_x;
        }
        if (inner_side_delta_x > inner_side_delta_y) {
            inner_side_max_delta = inner_side_delta_x;
            inner_side_min_delta = inner_side_delta_y;
        } else {
            inner_side_max_delta = inner_side_delta_y;
            inner_side_min_delta = inner_side_delta_x;
        }
        double result = 2.147483647E9;
        if (p_layer == 0) {
            if (!this.component_side_box_is_empty) {
                result = p_box.weighted_distance(this.component_side_box, this.trace_costs[0].horizontal, this.trace_costs[0].vertical);
            }
            if (this.active_layer_count <= 1) {
                return result;
            }
            double tmp_distance = this.min_solder_side_trace_cost < this.min_component_side_trace_cost ? this.min_solder_side_trace_cost * solder_side_max_delta + this.min_component_side_trace_cost * solder_side_min_delta + this.min_normal_via_cost : this.min_component_side_trace_cost * solder_side_max_delta + this.min_solder_side_trace_cost * solder_side_min_delta + this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            tmp_distance = component_side_max_delta + component_side_min_delta * this.min_component_inner_trace_cost + 2.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            if (this.active_layer_count == 2) {
                return result;
            }
            tmp_distance = inner_side_max_delta + inner_side_min_delta * this.min_component_inner_trace_cost + this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            tmp_distance = solder_side_max_delta + this.min_component_solder_inner_trace_cost * solder_side_min_delta + 2.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            tmp_distance = component_side_max_delta + component_side_min_delta + 2.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            if (this.active_layer_count == 3) {
                return result;
            }
            tmp_distance = inner_side_max_delta + inner_side_min_delta + 2.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            tmp_distance = solder_side_max_delta + solder_side_min_delta + 3.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            return result;
        }
        if (p_layer == this.layer_count - 1) {
            if (!this.solder_side_box_is_empty) {
                result = p_box.weighted_distance(this.solder_side_box, this.trace_costs[p_layer].horizontal, this.trace_costs[p_layer].vertical);
            }
            double tmp_distance = this.min_component_side_trace_cost < this.min_solder_side_trace_cost ? this.min_component_side_trace_cost * component_side_max_delta + this.min_solder_side_trace_cost * component_side_min_delta + this.min_normal_via_cost : this.min_solder_side_trace_cost * component_side_max_delta + this.min_component_side_trace_cost * component_side_min_delta + this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            tmp_distance = solder_side_max_delta + solder_side_min_delta * this.min_solder_inner_trace_cost + 2.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            if (this.active_layer_count <= 2) {
                return result;
            }
            tmp_distance = inner_side_min_delta * this.min_solder_inner_trace_cost + inner_side_max_delta + this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            tmp_distance = component_side_max_delta + this.min_component_solder_inner_trace_cost * component_side_min_delta + 2.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            tmp_distance = solder_side_max_delta + solder_side_min_delta + 2.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            if (this.active_layer_count == 3) {
                return result;
            }
            tmp_distance = inner_side_max_delta + inner_side_min_delta + 2.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            tmp_distance = component_side_max_delta + component_side_min_delta + 3.0 * this.min_normal_via_cost;
            result = Math.min(result, tmp_distance);
            return result;
        }
        if (!this.inner_side_box_is_empty) {
            result = p_box.weighted_distance(this.inner_side_box, this.trace_costs[p_layer].horizontal, this.trace_costs[p_layer].vertical);
        }
        double tmp_distance = inner_side_max_delta + inner_side_min_delta + this.min_normal_via_cost;
        result = Math.min(result, tmp_distance);
        tmp_distance = component_side_max_delta + component_side_min_delta * this.min_component_inner_trace_cost + this.min_normal_via_cost;
        result = Math.min(result, tmp_distance);
        tmp_distance = solder_side_max_delta + solder_side_min_delta * this.min_solder_inner_trace_cost + this.min_normal_via_cost;
        result = Math.min(result, tmp_distance);
        tmp_distance = component_side_max_delta + component_side_min_delta + 2.0 * this.min_normal_via_cost;
        result = Math.min(result, tmp_distance);
        tmp_distance = solder_side_max_delta + solder_side_min_delta + 2.0 * this.min_normal_via_cost;
        result = Math.min(result, tmp_distance);
        return result;
    }

    public double calculate_cheap_distance(IntBox p_box, int p_layer) {
        double min_normal_via_cost_save = this.min_normal_via_cost;
        this.min_normal_via_cost = this.min_cheap_via_cost;
        double result = this.calculate(p_box, p_layer);
        this.min_normal_via_cost = min_normal_via_cost_save;
        return result;
    }
}

